C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : THOMWGTA
C Description : COMPUTES WEIGHTS TO APPLY TO EIGENSPECTRA
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 2 DEC 1987
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: USED IN THOMSON'S SPECTRUM ANALYSIS METHOD
C 
C--
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  THE FORMULA USED IN COMPUTING THESE THOMSON WEIGHTS IS MY CORRECTED
C  VERSION OF THOMSON'S ORIGINAL FORMULA. IT IS
C
C  D**2 = {  S/(LAMBDA*S+SIGMA**2*(1-LAMBDA)) }**2
C
C  OUTPUT IS D**2/SUM D**2
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\
C
C  N         Integer (i)          length of dpss
C
C  NREQ      Integer (i)          length of FFT (e.g. 2**p or length
C                                 commensurate with Singleton's method
C
C  NREQMAX   Integer (i)          max length of FFT (defines dim of matrix
C                                 D in calling prog)
C
C  K0        Integer (i)          minimum order for dpss (e.g., 0)
C
C  K1        Integer (i)          maximum order for dpss (e.g., 5)
C
C  RLAM(K1-K0+1)  Real    (i)     eigenvalues corresponding to 
C                                 eigenvectors (dpss)
C
C  S((NREQ/2)+1)  Real    (i)     current spectral estimate (e.g., the
C                                 average spectrum over traces when weights
C                                 all equal)
C
C  VAR        Real  (i)           variance of time series (e.g., over all
C                                 traces)
C
C  D((NREQMAX/2)+1,K1-K0+1) Real (o) standardized weights (see above)
C
C  DF((NREQ/2)+1)  Real (o)       the computed degrees of freedom at each
C                                 frequency (including effects of weighting)
C
C  IFAULT    Integer  (o)         0: successful completion
C                                 1: K0<0 or K1>N-1
C                                 2: VAR =< 0
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE THOMWGTA(N, NREQ, NREQMAX, K0, K1, RLAM, S, VAR, 
     * D, DF, IFAULT)
C
      IMPLICIT NONE
C
      INTEGER NREQ, K11, K0, K1, NL, K, I, IFAULT, N, NREQMAX
C
      DOUBLE PRECISION VV, VAR, ONE, RLAM(K1-K0+1), EV, DIK,
     * D((NREQMAX/2)+1, K1-K0+1), S((NREQ/2)+1), DKS2, ZERO,
     * DF((NREQ/2)+1), TWO, DF1, DF2
C
      DATA ZERO, ONE, TWO/0.0D0, 1.0D0, 2.0D0/
C
C  FORM UP WEIGHTS AS SQUARED VALUES (D**2)
C
      IFAULT=1
      IF(K0 .LT. 0 .OR. K1 .GT. N-1) RETURN
      IFAULT=2
      IF(VAR .LE. ZERO) RETURN
      K11=K1-K0+1
      NL=(NREQ/2)+1
      DO 5 K=1,K11
          VV=VAR*(ONE-RLAM(K))
          EV=RLAM(K)
          DO 10 I=1,NL
               DIK=(S(I)*DSQRT(EV))/(EV*S(I)+VV)
 10            D(I,K)=DIK*DIK ! SQUARED WEIGHTS
  5   CONTINUE
C
C FIND SUM OF SQUARED VALUES OVER TAPERS AND STANDARDIZE
C
      DO 20 I=1,NL
           DF1=ZERO
           DF2=ZERO
           DKS2=ZERO
           DO 25 K=1,K11
             DF1=DF1+SQRT(RLAM(K)*D(I,K))
             DF2=DF2+RLAM(K)*D(I,K)
 25          DKS2=DKS2+D(I,K) ! SUM OF D**2 AT FREQ I
           DF(I)=TWO*DF1*DF1/DF2
           DO 30 K=1,K11
 30          D(I,K)=D(I,K)/DKS2 ! STANDARDIZE EACH WGT AT FREQ I
 20   CONTINUE
      IFAULT=0
      RETURN
      END
