C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gain(amp,t,vi,vrms,x,q,icomp,iarray,iq,isphd,nsamp,
     *ierr)
      real amp(*),t(*),vi(*),vrms(*),q(*),n,l,fh,fl,x
      integer nsamp,iarray,icomp,iq,ierr, isphd
c  amp       == gain factor  ie  gain corr trace(t) = amp(t) * trace(t)
c  vi        == intervals velocity - array
c  vrms      == rms velocity - array
c  x         == input x --- source reciever seperation scalar
c  t         == input time of each sample - array
c  q         == input q array             - array
c  nsamp     == number of samples
c  icomp     == component ( = omni  = verticle )
c  iq        == do q correction == 1     
c            == do not do spherical div == 0
c  iarray    == do array correction == 1 
c            == do not do spherical div == 0
c  isphd     == do spherical div == 1    
c            == do not do spherical div == 0
c  ierr      == error flag  no/err          = 0    
c                           error sphere    = 1
c                           error array     = 2
c                           error q         = 3
c
c    set the aquasition constants
c
         n  = 25
         l  = 82.5
         fh = 60
         fl = 5

      ierr = 0

      do 10 i=1,nsamp
      amp(i) = 1.0
 10   continue

c  spereical divergence correction

      if(isphd .eq. 1) call sphere(amp,icomp,vi,vrms,x,t,nsamp,ierr)

c        array correction

      if(iarray .eq. 1) call array(amp,t,x,fh,fl,ierr,n,l,vi,vrms,nsamp)
c        q correction

      if(iq .eq. 1) call  qloss(amp,t,q,x,vrms,nsamp,fl,fh,ierr)

      return
      end
