C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln (ntap,mtap,vsis,tdfnf,veltyp,otap,mode,
     :qvalue,iq,iarray,isphd,icomp,lerr,verbos)
c-----
c     get command arguments
c
c     ntap   - C*100    input file name
c     mtap   - C*100    model file name
c     vsis   - C*100    velocity file name
c     tdfnf  - C*100    tnfn file name
c     otap   - C*100    output file name
c     mode   - INTEGER  scaling mode
c                       = 1 - "gain" correction
c                       = 2 - calibration correction
c                       = 3 - gain and calibration
c     veltyp - C*3      velocity type - 'int' or 'rms' 
c     qvalue - REAL     = if iq is 1, qvalue required    
c     iq     - INTEGER  = 1 - q correction on
c                       = 0 - q correction off
c     iarray - INTEGER  = 1 - array on, = 0 - array off
c     isphd  - INTEGER  = 1 - spherical divergence correction on
c                       = 0 - spherical divergence correction 0ff
c     icomp  - INTEGER  = 0 - omni-marine on  
c                       = 1 - vertical-land on
c                       = 2 - horizontal on
c 
c     
c     verbos   LOGICAL  verbose output or not
c
c-----
      character*100
     :ntap, otap, vsis, mtap, tdfnf

      character*3
     :veltyp     

      integer
     :mode,iq,iarray,isphd,icomp,argis

      real
     :qvalue
 
      logical
     :verbos
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
      call argstr('-N'  , ntap,  ' ',  ' '  )
      call argstr('-O'  , otap,  ' ',  ' '  )
      call argstr('-M'  , mtap,  ' ',  ' '  )
      call argstr('-VI' , vsis,  ' ',  ' '  )
      call argstr('-TD' , tdfnf, ' ',  ' '  )
      call argstr('-ty' , veltyp,' ',  ' '  )
      call argi4 ('-md',  mode,   0,    0   )
      call argi4 ('-ar',  iarray, 0,    0   )
      call argi4 ('-sp',  isphd,  1,    0   )
      call argi4 ('-cm',  icomp,  0,    0   )
      call argi4 ('-qc',  iq,     0,    0   )
      call argr4 ('-vq',  qvalue, 50., 50.  )
      verbos =   (argis('-V') .gt. 0)

      if(veltyp .eq. 'RMS' ) veltyp = 'rms'
      if(veltyp .eq. 'INT' ) veltyp = 'int'

      return
      end
