C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine intrms(rms,vint,t,npairs,iret)

c     this subroutine calculates interval velocity from rms velocity

c***********************************************************************
c* rms    -- (i) rms velocity to be converted to interval velocity
c* vint   -- (o) interval velocity calculated.
c* t      -- (i) times associated with rms velocity
c* npairs -- (i) number of elements in rms and t
c* iret   -- (o) return code 0 ==> no problems
c*                          -1 ==> decrease in rms velocity
c***********************************************************************

      real*4 rms(*),vint(*),temp,t(*)
      integer*4 npairs,iret

      iret=0
      do 10 n=1,npairs-1

        k = 1 + n
        temp= t(k)*rms(k)**2 - t(n)*rms(n)**2

c                           ;set error flag if decrease in rms vel
        if(temp.lt.0.)then
          iret=-1
          vint(n)=0.
        else
          vint(n)=sqrt(temp/(t(k)-t(n)))
        endif
   10 continue

      rms(npairs)=rms(npairs-1)

      return
      end
