C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine parchk(ntap,mtap,vsis,tdfnf,veltyp,otap,mode,
     :qvalue,iq,iarray,isphd,icomp,lerr,verbos)
c----
c see gcmdln.f for definitions of variables
c----

      character*100
     :ntap, otap, mtap, vsis, tdfnf

      character*3
     : veltyp

      integer
     :mode,iq,iarray,isphd,icomp

      logical
     :verbos

      istop = 0
      
      if ( mode .lt. 1 .or. mode .gt. 3 ) then
        write(lerr,*)' '
        write(lerr,*)'mode = ',mode
        write(lerr,*)'command line parameter, ( -md ) invalid'
        istop = 1
      endif
        
      if(ntap(1:1) .eq. ' ' ) then
         write(lerr,*)' '
         write(lerr,*)'( -N ) NTAP name not specified. '
         write(lerr,*)'Correct and resubmit'
         write(lerr,*)' '
         istop = 1
      endif 

      if(otap(1:1) .eq. ' ' ) then
         write(lerr,*)' '
         write(lerr,*)'( -O ) OTAP name not specified. '
         write(lerr,*)'Correct and resubmit'
         write(lerr,*)' '
         istop = 1
      endif 

      if ( mode .eq. 1 .or. mode .eq. 3 ) then
        if ( vsis(1:1) .ne. ' ' .and. tdfnf(1:1) .ne. ' ' ) then
          write(lerr,*)' '
          write(lerr,*)'Both ( -VI ) and ( -TD ) were specified '
          write(lerr,*)'Must be only one.'
          istop = 1
        endif
        if ( vsis(1:1) .eq. ' ' .and. tdfnf(1:1) .eq. ' ' ) then
          write(lerr,*)' '
          write(lerr,*)'( -VI ) or ( -TD ) '
          write(lerr,*)'An input velocity file was not specified.' 
          istop = 1
        endif
        if (tdfnf(1:1) .ne. ' ' .and. veltyp(1:1) .eq. ' ' ) then
          write(lerr,*)' '
          write(lerr,*)'TDFN file name specified but velocity' 
          write(lerr,*)'type ( -vt ) was not specified' 
          istop = 1
        endif
        if ( vsis(1:1) .ne. ' ' ) veltyp = 'int'
        if ( veltyp .ne. 'rms' .and. veltyp .ne. 'int' ) then
          write(lerr,*)' '
          write(lerr,*)'Command line parmeter, ( -ty ) invalid'
          istop = 1
        endif
      endif

      if ( mode .eq. 2 .or. mode .eq. 3 ) then
        if ( mtap(1:1) .eq. ' ' ) then
          write(lerr,*)' '
          write(lerr,*)'Mode = ',mode
          write(lerr,*)'( -M ) Calibration file not specified'
          istop = 1
        endif
      endif

      nop = 0
      if ( mode .eq. 1 .or. mode .eq. 3 ) then

        if ( isphd .lt. 0 .or. isphd .gt. 1 ) then
          write(lerr,*)' '
          write(lerr,*)'command line parm ( -sp ) invalid'
          istop = 1
        elseif ( isphd .eq. 0 ) then
          nop = nop + 1
        endif

        if ( iarray .lt. 0 .or. iarray .gt. 1 ) then
          write(lerr,*)' '
          write(lerr,*)'command line parm ( -ar ) invalid'
          istop = 1
        elseif ( iarray .eq. 0 ) then
          nop = nop + 1
        endif

        if ( iq .lt. 0 .or. iq .gt. 1 ) then 
          write(lerr,*)' '
          write(lerr,*)'command line parm ( -iq ) invalid'
          istop = 1
        elseif ( iq .eq. 0 ) then
          nop = nop + 1
        endif
        
        if ( iq .eq. 1 ) then
          if ( qvalue .lt. 0.0 .or. qvalue .gt. 200.0) then
            write(lerr,*)' '
            write(lerr,*)'command line parm ( -qv ) invalid'
            istop = 1
          endif
        endif

        if ( nop .eq. 3 ) then
          write(lerr,*)' '
          write(lerr,*)'command line parms ( -sp ), ( -ar ) and'
          write(lerr,*)'( -iq ) are all zero - invalid.'
          istop = 1
        endif

        if ( icomp .lt. 0 .or. icomp .gt. 2 ) then
          write(lerr,*)' '
          write(lerr,*)'command line parm ( -cm ) invalid'
          istop = 1
        endif

      endif

      if ( istop .ne. 0 ) stop

      if ( verbos ) then

        write(lerr,*)'Mode                      = ',mode
        lenc = len(ntap)
        call charct (ntap,lenc,lenn)
        write(lerr,*)'Seismic Input             = ',ntap(:lenn)

        call charct(otap,lenc,lenn)
        write(lerr,*)'Seismic Output            = ',otap(:lenn)

        if ( mode .eq. 1 .or. mode .eq. 3 ) then
         
          if ( vsis(1:1) .ne. ' ' ) then 
            call charct (vsis,lenc,lenn)
            write(lerr,*)'Velocity Input            = ',vsis(:lenn)
          else
            call charct (tdfnf,lenc,lenn)
            write(lerr,*)'Velocity Input            = ',tdfnf(:lenn)
          endif
          write(lerr,*)'Velocity Type             = ',veltyp 
          if (icomp .eq. 0 )
     :      write(lerr,*)'Omni-marine              (=0)  OFF'
          if (icomp .eq. 1 )
     :      write(lerr,*)'Vertical-Land            (=1)  ON'
          if (icomp .eq. 2 )
     :      write(lerr,*)'Horizontal               (=2)  ON'
          if (isphd .eq. 0)
     :      write(lerr,*)'Sph. Divergence Corr.    (=0)  OFF'   
          if (isphd .eq. 1)
     :      write(lerr,*)'Sph. Divergence Corr.    (=1)  ON '   
          if (iq .eq. 0)
     :      write(lerr,*)'Q Correction             (=0)  OFF'   
          if (iq .eq. 1) then
            write(lerr,*)'Q Correction             (=1)  ON '   
            write(lerr,*)'Q value                   = ',qvalue
          endif 
          if (iarray .eq. 0)
     :      write(lerr,*)'Array correction         (=0)  OFF'   
          if (iarray .eq. 1)
     :      write(lerr,*)'Array correction         (=1)  ON '   

        endif

        if ( mode .eq. 2 .or. mode .eq. 3 ) then
           
          lenc = len(mtap)
          call charct (mtap,lenc,lenn)
          write(lerr,*)'Calib. scaler file        = ',mtap(:lenn)

        endif

      endif
               
      return
      end
