C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE SCAN SIS DATA
C
C**********************************************************************C
C
C SCAN READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C AND prints header information.
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE
C
C**********************************************************************C
c
c changes:
c
c   March 21, 2001
c
c     changed the output format for the data series values to be E15.8 from
c     E11.4 to get scan in sync with sis_xy.  This was causing confusion to users
c     who used both routines and couldn't understand the different numeric output
c
c   Garossino
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      integer     itr
      integer	  alloc_size,errcod,abort
      integer     luin, lbytes, nbytes, lbyout, lbyte
c     real        tri (4*SZSMPM),distt(SZSMPM),distr(SZSMPM)
      real        tri,distt,distr
      real        trcmax, trcmin, recmax, recmin
      real        xleft, xright, gapleft, gapright
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     ns, ne, rs, re, nbin, ihdwd(256)
      integer     isprd1, isprd2, isprd
      character   ntap*256, name*4, grp*4, fmt*120, oac*8
      character   word(256)*6
      integer     ivalue, ifmtw(256), l_word(256), lengthw(256)
      real        value
      character   cvalue
      logical     verbos, verby, terse,  vrbhlh, comp, summary, stream
      logical     query, calgary, realv, maxtim
      integer     mbs
      integer     argis, getrin, byte, ifmt
      integer     dist, pri, pti, gi, di, si, dstsgn, stacor, srcpt
      real        unitsc

      pointer (mem_itr, itr(1))
      pointer (mem_tri, tri(1))
      pointer (mem_distr, distt(1))
      pointer (mem_distt, distr(1))

c     equivalence ( itr(129), tri (1) )
      data  nbytes / 0 /, lbytes / 0 /
      data  verbos/.true./, name/'SCAN'/
      data  isprd1/0/, isprd2/0/
      data  xleft    /99999./
      data  xright   /-99999./
      data  gapleft  /-99999./
      data  gapright /99999./
      data  ihdwd    / 256*0 /
      data  ifmtw    / 256*4 /
      data  l_word   / 256*0 /
      data  word     / 256*'      ' /
      data  abort    / 0 /

c #include <f77/pid.h>
c-----
c      read program parameters from command line
c-----
      query = (argis('-?') .gt. 0)
      if(query) then
            call help()
            stop
      endif
c
c #include <f77/open.h>
c-----
c      parse command line arguments
c-----
      call gcmdln(ns,ne,rs,re,ntap,np,terse,comp,verbos,verby,vrbhlh,
     1            summary,nbin,ihdwd, stream, fmt, idec,word,ni,nw,
     2            byte,ifmt,calgary,mbs,realv,maxtim)
c-----
c      get logical unit numbers for input
c-----
      call getln( luin,ntap,'r',0 )

      alloc_size = SZLNHD * SZSMPD
      errcod = 0
      call galloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
c     else
c	write(LER,*) 'Workspace Allocation: ',
c    :             alloc_size,' bytes requested '
      endif

c-----
c     read line header of input
c     save certain parameters
c-----
c - remove refs to rtape4 - 2/28/96 - j.m.wade
c
c     call rtape4 (luin, itr, lbyte0, lbytes0)
c     lbytes = lbytes0
c     lbyte  = lbyte0
      call rtape (luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'SCAN: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINEHEADER)
      call saver(itr, 'SmpInt', nsi  , LINEHEADER)
      call saver(itr, 'NumTrc', ntrc , LINEHEADER)
      call saver(itr, 'NumRec', nrec , LINEHEADER)
      call saver(itr, 'Format', iform, LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINEHEADER)

c------
c     save certain parameters

c-----------
c format values are:
 
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('SoPtAl',ifmt_SoPtAl,l_SoPtAl,ln_SoPtAl,TRACEHEADER)
      call savelu('SoPtBi',ifmt_SoPtBi,l_SoPtBi,ln_SoPtAl,TRACEHEADER)

      if (byte .ne. 0 .and. ifmt .eq. 0) then
         write(LER,*)'Must specify length in bytes of hdr wrd - option 
     1bypassed'
         byte = 0
         ifmt = 0
      elseif (byte .eq. 0 .and. ifmt .ne. 0) then
         write(LER,*)'Must specify offset in bytes of hdr wrd - option 
     1bypassed'
         byte = 0
         ifmt = 0
      elseif (byte .ne. 0 .and. ifmt .ne. 0) then
         if (ifmt .eq. 3 .and. mod(byte,2) .ne. 0) then
            write(LER,*)'For real value length must = 3 - option bypasse
     1d'
            byte = 0
            ifmt = 0
         elseif (ifmt .eq. 3 .and. mod(byte,2) .eq. 0) then
            byte = byte / SZHFWD
         endif
      endif

#ifdef CRAYSYSTEM
      byte = 8 * (byte/2) + 1
#endif


      niw  = max (ni, nw)
      j    = 0

      DO  i = 1, niw


          if (ihdwd(i) .ne. 0) then

              if (ihdwd(i) .eq. 255) then
                 j = j + 1
                 call savelu('SoPtAl',ifmt_SoPtAl,l_SoPtAl,ln_SoPtAl,
     1                       TRACEHEADER)
	         ifmtw(j)   = ifmt_SoPtAl
                 l_word(j)  = l_SoPtAl
	         lengthw(j) = ln_SoPtAl

              elseif (ihdwd(i) .eq. 256) then
                 j = j + 1
                 call savelu('SoPtBi',ifmt_SoPtBi,l_SoPtBi,ln_SoPtBi,
     1                       TRACEHEADER)
	         ifmtw(j)   = ifmt_SoPtBi
                 l_word(j)  = l_SoPtBi
	         lengthw(j) = ln_SoPtBi

              elseif (ihdwd(i) .eq. 128) then
                 ni = ni + 1
                 j = j + 1
                 call savelu('SoPtAl',ifmt_SoPtAl,l_SoPtAl,ln_SoPtAl,
     1                       TRACEHEADER)
                 call savelu('SoPtBi',ifmt_SoPtBi,l_SoPtBi,ln_SoPtBi,
     1                       TRACEHEADER)
	         ifmtw(j)   = ifmt_SoPtAl
                 l_word(j)  = l_SoPtAl
	         lengthw(j) = ln_SoPtAl
                 j = j + 1
	         ifmtw(j)   = ifmt_SoPtBi
                 l_word(j)  = l_SoPtBi
	         lengthw(j) = ln_SoPtBi
              else
                  j = j + 1
	          ifmtw(j)   = SAVE_INTEGER2_DEF
	          lengthw(j) = 4
                  l_word(j)  = ihdwd(i)
              endif
          endif

          if (word(i) .ne. '      ') then
                 j = j + 1
                 call savelu( word(i),ifmtw(j),l_word(j),lengthw(j),
     1                       TRACEHEADER)
          endif


      ENDDO
      ninw = ni + nw

      do  j = 1, ninw
          write(LOT,*)'J= ',j,' ifmtw, l_word, lengthw= ',
     1                 ifmtw(j), l_word(j), lengthw(j)
      enddo
 
      call saver(itr, 'GrpInt', grp , LINEHEADER)
      call saver(itr, 'OACLin', oac  , LINEHEADER)

      call stoint (grp, igrp)
c     write(LOT,*)'grp= ',grp,igrp - how'd this get here ?  - j.m.wade -
c-----
c      ensure that command line values are compatible with data set
c-----
c     call cmdchk(ns,ne,rs,re,ntrc,nrec)
      if (ns .eq. 0) ns = 1
      if (ne .eq. 0) ne = ntrc
      if (re .eq. 0) re = nrec

      if(iabs(np) .gt. nsamp) np=np*nsamp/iabs(np)

c-----
c      verbose output of all pertinent information before
c      processing begins
c-----
      IF (.not. stream) THEN
c-----
c     dump historical line header information
c-----
         call savhlh(itr,lbytes,lbyout)
         if(verbos .or. terse .or. verby .or. summary .or. comp)then
               call verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,
     1                     ns,ne,rs,re,verbos,luin,grp,nbin,ihdwd,oac,
     2                     word,ni,nw,lbyout,unitsc)
         endif
      ENDIF

      IF (.not. stream) THEN
         if (verby)  call shwhed(itr,LINHED,mbs)
         if (vrbhlh) call shwhlh (itr)
         if (.not.verby .and. .not.verbos .and. .not.terse .and.
     1       .not.summary .and. .not. comp) stop
      ELSE

         if (np .eq. 0) np = nsamp

      ENDIF
c
c - now allocate space based on trace size
c
      alloc_size = SZTRHD + nsamp * SZSMPD
      errcod = 0
      call grealloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
c     else
c	write(LER,*) 'Workspace Allocation: ',
c    :             alloc_size,' bytes requested '
      endif

      alloc_size = (nsamp+5) * SZSMPD
      errcod = 0
      call galloc(mem_tri,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
c     else
c	write(LER,*) 'Workspace Allocation: ',
c    :             alloc_size,' bytes requested '
      endif

      alloc_size = (nbin+2) * SZSMPD
      errcod = 0
      call galloc(mem_distr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
c     else
c	write(LER,*) 'Workspace Allocation: ',
c    :             alloc_size,' bytes requested '
      endif

      alloc_size = (nbin+2) * SZSMPD
      call galloc(mem_distt,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
c     else
c	write(LER,*) 'Workspace Allocation: ',
c    :             alloc_size,' bytes requested '
      endif
c-----
c      BEGIN PROCESSING
c      read trace
c----
c-----
c     skip unwanted records
c-----
      call recskp(1,rs-1,luin,ntrc,itr)

c-----
c     process desired trace records
c-----

      DO  1000 jj = rs, re

            recmax = -1.e+30
            recmin = +1.e+30
            recrms = 0.
            live = 0
            large = 0
            little = 0

c-----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c-----------------------

c-------------------
c  initialize
c  rec hist vector
            call vclr (distr,1,nbin)
c-------------------

            if(terse .and. .not. stream) then

              write(LOT,111)
111           format()
              if (ntrc .gt. 1) then
                 if (byte .ne. 0 .and. ifmt .ne. 0) then
                  write(LOT,114)
c114               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
c     1                   ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
c     2                   ' dist ',' static    HW')
114               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
     1                   ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
     2                   ' dist ',' static    HW',/,
     3' RecNum TrcNum  RecInd DphInd SrcLoc  SoPtNm  SrcPnt LinInd  DstS
     4gn StaCor  HW')
                 else
                  write(LOT,104)
c104               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
c     1                   ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
c     2                   ' dist ',' static ')
104               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
     1                   ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
     2                   ' dist ',' static ',/,
     3' RecNum TrcNum  RecInd DphInd SrcLoc  SoPtNm  SrcPnt LinInd  DstS
     4gn StaCor')
                 endif
                  write(LOT,111)
              elseif (ntrc .eq. 1 .and. jj .eq. rs) then
                 if (byte .ne. 0 .and. ifmt .ne. 0) then
                  write(LOT,114)
                 else
                  write(LOT,104)
                 endif
                  write(LOT,111)
              endif

            endif

            if(comp .and. .not. stream) then
              write(LOT,111)
              if (ntrc .gt. 1) then
                  write(LOT,105)
c105               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
c     1               ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
c     2               ' dist ',' static ',1x,' comps')
105               format('   rec ',2x,' trc  ',2x,' gi ',2x,'  di ',1x,
     1               ' si_x10 ',' src_pt  sp/di ',1x,' li ',3x,
     2               ' dist ',' static ',1x,' comps',/,
     3' RecNum TrcNum  RecInd DphInd SrcLoc  SoPtNm  SrcPnt LinInd  DstS
     4gn StaCor  comps')
              elseif (ntrc .eq. 1 .and. jj .eq. rs) then
                  write(LOT,105)
                  write(LOT,111)
              endif
              write(LOT,111)
            endif


            do 1001 kk=ns,ne
                  nbytes = 0
                  call rtape (luin,itr,nbytes)
                  if(nbytes .eq. 0) go to 999
c                 call vmov  (lhed(ITHWP1), 1, tri, 1, nsamp)
                  call vmov  (itr(ITHWP1), 1, tri, 1, nsamp)

                        call saver2(itr,ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,
     1                               i15   , TRACEHEADER)
                        call saver2(itr,ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,
     1                               i16   , TRACEHEADER)
                        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                               irec  , TRACEHEADER)
                        call saver2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                               itrc  , TRACEHEADER)
                        call saver2(itr,ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,
     1                               idsi  , TRACEHEADER)
                        call saver2(itr,ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     1                                si   , TRACEHEADER)
                        call saver2(itr,ifmt_LinInd,l_LinInd,ln_LinInd,
     1                                li   , TRACEHEADER)
                        call saver2(itr,ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,
     1                               pri   , TRACEHEADER)
                        call saver2(itr,ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,
     1                               pti   , TRACEHEADER)
                        call saver2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1                               dist  , TRACEHEADER)
                        call saver2(itr,ifmt_RecInd,l_RecInd,ln_RecInd,
     1                                gi   , TRACEHEADER)
                        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                               dstsgn, TRACEHEADER)
                        call saver2(itr,ifmt_DphInd,l_DphInd,ln_DphInd,
     1                                di   , TRACEHEADER)
                        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     1                               stacor, TRACEHEADER)
                        call saver2(itr,ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     1                                srcpt, TRACEHEADER)

                    IF (stacor .ne. 30000) THEN

                       if    (dstsgn .lt. 0.) then
                          if (dstsgn .le. xleft) xleft = dstsgn
                          if (dstsgn .ge. gapleft) gapleft = dstsgn
                          isprd1 = 1
                       elseif (dstsgn .ge. 0.) then
                          if (dstsgn .ge. xright) xright = dstsgn
                          if (dstsgn .le. gapright) gapright = dstsgn
                          isprd2 = 2
                       endif

                    ENDIF

                    if (byte .ne. 0 .and. ifmt .ne. 0) then
                       if (ifmt .eq. 3) then
                          call getfp2 (itr, 4,byte,4,value,1)
                       else
                          ivalue = getrin (itr, byte, ifmt)
                       endif
                    endif
                        
                    if(verby)call shwhed(itr,TRCHED,mbs)

c--------------------------
c  initialize
c  trc hist vector, calc
c  hist for each trace &
c  accumulate hist foreach
c  record
                        call vclr (distt,1,nbin)
c--------------------------
                        if(stacor .ne. 30000) then

                           live = live + 1
                           call maxv (tri,1,xmax,indxu,nsamp)
                           call minv (tri,1,xmin,indxl,nsamp)
                           call rmsqv(tri,1,xrms,nsamp)
                           call vclr (distt,1,nbin)
                           call hist (tri,1,distt,nsamp,nbin,xmax,xmin)
                           trcmax = xmax
                           trcmin = xmin
                           recrms=recrms+xrms
                           if(xmax .ge. recmax) then
                              recmax = xmax
                              large = itrc
				lrgsmp = indxu
                           endif
                           if(xmin .le. recmin) then
                              recmin = xmin
                              little = itrc
				ltlsmp = indxl
                           endif
                           call hist (tri,1,distr,nsamp,nbin,recmax,
     1                                recmin)
                        else
                           trcmax = 0.
                           trcmin = 0.
                           xmax = 0.
                           xmin = 0.
                           call vclr (distt,1,nbin)
                        endif

                    if(terse .and. .not. stream) then
                       if (byte .ne. 0 .and. ifmt .ne. 0) then
                         if (ifmt .eq. 3) then
                           write(LOT,113) irec,itrc,gi,di,si,srcpt,idsi,
     1                                    li,dstsgn,stacor,value
                         else
                           write(LOT,103) irec,itrc,gi,di,si,srcpt,idsi,
     1                                    li,dstsgn,stacor,ivalue
                         endif
                       else
                         write(LOT,103) irec,itrc,gi,di,si,srcpt,idsi,
     1                                  li,dstsgn,stacor
                       endif

113                    format(i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,
     1                        i6,3x,i6,1x,i6,e9.2)
103                    format(i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,
     1                        i6,4x,i6,1x,i6,1x,i5)

                       do  i = 1, ninw

                       if (l_word(i) .ne. 0)then

                          if (ifmtw(i) .eq. SAVE_LONG_DEF .or.
     :				ifmtw(i) .eq. SAVE_SHORT_DEF) then
                             if (realv) then
                                call getfp2(itr,ifmtw(i),l_word(i),
     :                                    lengthw(i),value,TRACEHEADER)
                             write(LOT,*)'      Header word ',l_word(i),
     :                                    ' = ',value
                             else
                                call saver2(itr,ifmtw(i),l_word(i),
     :                                    lengthw(i),ivalue,TRACEHEADER)
                             write(LOT,*)'      Header word ',l_word(i),
     :                                    ' = ',ivalue
                             endif
                          elseif ((ifmtw(i) .eq. SAVE_FLOAT_DEF) .or.
     :				(ifmtw(i) .eq. SAVE_FKFLT_DEF)) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),value,TRACEHEADER)
                           write(LOT,*)'      Header word ',l_word(i),
     :                                  ' = ',value
                          elseif (ifmtw(i) .eq. SAVE_CHAR_DEF) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),cvalue,TRACEHEADER)
                           write(LOT,*)'      Header word ',l_word(i),
     :                                  ' = ',cvalue
                          endif

                       endif
                       enddo

                    endif

                    if(comp) then
                       write(LOT,106) irec,itrc,gi,di,si,srcpt,idsi,
     1                                li,dstsgn,stacor,i15,i16
106                    format(i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,i6,1x,
     1                        i6,4x,i6,1x,i6,4x,2i2)

                       do  i = 1, ninw

                       if (l_word(i) .ne. 0)then

                          if (ifmtw(i) .eq. SAVE_LONG_DEF .or.
     1				ifmtw(i) .eq. SAVE_SHORT_DEF) then
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),ivalue,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  ivalue
                          elseif ((ifmtw(i) .eq. SAVE_FLOAT_DEF) .or.
     :				(ifmtw(i) .eq. SAVE_FKFLT_DEF)) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),value,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  value
                          elseif (ifmtw(i) .eq. SAVE_CHAR_DEF) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),cvalue,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  cvalue
                          endif

                       endif
                       enddo

                    endif

                    if(verbos) then

                       write(LOT,111)
                       write(LOT,104)
                       write(LOT,103) irec,itrc,gi,di,si,srcpt,idsi,
     1                                dstsgn,stacor

                       do  i = 1, ninw

                       if (l_word(i) .ne. 0)then

                          if (ifmtw(i) .eq. SAVE_LONG_DEF .or.
     1				ifmtw(i) .eq. SAVE_SHORT_DEF) then
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),ivalue,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  ivalue
                          elseif ((ifmtw(i) .eq. SAVE_FLOAT_DEF) .or.
     :				(ifmtw(i) .eq. SAVE_FKFLT_DEF)) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),value,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  value
                          elseif (ifmtw(i) .eq. SAVE_CHAR_DEF) then 
                            call saver2(itr,ifmtw(i),l_word(i),
     :                                  lengthw(i),cvalue,TRACEHEADER)
                           write(LOT,*)'Header word ',l_word(i),' = ',
     :                                  cvalue
                          endif

                       endif
                       enddo

                      write(LOT,*)JJ,KK,' Min/Max amp= ',trcmin,trcmax,
     1                            ' Samps= ',indxl,indxu
                       write(LOT,111)
                       write(LOT,*)'~~~~~~~ trace histogram  ~~~~~~~'
                       write(LOT,*)'~ bin size=  ',(trcmax-trcmin)/nbin
                       write(LOT,*)'~'
                       write(LOT,*)'~ Index      | min ampl      <---      
     1             {distribution}             --->       max ampl |'
                       write(LOT,109)(ii,ii=1,10)
109                    format(7x,10(i8,1x))
                       write(LOT,*)'~'
                       write(LOT,*)'~'
                       do  820  i = 1, nbin, 10
                           write(LOT,110)i,(ifix(distt(ii)),ii=i,i+9)
110                        format(i5,2x,10(i8,1x))
820                    continue
                       write(LOT,*)'~'
                       write(LOT,*)'~'
                       write(LOT,*)'~~~~~~~ trace histogram  ~~~~~~~'
                       write(LOT,111)

                    endif

c----------------
c  section to
c  write out trc
c  values
              if(np .gt. 0 .and. .not. stream) then

                  ic = 0
c
c I don't know why np-1 was used; caused one-sample dataset bug - jmw - 7/24/96
c
c                 do 819 i = 1, np-1, idec
                  do 819 i = 1, np, idec
                     ic = ic + 1
                     if (mod(ic,5) .eq. 0 .or. ic .eq. 1) then
                        if (ic .eq. 1) then
                           j = 1
                        else
                           j = i + 1
                        endif
                        write(LOT,101) j,(tri(ii),ii=j,j+4*idec,idec)
  101                   format(i5,5x,5(e15.8,3x))
                     endif
  819             continue
                        

              elseif(np .lt. 0 .and. .not. stream) then

                  if (kk .gt. ns) write(LOT,*)' '
                  do  821  i = 1, iabs(np), idec
                      write(LOT,102) float((i-1)*nsi),tri(i)
102                   format(f10.2,5x,e12.3)
821               continue

              endif
              if (verbos)write(LOT,*)'++++++++++++++++++++++++++++++++++
     1++++++++++++++++++++++++++++++++'
c----------------
              if (stream) then
                 if (maxtim) then
                     write(LOT,133)irec, itrc, trcmax, (indxu-1)*nsi
133                  format (2i10,5x,e15.5,5x,i10)
                 else
                     write(LOT, fmt) (tri(i), i=1,np,idec)
                     write(LOT,*)' '
                 endif
              endif

 1001       continue

c-----------------------
c skip to end of current
c record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

c-----------------------

            if( summary ) then

                if (live .eq. 0) then
                   recmax = 0.
                   recmin = 0.
                   call vfill (0.0, distr, 1, nbin)
                else
                   recrms=recrms/live
                endif

                write(LOT,111)
                write(lOT,*)'Rec= ',irec,'  live traces= ',live
                write(LOT,*)'RMS  ampl= ',recrms
		write(LOT,*)' '
                write(LOT,*)'Min. ampl= ',recmin,' at Seql Rec=',JJ,
     *			' at trace=',little,' at Sample No.=',ltlsmp
                write(LOT,*)'Max. ampl= ',recmax,' at Seql Rec=',JJ,
     *			' at trace=',large, ' at Sample No.=',lrgsmp
		write(LOT,*)' '
                write(LOT,111)
                write(LOT,*)'~~~~~~~ record histogram  ~~~~~~~'
                write(LOT,*)'~ bin size=  ',(recmax-recmin)/nbin
                write(LOT,*)'~'
                       write(LOT,*)'~ Index      | min ampl      <---      
     1             {distribution}             --->       max ampl |'
                write(LOT,109)(ii,ii=1,10)
                write(LOT,*)'~'
                write(LOT,*)'~'
                do  822  i = 1, nbin, 10
                    write(LOT,110)i,(ifix(distr(ii)),ii=i,i+9)
822             continue
                write(LOT,*)'~'
                write(LOT,*)'~'
                write(LOT,*)'~~~~~~~ record histogram  ~~~~~~~'
                write(LOT,111)

            endif


 1000 CONTINUE

  999 continue

      
      IF (.not. stream) THEN

      isprd = isprd1 + isprd2
      write(LOT,*)' '
      write(LOT,*)'Spread Summary:'
      write(LOT,*)' '
        if     (isprd .eq. 1) then
           write(LOT,*)'Most negative distance            = ',xleft
           write(LOT,*)'Least negative distance           = ',gapleft
        elseif (isprd .eq. 2) then
           write(LOT,*)'Least positive distance           = ',gapright
           write(LOT,*)'Most positive distance            = ',xright
        elseif (isprd .eq. 3) then
           write(LOT,*)'Most negative distance            = ',xleft
           write(LOT,*)'Least negative distance           = ',gapleft
           write(LOT,*)'Least positive distance           = ',gapright
           write(LOT,*)'Most positive distance            = ',xright
        endif

      ENDIF

      close (LOT)
      call lbclos(luin)

      stop 0
      end


      function jchar(c)
      character*1 c
             jchar = ichar(c)
             if(jchar.lt.0)jchar = 256 + jchar
      return
      end

      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     1'***************************************************************'
      write(LER,*)' '
      write(LER,*)
     1'Execute scan by typing scan with the following arguments'
      write(LER,*)
     1' -N [ntap]    (default stdin) : Input data file name'
      write(LER,*)
     :' -ns[ns]      (default=first) : start trace # (sequential)'
      write(LER,*)
     :' -ne[ne]      (default=last)  : end trace # (sequential)'
      write(LER,*)
     :' -rs[rs]      (default=first) : start record # (sequential)'
      write(LER,*)
     :' -re[re]      (default=last)  : end record # (sequential)'
      write(LER,*)
     1' -np [np]     (default=0)     : print first np trace samples'
      write(LER,*)
     1' -i [idec]    (default=1)     : output sample increment'
      write(LER,*)
     1' -b [nbin]    (default=10)    : number bins for histogram' 
      write(LER,*)
     1' -w [ihdwd]   (default=0)     : aditional header wd position, or'
      write(LER,*)
     1' -w [ihdwd]   (default=0)     : aditional header wd position, or'
      write(LER,*)
     1'                  ...'
      write(LER,*)
     1' -W [word]    (default=none)  : aditional header wd mnemonic'
      write(LER,*)
     1' -W [word]    (default=none)  : aditional header wd mnemonic'
      write(LER,*)
     1' -R           : hdr word above is real packed into integer loc'
      write(LER,*)
     1'                  ...'
      write(LER,*)' '
      write(LER,*)
     1' -t           : output trace indices only (default)'
      write(LER,*)
     1' -c           : output trace indices (multicomponent)'
      write(LER,*)
     1' -v           : verbose output, including histogram'
      write(LER,*)
     1' -V           : very verbose output'
      write(LER,*)
     1' -mbs         : on verbose output, use selected mbs mneumonics'
      write(LER,*)
     1' -H           : header info'
      write(LER,*)
     1' -S           : record-by-record summary, including histogram'
      write(LER,*)
     1' -M           : output formatted stream of trace amplitudes'
      write(LER,*)
     1' -mt          : output only rec#, trc#, max ampl, time of max'
      write(LER,*)
     1' -F [fmt]   (default=(E15.4)) : format for stream output'
      write(LER,*)
     1' -B [byte]  (default=0)       : optional hdr wrd byte offset'
      write(LER,*)
     1' -L [length](default=0)       : optional hdr wrd length (bytes)'
      write(LER,*)' '
      write(LER,*)
     1'Usage:      scan -N[ntap] -ns[] -ne[] -rs[] -re[] -np[] -b[]'
      write(LER,*)
     1'                 -i[] [-w[], -W[]] [-mt M -F[] -v -V -H -S -[tc]]
     2'
      write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ns,ne,rs,re,ntap,np,terse,comp,verbos,verby,
     1	vrbhlh,summary,nbin,ihdwd, stream, fmt, idec,word,ni,nw,
     2            byte,ifmt,calgary,mbs,realv,maxtim)

#include <f77/iounit.h>
      integer   ns, ne, rs, re, np
      character ntap*(*), fmt*(*), word(*)*6
      integer   argis, nbin, ihdwd(*), ifmt, byte
      logical   terse, verbos, verby, vrbhlh, comp, summary, stream
      logical   calgary, realv, maxtim
      integer   mbs

            call argstr('-N', ntap, ' ', ' ' )
            call argstr('-F', fmt, '(e15.4)', '(e15.4)' )
            call argi4 ('-ns' , ns, 0, 0)
            call argi4 ('-ne' , ne, 0, 0)
            call argi4 ('-rs',rs,1,1)
            call argi4 ('-re',re,0,0)
            call argi4('-np', np, 0, 0)
            call argi4('-b', nbin, 10, 10)
            call argi4('-B', byte, 0, 0)
            call argi4('-L', ifmt, 0, 0)

            ni = 0
            nw = 0
            do  i = 1, 10

                call argi4('-w', ihdwd(i), 0, 0)
                if (ihdwd(i) .ne. 0) then
                   ni = ni + 1
                endif
                if (ihdwd(i) .lt. 0 .or. ihdwd(i) .gt. 256) then
                    write(LOT,*)'trace header word must lie in range'
                    write(LOT,*)'     1 =< ihdwd =< 256'
                    stop
                endif

                call argstr('-W', word(i), '      ', '      ' )
                if (word(i) .ne. '      ') then
                   nw = nw + 1
                endif
            enddo

            call argi4('-i', idec, 1, 1)

            stream = (argis ('-M') .gt. 0)
            if (stream) then
               verbos  = .false.
               verby   = .false.
               terse   = .false.
               comp    = .false.
               vrbhlh  = .false.
               summary = .false.
            else
               verbos  = ( argis ('-v') .gt. 0 )
               verby   = ( argis ('-V') .gt. 0 )
               terse   = ( argis ('-t') .gt. 0 )
               comp    = ( argis ('-c') .gt. 0 )
               realv   = ( argis ('-R') .gt. 0 )
               calgary = ( argis ('-Calgary') .gt. 0 )
               mbs     = argis ('-mbs')
               vrbhlh  = (argis ('-H') .gt. 0)
               summary = (argis ('-S') .gt. 0)
               maxtim  = (argis ('-mt') .gt. 0)
               if (maxtim) stream = .true.
            endif
            if(.not.verbos .and. .not.verby .and.
     1         .not.terse .and. .not.comp .and.
     2         .not.vrbhlh .and. .not.summary) terse = .true.

            if (calgary) then
                byte = 255
                ifmt = 2
            endif

      return
      end

      subroutine verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,
     1 ns, ne, rs, re, verbos,luin,grp,nbin,ihdwd,oac,word,ni,nw,
     2 lbyout,unitsc)

c-----
c     verbose output of processing parameters
c
c     lbytes- I*4 number of bytes in line header
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     rs    - I*4 starting record
c     re    - I*4 ending record
c     nbin  - I*4 no. histogram bins
c     ihdwd - I*4 additional header word position
c     grp   - C*4 group interval
c     oac   - C*8 group interval
c     verbos- L   verbose information
c     unitsc- R*4 unit scale factor
c-----
#include <f77/iounit.h>

      integer   lbytes, nsamp, nsi, ntrc, nrec, iform
      character ntap*(*), grp*4, oac*8, word(*)*6
      integer   ns, ne, rs, re, nbin, ihdwd(*)
      logical   verbos
      integer   lenstr

            ln = lenstr(ntap)
            write(LOT,*)' '
            write(LOT,*)' line header values after default check '
c           write(LOT,*) ' # of bytes in line header=',lbyte0,lbytes0
c           write(LOT,*) ' # of bytes in line header=',lbyte,lbytes
            write(LOT,*) ' # of bytes in line header=',lbytes
            write(LOT,*) ' # of bytes in output line header=',lbyout
            write(LOT,*) ' # of samples/trace =  ', nsamp
            write(LOT,*) ' sample interval    =  ', nsi
            write(LOT,*) ' s.i. multiplier    =  ', unitsc
            write(LOT,*) ' traces per record  =  ', ntrc
            write(LOT,*) ' records per line   =  ', nrec
            write(LOT,*) ' format of data     =  ', iform
            write(LOT,*) ' luin               =  ', luin
            write(LOT,*) ' input data set name =  ', ntap(1:ln)
            write(LOT,*) ' ns (starting trace)    =  ',ns
            write(LOT,*) ' ne (ending trace  )    =  ',ne
            write(LOT,*) ' rs (starting record)   =  ',rs
            write(LOT,*) ' re (ending record)     =  ',re
            write(LOT,*) ' Group interval         =  ',grp
            write(LOT,*) ' OAC Line               =  ',oac
            do  i = 1, ni
            write(LOT,*) ' Additional header word =  ',ihdwd(i)
            enddo
            do  i = 1, nw
            write(LOT,*) ' Additionl hdr word mnemonic =  ',word(i)
            enddo
            write(LOT,*) ' Number ampl. histogrm bins= ',nbin
            write(LOT,*) ' NOTE: a bin = (trcmax-trcmin)/nbin'
            write(LOT,*) ' verbose output         =  ',verbos
            write(LOT,*)' '
      return
      end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end

