C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ELOPEN(NOTUSD,BLKSRQ,BYTSRQ)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

C     THIS SET OF ROUTINES IS A REPLACEMENT FOR THE ORIGINAL ELOPEN
C     ELWRTE AND ELREAD ROUTINES IN SCOR.  THE ORIGINAL ROUTINES
C     WERE AN INTERFACE TO THE DAOPEN, DAWRTE AND DAREAD BLOCK DISK
C     I/O ROUTINES.  THIS VERSION SIMULATES DISK BLOCKS IN MEMORY
C     ACQUIRED VIA GALLOC. NOTE - FLOWTRACE DOES NOT FUNCTION
C     PROPERLY WITH THIS ROUTINE AS ENTRY STATEMENTS CONFUSE IT.

c     INTEGER BLKSRQ, BYTSRQ, SIMDSK(1,1), BUFR(*)
      INTEGER BLKSRQ, BYTSRQ, SIMDSK(*), BUFR(*)

      PARAMETER (NBPW=SZSMPD)

      POINTER (PD,SIMDSK)

      SAVE

      NBYTES = BYTSRQ

      NBLOKS = BLKSRQ

      NWORDS = NBYTES/NBPW

      IF (MOD(NBYTES,NBPW) .NE. 0) NWORDS = NWORDS + 1

      NTOTAL = NWORDS*NBLOKS

      CALL GALLOC(PD,NTOTAL*SZSMPD,KODE,0)
      IF (KODE .NE. 0) CALL ELALER(KODE,NBLOKS,NBYTES)

      RETURN

      ENTRY ELWRTE(K,BUFR) 

C     WRITE BLOCK K IF IN RANGE

      IF (K .LT. 1 .OR. K .GT. NBLOKS) THEN
          WRITE(LERR,*) 'ELWRTE: BLOCK ', K, ' OUT OF RANGE'
          WRITE(LERR,*) 'Legal range= 1,',NBLOKS
          CALL ABORT
      ENDIF

      CALL ELPUT(SIMDSK,BUFR,K,NBYTES,NWORDS,NBLOKS,NBPW)

      RETURN

      ENTRY ELREAD(K,BUFR) 

C     READ BLOCK K IF IN RANGE

      IF (K .LT. 1 .OR. K .GT. NBLOKS) THEN
          WRITE(LERR,*) 'ELREAD: BLOCK ', K, ' OUT OF RANGE'
          CALL ABORT
      ENDIF

      CALL ELGET(SIMDSK,BUFR,K,NBYTES,NWORDS,NBLOKS,NBPW)

      RETURN

      END

      SUBROUTINE ELGET(SIMDSK,BUFR,BLOCK,NBYTES,NWORDS,NBLOKS,NBPW)

C     GET SIMULATED DISK BLOCK FROM SIMDSK INTO BUFR

      INTEGER SIMDSK(NWORDS,NBLOKS), BUFR(NWORDS), BLOCK 

      IF (MOD(NBYTES,NBPW) .EQ. 0) THEN
          DO 1 J = 1, NBYTES/NBPW
             BUFR(J) = SIMDSK(J,BLOCK)
1         CONTINUE
          RETURN
      ENDIF
     
      CALL MOVE(1,BUFR,SIMDSK(1,BLOCK),NBYTES)

      RETURN

      END

      SUBROUTINE ELPUT(SIMDSK,BUFR,BLOCK,NBYTES,NWORDS,NBLOKS,NBPW)

C     PUT SIMULATED DISK BLOCK FROM BUFR INTO SIMDSK

      INTEGER SIMDSK(NWORDS,NBLOKS), BUFR(NWORDS), BLOCK

      IF (MOD(NBYTES,NBPW) .EQ. 0) THEN
          DO 1 J = 1, NBYTES/NBPW
             SIMDSK(J,BLOCK) = BUFR(J)
1         CONTINUE
          RETURN
      ENDIF

      CALL MOVE(1,SIMDSK(1,BLOCK),BUFR,NBYTES)

      RETURN

      END

      SUBROUTINE ELALER(KODE,NBLOKS,NBYTES)

#include <f77/iounit.h>
C     PRINT ERROR INFO FOR ELOPEN AND THEN CROAK

      WRITE(LERR,*) 'ELOPEN: CAN''T ACQUIRE ', NBLOKS, ' BLOCKS OF ',
     & NBYTES, ' BYTES'            

      IF (KODE .EQ. -1) THEN
          WRITE(LERR,*) 'BAD LENGTH'
      ELSEIF (KODE .EQ. -2) THEN
          WRITE(LERR,*) 'OUT OF MEMORY'
      ELSEIF (KODE .EQ. -3) THEN
          WRITE(LERR,*) 'BAD ADDRESS'
      ELSEIF (KODE .EQ. -4) THEN
          WRITE(LERR,*) 'BLOCK IS FREE'
      ELSEIF (KODE .EQ. -5) THEN
          WRITE(LERR,*) 'BAD CONTROL WORD FOR ALLOC BLOCK'
      ELSEIF (KODE .EQ. -6) THEN
          WRITE(LERR,*) 'BAD CONTROL WORD FOR FREE BLOCK'
      ELSEIF (KODE .EQ. -7) THEN
          WRITE(LERR,*) 'CONTROL FOR NEXT BLOCK IS BAD'
      ELSE
          WRITE(LERR,*) 'UNKNOWN ERROR CODE:', KODE
      ENDIF

      CALL ABORT

      END
