C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ERRCAL ( RMS, I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK,
     *                    NITEMS )
C***********************************************************************
C
C     SUBROUTINE NAME: ERRCAL
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE ERRCAL CALCULATES THE RMS ERROR
C               ASSOCIATED WITH A GIVEN SET OF PICKS.
C               THIS ERROR IS THE DEVIATION FROM THE BEST PICK
C               FROM THE EVENT TAPE.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C
C     PARAMETERS PASSED:
C        RMS    - RMS ERROR FOR A SET OF PICKS
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        C      - STRUCTURE CORRECTIONS
C        M      - MOVEOUT CORRECTIONS
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL        I(12001), R(12001), C(30001), M(30001), ARRAY(8190)
C
      INTEGER     DI, GI, TPRI
C
      DATA DEAD/-10000./
C
      SAVE ! CRAY
C
      SUM   = 0.0
      KOUNT = 0
C
C---- READ THROUGH ENTIRE DATA SET
      DO 200 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 100 IPNT2 = 1,N
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- IS PICK DEAD ???

            IF ( ARRAY( INDEX ) .EQ. DEAD ) GO TO 100
C
C---- GET THE INDICES.....
            DI   = ARRAY( INDEX + 6 )
            GI   = ARRAY( INDEX + 7 )
            TPRI = ARRAY( INDEX + 8 )
C
C---- SUM UP SEPARATE COMPONENTS...
            FACT = I(TPRI) + R(GI) + C(DI) + M(DI) * ARRAY( INDEX + 9 )
C
C---- DETERMINE ERROR....
            ERROR = ARRAY( INDEX ) - FACT
C
C---- KEEP TRACK OF HOW MANY
C---- ERRORS ARE BEING SUMMED UP..
            KOUNT = KOUNT + 1
C
C---- SUM UP THE SQUARE OF THE ERRORS...
            SUM = SUM + ( ERROR * ERROR )
C
  100    CONTINUE
  200 CONTINUE
C
C---- GET MEAN ERROR...
      SUM = SUM / KOUNT
C
C---- GET ROOT MEAN SQUARE ERROR...
      RMS = SQRT( SUM )
C
C---- SPLIT MAN...
      RETURN
      END
