C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE EVTIME ( FREC, LREC, REC1, REC2, BASESQ, IBUF, IEVENT,
     *                    CFOLD, IGRP, ARRAY, NBLK, LBLK, NTRBLK,
     *                    NITEMS, GIDIM, DIDIM , ITRWRD, SZSMPD, SZLNHD,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * verbos)
C***********************************************************************
C
C     SUBROUTINE NAME: EVTIME
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE EVTIME READS AN EVENT TAPE CREATED BY
C               PROGRAM TIME(TIDO), CONVERTS THE TIMES TO LAGS,
C               REMOVES THE MEAN, AND AVERAGES UP TO SIX EVENT
C               TIMES PER TRACE TO COME UP WITH A SET OF PICKS
C               COMPARABLE TO A PICK TAPE.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C
C     PARAMETERS PASSED:
C        FREC   - FIRST RECORD TO PROCESS FROM 1SCOR CARD
C        LREC   - LAST RECORD TO PROCESS FROM 1SCOR CARD
C        REC1   - FIRST RECORD ON EVENT TAPE
C        REC2   - LAST RECORD ON EVENT TAPE
C        BASESQ - BASE DISTANCE SQUARED FOR NMO CALCULATIONS
C        IBUF   - EVENT TRACE BUFFER
C        IEVENT - WHICH EVENTS TO PROCESS ON TIME TAPE
C        CFOLD  - FOLD FROM 1SCOR CARD
C        IGRP   - 3D PROCESSING FLAG
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C        GIDIM  - GROUP INDEX LIMIT
C        DIDIM  - DEPTH INDEX LIMIT
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL        ARRAY(8190), SUM(10)
C
      INTEGER     IEVENT(10), LIVCNT(10), GIDIM, DIDIM, TPRI, CFOLD,
     *            TOTPIK, FREC, REC1, REC2, BLKCNT, NITEMS,
     *            ITRWRD, SZSMPD, SZLNHD
C
      INTEGER     IBUF(6128)
      logical     verbos
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA INDEX/1/, MFLAG/0/, TOTPIK/0/, IDEAD/-10000/, DEAD/-10000./
C
      SAVE ! Cray
C
C---- INITIALIZE FLAGS AND COUNTERS
      NBLK = 0
      BLKCNT = 0
C
C---- READ TRACE AND DETERMINE
C---- IF 56 OR 256 BYTE TRACE HEADER...
      LENGTH = 0
      CALL RTAPE ( INEVNT, IBUF, LENGTH )
      IF ( LENGTH .NE. 0 ) GO TO 200
C
      WRITE(IPRNTR,100)
  100 FORMAT(/,12X, ' ** M7304 ** ERROR DETECTED BY SUBROUTINE EVTIME:',
     *       /,25X, 'END-OF-FILE ENCOUNTERED ON THE EVENT TAPE BEFORE',
     *       /,25X, 'ANY TRACES WERE READ.  VERIFY THE DATA SET NAME,',
     *       /,25X, 'AND CHECK FOR ERRORS IN PREVIOUS PROCESSING ',
     *              'STEPS.',/)
      GO TO 3700
C
  200 IREAD = 1

C
C---- TRAP FIRST RECORD ON TAPE....
  500 continue
c 500 REC1 = IBUF(106)
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    REC1 , 1)
C
C---- INITIALIZE COUNTER FOR
C---- NUMBER OF TRACES IN FOLD...
  600 continue
      TOTPIK = 0
C
C---- ZERO OUT ARRAYS FOR EVENTS....
      CALL MOVE ( 0, SUM, 0, 10*SZSMPD )     ! Cray
      CALL MOVE ( 0, LIVCNT, 0, 10*SZSMPD )  ! Cray
      GO TO 800
C
C---- READ NEXT TRACE
  700 LENGTH = 0
      CALL RTAPE ( INEVNT, IBUF(IREAD), LENGTH )
      IF ( LENGTH .EQ. 0 ) GO TO 900
C
C---- IS TRACE WITHIN RECORD BOUNDARIES ???
  800 continue
      IF ( irect .LT. FREC ) GO TO 700
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect , 1)
      IF ( irect .LE. LREC ) GO TO 1100
      GO TO 1000
C
  900 INDEX = INDEX - NITEMS
      IF ( INDEX .LT. 1 ) INDEX = 1 + ( NTRBLK - 1 ) * NITEMS
C
C---- END OF FILE...
 1000 MFLAG = 1
      IF ( TOTPIK .EQ. 0 ) GO TO 3400
      CFOLD = TOTPIK
      GO TO 2400
C
C---- START READING IN EVENT TIMES...
 1100 TOTPIK = TOTPIK + 1
      BLKCNT = BLKCNT + 1
C
C---- IPOINT IS POINTER FOR EVENT TO USE...
      IPOINT = ITRWRD + 1
      KOUNT  = 0
C
c-----
c event trace stores times-weights in alternating pairs (3)
c-----
      DO 1300 L = 1,10
         IF ( IEVENT(L) .EQ. 0 ) GO TO 1300
         ARRAY( INDEX + KOUNT ) = IBUF(IPOINT)
         KOUNT = KOUNT + 1
C
C---- IS EVENT DEAD ???
         IF ( IBUF(IPOINT) .EQ. IDEAD ) GO TO 1200
C
C---- SUM UP EVENT TIMES FOR THIS
C---- EVENT AND KEEP TRACK OF HOW MANY...
         SUM(L) = SUM(L) + IBUF(IPOINT)
         LIVCNT(L) = LIVCNT(L) + 1
C
C---- MAX OF 6 EVENTS TO AVERAGE...
 1200    IF ( KOUNT .EQ. 6 ) GO TO 1400
C
C---- BUMP UP EVENT POINTER...
 1300 IPOINT = IPOINT + 2
C
C---- STUFF SOME GOOD INFO....
 1400 continue
              call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    itrct , 1)
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect , 1)
              call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idi   , 1)
              call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ili   , 1)
              call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                    igi   , 1)
              call saver2(IBUF ,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1                    iprn  , 1)
              call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    istat , 1)
              call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                    idist , 1)
      ARRAY( INDEX + 6 ) = idi
      ARRAY( INDEX + 7 ) = igi
      ARRAY( INDEX + 8 ) = idi - igi
      if (verbos) then
      write(IPRNTR,*)'rec, trc= ',irect,itrct,' stat= ',ARRAY(1)
      endif

      IF ( IGRP .EQ. 3 ) ARRAY( INDEX + 8 ) = iprn
C
      IF ( istat .EQ.  30000 ) GO TO 2200
      i = ITRWRD
      IF ( IBUF(i+ 1) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+ 3) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+ 5) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+ 7) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+ 9) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+11) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+13) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+15) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+17) .NE.  IDEAD ) GO TO 1500
      IF ( IBUF(i+21) .NE.  IDEAD ) GO TO 1500
      GO TO 2200
C
C---- CHECK LIMITS...
C
 1500 IF ( idi .LE. DIDIM ) GO TO 1700
      WRITE(IPRNTR,1600) irect,itrct,idi,DIDIM
 1600 FORMAT(/,12X, ' ** M7301 ** ERROR DETECTED BY SUBROUTINE EVTIME:',
     *       /,25X, 'THE DEPTH INDEX (DI) FOR RECORD ',I5,' TRACE ',I4,
     *       /,25X, 'IS ',I5,'.  THE MAXIMUM DI ALLOWED IS ',I5,'.',
     *       /,25X, 'CHECK THE TRACE HEADER (WORD 122) FOR ENTRIES',
     *       /,25X, 'BEYOND PROGRAM RESTRICTIONS AND EXCLUDE THOSE',
     *       /,25X, 'RECORDS BY USING THE FIRST-LAST RECORDS TO',
     *       /,25X, 'PROCESS ENTRIES (CC 31-35, 36-40).',/)
      GO TO 3700
C
 1700 IF ( igi .LE. GIDIM ) GO TO 1900
      WRITE(IPRNTR,1800) irect,itrct,igi,GIDIM
 1800 FORMAT(/,12X, ' ** M7302 ** ERROR DETECTED BY SUBROUTINE EVTIME:',
     *       /,25X, 'THE GROUP INDEX (GI) FOR RECORD ',I5,' TRACE ',I4,
     *       /,25X, 'IS ',I5,'.  THE MAXIMUM GI ALLOWED IS ',I5,'.',
     *       /,25X, 'CHECK THE TRACE HEADER (WORD 118) FOR ENTRIES',
     *       /,25X, 'BEYOND PROGRAM RESTRICTIONS AND EXCLUDE THOSE',
     *       /,25X, 'RECORDS BY USING THE FIRST-LAST RECORDS TO',
     *       /,25X, 'PROCESS ENTRIES (CC 31-35, 36-40).',/)
      GO TO 3700
C
 1900 TPRI = idi - igi
      IF ( IGRP .EQ. 3 ) TPRI = iprn
      IF ( TPRI .LE. GIDIM
     *          .AND. TPRI .GE. 1 ) GO TO 2200
C
      WRITE(IPRNTR,2000) irect,itrct,TPRI,GIDIM,idi,
     *                   igi
 2000 FORMAT(/,12X, ' ** M7303 ** ERROR DETECTED BY SUBROUTINE EVTIME:',
     *       /,25X, 'THE SOURCE LOCATION INDEX FOR RECORD ',I5,
     *       /,25X, 'TRACE ',I4,' IS ',I5,'.  THE MAXIMUM SOURCE',
     *       /,25X, 'LOCATION INDEX ALLOWED IS ',I5,'.  IF TWO',
     *       /,25X, 'DIMENSIONAL PROCESSING IS REQUESTED ',
     *       /,25X, '(CC 20 = 0 OR 1), THE SOURCE LOCATION INDEX IS',
     *       /,25X, 'THE RESULTANT DIFFERENCE BETWEEN THE DEPTH INDEX',
     *       /,25X, '(DI) AND THE GROUP INDEX (GI).  FOR THIS RECORD',
     *       /,25X, 'AND TRACE, THE DI IS ',I5,' AND THE GI IS ',I5,'.',
     *       /,25X, 'IF THREE-DIMENSIONAL PROCESSING IS REQUESTED',
     *       /,25X, '(CC 20 = 3), THE SOURCE LOCATION INDEX IS THE',
     *       /,25X, 'PERMANENT RECORD INDEX (WORD 110)')
      WRITE(IPRNTR,2100)
 2100 FORMAT(  25X, 'CHECK THE TRACE HEADER WORDS THAT VIOLATE',
     *       /,25X, 'PROGRAM RESTRICTIONS AND EXCLUDE THOSE RECORDS',
     *       /,25X, 'BY USING THE FIRST-LAST RECORDS TO PROCESS ',
     *              'ENTRIES (CC 31-35, 36-40).',/)
      GO TO 3700
C
 2200 continue
      TRDIST = idist
      ARRAY ( INDEX +  9 ) = ( TRDIST * TRDIST ) / BASESQ
      ARRAY ( INDEX + 10 ) = iprn
C
C---- HAVE WE READ "FOLD" TRACES ???
      IF ( TOTPIK .EQ. CFOLD ) GO TO 2400
C
C---- HAVE WE READ A BLOCK OF TRACES ???
      IF ( BLKCNT .LT. NTRBLK ) GO TO 2300
      NBLK = NBLK + 1
      CALL ELWRTE ( NBLK, ARRAY )
      BLKCNT = 0
      INDEX = 1
      GO TO 700
C
 2300 INDEX = INDEX + NITEMS
      GO TO 700
C
C---- COMPUTE MEANS EVENT TIMES...
 2400 DO 2500 L=1,10
         IF ( IEVENT(L) .EQ. 0 ) GO TO 2500
         IF ( LIVCNT(L) .EQ. 0 ) GO TO 2500
         SUM(L) = SUM(L) / LIVCNT(L)
 2500 CONTINUE
C
      IADSAV = INDEX
      N = 0
      NN = NBLK + 2
      NNN = NBLK + 1
C
      DO 3000 L = 1,CFOLD
         AVERAG = -10000.
         TOTAL = 0.
         NUM = 0
         KOUNT = 0
C
C---- REMOVE MEAN TIME AND START SUMMING THEM...
         DO 2700 LL = 1,10
            IF ( IEVENT(LL) .EQ. 0 ) GO TO 2700
            IF ( ARRAY( INDEX + KOUNT ) .EQ. DEAD ) GO TO 2600
            TOTAL = TOTAL + ( ARRAY( INDEX + KOUNT ) - SUM(LL))
C
C---- KEEP TRACK OF HOW MANY...
            NUM = NUM + 1
 2600       KOUNT = KOUNT + 1
C
C---- DON'T GO OVER 6 EVENTS...
            IF ( KOUNT .EQ. 6 ) GO TO 2800
 2700    CONTINUE
C
C---- GET AVERAGE...
 2800    IF ( NUM .GT. 0 ) AVERAG = TOTAL / NUM
         IF ( AVERAG .GT. -10000.0 ) AVERAG = - AVERAG
C
C---- STORE AVERAGED EVENT TIME...
C---- MAKE IT LOOK LIKE A PICK TAPE WAS INPUT...
         ARRAY( INDEX + 0 ) = AVERAG
         ARRAY( INDEX + 1 ) = 1.
         ARRAY( INDEX + 2 ) = -10000.
         ARRAY( INDEX + 3 ) = 0.0
         ARRAY( INDEX + 4 ) = -10000.
         ARRAY( INDEX + 5 ) = 0.0
C
C---- HAVE WE GONE THROUGH "FOLD" TRACES ???
         IF ( L .EQ. CFOLD ) GO TO 3000
         IF ( INDEX .GT. 1 ) GO TO 2900
         N = 1
         NN = NN - 1
         NNN = NNN - 1
         CALL ELWRTE ( NN, ARRAY )
C
C---- READ PREVIOUS BLOCK FROM DISK....
C---- BACK UP...
         CALL ELREAD ( NNN, ARRAY )
         INDEX = ( ( NTRBLK - 1 ) * NITEMS ) + 1
         GO TO 3000
 2900    INDEX = INDEX - NITEMS
 3000 CONTINUE
C
C---- WRITE BACK TO DISK...
      IF ( N .EQ. 0 ) GO TO 3200
      CALL ELWRTE ( NNN, ARRAY )
C
C---- HAVE WE FILLED UP A BLOCK ???
C---- IF SO RESET POINTER CRUD...
      IF ( BLKCNT .LT. NTRBLK ) GO TO 3100
      NBLK = NBLK + 1
      BLKCNT = 0
      INDEX = 1
      GO TO 3300
 3100 N = NBLK + 1
      CALL ELREAD ( N, ARRAY )
 3200 INDEX = IADSAV + NITEMS
C
C---- HAVE WE FILLED UP A BLOCK ???
      IF ( BLKCNT .LT. NTRBLK ) GO TO 3300
      NBLK = NBLK + 1
      CALL ELWRTE ( NBLK, ARRAY )
      BLKCNT = 0
      INDEX = 1
C
C---- END OF FILE ???
 3300 IF ( MFLAG .EQ. 0 ) GO TO 600
C
C---- ZERO OUT UNUSED PORTION
C---- OF LAST BLOCK AND WRITE OUT....
 3400 REC2 = irect
      LBLK = NTRBLK
      IF ( BLKCNT .EQ. 0 ) GO TO 3600
      IF ( BLKCNT .EQ. NTRBLK ) GO TO 3500
      LBLK = BLKCNT
      IBYTES = ( NTRBLK - BLKCNT ) * ( SZSMPD * NITEMS ) ! Cray
C
C---- ZERO AWAY...
      CALL MOVE ( 0, ARRAY( BLKCNT * NITEMS + 1 ), 0, IBYTES )
 3500 NBLK = NBLK + 1
      CALL ELWRTE ( NBLK, ARRAY )
C
C---- FLY THE COOP....
 3600 RETURN
C
 3700 CALL LBCLOS ( INEVNT )
CIBM  CALL CCEXIT ( 100 )
      STOP 1040 ! Cray
c     RETURN
      END
