C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE FREQER ( I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK,
     *                    NITEMS )
C***********************************************************************
C
C     SUBROUTINE NAME: FREQER
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE FREQER DISPLAYS A HISTOGRAM CONTAINING
C               A DISTRIBUTION OF THE ERRORS WITH THE SOLUTIONS.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C
C     PARAMETERS PASSED:
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        C      - STRUCTURE CORRECTIONS
C        M      - MOVEOUT CORRECTIONS
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C
C***********************************************************************

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL        I(12001), R(12001), C(30001), M(30001), ARRAY(8190),
     *            P(103)
C
      INTEGER     DI, GI, TPRI, ERRKNT(103), HIGH, SCALE(103), IERROR,
     *            HISTGM(11)
C
Cray  LOGICAL * 1 B(100), ASST/'*'/, BLK/' '/
      CHARACTER*1 B(100), ASST, BLK
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA HISTGM/' HIS','TOGR','AM O','F FI','NAL ',
     *            'ERRO','RS A','FTER',' ITE','RATI','NG  '/,
     *             DEAD/-10000./,
     *             ASST /'*'/, BLK /' '/
C
      SAVE ! Cray
C
      HIGH = 0
C
C---- SCAN THROUGH ALL CORRECTIONS
C---- AND DETERMINE MIN AND MAX ERRORS....
      DO 200 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 100 IPNT2 = 1,N
C
C---- WHICH TRACE ???
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- IS PICK DEAD ??
            IF ( ARRAY( INDEX ) .EQ. DEAD ) GO TO 100
C
C---- SET INDICES...
            DI = ARRAY( INDEX + 6 )
            GI = ARRAY( INDEX + 7 )
            TPRI = ARRAY( INDEX + 8 )
C
C---- COMPUTE ERROR IN CORRECTION...
            ERR = ARRAY(INDEX) - I(TPRI) - R(GI)
     *            - C(DI) - M(DI) * ARRAY( INDEX + 9 )
            IERR = ERR + SIGN ( 0.5, ERR )
C
C---- TRAP MAX ABSOLUTE ERROR FOR
C---- HISTOGRAM NORMALIZATION....
            ABSERR = IABS( IERR )
            IF ( ABSERR .GT. HIGH ) HIGH = ABSERR
C
  100    CONTINUE
  200 CONTINUE
C
      N = 101
C
C---- DETERMINE HOW FAR ON EACH SIDE
C---- OF "ZERO ERROR SPIKE" WE NEED TO GO...
      IF ( HIGH .LT. 50 ) N = 2 * HIGH + 1
      IF ( HIGH .GT. 50 ) HIGH = 50
      LOW = - HIGH
      N2 = N + 2
C
C---- INITIALIZE ERRKNT ARRAY
      DO 300 K = 1,N2
         ERRKNT(K) = 0
  300 CONTINUE
C
C---- PREPARE ERRKNT ARRAY WITH KOUNT OF ERRORS IN EACH FIELD
      DO 500 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 400 IPNT2 = 1,N
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- IS PICK DEAD ???
            IF ( ARRAY( INDEX ) .EQ. DEAD ) GO TO 400
C
C---- SET INDICES..
            DI = ARRAY( INDEX + 6 )
            GI = ARRAY( INDEX + 7 )
            TPRI = ARRAY( INDEX + 8 )
C
C---- COMPUTE TOTAL CALCULATED CORRECTION.
            FACT = I(TPRI) + R(GI) + C(DI) + M(DI) * ARRAY( INDEX + 9 )
C
C---- COMPUTE ERROR
            E1 = ARRAY(INDEX) - FACT
            IERROR = E1 + SIGN ( 0.5, E1 )
C
C---- DETERMINE WHERE THE ERROR HAPPENED...
            LN = 1
            IB = IERROR - LOW + 2
            IF ( IB .LT. 1 ) IB = 1
            IF ( IB .GT. N2 ) IB = N2
C
C---- KEEP TRACK OF HOW MANY AT EACH ERROR...
            ERRKNT(IB) = ERRKNT(IB) + 1
  400    CONTINUE
  500 CONTINUE
C
C---- CALCULATE PERCENTAGES...
      ISUM = 0
C
C---- SUM UP HOW MANY ERRORS FOR NORMALIZATION...
      DO 600 K = 1,N2
         ISUM = ISUM + ERRKNT(K)
  600 CONTINUE
C
      PMAX = 0.0
      DIV = 1.0 / FLOAT(ISUM)
C
C---- TRAP MAX...
      DO 700 K = 1,N2
         P(K) = DIV * ERRKNT(K)
         IF ( P(K) .GT. PMAX ) PMAX = P(K)
C
C---- FILL SCALE WITH ERROR VALUES IN MS..
         SCALE(K) = LN * ( K - 2 ) + LOW
  700 CONTINUE
C
      SCALE(1) = -32768
      SCALE(N2) = 32767
C
C---- PRINT HEADING AT TOP OF NEW PAGE...
      WRITE(IPRNTR,800)
  800 FORMAT('1')
      N44 = 44
      CALL BOX ( IPRNTR, HISTGM, N44 )
C
      WRITE(IPRNTR,900) PMAX
  900 FORMAT(//' CLASS(MS)   KOUNT    0%',94X,2PF10.4,'%')
      WRITE(IPRNTR,1000)
 1000 FORMAT(22X,'+',10('---------+'))
C
      DO 1500 J = 1,N2
C
C---- BUILD LINE..
         DO 1100 K = 1,100
            B(K) = BLK
 1100    CONTINUE
C
C---- HOW MANY ASTERISKS DO WE PRINT ???
         IB = 100.0 * P(J) / PMAX
         IF (IB .LE. 0)  GO TO 1300
C
C---- FILL LINE WITH THEM...
         DO 1200 K = 1,IB
            B(K) = ASST
 1200    CONTINUE
C
C---- PRINT IT...
 1300    WRITE(IPRNTR,1400) SCALE(J),ERRKNT(J),(B(K),K=1,100)
 1400    FORMAT(4X,I6,3X,I5,4X,'I',100A1/22X,'I')
C
 1500 CONTINUE
C
C---- PRINT ENDING SEGMENT...
      WRITE(IPRNTR,1000)
      RETURN
      END
