C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine read_record(record, live, NumTrc, NumSmp,
     1                       luin, LERR, lenhed,
     3                       ifmt_StaCor, l_StaCor, ln_StaCor, ierr)

      implicit none

c To get TRACEHEADER definition
#include <save_defs.h>

      integer NumTrc, NumSmp, luin, LERR, lenhed
      real record(-lenhed+1:NumSmp, NumTrc)
      logical live(NumTrc)
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor, ierr

      integer i, lbytes

      integer recnum
      data recnum /0/
      save recnum

c     So far, no errors...
      ierr = 0
      recnum = recnum + 1

c     Read in an entire record, trace by trace
      do i = 1, NumTrc
c        Read the next record
         call rtape(luin, record(-lenhed+1,i), lbytes)

c        Live trace or dead?
         call saver2(record(-lenhed+1,i), ifmt_StaCor, l_StaCor,
     1               ln_StaCor, StaCor, TRACEHEADER)
         if (StaCor .eq. 30000) then
            live(i) = .false.
            call vclr(record(1,i), 1, NumSmp)
         else
            live(i) = .true.
         endif

c        If end of data encountered (nbytes=0) then bail out
         if (lbytes .eq. 0) then
            write(LERR,*)'Premature EOF on input at:'
            write(LERR,*)'  rec= ',recnum,'  trace= ',i
            ierr = -1
            return
         endif

      enddo

      end
