C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C**********************************************************************C
C
C     PROGRAM MODULE seelines (seel in data set lable)
C d. bjerstedt
C September 15, 1991.
C     Program does maximum entropy spectral analysis of a trace
C      on input tape and send results to X-Y file.
C     Analysis is done several times with a different number of
C      coefficients. Helps decide if lines exist and -M required
C      for program seelines.
C
C Spectral analysis routine is from Numerical Recipies.
C
C**********************************************************************C
C
C From USP manual by Don Wagoner, 10-31-90, pages 1 and 2.
C SZDTHD bytes in trace header on disk   (256)
C SZTRHD bytes in trace header in pipes  (256)
C LNTRHD samples in trace header         (128)
C SZDVHD size of vanl analysis header on disk in bytes    (2112)
C SZVAHD  "                           in pipe             (2112)
C SZSAMP bytes in floating pt sample   (4)
C SZSMPM max number of trace samples   (8000)
C SZLNHD line file size = (SZTRHD + SZSAMP*MAXSMP)/2      (8320)
C SZSPRD size of spread in channels      (500)
C SZSMPD bytes per sample in pipe   (4)
C HSTOFF count of byte at which hlh starts    (1004)
C SZHFWD bytes in 1/2 word           (2)
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
                                                                         
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
                                                                         
c
      INTEGER  itr1 ( SZLNHD )
cmam  INTEGER * 2 itr1 ( SZLNHD )
      INTEGER     luin1
      REAL        tri1 ( SZSMPM ), wk1( SZSMPM ), wk2( SZSMPM )
      real        cof( SZSMPM ), wkm( SZSMPM )
      CHARACTER   NAME * 4, ntap1 * 100, graphfile * 100
      logical     verbos, query
      integer     argis
      integer     ir, it
      integer     lbytes1,lbyted1
 
      EQUIVALENCE ( itr1(ITHWP1), tri1(1) )
cmam  EQUIVALENCE ( itr1(129), tri1(1) )
      DATA NAME / 'SEEL' /
C
C
c     write(LER,*)
c    :'Starting seelines.'
C
C open report files.
c     write(LER,*) 'Opening report.file                             '
cmam  open(35,file='report.file',form='formatted')
cmam  write(35,10)
cmam   10 format('Report for seelines program:')
C
                                                                         
C#include <f77/pid.h>
                                                                         
                                                                         
c     write(LER,*) 'Checking if help needed.                        '
C
C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
cmam  close(35)
          call help()
          stop
      endif
#include <f77/open.h>
c
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
c
c     write(LER,*) 'Calling cmdln.                                  '
      call cmdln(ntap1,graphfile,ir,it,numcs,numcnum,numcdiff,nfreq,
     :	 verbos)
C
      if(verbos) write(LERR,9000) nfreq,numcs,numcnum,numcdiff,ir,it
cmam  write(35,9000) nfreq,numcs,numcnum,numcdiff,ir,it
 9000 format('After cmdln, nfreq,numcs,numcnum,numcdiff,ir,it: ',
     :/,6i5)

C**********************************************************************C
C     verbos printout
C**********************************************************************C
cmam     if ( verbos ) then
             write(LERR,*) 'Values read from command line.'
             write(LERR,*) 'Input data   =  ', ntap1
             write(LERR,*) 'Output data  =  ', graphfile
             write(LERR,*) 'Start Num C  =  ', numcs
             write(LERR,*) 'Max Num C    =  ', numcsmax
             write(LERR,*) 'Number Freq  =  ', nfreq
             write(LERR,*) 'Delta num C  =  ', numcdiff
             write(LERR,*) 'Record       =  ', ir
             write(LERR,*) 'Trace        =  ', it
cmam     end if

C
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      if(verbos) write(LER,*) 'Getting logical unit # for input.  '
      call getln( luin1, ntap1, 'r', 0)
C
C Read line header for input data set and save parameters.
      lbytes1 = 0
      if(verbos) write(LER,*) 'Reading input header.             '
      CALL RTAPE4( luin1, itr1, lbytes1, lbyted1 )
C lbytes is number of bytes read in first record of tape image (header size).
C lbyted is number of bytes header takes on disk in computer being used.
      if(verbos) write(LERR,9074) lbytes1,lbyted1
cmam  write(35,9074) lbytes1,lbyted1
 9074 format('Header read done; lbytes(tape), lbyted(disk) are: ',2i7)
c
      lbytes1=lbyted1
      if(lbytes1 .eq. 0) then
         write(LERR,*)'seelines: zero bytes in header on unit ',ntap1
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
C
C Open coefficient output files.
      open(36,file='coeff.file',form='formatted')
C
C Open graph output files.
      open(37,file=graphfile,form='formatted')
c
C Get input data set parameters.
      if(verbos) write(LER,*) 'Doing saver stuff.               '
      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)
      call saver(itr1, 'Format', iform , LINHED)
      call saver(itr1, 'GrpInt', dx    , LINHED)
c
      if(verbos) write(LERR,9339) ntrc,nsamp,nrec,nsi
cmam  write(35,9339) ntrc,nsamp,nrec,nsi
 9339 format('After saver ntrc,nsamp,nrec,nsi are: ',4i6)
C
cmam     if (verbos) then
             write(LERR,*)
             write(LERR,*) 'Values from Lineheader of input 1:'
             write(LERR,*) 'No. of Records         =  ',nrec
             write(LERR,*) 'No. of Traces per Record =',ntrc
             write(LERR,*) 'No. of Samples per Trace =',nsamp
             write(LERR,*) 'Sample interval          =',nsi
             write(LERR,*) 'Format                   =',iform
cmam     end if
C
C Check nsi the sample interval.
      if(nsi.lt.1) then
      nsi=1
C Prevents divide by zero if nsi bad in header.
      write(LERR,9125)
cmam  write(35,9125)
      write(LER,9125)
 9125 format('***** Warning: Sample interval changed to 1 .')
      endif
C
C Nyquist frequency of data trace is fnyq.
      fnyq=500.0/float(nsi)
      write(LERR,9120) nsi, fnyq
cmam  write(35,9120) nsi, fnyq
 9120 format('Sample int, Nyquist freq are: ',i5,f10.2)
C
C Make sure at least 2 frequencies calculated to avoid divide by zero
C  when df is calculated.
      if(nfreq.lt.2) nfreq=2
      fstart=0.0
      fend=0.5
C
C Valid fdt for routine evlmem is -0.5 to +0.5 .
C We use range 0.0 to +0.5 corresponding to 0.0 Hz to +ve Nyquist.
      df=(fend-fstart)/float(nfreq-1)
C
C**********************************************************************C
C
C     READ TRACES IN, PERFORM ANALYSIS AND WRITE TO GRAPH FILE.
C
C**********************************************************************C
c
      if(verbos) write(LER,*) 'Begin record reading.             '
C Skip to start record
        call recskp(1,ir-1,luin1,ntrc,itr1)
C
        DO 200 JJ = 1, 1, 1
C
      if (verbos) write(LERR,3350) jj
cmam  write(35,3350) jj
 3350 format('Working record: ',i5)
C
            DO 198 KK = 1, ntrc
C
C Read trace from input 1.
               nbytes = 0
               CALL RTAPE  ( luin1, itr1, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input 1:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
C
C Check if trace is to be analysed.
      if(kk.eq.it) then
C
C Start analysis loop of different orders of coefficients.
      do 8761 ianal=1, numcnum, 1
C
      numc=numcs+(ianal-1)*numcdiff
C
C Perform analysis.
      call memcof(tri1,nsamp,numc,pm,cof,wk1,wk2,wkm)
C
C Do output of blank line separators and coefficients.
      write(36,410)
      write(37,410)
  410 format('    ')
      do 400 iout=1,numc,1
      write(36,420) iout, cof(iout)
      if(verbos) write(LERR,420) iout, cof(iout)
cmam  if(verbos) write(LER,420) iout, cof(iout)
  420 format(i10,f15.4)
C
C Report file output.
      if (verbos) write(LERR,440) iout, cof(iout)
cmam  write(35,440) iout, cof(iout)
  440 format('coefficient ',i10,' is : ',f15.4)
  400 continue
C
C
      do 4400 iout=1,nfreq,1
      fdt=fstart+df*float(iout-1)
      value=evlmem(fdt,cof,numc,pm)
C
c Convert natural frequency (range -0.5 to +0.5) to Hz.
C Factor of 2 used as range of fdt (-0.5 to +0.5) is from -Nyquist
C  to +Nyquist.
      f=fdt*2.0*fnyq
      write(37,4420) f, value
 4420 format(2f15.4)
 4400 continue
C
 8761 continue
C End analysis loop over values of M.
C
C
cmam  write(LERR,9004) kk
cmam  write(35,9004) kk
cmam  if(verbos) write(LER,9004) kk
      if(verbos) write(LERR,9004) kk
 9004 format(' Did output trace: ',i5)
      endif
C
  198 CONTINUE
C End trace loop.

  200 continue
C End record loop.
C
  999 continue
C Branch point for null trace.
c
      write(LERR,460) graphfile
cmam  write(35,460) graphfile
C
      if(verbos) write(LER,*) 'Closing logical units.             '
cmam  close(35)
      close(36)
      close(37)
      call lbclos ( luin1 )
      write(LER,460) graphfile
  460 format('See file ',a50,/,'for X-Y spectra results.')
      write(LER,*) 'Program seelines finished.                    '
C
      stop
      END

c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine help
                                                                         
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
         write(LER,*)
         write(LER,*)
     :'Program seelines: Finds required order of MEM spectra required'
         write(LER,*)
     :'                   to detect line spectra event(s) in a trace.'
         write(LER,*)
         write(LER,*)
     :'Run this program by typing: seelines and following arguments'
         write(LER,*)
         write(LER,*)
     :' -N [ntap1]     (no default)        : Input data file name'
         write(LER,*)
     :' -G [graphfile] (default graph.out) : Output X-Y graph file.'
         write(LER,*)
     :' -r [ir]        (default 1)    : Record with trace for analysis.'
         write(LER,*)
     :' -t [it]        (default 1)    : Trace to be analysed.'
         write(LER,*)
     :' -ns [numcs]    (default 10)   : Start order for # of MEM coeff.'
         write(LER,*)
     :' -nd [numcdiff] (default 10)   : Increment value for order.'
         write(LER,*)
     :' -nn [numcnum]  (default 20)   : Number of different orders '
         write(LER,*)
     :'                                  (including starting order).'
         write(LER,*)
         write(LER,*)
     :' -F [nfreq]     (default 2001) : Desired number of frequencies '
         write(LER,*)
     :'                                  from 0 to Nyquist (inclusive).'
         write(LER,*)
         write(LER,*)
     :' -V    This optional usage will cause verbos screen reporting.'
         write(LER,*)
         write(LER,*)
     :'Usage: seelines -N[ntap1] -G[graphfile] -r[rec_#] -t[trace_#] '
         write(LER,*)
     :' -ns[start_order] -nd[order_incement] -nn[total_#_of_orders]'
         write(LER,*)
     :' -F[#_of_frequencies] -V '
         write(LER,*)
         write(LER,*)
     :'***************************************************************'
c
      return
      end
c
c-----
c     get command arguments
c
c     ntap1      - C*100  input file name.
c     graphfile  - C*100  X-Y graph file output name.
C     verbos     - L      verbose output or not.
C     ir         - I      record containing trace to be analysed.
C     it         - I      trace to analyse.
C     numcs      - I      desired order of MEM approximation to start.
C     numcnum    - I      number of times to increment order numc.
C     numcdiff   - I      amount to increment numc each time incremented.
C     nfreq      - I      number of frequency values to use between
C                          0.0 and Nyquist frequency (inclusive).
c-----
      subroutine cmdln(ntap1,graphfile,ir,it,numcs,numcnum,numcdiff,
     :		 nfreq, verbos)
                                                                         
#include <f77/iounit.h>
                                                                         
      character   ntap1*(*), graphfile*(*)
      integer     argis
      integer     ir, it, numcs, numcnum, numcdiff, nfreq
      logical     verbos
c
         call argstr ( '-N', ntap1, ' ', ' ' )
         call argstr ( '-G', graphfile, 'graph.out', 'graph.out' )
         call argi4  ( '-r', ir  , 1, 1 )
         call argi4  ( '-t', it  , 1, 1 )
         call argi4  ( '-ns' , numcs    , 10  , 10 )
         call argi4  ( '-nd' , numcdiff , 10  , 10 )
         call argi4  ( '-nn' , numcnum  , 20  , 20 )
         call argi4  ( '-F'  , nfreq    , 2001, 2001 )
C
         verbos = ( argis ( '-V' ) .gt. 0 )
c
      return
      end
C
