/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*	This program is a quick and dirty way to take a look at "standard"
	SEGY datasets and manipulate a few of the fields in the various
	headers. It relies on raw C i/o for reading (and writing) the
	dataset(s). This is not designed to be some kind of panacea SEGY
	program, just a one-day hack to take care of some common SEGY 
	problems amongst the user community.
						- j.m.wade 6/8/93
*/

#include <stdio.h>
#include <localsys.h>
#include <size_defs.h>
#include <cu_defs.h>
#include <segy.h>
#include <header.h>

void main(argc,argv)
int argc;
char **argv;
{
	int samples,bytes,help,verbose,databytes,sample_rate;
	FILE *input,*output;
	char ntap[256],otap[256];
	char *header;
	int override_samples,new_samples,new_traces,new_sample_intv,new_fold;
	int trace_samp_flag;

	help = C_ARGIS("-?",&argc,argv);
	help += C_ARGIS("-h",&argc,argv);
	if (help > 0) {
	  fprintf(stderr,"\nUsage: segyinfo -N[] -O[] -SO[] -S[] -l[] ");
	  fprintf(stderr,"-dt[] -fold[] -TS\n\n");
	  fprintf(stderr,"       -N[input]   -- input data set (default=stdin)\n");
	  fprintf(stderr,"       -O[output]  -- output data set (optional)\n");
	  fprintf(stderr,"       -SO[rate]   -- override number of samples");
	  fprintf(stderr," in input header\n");
	  fprintf(stderr,"       -S[rate]    -- new number of samples\n");
	  fprintf(stderr,"       -l[trace]   -- new traces per record\n");
	  fprintf(stderr,"       -dt[rate]   -- new sample rate (microsec)\n");
	  fprintf(stderr,"       -fold[fold] -- new fold\n");
	  fprintf(stderr,"       -TS         -- force setting of trace header");
	  fprintf(stderr," entries for\n\t\t\tnumber of samples and sample rate\n");
	  fprintf(stderr,"       -V          -- verbose mode\n\n");
	  fprintf(stderr,"       -h -?       -- display this help screen\n\n");
	  exit(1);
	  }
	verbose = C_ARGIS("-V",&argc,argv);
	C_ARGI4("-SO",&override_samples,0,0,&argc,argv);
	C_ARGI4("-S",&new_samples,0,0,&argc,argv);
	C_ARGI4("-l",&new_traces,0,0,&argc,argv);
	C_ARGI4("-dt",&new_sample_intv,0,0,&argc,argv);
	C_ARGI4("-fold",&new_fold,0,0,&argc,argv);
	trace_samp_flag = C_ARGIS("-TS",&argc,argv);

	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (verbose == 1) fprintf(stderr,"input file = ");
	if (strcmp(ntap," ") == 0) {
	  if (verbose == 1) fprintf(stderr,"stdin\n");
	  input = stdin;
	  }
	else {
	  if (verbose == 1) fprintf(stderr,"%s\n",ntap);
	  input = fopen(ntap,"r");
	  if (input == NULL) {
	    fprintf(stderr,"%s: error opening input data file (%s)\n",
		argv[0],ntap);
	    exit(1);
	    }
	  }

	C_ARGSTR("-O",otap," ","nooutput",&argc,argv);
	if (strcmp(otap," ") == 0) {
	  if (verbose == 1) fprintf(stderr,"output file = stdout\n");
	  output = stdout;
	  }
	else if (strcmp(otap,"nooutput") == 0) {
	  output = NULL;
	  }
	else {
	  if (verbose == 1) fprintf(stderr,"output file = %s\n",otap);
	  output = fopen(otap,"w");
	  if (output == NULL) {
	    fprintf(stderr,"%s: error opening output data file (%s)\n",
		argv[0],otap);
	    exit(1);
	    }
	  }

	if ((header = (char *)malloc(EBCBYTES)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory\n",
		argv[0],EBCBYTES);
	  exit(1);
	  }
	bytes = fread(header,1,EBCBYTES,input);
	if (bytes == 0) {
	  fprintf(stderr,"%s: error reading header (%d bytes attempted)\n",
		argv[0],EBCBYTES);
	  exit(1);
	  }
	if (output != NULL) fwrite(header,bytes,1,output);
	free(header);

	if ((header = (char *)malloc(BNYBYTES)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory\n",
		argv[0],BNYBYTES);
	  exit(1);
	  }
	bytes = fread(header,1,BNYBYTES,input);
	if (bytes == 0) {
	  fprintf(stderr,"%s: error reading header (%d bytes attempted)\n",
		argv[0],BNYBYTES);
	  exit(1);
	  }

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	HTOCL(&((bhed *)header)->jobid,3);
	HTOCL(&((bhed *)header)->ntrpr,25);
#endif
	if (verbose == 1) {
	  fprintf(stderr,"\n");
/*
	  fprintf(stderr,"job identification number        = %d\n",
						((bhed *)header)->jobid);
*/
	  fprintf(stderr,"line number                      = %d\n",
						((bhed *)header)->lino);
	  fprintf(stderr,"reel number                      = %d\n",
						((bhed *)header)->reno);

	  fprintf(stderr,"data traces per record           = %d",
						((bhed *)header)->ntrpr);
	  if (new_traces != 0) fprintf(stderr,"\t(changed to %d)",new_traces);

	  fprintf(stderr,"\nauxiliary traces per record      = %d\n",
						((bhed *)header)->nart);

	  fprintf(stderr,"sample interval in micro seconds = %d",
						((bhed *)header)->hdt);
	  if (new_sample_intv != 0)
		fprintf(stderr,"\t(changed to %d)",new_sample_intv);

	  fprintf(stderr,"\nsamples/trace for this reel      = %d",
						((bhed *)header)->hns);
	  if (new_samples != 0) 
		fprintf(stderr,"\t(changed to %d)",new_samples);
	  else if (override_samples != 0) 
		fprintf(stderr,"\t(changed to %d)",override_samples);

	  fprintf(stderr,"\ndata sample format code          = %d\n",
						((bhed *)header)->format);
	  fprintf(stderr,"CDP fold                         = %d",
						((bhed *)header)->fold);
	  if (new_fold != 0) fprintf(stderr,"\t(changed to %d)",new_fold);

/*
	  fprintf(stderr,"\nsamples/trace for orig. field recording =");
	  fprintf(stderr,"\t%d\n",((bhed *)header)->nso);
*/
	  fprintf(stderr,"\n\n");
	  }

	if (override_samples != 0) {
	  samples = override_samples;
	  if (new_samples == 0) new_samples = override_samples;
	  }
	else
	  samples = ((bhed *)header)->hns;

	if (output != NULL) {
	  if (new_traces  != 0) ((bhed *)header)->ntrpr = new_traces;
	  if (new_samples != 0) ((bhed *)header)->hns = new_samples;
	  if (new_fold    != 0) ((bhed *)header)->fold = new_fold;
	  if (new_sample_intv != 0) ((bhed *)header)->hdt = new_sample_intv;
	  fwrite(header,bytes,1,output);
	  }
	  
	sample_rate = ((bhed *)header)->hdt;

	free(header);

	if ((header = (char *)malloc(HDRBYTES+(samples*SZSMPD))) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory\n",
		argv[0],HDRBYTES);
	  exit(1);
	  }

	  if (verbose == 1) {
	    fprintf(stderr," trace       field      field ");
	    fprintf(stderr,"      trace         number      sample\n");

	    fprintf(stderr,"sequence     record     trace ");
	    fprintf(stderr,"  identification      of       interval\n");

	    fprintf(stderr," number      number     number");
	    fprintf(stderr,"      code         samples    (microsecs)\n");

	    fprintf(stderr,"--------     ------     ------");
	    fprintf(stderr,"  --------------   -------    -----------\n");

	    fprintf(stderr,"\n\n");
/*
	    fprintf(stderr,"trace seq. no. within line = %d\n",
						((segy *)header)->tracl);
	    fprintf(stderr,"original field record no.  = %d\n",
						((segy *)header)->fldr);
	    fprintf(stderr,"trace no. with field rec.  = %d\n",
						((segy *)header)->tracf);
	    fprintf(stderr,"trace identification code  = %d\n",
						((segy *)header)->trid);
*/
/* deleted
	    fprintf(stderr,"trace sequence number within reel = %d\n",
						((segy *)header)->tracr);
	    fprintf(stderr,"CDP ensemble number                  = %d\n",
						((segy *)header)->cdp);
	    fprintf(stderr,"number of horizontally summed traces = %d\n",
						((segy *)header)->nhs);
deleted */
/*
	    fprintf(stderr,"no. samples on this trace  = %d\n",
						((segy *)header)->ns);
	    fprintf(stderr,"samp interval in microsecs = %d\n",
						((segy *)header)->dt);
	    fprintf(stderr,"\n\n");
*/
	    }

	while ((bytes = fread(header,1,HDRBYTES,input)) != 0) {
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  HTOCL(&((segy *)header)->tracl,7);
	  HTOCS(&((segy *)header)->trid,4);
	  HTOCL(&((segy *)header)->offset,8);
	  HTOCS(&((segy *)header)->scalel,2);
	  HTOCL(&((segy *)header)->sx,4);
	  HTOCS(&((segy *)header)->counit,46);
#endif
	  if (bytes != HDRBYTES) {
	    fprintf(stderr,"%s: error reading trace header;\n",argv[0]);
	    fprintf(stderr,"\t\t%d bytes attempted, %d read\n",HDRBYTES,bytes);
	    fclose(output);
	    exit(1);
	    }
	  if (verbose == 1) {
	    fprintf(stderr," %5d       %5d      %5d ",
	    	((segy *)header)->tracl,((segy *)header)->fldr,
	    	((segy *)header)->tracf);
	    fprintf(stderr,"        %1d           %5d      %5d     %5d     %5d\n",
	    	((segy *)header)->trid,
	    	((segy *)header)->ns,((segy *)header)->dt,
	    	((segy *)header)->cdp,((segy *)header)->cdpt);
/*
	    fprintf(stderr,"trace sequence number within reel = %d\n",
						((segy *)header)->tracr);
	    fprintf(stderr,"CDP ensemble number                  = %d\n",
						((segy *)header)->cdp);
	    fprintf(stderr,"number of horizontally summed traces = %d\n",
						((segy *)header)->nhs);
*/
	    }

/*
	  databytes = ((segy_trace_header *)header)->NumSmp;
*/
	  if (((segy *)header)->ns != 0) 
	    databytes = ((segy *)header)->ns * SZSMPD;
	  else
	    databytes = samples * SZSMPD;

	  if (trace_samp_flag == 1) {
	    if (new_samples != 0)
		((segy *)header)->ns = new_samples;
	    else
		((segy *)header)->ns = samples;

	    ((segy *)header)->dt = sample_rate;
	    }

	  if (output != NULL) fwrite(header,bytes,1,output);

	  bytes = fread(((segy *)header)->data,1,databytes,input);
	  if (bytes != databytes) {
	    fprintf(stderr,"%s:\n\t\terror reading trace data; %d bytes ",
		argv[0],databytes);
	    fprintf(stderr,"attempted, %d read\n",bytes);
	    exit(1);
	    }
	  if (output != NULL) {
		if (new_samples != 0)
		  fwrite(((segy *)header)->data,SZSMPD,new_samples,output);
		else
		  fwrite(((segy *)header)->data,bytes,1,output);
	    }
	  }
	  fclose(output);
}
