C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE shapes(LB,B,LD,D,LA,A,ASE,PREW,space,ierr)

#include <localsys.h>
#include <f77/lhdrsz.h>

      DIMENSION B(*),A(*),D(*)
      DIMENSION SPACE(*)
      real      c(4*SZSMPM)
C
C     THIS SUBROUTINE COMPUTES THE LA-LENGTH SINGLE CHANNEL WIENER
C     which turns series B(i) into series D(i) in a least squares sense

C     THE SYSTEM OF NORMAL EQUATIONS,
C
C
C         R(1),R(2),...R(LA)   A(1)     R(1)
C         R(2)          .      A(2)     R(2),  (R=AUTOPRODUCT OF A)
C          .            .       .    =   .
C          .            .       .        .
C          .            .       .        .
C         R(LA),...,   R(1)    A(LA)    R(LA)
C
C     AUTHOR--S.TREITEL, 10/5/1965
C
C     INPUTS ARE
C        LB=LENGTH OF INPUT B
C         B=INPUT B
C        LA=LENGTH OF FILTER A
C        LD=LENGTH OF desired output
C         D=desired output
C      PREW=PREWHITENING LEVEL OF AUTO-CORR MATRIX (B X B)
C     OUTPUTS ARE
C        A=FILTER A
C        ASE=AVERAGE SQUARE PREDICTION ERROR FOR PRED. DIST. LPR
C        SPACE=4*LA CELLS OF WORKING SPACE
C           FIRST LA CELLS CONTAIN  R(1),...R(LA)
C           NEXT  LA CELLS CONTAIN  R(1+LPR),...R(LA+LPR)
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT RETROSPECTION
C             ERROR OPERATOR, STORED IN REVERSE ORDER
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT PREDICTION
C             ERROR OPERATOR, STORED IN REVERSE ORDER
C

      call vclr(space,1,2*la)
      CALL CROSS(LB,B,LB,B,LA,SPACE)
      SPACE(1)=SPACE(1)+PREW*SPACE(1)
      CALL CROSS(LD,D,LB,B,LA,SPACE(LA+1))


c------------------------------
c  call math adv decon routine

      call wiener(la,space,space(la+1),a,c,1,ierr)
c------------------------------


      RETURN
      END
