C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MemoryRoll (Record_WorkSpace, Headers, ntrc, nsamp )

#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer ntrc, nsamp
      integer Headers(ITRWRD,3*ntrc)

      real Record_WorkSpace(nsamp,3*ntrc)

c declare local variables

      integer i, j

c roll memory

      do i = 1, nsamp
         do j = 1, 2*ntrc
            Record_WorkSpace(i,j) = Record_WorkSpace(i,j+ntrc) 
         enddo
      enddo
 
      do i = 1, ITRWRD
         do j = 1, 2*ntrc
            Headers(i,j) = Headers(i,j+ntrc)
         enddo
      enddo

      do i = i, nsamp
         do j = 2*ntrc+1, 3*ntrc
            Record_WorkSpace(i,j) = 0.0
         enddo
      enddo

      do i = 1, ITRWRD
         do j = 2*ntrc+1, 3*ntrc
            Headers(i,j) = 0
         enddo
      enddo

      return
      end
