C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     Program Changes:

c     Jan 97 add -nopower option as another measure which responds 
c            better to small character changes in autocorrelation.
c     Garossino

c      - original written: Jun/96 Garossino

c     Program Description:

c 
c routine to perform adjacent shot averaging to reduce coherent noise on the
c central shot of the averaged set.  The routine exploits redundency in the
c subsurface coverage of adjacent shots to reconstruct the central shot.
c An option to add back in a certain percentage of the central shot is 
c to be made available.
c

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis

      character   ntap*255, otap*255, name*5


c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize
      integer Headers, Shots, shaved, detected
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer errcd7, abort

      real Record, Record_WorkSpace, thresholds

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Space, Record_WorkSpace(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_Shots, Shots(200000))
      pointer (memadr_shaved, shaved(200000))
      pointer (memadr_thresholds, thresholds(200000))
      pointer (memadr_detected, detected(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_VPick2,l_VPick2,ln_VPick2, VPick2
      integer ifmt_VPick1,l_VPick1,ln_VPick1, VPick1
      integer hdr_index, tr_index, JJ, KK, lushot, ierr
      integer num_shots, length, skip_traces, lustats
      integer tr_outdex, hdr_outdex, ntrc_cable, lags, nshaved
      integer nkicks

      real add_back_percentage, shot_interval, group_interval
      real denominator, threshold, min_threshold, max_threshold

      character shottap*255, c_ShtWrd*6, avtap*255

      logical automode, mute, ramp, nopower

c Initialize variables

      data abort/0/
      data name/"SHAVE"/
      data automode/.false./
      data nshaved/0/
      data nkicks/0/
      data min_threshold/1.e30/
      data max_threshold/0.0/
      data ramp /.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, shottap, avtap, irs, ire, ist, iend, 
     :     name, add_back_percentage, c_ShtWrd, shot_interval,
     :     group_interval, ntrc_cable, threshold, lags, mute, nopower )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open shots file

      if ( shottap .ne. ' ' ) then
         length = lenth ( shottap )
         call alloclun(lushot)
         open(unit=lushot, file=shottap(1:length), status='old', 
     :        iostat=ierr)
         if(ierr .ne. 0) then
            write(LERR,*)'Could not open shot record numbers pick file'
            write(LERR,*)'Check spelling/existence'
            write(LER,*)' '
            write(LER,*)'SHAVE:'
            write(LER,*)' Could not open shot record numbers pick file'
            write(LER,*)' Check spelling/existence'
            write(LER,*)'FATAL'
            stop
         endif

c determine number of entries in shots file

         call ShotCount ( lushot, num_shots )
         
c allocate appropriate memory

         call galloc (memadr_Shots, num_shots * SZSMPD, errcd1, abort)
         if ( errcd1 .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) num_shots * SZSMPD, '  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) num_shots * SZSMPD, '  bytes'
            write(LER,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) num_shots * SZSMPD, '  bytes'
            write(LERR,*)' '
         endif

c read shots data

         call ReadShots( lushot, Shots, num_shots, c_ShtWrd )
      else
         write(LERR,*)' '
         write(LERR,*)' no shot pick file attached'
         write(LERR,*)' will operate in AutoDetect mode'
         write(LERR,*)'WARNING'
         automode = .true.
      endif

c open the output statistics file if requested

      if ( avtap .ne. ' ' ) then

         call alloclun(lustats)
         length = lenth(avtap)
         open(unit=lustats, file=avtap(1:length), status='unknown', 
     :        iostat=ierr)
         
         if(ierr .ne. 0) then
            write(LERR,*)'Could not open output statistics file'
            write(LERR,*)'Check permissions'
            write(LER,*)' '
            write(LER,*)'SHAVE:'
            write(LER,*)' Could not open output statistics file'
            write(LER,*)' Check permissions'
            write(LER,*)'FATAL'
            stop
         endif

      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'SHAVE: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 5, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

c ist and iend will be used to limit the operation only.  All data
c will be passed through the process.  Only data between ist and
c iend will incurr the averaging process

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( c_ShtWrd, ifmt_ShtWrd, l_ShtWrd, ln_ShtWrd, 
     :     TRACEHEADER )
      call savelu ( 'VPick2', ifmt_VPick2, l_VPick2, ln_VPick2, 
     :     TRACEHEADER )
      call savelu ( 'VPick1', ifmt_VPick1, l_VPick1, ln_VPick1, 
     :     TRACEHEADER )

c calculate traces to skip from surrounding records to position the
c Fresnel zone on the central record

      skip_traces = nint ( shot_interval / group_interval )
      denominator = 1.75 + add_back_percentage
      if ( ( iend - ist + 1 ) .gt. 20 ) ramp = .true.

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, shottap, avtap, nsamp, nsi, ntrc, nrec, 
     :     iform, ist, iend, irs, ire, Shots, num_shots, nopower,
     :     shot_interval, group_interval, skip_traces, c_ShtWrd, 
     :     add_back_percentage, ntrc_cable, threshold, lags, mute )

c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_Space, 3 * RecordSize * SZSMPD, errcd3, abort)
      call galloc (memadr_Headers, 3 * HeaderSize * SZSMPD, errcd4, 
     :     abort)
      call galloc (memadr_shaved, nrec * SZSMPD, errcd5, abort)
      call galloc (memadr_thresholds, nrec * SZSMPD, errcd6, abort)
      call galloc (memadr_detected, nrec * SZSMPD, errcd7, abort)
    
      if ( errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 4*RecordSize * SZSMPD, '  bytes'
         write(LERR,*) 3*HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 3*nrec * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 4*RecordSize * SZSMPD, '  bytes'
         write(LER,*) 3*HeaderSize * SZSMPD, '  bytes'
         write(LER,*) 3*nrec * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 4*RecordSize * SZSMPD, '  bytes'
         write(LERR,*) 3*HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 3*nrec * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Record_WorkSpace, 1, 3*RecordSize )
      call vclr ( Headers, 1, 3*HeaderSize )
      call vclr ( shaved, 1, nrec )
      call vclr ( thresholds, 1, nrec )
      call vclr ( detected, 1, nrec )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      tr_index = 1 - nsamp
      hdr_index = 1 - ITRWRD

      DO JJ = irs, ire

c load record to memory

         IF ( JJ .le. irs+2 ) then

c if just starting then load first three records

            DO KK = 1, ntrc

               nbytes = 0
               call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif

c set array load points for this trace 
               
               tr_index = tr_index + nsamp
               hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

               call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor,TRACEHEADER )

               if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

                  call vmov ( itr(ITHWP1), 1, Record_WorkSpace(tr_index)
     :                 , 1, nsamp )

               else
                  call vclr ( Record_WorkSpace(tr_index), 1, nsamp )
               endif

c load trace header to array Headers[]

               call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

            ENDDO

         ELSEIF ( JJ .gt. irs + 2 )then

c load the current record by rolling the records along in memory. The 
c first record in Record_WorkSpace would be dropped, the last two
c moved into the first two positions and the record to now be read
c would be place in position three.

c set indices appropriately
  
            tr_index = 2 * ntrc * nsamp + 1 - nsamp
            hdr_index = 2 * ntrc * ITRWRD + 1 - ITRWRD

c do memory roll and return  indices in proper position to load the
c current record

            call MemoryRoll( Record_WorkSpace, Headers, ntrc, nsamp )

c read the current record into position three

            DO KK = 1, ntrc
               
               nbytes = 0
               call rtape( luin, itr, nbytes)
               
c     if end of data encountered (nbytes=0) then bail out
               
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif

c set array load points for this trace 
               
               tr_index = tr_index + nsamp
               hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

               call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               
               if ( StaCor .ne. 30000 ) then

c load trace to array Record[]
                  
                  call vmov ( itr(ITHWP1), 1, Record_WorkSpace(tr_index)
     :                 , 1, nsamp )
                  
               else
                  call vclr ( Record_WorkSpace(tr_index), 1, nsamp )
               endif

c load trace header to array Headers[]

               call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

            ENDDO
         ENDIF
            
         if ( JJ .gt. 2 ) then

c do shot averaging with Fresnel positioning for this output shot if required, 
c give the routine the three records in Record_WorkSpace and header data in 
c Headers and get back the averaged record in Record

            call Shot_Average ( Record_WorkSpace, Headers, nsamp, ntrc, 
     :           ist, iend, Record, Shots, num_shots, skip_traces, 
     :           denominator, add_back_percentage, ifmt_ShtWrd, 
     :           l_ShtWrd, ln_ShtWrd, ntrc_cable, automode, threshold, 
     :           lags, nrec, nshaved, shaved, nkicks, min_threshold,
     :           max_threshold, thresholds, detected, ramp, nopower )

         endif

c output data 

         if ( JJ .lt. irs+1 ) then

            if ( JJ .eq. irs ) then
               tr_outdex = 1 - nsamp
               hdr_outdex = 1 - ITRWRD
            endif

            DO KK = 1, ntrc

               tr_outdex = tr_outdex + nsamp
               hdr_outdex = hdr_outdex + ITRWRD

               call vmov ( Headers(hdr_outdex), 1, itr, 1, ITRWRD )
               call saver2 ( itr, ifmt_VPick1, l_VPick1, ln_VPick1, 
     :              VPick1, TRACEHEADER )

               if ( mute ) then
                  call DoSurgMute (Record_WorkSpace(tr_outdex), nsamp, 
     :                 nsi, VPick1, VPick2 )
                  call savew2 ( itr, ifmt_VPick2, l_VPick2, ln_VPick2, 
     :              VPick2, TRACEHEADER )
               endif

               call vmov ( Record_WorkSpace(tr_outdex), 1, itr(ITHWP1), 
     :              1, nsamp )
               call wrtape (luout, itr, obytes)
               
            ENDDO

         elseif ( JJ .gt. (irs+1) .and. JJ .lt. (ire ) ) then

            tr_outdex = 1 - nsamp
            hdr_outdex = ntrc * ITRWRD + 1 - ITRWRD

c write output data

            DO KK = 1, ntrc

               tr_outdex = tr_outdex + nsamp
               hdr_outdex = hdr_outdex + ITRWRD

               call vmov ( Headers(hdr_outdex), 1, itr, 1, ITRWRD )
               call saver2 ( itr, ifmt_VPick1, l_VPick1, ln_VPick1, 
     :              VPick1, TRACEHEADER )

               if ( mute ) then
                  call DoSurgMute (Record(tr_outdex), nsamp, nsi, 
     :                 VPick1, VPick2 )
                  call savew2 ( itr, ifmt_VPick2, l_VPick2, ln_VPick2, 
     :              VPick2, TRACEHEADER )
               endif

               call vmov ( Record(tr_outdex), 1, itr(ITHWP1), 1, nsamp )
               call wrtape (luout, itr, obytes)
 
            ENDDO

         elseif ( JJ .eq. ire ) then

            tr_outdex = 1 - nsamp
            hdr_outdex = 1 - ITRWRD

c write output data [ here we must output last two records ], the second
c last record must come from the Record() and the last record from the
c input Record_WorkSpace() buffer

            DO KK = 1, ntrc

               tr_outdex = tr_outdex + nsamp
               hdr_outdex = hdr_outdex + ITRWRD

               call vmov ( Headers(hdr_outdex), 1, itr, 1, ITRWRD )
               call saver2 ( itr, ifmt_VPick1, l_VPick1, ln_VPick1, 
     :              VPick1, TRACEHEADER )

               if ( mute ) then
                  call DoSurgMute (Record(tr_outdex), nsamp, nsi, 
     :                 VPick1, VPick2 )
                  call savew2 ( itr, ifmt_VPick2, l_VPick2, ln_VPick2, 
     :              VPick2,TRACEHEADER )
               endif

               call vmov ( Record(tr_outdex), 1, itr(ITHWP1), 
     :              1, nsamp )
               call wrtape (luout, itr, obytes)
 
            ENDDO

c reset pointers to pick up last record out of Record_WorkSpace()

            tr_outdex = 2 * ntrc * nsamp + 1 - nsamp
            hdr_outdex = 2 * ntrc * ITRWRD + 1 - ITRWRD

            DO KK = 1, ntrc

               tr_outdex = tr_outdex + nsamp
               hdr_outdex = hdr_outdex + ITRWRD

               call vmov ( Headers(hdr_outdex), 1, itr, 1, ITRWRD )
               call saver2 ( itr, ifmt_VPick1, l_VPick1, ln_VPick1, 
     :              VPick1, TRACEHEADER )

               if ( mute ) then
                  call DoSurgMute (Record_WorkSpace(tr_outdex), nsamp, 
     :                 nsi, VPick1, VPick2 )
                  call savew2 ( itr, ifmt_VPick2, l_VPick2, ln_VPick2, 
     :              VPick2,TRACEHEADER )
               endif

               call vmov ( Record_WorkSpace(tr_outdex), 1, itr(ITHWP1), 
     :              1, nsamp )
               call wrtape (luout, itr, obytes)
 
            ENDDO

         endif

      ENDDO

c report on records that underwent averaging to both printout file
c and stats file

      write(LERR,*)' '
      write(LERR,*)' Shave Statistics '
      write(LERR,*)' ----------------'
      write(LERR,*)' '
      write(LERR,*)' window start sample = ',ist
      write(LERR,*)' window end sample   = ',iend
      write(LERR,*)' autodetect threshold = ',threshold
      write(LERR,*)' '
      write(LERR,*)' Covariance Anomalies Detected '
      write(LERR,*)' -----------------------------'
      write(LERR,*)' '
      write(LERR,*)c_ShtWrd,'  Threshold'
      write(LERR,*)'------    ---------'
      write(LERR,*)' '
      do i = 1, nkicks
         write(LERR,*) detected(i), thresholds(i)
      enddo
      write(LERR,*)' '
      write(LERR,*)' Total Anomalous Detections = ',nkicks
      write(LERR,*)' Minimum Threshold Detected = ',min_threshold
      write(LERR,*)' Maximum Threshold Detected = ',max_threshold
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Covariance Anomalies Above Threshold'
      write(LERR,*)' ------------------------------------'
      write(LERR,*)' '
      write(LERR,*)c_ShtWrd
      write(LERR,*)'------'
      write(LERR,*)' '
      do i = 1, nshaved
         write(LERR,*)shaved(i)
      enddo
      write(LERR,*)' Total Shots Averaged = ',nshaved
      write(LERR,*)' '

c to stats file if requested
      
      if ( avtap .ne. ' ' ) then
         write(lustats,*)' '
         write(lustats,*)' Shave Statistics '
         write(lustats,*)' ----------------'
         write(lustats,*)' '
         write(lustats,*)' window start sample = ',ist
         write(lustats,*)' window end sample   = ',iend
         write(lustats,*)' autodetect threshold = ',threshold
         write(lustats,*)' '
         write(lustats,*)' Covariance Anomalies Detected '
         write(lustats,*)' -----------------------------'
         write(lustats,*)' '
         write(lustats,*)c_ShtWrd,'  Threshold'
         write(lustats,*)'------    ---------'
         write(lustats,*)' '
         do i = 1, nkicks
            write(lustats,*) detected(i), thresholds(i)
         enddo
         write(lustats,*)' '
         write(lustats,*)' Total Anomalous Detections = ',nkicks
         write(lustats,*)' Minimum Threshold Detected = ',min_threshold
         write(lustats,*)' Maximum Threshold Detected = ',max_threshold
         write(lustats,*)' '
         write(lustats,*)' '
         write(lustats,*)' Covariance Anomalies Above Threshold'
         write(lustats,*)' ------------------------------------'
         write(lustats,*)' '
         write(lustats,*)c_ShtWrd
         write(lustats,*)'------'
         write(lustats,*)' '
         do i = 1, nshaved
            write(lustats,*)shaved(i)
         enddo
         write(lustats,*)' Total Shots Averaged = ',nshaved
         write(lustats,*)' '
      endif

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      if ( avtap .ne. ' ') close(lustats)
      if ( shottap .ne. ' ' ) close(lushot)
      write(LERR,*)'shave: Normal Termination'
      write(LER,*)'shave: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      if ( avtap .ne. ' ') close(lustats)
      if ( shottap .ne. ' ' ) close(lushot)
      write(LERR,*)'shave: ABNORMAL Termination'
      write(LER,*)'shave: ABNORMAL Termination'
      stop
      end
