C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
***********************************************************************
      program simindex 
c_______________________________________________________________________
c     calculate a normalized semblance based on roelof versteeg's      
c     empirical ideas.
c                                 Kurt J. Marfurt
c                                   1/30/92
C***********************************************************************
      parameter (maxs  = 0 000 002)
      dimension s(maxs)
      pointer  (pntrs,s)    
C
      integer   hbegin
      integer argis
      integer      stderr
      integer   ipwr(4)   
C
      integer   sheader(6000)
      character*(80) file_in,file_out
C
      logical      query
      logical      verbose
C
      character*8   name
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
C
      data   luprep1/61/,luprep2/62/,luzeta/63/
      data   stderr/0/    
      data name /'SIMINDEX'/
c_________________________________________________________________________
c     get online help if necessary
c_________________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help(ler)
         stop 0
      endif
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>
c_____________________________________________________________________
c     read command line arguements
c_____________________________________________________________________
      verbose=(argis('-V') .gt. 0)
      call argstr('-N',file_in,' ',' ')
      call argstr('-O',file_out,' ',' ')
      call argi4('-alg',ialg,3,3) 
      call argr4('-w',semb_window,50.,50.)
c_____________________________________________________________________
c     open input and output seismic worktapes.
c_____________________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout,file_out,'w',1)
      WRITE(lerr,'(A20,A10,t40,a50)') 'FILE UNIT', 'VALUE','FILE NAME'
      WRITE(lerr,'(A20,I10,t40,a50)')
     1     'luin',luin,file_in,
     2     'luout',luout,file_out
c_____________________________________________________________________
c     read in irregular seismic worktape header.
c_____________________________________________________________________
      lensh=0
      call rtape(luin,sheader,lensh)
      call hlhprt(sheader,lensh,name,len(name),lerr)
C***********************************************************************
C     PULL INPUT DATA parameterS Off THE LINE HEADER.
C     THESE WILL SERVE AS DEfAULT INPUT parameterS.
C***********************************************************************
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'NumSmp',nz,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      if(nsi .gt. 0) then
         lzsemb=nint(semb_window/nsi)
         nzsemb=2*lzsemb+1
      else
         write(lerr,*) 'error in routine SIMINDEX'
         write(lerr,*) 'sample interval SmpInt = ',nsi
         call exit(2666)
      endif
C_______________________________________________________________________
c     update certain line  header words. 
c     update the historical line header.
c     write it out. 
C_______________________________________________________________________
      call savew(sheader,'NumTrc',1,LINEHEADER)
      call savhlh(sheader,lensh,lbyout)
      call wrtape(luout,sheader,lbyout)
c
      call nrfft(nz,2,nznew,ipwr)
      write(lerr,'(a20,a20)') 'variable','value'
      write(lerr,'(a20,i20)') 'nrec',nrec,'nz',nz,'nznew',nznew,
     1                           'ntr',ntr    
      write(lerr,'(a20,i20)') 'ialg',ialg,'lzsemb',lzsemb,
     1                           'nzsemb',nzsemb
      write(lerr,'(a20,f20.3)') 'semb_window',semb_window 
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'variable name','begin','end','length'
C
      l_free=1
      call mapmem('uin',l_uin,l_free,ntr*(lenhed+nz),lerr)
      call mapmem('c',l_c,l_free,lenhed+nz,lerr)
      call mapmem('unum',l_unum,l_free,nz,lerr)
      call mapmem('udenom',l_udenom,l_free,nz,lerr)
      call mapmem('unumsum',l_unumsum,l_free,nz,lerr)
      call mapmem('udenomsum',l_udenomsum,l_free,nz,lerr)
      call mapmem('rwork',l_rwork,l_free,nznew,lerr)
      call mapmem('cwork',l_cwork,l_free,nznew,lerr)
      call mapmem('a2',l_a2,l_free,nz,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for SIMINDEX: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for SIMINDEX: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program simindex aborted'
         stop 101
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
c
      do 20000 irec=1,nrec
       call roelof(s(l_uin),s(l_udenom),s(l_unum),
     1             s(l_unumsum),s(l_denomsum),s(l_c),
     2             s(l_a2),s(l_rwork),s(l_cwork),nznew,lzsemb,nzsemb,
     3             hbegin,nz,ntr,luin,luout,ialg) 
20000 continue
C
      call lbclos(luin) 
      call lbclos(luout)
      write(lerr,*)'normal completion of simindex' 
      write(ler,*)'Normal completion of SIMINDEX' 
C
      STOP 0
      END
      subroutine  help(ler)
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for simindex: '
        write(LER,*)'calculate horizontal semblance'                   
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N [file_irreg] (stdin)     :'
        write(ler,*)'                input seismic gathers'         
        write(LER,*)'-O [file_reg  ] (stdout)   :'
        write(ler,*)'                Output coherency function'      
        write(LER,*)'-alg [ialg]     algorithm number (5)     :'
        write(ler,*)'       1...conventional semblance'     
        write(ler,*)'       2...stack energy'               
        write(ler,*)'       3...rms emergy weighted semblance'  
        write(ler,*)'       4...signed rms emergy weighted semblance'  
        write(ler,*)'       5...envelope of stack squared over' 
        write(ler,*)'                   sum of envelopes squared'
        write(ler,*)'       6...signed envelope of stack squared over' 
        write(ler,*)'                   sum of envelopes squared'
        write(LER,*)'-w [semb_window] (50) '
     1                     //' semblance time window in msec '  
      write(LER,*)'-V           -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'        simindex -N[] -O[] -alg[] -w[] -V '
      write(LER,*)' '

      return
      end
