C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c This program converts seismic data as gridded flat file for PLOTXY
c PLOTXY can display contour in such as nice way that you can have
c a zoom-in look on velocity or time-frequency spectrum. Each gather
c will give a PLOTXY gridded file. If the data is a stacked data, i.e.,
c there is only one trace in each record, whole line will be converted
c into one PLOTXY file.
c
c Author: Yaohui Zhang, Ext3901, E&PTG
c         April, 1995
c**********************************************************************c
c
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer   itr  ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , lbytes, nbytes
      integer     ns,ne, s, e, rs, re, luplotxy
      integer   argis

      real        x(SZLNHD)

      character   ntap * 120, otap * 120, name*10, fnplotxy*100

      logical     verbos, query, DeaDTracE, unstacked, stacked
      logical	heapi, heap1, heap2

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'SIS2PLOTXY'/
 
#include <f77/open.h>
c
c    initialize memory
c
       call vclr(x,1,SZLNHD)
c
c    help information
c
      query = ( argis ( '-?' ) .gt. 0 .OR.
     1          argis ( '-h' ) .gt. 0 .OR.
     2          argis ( '-help' ) .gt. 0 )
      if ( query ) then
            write(*,*) 'help helP heLp hELP HELP'
            call help()
            stop
      endif
c
      call gcmdln(ntap,otap,ns,ne,rs,re,s,e,
     1            xmin,xmax,ymin,ymax,verbos)
c
      ntap_len = lenth(ntap)
      if(otap(1:1) .eq. ' ') then
        if (ntap_len .gt. 0) then
	  otap = ntap(1:ntap_len)//'_'
	else
	  otap = 'sis2plotxy'//'_'
	endif
      endif
     
      call getln(luin , ntap,'r', 0)
 
      call rtape  ( luin, itr, lbytes)

      if(lbytes .eq. 0) then
         write(LOT,*)'SIS2PLOTXY: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

c-----------
c format values are:
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 10, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
c
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
c 
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
c 
c-----
c     modify line header to reflect actual number of traces output
c-----

      nreco = (re - rs + 1)*(ne -ns + 1)
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
      if(e .eq. 0) e=nsamp*dt*1000.0
      nbeg=s/dt/1000.0+1
      nend=e/dt/1000.0+1
      if(nbeg .lt. 1) nbeg =1
      if(nend .lt. nbeg) nend = nsamp 
            
c
c     determine PLOTXY parameters
c
      nt=nend-nbeg+1
      ny=ne-ns+1
      if(ns .eq. ne) then
         ny=re-rs+1
         stacked = .true.
         unstacked = .false.
      else
         ny=ne-ns+1
         stacked = .false.
         unstacked = .true.
      endif
      if(xmin .eq. -30000.0 .AND. xmax .eq. -30000.0) then
         xmin=nbeg*dt*1000.0
         xmax=nend*dt*1000.0
      endif
      if(ymin .eq. -30000.0 .AND. ymax .eq. -30000.0) then
         if(ns .eq.ne) then
             ymin=rs
             ymax=re
         else
             ymin=ns
             ymax=ne
         endif
      endif


c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c
      call verbal(ntap,nsamp,nsi,ntrc,nrec,iform,
     1                 s,e,ns,ne,rs,re,
     2                 otap,nt,ny,xmin,xmax,ymin,ymax)
c 
c--------------------------------------------------
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c     skip unwanted records
c-----
      call recskp(1,rs-1,luin,ntrc,itr)
c 
      nrsre=re-rs+1
c
      if( nrsre .gt. 25 .AND. ne .ne. ns) then
           write(*,*) 'You are going create ',nrsre,' PLOTXY files!'
           write(*,*) 'These files need large space.'
           write(*,*) 'ARE YOU SURE YOU WANT TO CREATE THEM??'
           write(*,*) 'Type 1 = Yes, 0 = NO'
           read(*,*) iy
           if(iy .ne. 1) then
              write(*,*) 'Change rs and re parameters and re-run'
              write(*,*)
              stop 1
           else
              write(*,*) 'The program may be terminated'
              write(*,*) 'if there is not enough space.'
           endif
       endif
c
c     create PLOTXY file here if stacked data
c
      if(stacked) then
         jj=0
         call getfname1("plotxy",jj,".dat",fnplotxy)
         call alloclun(luplotxy)
         open(unit=luplotxy,file=fnplotxy)
         rewind(luplotxy)
         write(luplotxy,*) nt, ' ', ny
         write(luplotxy,*) xmin,' ',xmax
         write(luplotxy,*) ymin, ' ',ymax
      endif

c
c      write(*,*) 'HELP rs,re=',rs,re
c       write(*,*) 'HELP nbeg,nend=',nbeg,nend
      do 4096 jj = rs, re
c 
c----------------------
c  skip to start trace
c----------------------
c
         call trcskp(jj,1,ns-1,luin,ntrc,itr)
c 
c     create PLOTXY file here if unstacked data
c
      if(unstacked) then
         ijk=jj
c         write(*,*) 'PLOTXY ijk=',ijk
         call getfname1("plotxy",ijk,".dat",fnplotxy)
         call alloclun(luplotxy)
         open(unit=luplotxy,file=fnplotxy)
         rewind(luplotxy)
         write(luplotxy,*) nt, ' ', ny
         write(luplotxy,*) xmin,' ',xmax
         write(luplotxy,*) ymin, ' ',ymax
      endif
c
         do 1024 kk = ns, ne
c 
            nbytes = 0
            call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

            if (StaCor .eq. 30000) then
               DeaDTracE = .true.
               do 500 ijk=nbeg,nend
500            x(ijk)=0.0
            else
               call vmov (itr(ITHWP1), 1, x, 1,nsamp)
            endif
c
c              write plotxy data
c
            do 600 ijk=nbeg,nend
               write(luplotxy,*) x(ijk)
600         continue
c 
1024     continue
c 
c      close plotxy data file if(unstacked)
c
         if(unstacked) close(luplotxy)
c
 
c----------------------
c  skip to end of record
c----------------------

         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 
c---------------------
4096     continue
         if(stacked) close(luplotxy)
c
c-----
c Normal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
 
c      write(LERR,*)'SIS2PLOTXY: Normal Completion'
c      write(LERR,*)'processed',nrec,' record(s)',
c     :     ' with ',ntrc, ' traces'
      write(LER,*) ' '
      write(LER,*) 'SIS2PLOTXY: Normal Completion'
      write(LER,*) ' '
      stop  
    
 999  continue
 
c-----
c Abnormal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
 
      write(LER,*) ' '
      write(LERR,*)'SIS2PLOTXY: Abormal Completion'
      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'SIS2PLOTXY: Abormal Completion'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
          write(LER,*) 
     1    '"sis2plotxy" is a USP program to convert seismic data'
          write(LER,*) 
     1    ' into a gridded flat file for displaying contour by'
          write(LER,*) 
     3    ' PLOTXY. '
          write(LER,*) ' '
          write(LER,*) 
     1    'users enter the following parameters,'
          write(LER,*) 
     1    'or use the default values:'
        write(LER,*) ' '
          write(LER,*)
     1 '-N[ntap]   (no default)     : input dataset filename'
          write(LER,*)
     1 '-rs[rs]    (default=first)  : start record number'
          write(LER,*)
     1 '-re[re]    (default=last)   : end record number'
          write(LER,*)
     1 '-ns[ns]    (default=first)  : start trace number'
          write(LER,*)
     1 '-ne[ne]    (default=last)   : end trace number'
          write(LER,*)
     1 '-s[s]      (default=first)  : start time (ms)'
          write(LER,*)
     1 '-e[e]      (default=last)   : end time (ms)'
          write(LER,*)
     1 'Xmin[xmin]   (default=s)    : Minimum X value'
          write(LER,*)
     1 'Xmax[xmax]   (default=e)    : Maximum X value'
          write(LER,*)
     1 'Ymin[ymin]   (default=ns)   : Minimum Y value'
          write(LER,*)
     1 'Ymax[ymax]   (default=ne)   : Maximum Y value'
          write(LER,*)
          write(LER,*) ' '
          write(LER,*)
     2 '           The gridded flat files will be named:'
          write(LER,*)
     3 '           PLOTXY_rec#.DAT'
          write(LER,*)
     4 '           If stacked data, the file name will be'
          write(LER,*)
     5 '           PLOTXY_0.DAT'
          write(LER,*) ' '
          write(LER,*) ' '
        write(LER,*)'usage:  '
        write(LER,*)
     1 'sis2plotxy -N[ntap] -rs[ns] -re[ne] -ns[ns] -ne[ne] -s[s] -e[e]'
          write(LER,*)
     2'            -Xmin[xmin] -Xmax[xmax] -Ymin[ymin] -Ymax[ymax]'
        write(LER,*) ' '
        write(LER,*) 'Contact: Yaohui Zhang/Ext3901, E&PTG'
        write(LER,*) '         Email: yzhang@trc.amoco.com'
        write(LER,*)
     :'************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,rs,re,s,e,
     1                  xmin,xmax,ymin,ymax,verbos)
c-----
c     get command arguments
c
c     ntap  - C*120    input file name
c     otap  - C*120    output file name
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     rs    - I*4      starting record index
c     re    - I*4      ending record index
c     s     - I*4      starting time (ms)
c     e     - I*4      ending time (ms)
c     xmin  - R*4      Minimum X value
c     xmax  - R*4      Maximum X value
c     ymin  - R*4      Minimum Y value
c     ymax  - R*4      Maximum Y value
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, rs, re, s, e
      real        xmin,xmax,ymin,ymax
      logical     verbos
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-s', s ,   0  , 0  )
            call argi4 ( '-e', e ,   0  , 0  )
            call argi4 ( '-ns', ns , 0  , 0  )
            call argi4 ( '-ne', ne , 0  , 0  )
            call argi4 ( '-rs', rs , 0  , 0  )
            call argi4 ( '-re', re , 0  , 0  )
            call argr4 ( '-Xmin', xmin , -30000.0 , -30000.0 )
            call argr4 ( '-Xmax', xmax , -30000.0 , -30000.0 )
            call argr4 ( '-Ymin', ymin , -30000.0 , -30000.0 )
            call argr4 ( '-Ymax', ymax , -30000.0 , -30000.0 )
            verbos =   (argis('-V') .gt. 0)
 
      return
      end
 
C***********************************************************************
      subroutine verbal(ntap,nsamp,nsi,ntrc,nrec,iform,
     1                  s,e,ns,ne,rs,re,
     2                  otap,nx,ny,xmin,xmax,ymin,ymax)
c-----
c     verbose output of processing parameters
c

c     ntap  - C*120    input file name
c     nsamp - I*4      number of samples in trace
c     nsi   - I*4      sample interval in ms
c     ntrc  - I*4      traces per record
c     nrec  - I*4      number of records per line
c     iform - I*4      format of data
c     s     - I*4      starting time (ms)
c     e     - I*4      ending time (ms)
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     rs    - I*4      starting record index
c     re    - I*4      ending record index
c     otap  - C*120    rootName for PLOTXY files
c     nx    - I*4      Number of samples on X
c     ny    - I*4      Number of samples on Y
c     xmin  - R*4      Minimum X value
c     xmax  - R*4      Maximum X value
c     ymin  - R*4      Minimum Y value
c     ymax  - R*4      Maximum Y value
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,rs,re,s,e
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
c            write(LERR,10) ' input data set name =  ', ntap
            write(LERR,10) ntap
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) ' Input values from command line:'
            write(LERR,*) ' starting time         : ',s, '(ms)'
            write(LERR,*) ' ending time           : ',e, '(ms)'
            write(LERR,*) ' starting trace index  :',ns
            write(LERR,*) ' ending trace index    :',ne
            write(LERR,*) ' starting record index :',rs
            write(LERR,*) ' ending record index   :',re
            write(LERR,*) ' # of samples of X     = ',nx
            write(LERR,*) ' # of samples of Y     = ',ny
            write(LERR,*) ' Minimum X value       = ',xmin
            write(LERR,*) ' Maximum X value       = ',xmax
            write(LERR,*) ' Minimum Y value       = ',ymin
            write(LERR,*) ' Maximum Y value       = ',ymax
            write(LERR,*)' '
            write(LERR,*)' '
10          format(' input data set name   =  ',a120)
      return
      end
 
