/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* this program is used to scan an SIS format (USP) format, checking for
   invalid green words within the dataset. 
					- Joe M. Wade			*/

/* modified the code to NOT print out the record, trace indices unless the
   verbose flag ( "-V" ) has been set. 

   also put in freads so that piped data is now allowable. However, any
   format other that the normal IEEE disk format will not work.
					- Joe M. Wade     12/14/95	*/
/*
   the above problem with piped data that is NOT big-endian format has been
   repaired. The Crays are probably still a problem, but we no longer have
   access to that architecture.
					- Joe M. Wade      3/8/01 
*/

#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <fcntl.h>
#include <cu_defs.h>
#include <sys/types.h>
#ifdef SUNSYSTEM
#include <sys/unistd.h>
#endif

#ifdef CRAYSYSTEM
#define WORDSIZE 8
#else
#define WORDSIZE 4
#endif

main (argc, argv) 
int    argc;
char * argv[];
{
	FILE *fdin;
	int c;
	int i,j,k;

#ifndef __convex__
	off_t lh_green_word,tail;
#else
	off64_t lh_green_word,tail;
#endif
	int help;
	int verbose = 0;
	int piped_data;
	int format,start_rec,end_rec,start_trace,end_trace;
	int no_of_samples,no_of_records,traces_per_record;
	int expected_green_word;
	int no_of_traces = 0;
	int lh_count;
	int traces_to_skip,seq_rec,seq_trace;
	char ntap[256];
	char *hlh_entry,*buffer;
	int C_ARGIS();
	int is_a_pipe();
	int read_to_eof;
 
	union {
		int size;
		char dummy[WORDSIZE];
		} green_word ;

	help = C_ARGIS("-h",&argc,argv);
	help += C_ARGIS("-?",&argc,argv);
	if (help > 0) {
	  fprintf(stderr,"****************************************");
	  fprintf(stderr,"***************************************\n");
	  fprintf(stderr,"Usage: sis_verify -N[ntap] -rs[rs] -re[re] ");
	  fprintf(stderr,"-ns[ns] -ne[ne]\n\n");
	  fprintf(stderr," -N[ntap]\t(default=stdin) : Input data set");
	  fprintf(stderr," file name\n");
	  fprintf(stderr," -rs[rs]\t(default=first) : start record #");
	  fprintf(stderr," (sequential)\n");
	  fprintf(stderr," -re[re]\t(default=last)  : end record #");
	  fprintf(stderr," (sequential)\n");
	  fprintf(stderr," -ns[ns]\t(default=first) : start trace #");
	  fprintf(stderr," (sequential)\n");
	  fprintf(stderr," -ne[ne]\t(default=last)  : end trace #");
	  fprintf(stderr," (sequential)\n");
	  fprintf(stderr," -eof\t(default=off)   : read to end of data");
	  fprintf(stderr," -V\t\t                : verbose output\n");
	  fprintf(stderr," -H\t\t                : display HLH entries\n");
	  fprintf(stderr," -h\t\t                : print this help\n");
	  fprintf(stderr,"****************************************");
	  fprintf(stderr,"***************************************\n\n");
	  exit(0);
	  }

/* turn off buffering on stdout */

	setbuf(stdout, NULL);

	verbose = C_ARGIS("-V",&argc,argv);
	read_to_eof = C_ARGIS("-eof",&argc,argv);

	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (strncmp(ntap," ",1) != 0) {
	  fdin = fopen(ntap, "r");
	  if (fdin == NULL) {
	    fprintf(stderr,"%s: unable to open input dataset %s\n",
		argv[0],ntap);
	    exit(1);
	    }
	  printf("dataset = %s\n\n",ntap);
	  }
	else {
	  fdin = stdin;
	  printf("dataset = stdin\n\n");
	  }

	piped_data = is_a_pipe(fdin);

	green_word.size = 0;
	for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
		c = getc(fdin);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}

	buffer = (char *) malloc(green_word.size);
	if (buffer == NULL) {
	  printf("sis_verify (memory allocation): unable to allocate ");
	  printf("%d bytes\n",green_word.size);
	  fflush(stdout);
	  exit(1);
	  }

#ifndef __convex__
	lh_green_word = (off_t) green_word.size;
	printf("line header green word = %d\n",(int)lh_green_word);
	if (!piped_data) {
	  if ((fseek(fdin,(long int)48,SEEK_CUR)) == EOF) {
	    perror("sis_verify (seek)");
	    exit(1);
	    }
	  }
	else if ((int)fread(buffer,sizeof(char),(off_t) 48,fdin) <= (int) 0) {
	  perror("sis_verify (read)");
	  exit(1);
	  }
#else
	lh_green_word = (off64_t)green_word.size;
	printf("line header green word = %d\n",lh_green_word);
	if (!piped_data) {
	  if ((fseek64(fdin,(off64_t)48,SEEK_CUR)) == EOF) {
	    perror("sis_verify (seek)");
	    exit(1);
	    }
	  }
	else if ((int)fread(buffer,sizeof(char),(off64_t) 48,fdin) <= (int) 0) {
	  perror("sis_verify (read)");
	  exit(1);
	  }
#endif

	green_word.size = 0;
	for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	printf("number of traces/record = %d\n",green_word.size);
	traces_per_record = green_word.size;

	green_word.size = 0;
	for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	printf("number of records = %d\n",green_word.size);
	no_of_records = green_word.size;

	green_word.size = 0;
	for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	printf("sample interval = %d\n",green_word.size);

	green_word.size = 0;
	for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	no_of_samples = green_word.size;
	printf("number of samples/trace = %d\n",green_word.size);

	green_word.size = 0;
	for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[i] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	format = green_word.size;
	printf("format = %d\n",format);

/*
	for (i=0; i<934; i++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
 		}
*/
	if (!piped_data) {
	  if ((fseek(fdin,(long int)934,SEEK_CUR)) == EOF) {
	    perror("sis_verify (seek)");
	    exit(1);
	    }
	  }
	else {
	  if (((int)fread(buffer,sizeof(char),(off_t)934,fdin)) <= (int) 0) {
	    perror("sis_verify (read)");
	    exit(1);
	    }
	  }

	green_word.size = 0;
	for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[i] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	printf("no. of hlh entries = %d\n",green_word.size);
	lh_count = green_word.size;

	green_word.size = 0;
	for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[i] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	printf("hlh byte total = %d\n\n",green_word.size);

	if ( C_ARGIS("-H",&argc,argv) != 0 ) {
	  printf("hlh entries: \n");
	  for (k=0; k<lh_count; k++) {
	    green_word.size = 0;
	    for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
		if ( ! piped_data )
		  green_word.dummy[WORDSIZE-j-1] = (char) c;
		else
		  green_word.dummy[j] = (char) c;
#else
		green_word.dummy[j] = (char) c;
#endif
 		}
	    hlh_entry = (char *)malloc((green_word.size+1)*sizeof(char));
	    hlh_entry[green_word.size] = '\0';
	    if ((int)fread(hlh_entry,sizeof(char),
			(int) green_word.size,fdin) <= (int) 0) {
		perror("sis_verify (hlh read)");
		exit(2);
		}
	    printf(" %3d (%3d bytes) : %s\n",
		k+1,green_word.size,(char *)&hlh_entry[0]);
	    free(hlh_entry);
	    }
	  printf("\n");
	  }
	else {
#ifndef __convex__
	  if (!piped_data) {
	    if ((fseek(fdin,(long int)(lh_green_word-1004),SEEK_CUR)) == EOF) {
	      perror("sis_verify (seek)");
	      exit(1);
	      }
	    }
	  else if ((int)fread(buffer,sizeof(char),
			(off_t)(lh_green_word-1004),fdin) <= (int) 0) {
	    perror("sis_verify (read)");
	    exit(1);
	    }
#else
	  if (!piped_data) {
	    if ((fseek64(fdin,(off64_t)(lh_green_word-1004),SEEK_CUR)) == EOF) {
	      perror("sis_verify (seek)");
	      exit(1);
	      }
	    }
	  else if ((int)fread(buffer,sizeof(char),
		(off64_t)(lh_green_word-1004),fdin) <= (int) 0) {
	    perror("sis_verify (read)");
	    exit(1);
	    }
#endif
	  }

	C_ARGI4("-rs",&start_rec,1,1,&argc,argv);
	C_ARGI4("-re",&end_rec,no_of_records,no_of_records,&argc,argv);
	C_ARGI4("-ns",&start_trace,1,1,&argc,argv);
	C_ARGI4("-ne",&end_trace,traces_per_record,traces_per_record,&argc,argv);
	printf("starting record %d\n",start_rec);
	if (read_to_eof == 0)
	  printf("ending record %d\n",end_rec);
	else
	  printf("ending record EOF\n");
	printf("starting trace %d\n",start_trace);
	printf("ending trace %d\n",end_trace);

	green_word.size = 0;
	traces_to_skip = ((start_rec-1) * traces_per_record) + start_trace - 1;
	seq_rec = start_rec;
	seq_trace = start_trace;

	printf("expected trace green word =  ");

	if (format == 1)
	  expected_green_word = (2*no_of_samples)+256;
	else if (format == 3)
	  expected_green_word = (4*no_of_samples)+256;
	else {
	  fprintf(stderr,"\n**** unrecognized format **** (%d)\n",
	  format);
	  exit(1);
	  }
	printf("%d bytes\n\n",expected_green_word);

	if (piped_data | verbose) {
	  buffer = (char *)realloc(buffer,expected_green_word);
	  if (buffer == NULL) {
	    printf("sis_verify (memory allocation): unable to allocate ");
	    printf("%d bytes\n",green_word.size);
	    fflush(stdout);
	    exit(1);
	    }
	  }
/*
	read one green word to verify size of each trace
*/
	while(1) {
	 
		if (traces_to_skip != 0) {
		  for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
		 	if ((c=getc(fdin)) == EOF) {
		  	  printf("end of data found: ");
		  	  printf("traces processed = %d\n",no_of_traces);
			  exit(0);
			  }
#ifdef LINUXSYSTEM
		        if ( ! piped_data )
			  green_word.dummy[WORDSIZE-j-1] = (char) c;
			else
			  green_word.dummy[j] = (char) c;
#else
			green_word.dummy[j] = (char) c;
#endif
 			}

		  if ( verbose ) {
		    printf("green word = %d; ",green_word.size);
		    printf("skipping %d traces ",traces_to_skip);
		    }

#ifdef CONVEXSYSTEM
		  tail = (off64_t) ((off64_t) traces_to_skip *
			(off64_t)(green_word.size+4)) - 4;
		  if ( verbose )  printf("( %lld bytes )\n",tail);
		  if (!piped_data) {
		    if ((fseek64(fdin,(off64_t) tail,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else {
		    for (i=0, tail=(off64_t)green_word.size;
			i<traces_to_skip; i++, tail=(off64_t)green_word.size+4) {
		      if (((int)fread(buffer,sizeof(char),
				(off64_t)tail,fdin)) <= (int) 0) {
		        perror("sis_verify (read)");
		        exit(1);
		        }
		      }
		    }
#elif defined ( FSEEKO  )
		  tail = (off_t) ((off_t) traces_to_skip *
			(off_t)(green_word.size+4)) - 4;
		  if ( verbose )  printf("( %ld bytes )\n",tail);
		  if (!piped_data) {
		    if ((fseeko(fdin,(off_t)tail,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else {
		    for (i=0, tail=(off_t)green_word.size;
			i<traces_to_skip; i++, tail=(off_t)green_word.size+4) {
		      if (((int)fread(buffer,sizeof(char),
				(off_t)tail,fdin)) <= (int) 0) {
		        perror("sis_verify (read)");
		        exit(1);
		        }
		      }
		    }
#else
		  tail = (off_t) ((off_t) traces_to_skip *
			(off_t)(green_word.size+4)) - 4;
		  if ( verbose )  printf("( %ld bytes )\n",tail);
		  if (!piped_data) {
		    if ((fseek(fdin,(long int)tail,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else {
		    for (i=0, tail=(off_t)green_word.size;
			i<traces_to_skip; i++, tail=(off_t)green_word.size+4) {
		      if (((int)fread(buffer,sizeof(char),
				(off_t)tail,fdin)) <= (int) 0) {
		        perror("sis_verify (read)");
		        exit(1);
		        }
		      }
		    }
#endif
		  no_of_traces += traces_to_skip;
		  traces_to_skip = 0;
		  }

		for (i=0,j=WORDSIZE-4; i<4; i++, j++) {
	 		if ((c=getc(fdin)) == EOF) {
		  	  printf("end of data found: ");
		  	  printf("traces processed = %d\n",no_of_traces);
			  exit(0);
			  }
#ifdef LINUXSYSTEM
			if ( ! piped_data )
			  green_word.dummy[WORDSIZE-j-1] = (char) c;
			else
			  green_word.dummy[j] = (char) c;
#else
			green_word.dummy[j] = (char) c;
#endif
 			}

/* if we've found a bad green word; turn on the printout */

		if (green_word.size != expected_green_word) {
		  verbose+=100;
		  if (green_word.size > expected_green_word) {
		    buffer = (char *)realloc(buffer,green_word.size);
		    if (buffer == NULL) {
		      printf("sis_verify (memory allocation): unable to allocate ");
		      printf("%d bytes\n",green_word.size);
	              printf("traces processed = %d\n",no_of_traces);
		      fflush(stdout);
		      exit(1);
		      }
		    }
		  }
		
		if ( !verbose )
		  tail = green_word.size;
		else {
		  printf("green word = %d; ",green_word.size);
		  tail = green_word.size-214;

		  if (tail <= 0) {
		    printf("\nsomething's gone wrong; ");
		    printf("traces processed = %d\n",no_of_traces);
		    exit(1);
		    }
		
		  green_word.size = 0;

#ifdef CONVEXSYSTEM
		  if (!piped_data) {
	  	    if ((fseek64(fdin,(off64_t) 210,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else if (((int)fread(buffer,sizeof(char),
				(off64_t)210,fdin)) <= (int) 0) {
		    perror("sis_verify (read)");
		    exit(1);
		    }
#elif defined ( FSEEKO  )
		  if (!piped_data) {
	  	    if ((fseeko(fdin,(off_t)210,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else if (((int)fread(buffer,sizeof(char),
			(off_t)210,fdin)) <= (int) 0) {
		    perror("sis_verify (read)");
		    exit(1);
		    }
#else
		  if (!piped_data) {
	  	    if ((fseek(fdin,(long)210,SEEK_CUR)) == EOF) {
		      perror("sis_verify (seek)");
		      exit(1);
		      }
		    }
		  else if (((int)fread(buffer,sizeof(char),
			(size_t)210,fdin)) <= (int) 0) {
		    perror("sis_verify (read)");
		    exit(1);
		    }
#endif

		  for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 		if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
			if ( ! piped_data )
			  green_word.dummy[WORDSIZE-j-1] = (char) c;
			else
			  green_word.dummy[i] = (char) c;
#else
			green_word.dummy[j] = (char) c;
#endif
		 	}

		  printf("rec %d ",green_word.size);

		  for (i=0,j=WORDSIZE-2; i<2; i++, j++) {
	 		if ((c=getc(fdin)) == EOF) exit(1);
#ifdef LINUXSYSTEM
			if ( ! piped_data )
			  green_word.dummy[WORDSIZE-j-1] = (char) c;
			else
			  green_word.dummy[i] = (char) c;
#else
			green_word.dummy[j] = (char) c;
#endif
 			}

		  printf("trace %d\n",green_word.size);
		  fflush(stdout);
		  }

		no_of_traces++;

#ifdef CONVEXSYSTEM
		if (!piped_data) {
	  	  if ((fseek64(fdin,(off64_t) tail,SEEK_CUR)) == EOF) {
		    perror("sis_verify (seek)");
		    exit(1);
		    }
		  }
		else if (((int)fread(buffer,(size_t)sizeof(char),
			(size_t)tail,fdin)) <= (int) 0) {
		  perror("sis_verify (read)");
		  exit(1);
		  }
#elif defined ( FSEEKO  )
		if (!piped_data) {
	  	  if ((fseeko(fdin,(off_t)tail,SEEK_CUR)) == EOF) {
		    perror("sis_verify (seek)");
		    exit(1);
		    }
		  }
		else if (((int)fread(buffer,(size_t)sizeof(char),
				(size_t)tail,fdin)) <= (int) 0) {
		  perror("sis_verify (read)");
		  exit(1);
		  }
#else
		if (!piped_data) {
	  	  if ((fseek(fdin,(long)tail,SEEK_CUR)) == EOF) {
		    perror("sis_verify (seek)");
		    exit(1);
		    }
		  }
		else if (((int)fread(buffer,(size_t)sizeof(char),
				(size_t)tail,fdin)) <= (int) 0) {
		  perror("sis_verify (read)");
		  exit(1);
		  }
#endif
		if (verbose >= 100) {
		  verbose-=100;
		  buffer = (char *)realloc(buffer,expected_green_word);
		  if (buffer == NULL) {
		    printf("sis_verify (memory allocation): unable to allocate ");
		    printf("%d bytes\n",green_word.size);
		    fflush(stdout);
		    exit(1);
		    }
		  }

		if (seq_trace == end_trace) {
		  if ((seq_rec == end_rec) && ( read_to_eof == 0)) {
		  	printf("traces processed = %d\n",no_of_traces);
			exit(0);
			}
		  seq_rec++;
		  seq_trace = 0;
		  seq_trace = start_trace;
		  traces_to_skip = (traces_per_record - end_trace) +
			(start_trace - 1);
		  }
		else
		  seq_trace++;
		}
}
