C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c     program module sisort
c
c**********************************************************************c
c
c     sisort reads a siesmic trace from the command line,
c     and creates an output in the order of entries in
c     a table to create an output stream ordered on the
c     gi, si, di or distance
c
c subroutine calls: rtape, hlh, wrtape, save, dagc, odd
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c
      integer     itr ( SZLNHD ), ltr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, rind, tind
      integer     luin , luout, lbytes, nbytes
      integer     istart,iend, nsampo,obytes
#include <f77/pid.h>
      integer     reccnt(4),trccnt(4)
      integer     trc,rec
      integer     currec, curtrc
      integer     gimin, gidel,recind,gival
      real        tri ( SZLNHD )
      character   name * 6,   ntap * 256, otap * 256, tnam * 256
      real        lri ( SZLNHD )
      logical     verbos, query, G, S, D, R, X, leave, first
      integer     argis

c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
c     equivalence ( ltr(129), lri (1) )
      data name     /'GSORT'/
      data lbytes / 0 /, nbytes / 0 /, leave / .false. /
      data ltr/ SZLNHD * 0/
      data first/.true./
      
c-----
c     get help if necessary
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

c-----
c     read program parameters from command line card image file
c-----
      call gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos,leave,
     &             istart,iend,nsampo)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      if (luin .eq. 0) then
         write(LERR,*)'Cannot pipe into sisort'
         write(LERR,*)'Use -Nindata on command line where indata'
         write(LERR,*)'refers to a disk file (including full path)'
         write(LERR,*)'if data not in current working directory'
         stop
      endif
      call getln(luout, otap,'w', 1)
c     call sislgbuf( luin, 'off' )

c-----
c     guarantee that we can work with the files
c-----
       if(tnam(1:1).eq.' ')then
              luns = LIN
       else
              luns = 22
              open(luns,file=tnam,status='old',
     1                     form='formatted',access='sequential')
              rewind luns
       endif
       if(luin.eq.0)then
              write(LER,*)'DATA FILE must be given as -Nntap'
              write(LER,*)'FATAL ERROR'
              stop
       endif

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape ( luin, itr, lbytes            )
      if(lbytes .eq. 0) then
             write(LOT,*)'sisort: no header read from unit ',luin
             write(LOT,*)'FATAL'
             stop
      endif

      call hlhprt ( itr , lbytes, name, 6, LERR        )
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)

      nsampo = nsampo/nsi
      if(nsampo .le. 0) nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo
      lbytes4 = lbytes + SZSAMP
      nbytes4 = SZDTHD + SZSAMP * nsamp + SZSAMP

c-----
c     modify line header to reflect actual number of traces output
c-----
c  check for old table & abort if necessary
      read(luns,*,end=7) itype
      if(itype .ne. -1) then
c  old table
      write(LERR,*)'Sort table is old: run presort step again'
      stop
      endif
      go to 9
c  new table
    7 continue
      write(LERR,*)'Premature end of file on sort table'
      write(LERR,*)'check presort run & repeat if necessary'
      stop
    9 continue

c-------
c  read presort table header
c-------
      read(luns,*)ndat
      write(LERR,*)'number entries in sort table= ',ndat
      read(luns,*)(reccnt(i),trccnt(i),i=1,4)
      write(LERR,*)(reccnt(i),trccnt(i),i=1,4)
      read(luns,*)gimin,gidel
      if(G)then
            nrecc = reccnt(1)
            jtr   = trccnt(1)
      elseif(S)then
            nrecc = reccnt(2)
            jtr   = trccnt(2)
      elseif(D)then
            nrecc = reccnt(3)
            jtr   = trccnt(3)
      elseif(R)then
            nrecc = reccnt(4)
            jtr   = reccnt(1)
      elseif(X)then
            nrecc = reccnt(4)
            jtr   = trccnt(4)
      endif
      if(iend .ne. 0) then
         nrecc = iend - istart + 1
      else
         iend = 1 000 000 000
      endif

c--------
c  save new line header values
c  adjust hist header
c  write line header
c--------
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savew(itr, 'NumSmp', nsampo,LINHED)
      call savhlh( itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec,iform, 
     1           ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo)
      end if

c-----
c     BEGIN PROCESSING
c     process desired trace records
c-----

      currec = 1
      curtrc = 1
      gival  = gimin
      if(verbos)write(LERR,*)'# recs= ',nrecc, ' # trc/rec= ',jtr,
     1           ' istart= ',istart,' iend= ',iend

c----------
c  read each line of presort table
c  pick off appropriate index and its associated rec & trc #'s
c  these #'s are then used to pick off the correct sorted trace
c  from somewhere in the input disk data set
c----------

      DO  1000 jjj = 1, ndat

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'New presort line  ',jjj
         write(LERR,*)' '
      endif
      read(luns,*,end=9999)i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12
            if(R)then
                  newrec = i10
                  jj  = i10
                  rec = i11
                  trc = i12
            elseif(S)then
                  newrec = i2
                  rec = i6
                  trc = i7
                  jj = i2

          if (i6 .eq. 0 .or. i7 .eq. 0) then
             write(LERR,*)'Source indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Source indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(G)then
                  newrec = i1
                  rec = i4
                  trc = i5
                  jj = i1

          if (i4 .eq. 0 .or. i5 .eq. 0) then
             write(LERR,*)'Group index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Group indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(D)then
                  newrec = i3
                  rec = i8
                  trc = i9
                  jj = i3

          if (i8 .eq. 0 .or. i9 .eq. 0) then
             write(LERR,*)'Depth index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Depth indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(X)then
                  newrec = i10
                  rec = i11
                  trc = i12
                  jj  = i10

          if (i11 .eq. 0 .or. i12 .eq. 0) then
             write(LERR,*)'Offset indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Offst indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            endif



c-------------
c  is the sort index within the user
c  specified range?
c-------------
         IF (jj .ge. istart .and. jj .le. iend) THEN

            call dif(irccnt,itrcnt,jjj,jj,jump,first)
            if(verbos) then
                      write(LERR,*)' '
                      write(LERR,*)' '
                      write(LERR,*)'irccnt= ',irccnt,'  itrcnt= ',
     1                itrcnt,'  jjj= ',jjj,'  jj= ',jj,'  jump= ',jump
                      write(LERR,*)' '
            endif
c-----
c      if we have jumped to a new record or if we are at
c      the end of a data set, output necessary blank
c      traces at the end to fill in the record
c-----
            if(jump.eq.1 )then
              if(verbos)
     1        write(LERR,*)'Start new record: jtr= ',jtr
              if(jj .ge. istart .and. jj .le. iend) then
                  if(curtrc.ge.1 .and. curtrc.le.jtr)then
                  if(verbos)
     1            write(LERR,*)'currec= ',currec,' curtrc= ',curtrc
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     7                 currec,curtrc-1,jtr,nsamp,iform)
                  endif
              endif
                  currec = currec + 1
                  curtrc = 1
                  gival = gimin
            endif

            if(verbos)write(LERR,*)i1,i2,i3,i4,i5,i6,i7,
     1            i8,i9,i10,i11,i12

c           ioff = lbytes4 + ((rec-1)*ntrc + (trc-1))*nbytes4
c           call seekt ( luin, ioff )
            ioff = (rec-1)*ntrc + trc
            call sisseek (luin, ioff)

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
              write(LERR,*)'FATAL ERROR'
              write(LERR,*)' '
              write(LERR,*)'read failed for rec, trc= ',rec,trc
              write(LERR,*)' '
              write(LERR,*)'presort table line...'
              write(LERR,*)i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12
              write(LERR,*)' '
              write(LERR,*)'Try rerunning presort on your data to build'
              write(LERR,*)'a new table.  Has your data changed since'
              write(LERR,*)'sort table was built?'
              stop
            endif

c           recind = itr(122)
c           rind   = itr(106)
c           tind   = itr(107)
            call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                  recind, TRACEHEADER)
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  rind  , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  tind  , TRACEHEADER)

            if(verbos)write(LERR,*)'recind=',recind,' rind= ',rind,
     &                             ' tind= ',tind,' nbytes= ',nbytes
            if(.not. leave) then
               call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     currec, TRACEHEADER)
               call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     curtrc, TRACEHEADER)
            endif
            curtrc = curtrc + 1

c------------
c  write out sorted trace
c  or padded trace
c------------
            call wrtape( luout, itr, obytes)

            gival = gival + 1
            if(verbos)write(LERR,*)'rec trc gival  ',currec, 
     1            curtrc, gival,recind

         ENDIF

 1000    CONTINUE

            currec = currec + 1
            if(curtrc-1.lt.jtr)then
                  if(verbos)
     1            write(LERR,*)'End of line:  currec= ',currec,
     2                          ' curtrc= ',curtrc,' jtr= ',jtr
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     7                 currec-1,curtrc-1,jtr,nsamp,iform)
            endif

 9999 continue
c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if(verbos) then
            write(LERR,*)'end of sisort, processed ',nrec,' record(s)',
     1            ' with ',ntrc, ' traces'
      endif
      end

       subroutine dif(ir,it,i,j,jump,first)
c-----
c      increment record count (ir) and trace count (it)
c      whenever j changes
c      i is the initialization flag
c      jump indicates that a transition to a new record has occurred
c-----
       logical first
c      static oldj, nt, nr
       save oldj, nt, nr
       if(first)then
              ir = 1
              it = 1
              nt = 1
              nr = 1
              oldj = j
              jump = 0
              first = .false.
       else
c--------------------------------------------
c  oldj is last
c  sort index #
c  nt = new trc seq
c  nr = new rec seq

              if(j .le. oldj)then
                     nt = nt + 1
                     it = it + 1
                     jump=0
              else
                     nr = nr + 1
                     if(nt.gt.it)it=nt
                     nt = 1
                     it = 1
                     ir = nr
                     oldj = j
                     jump = 1
              endif
       endif
       return
       end

      subroutine nultrc(itr,tri,verbos,nbytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     7                 currec,j1,j2,nsamp,iform)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer*4 nsamp, iform, j1, j2
      integer * 2 itr ( SZLNHD )
      real    * 4 tri ( SZSMPM )
      integer*4 currec
      integer*4 luout
      logical verbos

c           itr(125) = 30000
            call savew2(itr,ifmt_StaCor,l_StaCor,
     1                  ln_StaCor, 30000, 1)
 1002       continue
            do 1001 i=j1+1,j2
                  if(verbos)write(LERR,*)'Null outputting rec='
     1                  ,currec,' trace=',i
c                 itr(106)=currec
c                 itr(107)=i
c                 itr(109)=0
c                 itr(110)=0
c                 itr(111)=0
c                 itr(118)=0
c                 itr(122)=0
                  call savew2(itr,ifmt_RecNum,l_RecNum,
     1                        ln_RecNum, currec, 1)
                  call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                        ln_TrcNum, i     , 1)
                  call savew2(itr,ifmt_SrcLoc,l_SrcLoc,
     1                        ln_SrcLoc, 0     , 1)
                  call savew2(itr,ifmt_PrRcNm,l_PrRcNm,
     1                        ln_PrRcNm, 0     , 1)
                  call savew2(itr,ifmt_PrTrNm,l_PrTrNm,
     1                        ln_PrTrNm, 0     , 1)
                  call savew2(itr,ifmt_RecInd,l_RecInd,
     1                        ln_RecInd, 0     , 1)
                  call savew2(itr,ifmt_DphInd,l_DphInd,
     1                        ln_DphInd, 0     , 1)
                  call wrtape( luout, itr, nbytes)
 1001       continue
      return
      end

      subroutine help
#include <f77/iounit.h>
         write(LOT,*)
     1'***************************************************************'
      write(LOT,*)
     1'execute sisort by typing sisort and  list of program parameters.'
      write(LOT,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LOT,*)
     1'a character(s) corresponding to some parameter.'
        write(LOT,*)
     1'users enter the following parameters, or use the default values'
        write(LOT,*)' '
        write(LOT,*)
     1' -N [ntap]    (no default)         : input data file name'
        write(LOT,*)
     1' -O [otap]    (default = stdout )  : output data file name'
       write(LOT,*)
     1' -n [tnam]    (default = stdin)    : sort table name'
        write(LOT,*)' '
        write(LOT,*)
     1' -e [time]    (default = input )   : output trace length (ms)'
        write(LOT,*)
     1' -l [istart]  (default = first )   : starting record to sort'
        write(LOT,*)
     1' -m [iend]    (default = last )    : ending record to sort'
       write(LOT,*)
     1' -orig        (default = false)    : leave original rec/trc nos.'
       write(LOT,*)
     1' -G           (default = false)    : sort on receiver index'
       write(LOT,*)
     1' -S           (default = false)    : sort on source index  '
       write(LOT,*)
     1' -D           (default = false)    : sort on depth index'
       write(LOT,*)
     1' -R           (default = false)    : sort on distance-zero pad'
       write(LOT,*)
     1' -X           (default = false)    : sort on distance-no pad'
        write(LOT,*)' '
        write(LOT,*)
     1' NOTE only one of -G -R -S or -D can be given'
       write(LOT,*)
     1'usage:   sisort -N[ntap] -O[otap] -n[tnam] -e[] -G -R -S -D -X',
     2'  -V'
         write(LOT,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos, leave,
     &                       istart, iend, nsampo)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table file name
c   istart  - I         start sort record
c    iend   - I         stop sort record
c   leave   - L         leave trace & record number the same as input
c     G     - L         Sort on receiver index
c     S     - L         Sort on source index
c     D     - L         Sort on depth index
c     R     - L         Sort on distance
c     X     - L         Sort on distance - no null trace padding
c     verbos- L   verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), tnam*(*)
      logical verbos, leave, G, S, D, R, X
      integer argis,istart,iend

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-n', tnam, ' ', ' ' )
            call argi4('-e',nsampo,0,0)
            call argi4('-l',istart,-999 999 999,-999 999 999)
            call argi4('-m',iend,0,0)
            verbos = ( argis( '-V' ) .gt. 0 )
            leave = ( argis( '-orig' ) .gt. 0 )
            G = ( argis( '-G' ) .gt. 0 )
            D = ( argis( '-D' ) .gt. 0 )
            S = ( argis( '-S' ) .gt. 0 )
            R = ( argis( '-R' ) .gt. 0 )
            X = ( argis( '-X' ) .gt. 0 )
c-----
c     ensure than no more than one processing option is taken
            icmd = 0
            if(G)icmd=icmd+1
            if(D)icmd=icmd+1
            if(R)icmd=icmd+1
            if(S)icmd=icmd+1
            if(X)icmd=icmd+1
            if(icmd.ne.1)then
                  write(LOT,*)'FATAL ERROR'
                  call help()
                  stop
            endif
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec,iform, 
     1        ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table name
c     G     - L     arrange by receiver index
c     S     - L     arrange by source index
c     D     - L     arrange by CDP index
c     R     - L     arrange by distance
c     X     - L     arrange by distance no trace padding
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, istart, iend
      character ntap*(*), otap*(*), tnam*(*)
      logical D, S, R, G, X

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' sort table name     =  ',tnam
            write(LERR,*) ' output trace lenght =  ',nsampo
            write(LERR,*) ' start record        =  ',istart
            write(LERR,*) ' end record          =  ',iend
            write(LERR,*) ' sort by receiver ind=  ',G
            write(LERR,*) ' sort by source index=  ',S
            write(LERR,*) ' sort by depth index =  ',D
            write(LERR,*) ' sort by distance    =  ',R
            write(LERR,*) ' sort by dist-no fill=  ',X
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
