C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine decon_tv(x,ns,lopp,pred,pw,y,ierr,lslide,nwin,
     :ovlp)
      real x(*),y(*),decop(1501),peo(3001)
      real acorr(6000),right(1501),work(8194)
      real winwork(6000)
      real xavg, xknt,pw,offset,xmul
      real hold1(3000),sumb(3000)
      integer pred,lopp,lwind,lacorr,ovlp
      integer i,lwork,lxform,ns,ierr
      integer ioff,nzro,iflg,nf,jj
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lopp   - Operator length (samples)                    |
C |   pred   - Prediction length (samples or zero crossings)|
C |   pw     - Prewhitening (fraction)                      |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+
c     write(0,*)'ns,lopp,pred,pw,lslide,nwin,ovlp= ',
c    1ns,lopp,pred,pw,lslide,nwin,ovlp

      lacorr=(lopp+pred)*2+50
      if(lacorr.gt.lslide)lacorr=lslide
      imid1 = 0
      do kk=1,nwin
      if(kk.eq.1)then
       nmove=lslide+ovlp
       ilast=lslide+ovlp
       ifirst=1
       if(lslide.eq.ns)nmove=ns
       jmove=nmove
      else
       nmove=lslide+ovlp
       jmove=nmove
       ifirst=ifirst+ovlp
       imid1=ifirst
       ilast=ifirst+nmove-1
       if(ilast.gt.ns)then
        jmove=ns-ifirst+1
       endif
      endif
      do mm=1,nmove
       winwork(mm)=0.
      end do
      call vmov(x(ifirst),1,winwork,1,jmove)
      lwind=nmove
      xavg=0.
      jj=1
c +=============================+
c | Remove the ensemble average |
c +=============================+
      do i=1,lwind
        if(winwork(jj).ne.0.0)then
         xavg = xavg+winwork(jj)
         xknt = xknt+1.
        endif
        jj=jj+1
      end do
      if(xknt.ne.0.0)then
         xavg = xavg/xknt
      else
         xavg = 0.
      end if
      do i=lwind,4096
        work(i)=0.
      end do
      do i=1,lwind
        work(i)=winwork(i)-xavg
      end do
C +------------------------+
C | Do the autocorrelation |
C +------------------------+
      lwork=2*lwind
      lxform=64
      do while(lxform.lt.lwork)
       lxform=lxform+lxform
      end do
      call vclr(acorr,1,3000)
      call vclr(work(lwind+1),1,lxform-lwind)
      call acorf(work,acorr,lacorr,lxform)
      if (acorr(1) .lt. 1.e-30) then
       do  i = 1, lopp
        peo (i) = 0.
       enddo
       go to 10
      endif
      acorr(1)=acorr(1)*(1.+pw)
C +==========================+
C | Build the decon operator |
C +==========================+
      if(pred.ge.0)then
         if(pred.lt.1)pred=1
         ioff=pred
      else
         nzro=iabs(pred)
         if(nzro.ge.10)nzro=1
C +------------------------------------------------------------+
C | nzcros looks for nzro-th zero crossing, returning in ioff  |
C | the index count of the last sample before the nzro-th      |
C | crossing.  nf is the number of zero crossings found up to  |
C | and including the nzro-th crossing.                        |
C +------------------------------------------------------------+
         call nzcros(acorr,1,nzro,ioff,nf,lacorr)
         if(nf.lt.nzro)then
            ierr=200
            call vmov(x,1,y,1,ns)
            return
         endif
         if(pred.le.-10)then
          xmul=pred
          xmul=ABS(xmul)/10.
          offset=ioff
          ioff=offset*xmul
         endif
      endif
        call vclr(right,1,lopp)
      if(ioff.le.1)then
        call vmov(acorr(2),1,right,1,lopp)
      else
        call vmov(acorr(ioff+1),1,right,1,lopp)
      endif
      if(pred.eq.1)then
       call wiener(lopp,acorr,right,decop,peo,1,ierr)
       do i=1,lopp
        decop(i)=peo(i)
       end do
       ioff=0
      else
       call wiener(lopp,acorr,right,decop,peo,1,ierr)
      endif
      if(ierr.ne.0)call vclr(decop,1,lopp)
C +-------------------------------------------------+
C | Create proper PEO for given prediction distance |
C +-------------------------------------------------+
      lconv = lopp+ioff
      do i=1,lconv
       work(i)=0.
      end do
      call vmov(decop(1),1,work(ioff+1),1,lopp)
      if(pred.ne.1)then
       do i=1,lconv
        work(i)=-work(i)
       end do
       work(1)=1.
      endif
      call vmov(work,1,peo,1,lconv)
C +-----------------------------------+
C | Convolve the filter with the data |
C +-----------------------------------+
      do i=1,lconv
         work(i)=0.
      end do
      call vmov(winwork,1,work(lconv),1,lwind)
      call conv(work,1,peo(lconv),-1,hold1,1,lwind,lconv,1)
      if(kk.eq.1)then
       do i=1,lwind
        sumb(i)=hold1(i)
       end do
      else
       jj=imid1-1
       xj=ovlp
       do i=1,ovlp
        jj=jj+1
        x1=(i-1)/xj
        x2=1.0-x1
        sumb(jj)=sumb(jj)*x2+hold1(i)*x1
       end do
       do i=ovlp+1,jmove
        jj=jj+1
        sumb(jj)=hold1(i)
       end do
      endif
   10 continue
      end do
      do i=1,ns
       y(i)=sumb(i)
      end do
      continue
      return
      end
