C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- smooth ----- ----- ----- ----- ----- ----- -----

c routine to smooth input time series using fft smoother

c Changes:

c    June 16, 2001:  replaced all Numerical Recipe routines
c                    with NSWC public math library routines
c    Garossino

c ----- get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 


      integer     itr ( 2*SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, nreco, ntrco, argis

      real        tri ( 2*SZLNHD  )

      character   ntap*256, otap*256, name*6

      logical     verbos, flatfile, TwoFlag, EndFlag
      logical     xgraph

c set up printout files 

#include <f77/pid.h>

c dimension program specific variables 

      integer StaCor, l_StaCor, ifmt_StaCor, ln_StaCor
      integer SmoothOrder

      real xaxis(2*SZLNHD), X(2*SZLNHD),Y(2*SZLNHD), Record(2*SZLNHD)

      character XgraphName*80, ReadOrder*2

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'SMOOTH'/
      data flatfile /.false./
      data TwoFlag /.false./
      data xgraph /.false./

c give command line help if requested 

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file 

#include <f77/open.h>

c get command line input parameters 

      call cmdln ( ntap, otap, ns, ne, irs, ire, SmoothOrder, flatfile, 
     :     nsi, TwoFlag, xgraph, ReadOrder, verbos )

c get logical unit numbers for input and output of seismic data/flat file 

      if ( .not. flatfile .and. 
     :     .not. xgraph .and.
     :     .not. TwoFlag ) then
         call getln(luin , ntap,'r', 0)
         call getln(luout, otap,'w', 1)
      else
         call vclr ( xaxis, 1, 2*SZLNHD)
         call vclr ( X, 1, 2*SZLNHD)
         call vclr ( Y, 1, 2*SZLNHD)
         call vclr ( Record, 1, 2*SZLNHD)
         luin = 5
         luout = 6
         lentap = lenth(ntap)
         leotap = lenth(otap)
         if ( ntap .ne. ' ' )
     :        open ( luin, file=ntap(1:lentap), status='old',err=990)
         if ( otap .ne. ' ' )
     :        open ( luout, file=otap(1:leotap), status='unknown',
     :        err=991)
      endif
       
c read line header of input save certain parameters

      IF ( .not. flatfile .and. 
     :     .not. xgraph .and.
     :     .not. TwoFlag ) then

         call rtape(luin,itr,lbytes)

         if(lbytes.eq.0)then
            write(LOT,*)'SMOOTH: no header read from unit ',luin
            write(LOT,*)'FATAL'
            stop
         endif

c build pointer to traceheader entry StaCor

         call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     :        TRACEHEADER)

c retrieve line header global variables

         call saver(itr, 'NumSmp', nsamp, LINHED)
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

         call hlhprt (itr, lbytes, name, 6, LERR)

c ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)

         call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output 

         nreco = ire - irs + 1
         call savew(itr, 'NumRec', nreco, LINHED)
         ntrco = ne - ns + 1
         call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes 

         obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header 

         call savhlh ( itr, lbytes, lbyout )
         call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

         call verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :        flatfile, TwoFlag, SmoothOrder, xgraph, ReadOrder )

c BEGIN PROCESSING SEISMIC DATA 

c skip unwanted records 

         call recskp(1,irs-1,luin,ntrc,itr)

c process desired trace records 

         DO JJ = irs, ire
 
c skip to start trace 

            call trcskp(JJ,1,ns-1,luin,ntrc,itr)
            ic = 0

            DO  KK = ns, ne

               nbytes = 0
               call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out 

               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif
               
               call vmov(itr(ITHWP1),1,tri(1),1,nsamp)
            
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )

c kill trace if dead 
               
               if (StaCor .eq. 30000) then
                  call vclr (tri,1,nsamp)
               else
c smooth trace if not dead
               
                  call SmoothFit ( tri, nsamp, SmoothOrder)
               endif

c output trace

               call vmov (tri, 1, itr(ITHWP1), 1, nsamp )
               call wrtape ( luout, itr, obytes )
 
            ENDDO
 
c skip to end of record 

            call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

         ENDDO

         goto 999

      ELSE

c handle flat file smoothing only ... forget about all the seismic
c stuff

         call verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :        flatfile, TwoFlag, SmoothOrder, xgraph, ReadOrder )

         DO WHILE ( 1 .eq. 1 )

            if ( ReadOrder .eq. 'xy' ) then
               call ReadNextFcn ( luin, X, Y, Record, N, TwoFlag, 
     :           EndFlag, xgraph, XgraphName )
            else
               call ReadNextFcn ( luin, Y, X, Record, N, TwoFlag, 
     :           EndFlag, xgraph, XgraphName )
            endif

            if ( EndFlag .and. flatfile ) goto 999
               call UniformFcn ( X, Y, N, nsi, xaxis, tri, nsamp )
               call SmoothFit (tri, nsamp, SmoothOrder )
               call ExtractFcn ( xaxis, tri, nsamp, X, Y, N )
               call OutputFcn ( luout, X, Y, Record, N, TwoFlag, Xgraph, 
     :              XgraphName )

            if ( EndFlag .and. TwoFlag .or. EndFlag .and. xgraph ) 
     :           goto 999
            
         ENDDO
      ENDIF

 990  continue
      write(LERR,*) 'SMOOTH: Error reading ', ntap(1:lentap)
      write(LER,*) 'SMOOTH: Error reading ', ntap(1:lentap)
      stop

 991  continue
      write(LERR,*) 'SMOOTH: Cannot open output flat file ', 
     :     otap(1:leotap)
      write(LER,*) 'SMOOTH: Cannot open output flat file ', 
     :     otap(1:leotap)
      stop

c close data files 

 999  continue

      if ( .not. flatfile .and. 
     :     .not. xgraph .and.
     :     .not. TwoFlag) then
         call lbclos ( luin )
         call lbclos ( luout )
         write(LERR,*)'SMOOTH: processed',nreco,' record(s)',
     :        ' with ',ntrc, ' traces'
         write(LER,*)'SMOOTH: processed',nreco,' record(s)',
     :        ' of ',ntrc, ' traces'
      else
         close ( luin )
         close ( luout )
         write(LERR,*)'Normal Termination'
         write(LER,*)'SMOOTH: Normal Termination'
      endif

      stop
      end
