C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do spatial 
c interpolation

#include <localsys.h>
#include <size_defs.h>

      subroutine spctrp (ntrc, ntrco, ntrcm, nsamp, bigar1,
     1                   tabl1, tabl2, tablh1, tablh2, itrhdr,
     2                   zz, iz, zzh, izh, cubic, iflag, icinit,
     3                   icinith, sii, sio, livtrc,
     4                   wsinc, nsinc, nover, nss,
     5                   ifmt_StaCor,l_StaCor,ln_StaCor)

#include <f77/iounit.h>

      real       bigar1(nsamp,ntrcm)
      integer*2  itrhdr(LNTRHD,ntrcm)
      real       zz(*), tabl1(*), tabl2(*), wsinc(nss)
      integer    iz(*), nsinc, nover
      integer    iwork (128,3)
      real       work1, work2, works
      integer    istat, jstat, idead
      pointer    (wkwork1, work1(1))
      pointer    (wkwork2, work2(1))
      pointer    (wkworks, works(1))
      pointer    (wkistat, istat(1))
      pointer    (wkjstat, jstat(1))
      pointer    (wkidead, idead(1))
      real       tablh1 (*), tablh2 (*), zzh(*)
      integer    izh (*)
      integer    errcd, errcdt, bytot, abort
      logical    cubic
      abort = 0

      ntrc1 = ntrc + 1
      nrat  = ntrco/ntrc
      nrat1 = nrat - 1
      nrat2 = 2 * nrat
      nrat3 = 3 * nrat
      nstt  = nover * nsinc
      nst   = nover * nsinc - nover ! nover=2,3,4,5
      ntrci = ntrc + 2*nsinc ! nover=2,3,4,5
      ntrcoo= ntrci * nover
      if (cubic) then
          nst   = 0
          nsinc = 1
          nover = 1
          ntrci = ntrc
          ntrcoo= ntrco
      endif

      item  = ( max (LNTRHD,ntrcoo+nstt) ) * SZSMPD
      itemh = max (LNTRHD,ntrcm+nst) * SZSMPD
      errcdt = 0
      bytot  = 0
      call galloc (wkwork1, item, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + item
      call galloc (wkwork2, item, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + item
      call galloc (wkworks, item, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + item
      call galloc (wkistat, itemh, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + itemh
      call galloc (wkjstat, itemh, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + itemh
      call galloc (wkidead, itemh, errcd, abort)
      errcdt = errcdt + errcd
      bytot  = bytot + itemh

      do  j = 1, ntrc
          idead(j) = 0
          amp = 0.
          do  i = 1, nsamp
              amp = abs (bigar1(i,j)) + amp
          enddo
          if (amp .eq. 0.0) idead(j) = 1
      enddo

      
c----
c   interpolate record
c----
      DO  100  i = 1, nsamp

          do  ii = 1, ntrcm+nst
              work1 (ii) = 0.0
              work2 (ii) = 0.0
          enddo

          do  1  j = 1, ntrc
              work1 (j+nsinc-1) = bigar1(i,j) ! nover=2,3,4,5
1         continue

          if (cubic) then
             call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrco,
     1                    iz, zz, icinit)
             icinit = 1
          else
          
             call oversampt (work1, ntrci, work2, ntrcoo, nover,
     1                       wsinc, nsinc, iflag)
          endif

          do  2  j = 1, ntrco
              bigar1(i,j) = work2(j+nst-(nover-1)) ! nover=2,3,4,5
2         continue

100   CONTINUE

c----
c   interpolate headers
c----

      IF (livtrc .eq. 1) THEN

          do  i = 1, LNTRHD
              istat(i) = itrhdr(i,1)
          enddo
          do  j = 1, nrat
              do  i = 1, LNTRHD
                  itrhdr(i,j) = istat(i)
              enddo
          enddo
          do  i = 1, LNTRHD
              istat(i) = itrhdr(i,nrat+1)
          enddo
          do  j = nrat+1, ntrco
              do  i = 1, LNTRHD
                  itrhdr(i,j) = istat(i)
              enddo
          enddo

      ELSEIF (livtrc .eq. 2) THEN

          do  j = 1, 2
              do  i = 1, LNTRHD
                  iwork(i,j) = itrhdr(i,j)
              enddo
          enddo
          do  i = 1, LNTRHD
              i1 = iwork(i,1)
              i2 = iwork(i,2)
              s  = float(i2 - i1) / float(nrat)
              do  j = 1, nrat2
                  ii = i1 + nint (s * float(j - nrat) )
                  itrhdr(i,j) = ii
              enddo
          enddo
          do  i = 1, LNTRHD
              istat(i) = itrhdr(i,nrat2+1)
          enddo
          do  j = nrat2+1, ntrco
              do  i = 1, LNTRHD
                  itrhdr(i,j) = istat(i)
              enddo
          enddo

      ELSEIF (livtrc .eq. 3) THEN

          do  j = 1, 3
              do  i = 1, LNTRHD
                  iwork(i,j) = itrhdr(i,j)
              enddo
          enddo
          do  i = 1, LNTRHD
              i1 = iwork(i,1)
              i2 = iwork(i,2)
              s  = float(i2 - i1) / float(nrat)
              do  j = 1, nrat2
                  ii = i1 + nint (s * float(j - nrat) )
                  itrhdr(i,j) = ii
              enddo
          enddo
          do  i = 1, LNTRHD
              i2 = iwork(i,2)
              i3 = iwork(i,3)
              s  = float(i3 - i2) / float(nrat)
              do  j = 1, nrat
                  ii = i2 + nint (s * float(j) )
                  itrhdr(i,nrat2+j) = ii
              enddo
          enddo
          do  i = 1, LNTRHD
              istat(i) = itrhdr(i,nrat3+1)
          enddo
          do  j = nrat3+1, ntrco
              do  i = 1, LNTRHD
                  itrhdr(i,j) = istat(i)
              enddo
          enddo

      ELSE
  
          do  j = 1, ntrc
              istat(j) = itrhdr(l_StaCor,j)
          enddo
          do  j = 1, ntrco
              jstat(j) = 0
          enddo

          DO  200  i = 1, LNTRHD

              is = 0
              ir = 0
              io = 0

              do  ii = 1, ntrcm
                  work1 (ii) = 0.0
                  work2 (ii) = 0.0
                  works (ii) = 0.0
              enddo

              do  5  j = 1, ntrc

                  wrk      = float( itrhdr(i,j))
                  io = io + 1
                  if (istat(j) .ne. 30000) then
                     ir = ir + 1
                     work1 (ir) = wrk + sign(.1, wrk)
                     tablh1(ir) = sii * float(j)
                  else
                     is = is + 1
                     works (is) = wrk
                  endif

5             continue
              ntrci = ir

              call fcuint (tablh1,work1,ntrci,tablh2,work2,ntrco,
     1                     izh, zzh, icinith)
              icinith = 0

              ir = 0
              is = 0
              io = 1
              do  6  j = 1, ntrco

                  ist = istat(io)
 
                  if     (mod (j,nrat).eq.0 .AND. ist.ne.30000) then
 
                     ir = ir + 1
                     io = io + 1
                     work2(j) = work1(ir)
 
                  elseif (mod (j,nrat).eq.0 .AND. ist.eq.30000) then
 
                     is = is + 1
                     io = io + 1
                     work2(j) = works(is)
 
                  endif
 
                  itrhdr(i,j) = work2(j)

6             continue

200       CONTINUE

c----
c   fix up first nrat interpolated traces
c----
          DO  300  i = 1, LNTRHD

              IF (i .ne. l_StaCor) THEN

                 do  10  j = nrat, ntrco

                     ist1 = itrhdr(l_StaCor,j)
                     ist2 = itrhdr(l_StaCor,j+1)

                     if (ist1.ne.30000 .AND. ist2.ne.30000) then
                        s = itrhdr(i,j) - itrhdr(i,j+1)
                        go to 11
                     endif
10              continue
11          continue

            do  12  j = 1, nrat1
                itrhdr(i,j) = itrhdr(i,j) + s * (nrat-j)
12          continue

         ENDIF

300   CONTINUE

c----
c   if we have several leading dead traces we could run into 
c   interpolation troubles
c----
      isoff = 0
      do  j = ntrc, 1, -1
          ist = istat(j)
          if (ist .ne. 30000) go to 310
          isoff = isoff + 1
      enddo
310   continue
      if (isoff .gt. 0) then
         do  j = 1, isoff*nrat
             jj = ntrco - j + 1
             itrhdr (l_StaCor, jj) = 30000
         enddo
      endif

c----
c   if we have several trailing dead traces we could run into 
c   interpolation troubles
c----
      isoff = 0
      do  j = 1, ntrc
          ist = istat(j)
          if (ist .ne. 30000) go to 320
          isoff = isoff + 1
      enddo
320   continue
      if (isoff .gt. 0) then
         do  j = 1, isoff*nrat
             itrhdr (l_StaCor, j) = 30000
         enddo
      endif
             
      ENDIF

      do  j = 1, ntrc
          if (idead(j) .eq. 1) then
             jj = (j-1)*nrat + nover
             do  jjj = jj-nrat1, jj+nrat1
                 if (jjj .ge. 1 .AND. jjj .le. ntrco) then
                    call vclr (bigar1(1,jjj), 1, nsamp)
                    call savew2(itrhdr(1,jjj),ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000 , 1)
                 endif
             enddo
          endif
      enddo

      call gfree (wkwork1)
      call gfree (wkwork2)
      call gfree (wkworks)
      call gfree (wkistat)
      call gfree (wkjstat)
      call gfree (wkidead)

      return
      end
