C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE BLDRMP ( ISI, PRINTR )

***********************************************************************
*                                                                     *
*  NAME    : BUILD RAMP                       ENTRYS: RZEROS  IZEROS  *
*  AUTHOR  : DAVID LEWIS                              RSTORE          *
*  DATE    : 07/10/86                                                 *
*                                                                     *
*  PURPOSE : SUBROUTINE BLDRMP WILL BUILD A 48MS RAMP TO BE           *
*            USED FOR SMOOTHING THE FRONT OF A TRACE.                 *
*                                                                     *
*  INPUT   : ISI    - INTEGER * 4 SAMPLE INTERVAL GIVEN IN MS.        *
*            PRINTR - INTEGER * 4 PRINTER UNIT NUMBER.                *
*                                                                     *
*  PASSED  : RMPFLG - LOGICAL * 4 FLAG USED BY "RSTORE" ROUTINE.      *
*            RAMP   - REAL * 4 RAMP ARRAY USED BY "RSTORE" ROUTINE.   *
*            RMPLEN - INTEGER * 4 RAMP LENGTH USED BY "RSTORE" .      *
*                                                                     *
*  INTERNAL VARIABLES:                                                *
*           RAMP   - REAL * 4 RAMP ARRAY CONTAINING THE RAMP VALUES.  *
*           RMPLEN - INTEGER * 4 VALUE FOR RAMP LENGTH.               *
*           RMPDIM - INTEGER * 4 VALUE FOR RAMP DIMENSION OF 48.      *
*           RMPFLG - LOGICAL * 4 RAMP FLAG INDICATES "BLDRMP" INVOKED *
*                                                                     *
***********************************************************************
*
*                       ----------------------------
*                       |       DECLARATIONS       |
*                       ----------------------------
      REAL         RTRACE ( 1 )
     *            ,RAMP   ( 48 )
*
      INTEGER      RMPLEN
     *            ,RMPDIM
     *            ,PRINTR
     *            ,TRALEN
c
c  set up a local variable to hold TRALEN - j.m. wade
c
      integer ltrlen
 
      LOGICAL*4    RMPFLG
 
      INTEGER*2 ITRACE (1)
 
      DATA       RMPDIM / 48 /
     *          ,RMPFLG /.FALSE. /

      SAVE rmpdim,rmpflg,ltrlen,rmplen,ramp
*
*                    -------------------------------
*                    | CHECK SAMPLE INTERVAL RANGE |
*                    -------------------------------
      IF ( ISI .EQ. 1  .OR.
     *     ISI .EQ. 2  .OR.
     *     ISI .EQ. 3  .OR.
     *     ISI .EQ. 4  .OR.
     *     ISI .EQ. 6  .OR.
     *     ISI .EQ. 8  .OR.
     *     ISI .EQ. 12 .OR.
     *     ISI .EQ. 16)         GO TO 10
*
*
*                     --------------------------------
*                     | PRINT ERROR MESSAGE AND EXIT |
*                     --------------------------------
*
*
      WRITE (PRINTR,1) ISI
    1 FORMAT('0','** M0001 **  ERROR DETECTED BY SUBROUTINE BLDRMP',/,
     *T14,' THE SAMPLE INTERVAL "',I4,'" IS INVALID.    THE SAMPLE IN',
     *    'TERVAL MUST BE 1,2,3,4,6,8,12, OR 16 .')
      CALL CCEXIT(100)
*
*
*                       ---------------------------
*                       |  CALCULATE RAMP LENGTH  |
*                       ---------------------------
*
   10 RMPLEN = RMPDIM / ISI
*
*
*                       ----------------------------
*                       | CALCULATE RAMP INCREMENT |
*                       ----------------------------
*
      XRAMP = 1.0 / FLOAT (RMPLEN)
*
*
*                       ----------------------------
*                       |   INITIALIZE RAMP ARRAY  |
*                       ----------------------------
*
      DO 20 I = 1, RMPLEN
         RAMP ( I ) = I * XRAMP
   20 CONTINUE
*
*
*             --------------------------------------------------
*             | INDICATE "BLDRMP" WAS INVOKED BY SETTING FLAG. |
*             --------------------------------------------------
*
      RMPFLG = .TRUE.
      RETURN
*
*
      ENTRY IZEROS ( ITRACE, TRALEN, LZEROS )
***********************************************************************
*                                                                     *
*  NAME    : INTEGER ZEROS                                            *
*                                                                     *
*  PURPOSE : IZEROS WILL COUNT THE NUMBER OF LEADING ZEROS IN         *
*            A I*2 TRACE FOR PRESERVING THE EARLY MUTE .              *
*                                                                     *
*  INPUT   : ITRACE - I*2 ARRAY HOLDING THE TRACE DATA.               *
*          : TRALEN - I*4 VALUE SPECIFYING THE TRACE LENGTH.          *
*                                                                     *
*  OUTPUT  : LZEROS - I*4 NUMBER OF LEADING ZEROES                    *
*                                                                     *
***********************************************************************
*         ---------------------------------------------------------
*         |  COUNT THE NUMBER OF ZEROS AT THE FRONT OF THE TRACE. |
*         ---------------------------------------------------------
      ltrlen = tralen
      LZEROS = 0
      DO 90 I = 1, TRALEN
         IF ( ITRACE ( I ) .NE. 0 ) RETURN
         LZEROS = LZEROS + 1
   90 CONTINUE
*          ------------------------
*          |  TRACE IS ALL ZEROS  |
*          ------------------------
      RETURN
*
*
*
      ENTRY RSTORE ( RTRACE, PRINTR, ICOUNT )
*
***********************************************************************
*                                                                     *
*    NAME   : RESTORE                                                 *
*                                                                     *
*    PURPOSE: THIS SUBROUTINE IS CALLED TO RESTORE AN EARLY MUTE OF   *
*             ZEROS FOR A SEISMIC TRACE AND THEN SMOOTH THE TRACE     *
*             WITH A RAMP FUNCTION.                                   *
*                                                                     *
*    INPUT  : RTRACE -  REAL ARRAY HOLDING THE TRACE DATA.            *
*             PRINTR -  INTEGER PRINTER UNIT NUMBER.                  *
*             ICOUNT -  INTEGER VALUE SPECIFYING THE COUNT            *
*                       OF ZEROS TO BE PLACED IN FRONT OF THE TRACE.  *
*             RAMP   -  REAL ARRAY HOLDING THE RAMP FUNCTION.         *
*                       SUPPLIED BY "BLDRMP" ROUTINE.                 *
*             RMPLEN -  INTEGER VALUE SPECIFYING THE RAMP             *
*                       LENGTH IN SAMPLES.  SUPPLIED BY "BLDRMP" PGM. *
*             RMPFLG -  LOG*4 FLAG USED TO VERIFY BLDRMP WAS INVOKED. *
*                       SUPPLIED BY "BLDRMP" ROUTINE.                 *
*                                                                     *
*    OUTPUT : RTRACE -  REAL ARRAY HOLDING RESORTED TRACE DATA.       *
*                                                                     *
***********************************************************************
*      ---------------------------------------------------------
*      |  VERIFY THAT THE "BLDRMP"  ROUTINE WAS INVOKED        |
*      |  PRIOR TO APPLYING THE RAMP FUNCTION.                 |
*      ---------------------------------------------------------
      IF ( .NOT. RMPFLG ) THEN
         WRITE (PRINTR,21)
   21    FORMAT(
     *   '0','** M0021 **  ERROR DETECTED BY SUBROUTINE RSTORE',/,T14
     *   ,' SUBROUTINE "BLDRMP" MUST BE CALLED AT LEAST ONCE BEFORE',
     *    ' INVOKING SUBROUTINE "RSTORE".')
         CALL CCEXIT (100)
      ENDIF
*      ---------------------------------------------------------
*      | RESTORE THE ZEROS AT THE FRONT OF THE TRACE IF ZEROS  |
*      | WERE FOUND.  IF NOT THEN DONT RESTORE OR APPLY RAMP.  |
*      ---------------------------------------------------------
*
      IF ( ICOUNT .NE. 0 )  THEN
*
         CALL VMOV ( 0.0, 0, RTRACE, 1, ICOUNT )
*                 -----------------------------------
*                 | MUTLIPLY THE RAMP BY THE TRACE. |
*                 -----------------------------------
*
* --- RESET THE RAMP LENGTH IF NECESSARY.
         LENGTH = RMPLEN
c        IF (ICOUNT + RMPLEN  .GT.  TRALEN)   LENGTH = TRALEN - ICOUNT
         IF (ICOUNT + RMPLEN  .GT.  ltrlen)   LENGTH = ltrlen - ICOUNT
*
         DO 50 I = 1, LENGTH
            J            = ICOUNT + I
            RTRACE ( J ) = RTRACE ( J ) * RAMP ( I )
   50    CONTINUE
*
      ENDIF
      RETURN
*
*
      ENTRY RZEROS ( RTRACE, TRALEN, LZEROS )
***********************************************************************
*                                                                     *
*  NAME    : REAL ZEROS                                               *
*                                                                     *
*  PURPOSE : RZEROS WILL COUNT THE NUMBER OF LEADING ZEROS IN         *
*            A R*4 TRACE FOR PRESERVING THE EARLY MUTE .              *
*                                                                     *
*  INPUT   : RTRACE - R*4 ARRAY HOLDING THE TRACE DATA.               *
*            TRALEN - I*4 VALUE SPECIFYING THE TRACE LENGTH.          *
*            LZEROS - I*4 NUMBER OF LEADING ZEROES                    *
*                                                                     *
***********************************************************************
*         ---------------------------------------------------------
*         |  COUNT THE NUMBER OF ZEROS AT THE FRONT OF THE TRACE. |
*         ---------------------------------------------------------
      LZEROS = 0
      ltrlen = tralen
      DO 70 I = 1, TRALEN
         IF ( RTRACE ( I ) .NE. 0.0 ) RETURN
         LZEROS = LZEROS + 1
   70 CONTINUE
*         ------------------------
*         |  TRACE IS ALL ZEROS  |
*         ------------------------
      RETURN
      END
