C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - SPBL   LEVEL - CA                  ENTRY .MAIN      * C
C *   LANGUAGE - FORTRAN                                             * C
C *   AUTHOR - R. CRIDER                                             * C
C *   DATE WRITTEN - 5/82                                            * C
C *   MODIFICATION HISTORY - 01/24/83                                * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *                                                                  * C
C *     SPECTRAL BALANCING IN THE FREQUENCY DOMAIN. THE BASIC        * C
C *     EQUATION IS                                                  * C
C *             G(W) = (F(W)/|F(W)|)*A(W)                            * C
C *       WHERE    G(W) = OUTPUT DATA,                               * C
C *                F(W) = INPUT DATA,                                * C
C *              |F(W)| = INPUT AMPLITUDE SPECTRUM,                  * C
C *                A(W) = MEAN AMPLITUDE SPECTRUM OF DATA,           * C
C *          AND     W  = FREQUENCY.                                 * C
C *                                                                  * C
C *     SPECTRAL AVERAGING MAY BE EITHER GEOMETRIC OR ARITHMETIC.    * C
C *     USING J. CLAEBOUT'S ROUTINES (SEP, APRIL,1975).              * C
C *                                                                  * C
C *   INTERNAL SUBROUTINES -                                         * C
C *     RTAPHD    WTAPHD   READCD     TRIN       TROUT               * C
C *     POWER2    OPENAC   BLDCHN     DISCOR     ERRSUB              * C
C *                                                                  * C
C *   UTILITY SUBROUTINES CALLED -                                   * C
C *     RTAPE     MOVE     GAMOVR     ITOFP                          * C
C *     WRCARD   LBOPEN    CCEXI       HLH                           * C
C *     WRTAPE                                                       * C
C *     BLDRMP   RZEROS    RSTORE     RIPRNT                         * C
C *                                                                  * C
C ******************************************************************** C
#include <save_defs.h>
c#include <f77/hdrsize.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
c	parameter (KDIM = 4000 + ITRWRD)
      INTEGER ERRCNT
 	INTEGER INPUT(4064)
c	INTEGER INPUT(KDIM)
      CHARACTER*1 LABEL(18),RELBL(66)
      character ntap*256, otap*256, cardin*256
      character name*4
      character*8 iparm1,iparm2
      logical query
      integer argis
      real work1,work2,work3
      real holdb
      pointer (phb, holdb(1))
      DIMENSION TA(8204),SUM(4097), OPRATR(8204)
      COMMON /PPARM/IPARM1,IPARM2
      common /fftp/n2
      common /work/work1(8204), work2(8204), work3(8204)
      common /header/ldh(9000), NIT,NRCD
      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm


      DATA ICR/5/,LUI/3/,LUO/8/
      DATA LABEL/'S','P','E','C','T','R','A','L',' ','B','A',
     *'L','A','N','C','I','N','G'/
      DATA ERRCNT/0/,IC/0/
      DATA ITRKNT/0/,JSTAK/0/
      DATA name/'SPBL'/
C *------------------------------------------------------------------* C
C *   SET UP TITLE FOR AND DO THE TORCH 'N OVAL THING.               * C
C *------------------------------------------------------------------* C
      do 700 i=1,66
        relbl(i) = ' '
  700 continue
      do 701 i=24,41
        relbl(i)=label(i)
  701 continue
      query = ((argis('-?').gt.0).or.(argis('-H').gt.0))
      if(query)then
        call help()
        call ccexit(0)
      endif
C *------------------------------------------------------------------* C
C *   Get the command line input                                     *
C *------------------------------------------------------------------* C
*  call gcmdln(ntap, otap, cardin, verbos, icr)
      call gcmdln(ntap, otap, cardin, icr,
     * iws, iwe, ntp,iadd,v1,v2,ivflg,iopt,idecon,ifrs,lrcd)
#include <f77/open.h>
      IPR = LERR
      CALL GAMOCO(RELBL,1,IPR)
C *------------------------------------------------------------------* C
C *   OPEN THE TAPE UNITS.                                           * C
C *------------------------------------------------------------------* C
*     CALL LBOPEN(LUI,LUO)
C *------------------------------------------------------------------* C
C *  If ntap specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntap.ne.' ')then
        call lbopen(lui, ntap, 'r')
      else
        lui = 0
      endif
       if (lui .lt. 0) then
         write (LERR,*) 'Could not open input ',ntap
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If otap specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otap.ne.' ')then
        call lbopen(luo, otap, 'w')
      else
        luo = 1
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

C *------------------------------------------------------------------* C
C *     READ THE INPUT LINE HEADER.                                  * C
C *------------------------------------------------------------------* C
      CALL RTAPHD(LUI, IPR, NS, NSR, ITRCLN,
     *            NTRCD,  IFMT, ERRCNT, IC, IOPT,idecon,ifrs,
     *            ITRWRD,ITHWP1,SZLNHD,ISZBYT)
C ******************************************************************** C
C *                                                                  * C
C *  READ THE DATA CARD.                                             * C
C *                                                                  * C
C ******************************************************************** C
      CALL READCD(ICR, IPR,  IWS, IWE, NTP, IADD, V1, V2,
     *            IVFLG, IOPT, IOFMT, LRCD, IFMT, ITRCLN, NTRCD,
     *            JSTAK, ERRCNT, IC, LUO, idecon,ifrs)
C  allocate the memory space required
      ierror = 0
      iabort = 0
      iget = (ns+ITRWRD) * ntp * ISZBYT
      call galloc(phb,iget,ierror,iabort)
      if(ierror.ne.0)then
         write(LERR,*)'  Unable to allocate space for ',ntp,' traces'
         call ccexit(100)
      endif
      IF (ERRCNT.ne.0) then
 1099 WRITE(LERR,1100)ERRCNT
 1100 FORMAT(///,20X,'***********  SPBL ABORTED DUE TO ',I5,' ERRORS',
     *' ************')
      IC=100
      GO TO 9999
      endif
  300 CONTINUE
C *------------------------------------------------------------------* C
C *   CALL TRIN TO READ IN THE TRACES, WRITE TO DISK,                * C
C *   AND COMPUTE THE AMPLITUDE SPECTRUM.                            * C
C *------------------------------------------------------------------* C
  303 continue
      CALL TRIN (LUI, IPR,  SUM, TA,XN, NS, NSR, ITRKNT, ITRCLN,
     *           LREC, IOPT, NTP,LRCD, IFMT, JSTAK, IADD, IWS, IWE,
     *           V1, V2,IVFLG, KNT, IPASS, IDEAD, IEND, IC, OPRATR,
     *           holdb,ifrs, LUO, INPUT, NIT, ITRWRD, ITHWP1, SZLNHD,
     *           ISZBYT)
C
      IF (IC .NE. 0) GO TO 9999
C ******************************************************************** C
C *                                                                  * C
C *   SECTION 4. OUTPUT AREA.                                        * C
C *                                                                  * C
C ******************************************************************** C
  500 CONTINUE
C *------------------------------------------------------------------* C
C *   THE COUNTER MUST BE GE NTP, EXCEPT FOR THE LAST TIME THROUGH.  * C
C *------------------------------------------------------------------* C
      IF(KNT.GE.NTP)GO TO 501
      IF(IPASS.GT.0)GO TO 501
      CALL ERRSUB(IPR,9)
      IC=100
      GO TO 9999
  501 CONTINUE
c     IF(KNT.LE.0)GO TO 9998
	if(KNT .GT. 0) go to 502
	   if(NIT .eq. 0) go to 9998
9995	   call wrtape(LUO, INPUT, NIT)
           nit = 0
           call RTAPE(LUI,INPUT,nit)
           if(nit.eq.0) go to 9998
            go to 9995
C
C        CALCULATE THE SCALE FACTOR FOR COMPUTING THE OPERATOR
C
  502 XN = KNT - IDEAD
      IF (XN .GT. 0.0) XN = 1. / XN
C
C        CALL THE ROUTINE TO BUILD THE OPERATOR
C
      if(xn.ne.0.0) then
         CALL DOIT2(N2,SUM,IOPT, XN,OPRATR,WORK1,WORK2,WORK3)
      endif
C
C *------------------------------------------------------------------* C
C *   CALL TROUT TO FINISH PROCESSING THE TRACES AND                 * C
C *   OUTPUT THEM.                                                   * C
C *------------------------------------------------------------------* C
      CALL TROUT (LUO, IPR, SUM, TA, XN,
     *  NS, NSR, NTP, NTRCD, IOFMT, JSTAK,
     *  IADD, IWS, IWE, V1, V2, IVFLG, KNT,
     *     IOPT,  IPASS, IDEAD, IEND, IC, OPRATR, ITRCLN,holdb,
     *     idecon,ITRWRD, ITHWP1, SZLNHD,
     *           ISZBYT)
C
c     IF(IEND.EQ.1)GO TO 9998
	if(iend .eq. 1) then
		if(lrcd .eq. 99999) then
9997		   nit = 0
		   call RTAPE(LUI,work1,nit)
		   if(nit.eq.0) go to 9998
		   call wrtape(LUO,work1,nit)
		   go to 9997
		endif
	   go to 9998
	endif
      IF(LREC.LE.LRCD)GO TO 303
9996               nit = 0
                   call RTAPE(LUI,work1,nit)
                   if(nit.eq.0) go to 9998
                   call wrtape(LUO,work1,nit)
                   go to 9996
 
C *------------------------------------------------------------------* C
C *  CALL THE RECORDS PROCESSED ROUTINE FOR THE LAST TIME.           * C
C *------------------------------------------------------------------* C
 9998 IC=0
 9999 CONTINUE
      CALL RICLR (IPR)
C *------------------------------------------------------------------* C
C *  CLOSE THE TAPE UNITS.
C *------------------------------------------------------------------* C
      CALL LBCLOS(LUI)
      CALL LBCLOS(LUO)
C *------------------------------------------------------------------* C
C *  FINISH THE ACCOUNTING.
C *------------------------------------------------------------------* C
      IF(NTRCD.NE.0)ITRKNT=ITRKNT/NTRCD
      CALL CCEXIT(IC)
      STOP
      END
      SUBROUTINE RTAPHD(LUI, IPR, NS, NSR, ITRCLN,
     *                  NTRCD,  IFMT, ERRCNT, IC, IOPT,
     *                  idecon,ifrs,
     *                  ITRWRD,ITHWP1,SZLNHD,SZSMPD)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - RTAPHD                                              * C
C *   ENTRY    - WTAPHD                                              * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST, 1982                                    * C
C *   REVISION - APRIL, 1983 - JACQUIE VINSON                        * C
C *              CREATED SUBROUTINE FROM IN-LINE CODE                * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE READS AND UPDATES THE LINE HEADER AND          * C
C *      EXTRACTS INFORMATION NECESSARY FOR PROCESSING.              * C
C *      THE ENTRY WILL WRITE OUT THE UPDATED LINE HEADER.           * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL RTAPHD(LUI, IPR,                 NS, NSR, ITRCLN,         * C
C *               NTRCD,  IFMT, ERRCNT, IC)                          * C
C *                                                                  * C
C *   LUI    - LOGICAL UNIT OF INPUT TAPE                            * C
C *   IPR    - LOGICAL UNIT OF PRINTER                               * C
C *   NS     - NUMBER OF SAMPLES PER TRACE                           * C
C *   NSR    - SAMPLE INTERVAL                                       * C
C *   ITRCLN - TRACE LENGTH IN MS.                                   * C
C *   NRCD   - NUMBER OF RECORDS                                     * C
C *   NTRCD  - NUMBER OF TRACES PER RECORD                           * C
C *   IFMT   - FORMAT CODE                                           * C
C *   ERRCNT - ERROR COUNT                                           * C
C *   IC     - RETURN CODE                                           * C
C *                                                                  * C
C ******************************************************************** C
c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      INTEGER LHD, NIT,NRCD
      INTEGER ERRCNT
      character*8 iparm1,iparm2
      character modhlh*35
      character title*4
      COMMON /PPARM/IPARM1,IPARM2
      common /header/lhd(9000), NIT,NRCD
      DATA TITLE/'SPBL'/
      SAVE
C
C *------------------------------------------------------------------* C
C *     READ THE INPUT LINE HEADER.                                  * C
C *------------------------------------------------------------------* C
      CALL STRCLR(MODHLH,35)
      NIT=0
      CALL RTAPE(LUI,LHD,NIT)
      IF(NIT.EQ.0)THEN
        CALL ERRSUB(IPR,1)
        ERRCNT=ERRCNT+1
        IC=100
        RETURN
      ENDIF
C *------------------------------------------------------------------* C
C *   GET THE NUMBER OF SAMPLES FROM THE LINE HEADER AND             * C
C *   CHECK FOR LESS THAN OR EQUAL TO 4000.                          * C
C *------------------------------------------------------------------* C
*     NS=LHD(16)
      CALL saver(LHD,'NumSmp',NS,LINHED)
      IF(NS.GT.4000)THEN
       write(iparm1,'(i8)')ns
       CALL ERRSUB(IPR,2)
       ERRCNT=ERRCNT+1
       IC=100
      ENDIF
C *------------------------------------------------------------------* C
C *     COMPUTE THE OUTPUT TRACE LENGTH.                             * C
C *------------------------------------------------------------------* C
      NS2=NS+NS
C *     FORMAT 1 OUTPUT LENGTH (BYTES).                              * C
      NS4=NS2+NS2
      ns4 = ns*ISZBYT
C *     FORMAT 3 OUTPUT LENGTH (BYTES).                              * C
C *     GET THE SAMPLE INTERVAL.                                     * C
      CALL saver(LHD,'SmpInt',NSR,LINHED)
      ITRCLN=(NS-1)*NSR
      SR=NSR
C *     GET THE NUMBER OF RECORDS IN THE JOB.                        * C
      CALL saver(LHD,'NumRec',NRCD,LINHED)
C *------------------------------------------------------------------* C
C *   GET THE NUMBER OF TRACES PER RECORD. A MAXIMUM OF 2048            * C
C *   IS ALLOWED.                                                    * C
C *------------------------------------------------------------------* C
      CALL saver(LHD,'NumTrc',NTRCD,LINHED)
      IF(NTRCD.gt.2048)then
        write(iparm1,'(i8)')ntrcd
        CALL ERRSUB(IPR,3)
        ERRCNT=ERRCNT+1
        IC=100
      ENDIF
C *                                                                  * C
C *------------------------------------------------------------------* C
C *   GET THE FORMAT CODE FOR INPUT. IT MUST BE 1 ,3, OR 5.          * C
C *------------------------------------------------------------------* C
      CALL saver(LHD,'Format',IFMT,LINHED)
      IF(IFMT.NE.3)THEN
        write(iparm1,'(i8)')ifmt
        CALL ERRSUB(IPR,4)
        ERRCNT=ERRCNT+1
        IC=100
      ENDIF
C *                                                                  * C
C *------------------------------------------------------------------* C
C *   INITIATE THE ACCOUNTING.                                       * C
C *------------------------------------------------------------------* C
       IFOUR = 4
      CALL HLHPRT(LHD,NIT,title,IFOUR,LERR)
C *------------------------------------------------------------------* C
C *   CHECKS ON MODE NO LONGER NECESSARY                             * C
C *------------------------------------------------------------------* C
C
  200 RETURN
      end
      SUBROUTINE WTAPHD (LUO, IOPT, NTP, IWS, IWE, IADD, IOFMT, LRCD,
     *ERRCNT,idecon, ifrs)
C ******************************************************************** C
C *                                                                  * C
C *                                                                  * C
C *   CALL WTAPHD (LUO, IOPT, NTP, IWS, IWE, IADD, IOFMT, LRCD)      * C
C *                                                                  * C
C *   LUO    - LOGICAL UNIT OF OUTPUT TAPE                           * C
C *   IOPT   - AVERAGING FLAG                                        * C
C *   NTP    - NUMBER OF TRACE TO PROCESS                            * C
C *   IWS    - WINDOW START TIME (MS)                                * C
C *   IWE    - WINDOW END TIME (MS)                                  * C
C *   IADD   - DROP ONE - ADD ONE FLAG                               * C
C *   IOFMT  - OUTPUT FORMAT CODE                                    * C
C *   LRCD   - LAST RECORD TO PROCESS                                * C
C *                                                                  * C
C ******************************************************************** C
#include <localsys.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      character modhlh*35
      integer lhd
      common /header/lhd(9000), NIT,NRCD
C
C *------------------------------------------------------------------* C
C *  WRITE THE LINE HEADER AFTER SETTING THE FORMAT CODE AND         * C
C *  COMPLETING THE HLH UPDATE.                                      * C
C *------------------------------------------------------------------* C
      IFOUR=24
      IF(IOPT.EQ.0)WRITE(modhlh,600)NTP
  600 FORMAT(' ',I3,' TR GEOMETRIC MEAN  ')
      IF(IOPT.EQ.1)WRITE(modhlh,601)NTP
  601 FORMAT(' ',I3,' TR ARITHMETIC MEAN ')
      CALL HLHPRT(LHD,NIT,MODHLH,IFOUR,LERR)
      CALL STRCLR(MODHLH,35)
      WRITE(modhlh,602)IWS,IWE
  602 FORMAT(1X,' WINDOW ',I5,' - ',I5,' MS')
      ifour = 25
      CALL HLHPRT(LHD,NIT,MODHLH,IFOUR,LERR)
  225 CONTINUE
      IF(IADD.NE.0)THEN
      CALL STRCLR(MODHLH,35)
      WRITE(modhlh,609)
      ifour = 27
  609 FORMAT(1X,' ADD ONE - DROP ONE OPTION ')
      CALL HLHPRT(LHD,NIT,MODHLH,IFOUR,LERR)
      endif
* 228 CONTINUE
      call savew(LHD,'Format',IOFMT,LINHED)
c     nr = lrcd - ifrs + 1
c     IF(nr.LT.NRCD)then
c     print *,'setting NumRec in lh=',nr
c     print *,'nrcd=',NRCD
c        call savew(LHD,'NumRec', nr, LINHED)
c     endif
	if(ifrs .eq. 0) ifrs = 1
	if(lrcd .eq. 0) lrcd = 99999
      iby = nit
      call savhlh(lhd,iby,nit)
      IF(ERRCNT.EQ.0)CALL WRTAPE(LUO,LHD,NIT)
C *------------------------------------------------------------------* C
C *  SET LAST RECORD TO PROCESS IF IT WAS DEFAULTED.                 * C
C *------------------------------------------------------------------* C
      IF (LRCD.EQ.0) LRCD = 32767
      RETURN
      END
      SUBROUTINE READCD(ICR, IPR,  IWS, IWE, NTP, IADD, V1, V2,
     *                  IVFLG, IOPT, IOFMT, LRCD, IFMT, ITRCLN, NTRCD,
     *                  JSTAK, ERRCNT, IC, LUO, idecon,ifrs)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - READCD                                              * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST, 1982                                    * C
C *   REVISION - APRIL, 1983 - JACQUIE VINSON                        * C
C *              CREATED SUBROUTINE FROM IN-LINE CODE                * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE READS THE INPUT DATA CARD, THEN VERIFIES       * C
C *      AND DEFAULTS THE CARD PARAMETERS.                           * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL READCD(ICR, IPR,  IWS, IWE, NTP, IADD, V1, V2,            * C
C *               IVFLG, IOPT, IOFMT, LRCD, IFMT, ITRCLN, NTRCD,     * C
C *               JSTAK, ERRCNT, IC , idecon)                        * C
C *                                                                  * C
C *   ICR    - LOGICAL UNIT OF CARD READER                           * C
C *   IPR    - LOGICAL UNIT OF PRINTER                               * C
C *   IWS    - WINDOW START TIME (MS)                                * C
C *   IWE    - WINDOW END TIME (MS)                                  * C
C *   NTP    - NUMBER OF TRACE TO PROCESS                            * C
C *   IADD   - DROP ONE - ADD ONE FLAG                               * C
C *   V1     - ADJUSTMENT VELOCITY - WINDOW START                    * C
C *   V2     - ADJUSTMENT VELOCITY - WINDOW END                      * C
C *   IVFLG  - ADJUSTMENT TYPE                                       * C
C *   IOPT   - AVERAGING FLAG                                        * C
C *   IOFMT  - OUTPUT FORMAT CODE                                    * C
C *   LRCD   - LAST RECORD TO PROCESS                                * C
C *   ITRCLN - TRACE LENGTH IN MS.                                   * C
C *   NTRCD  - NUMBER OF TRACES PER RECORD                           * C
C *   JSTAK  - STACKED DATA FLAG                                     * C
C *   ERRCNT - ERROR COUNT                                           * C
C *   IC     - RETURN CODE                                           * C
C *   IDECON - DECONVOLUTION OPTION                                  * C
C *            0 = NO                                                * C
C *            1 = YES                                               * C
C *                                                                  * C
C ******************************************************************** C
      INTEGER ERRCNT
      CHARACTER CARD*80, CARDID*5
      character*8 iparm1,iparm2
      COMMON /PPARM/IPARM1,IPARM2
      DATA CARDID/'1SPBL'/
      SAVE
      IER11 = 0
      IER12 = 0
      IER13 = 0
      IER14 = 0
C *------------------------------------------------------------------* C
C *   READ THE CARD ID, THE JOB NUMBER, AND THE FULL CARD.           * C
C *------------------------------------------------------------------* C
 1000 FORMAT(A80)
      if(icr.gt.0)then
        READ(ICR,1000,END=9997)CARD
C *------------------------------------------------------------------* C
C *  CHECK THE CARD ID TO BE "1SPBL".                                * C
C *------------------------------------------------------------------* C
        IF(CARD(1:5).NE.CARDID)THEN
         IPARM1=CARD(1:5)
         IPARM2=CARDID
         CALL ERRSUB(IPR,5)
         ERRCNT=ERRCNT+1
        ENDIF
        IF (ERRCNT .NE. 0) GO TO 9998
C ******************************************************************** C
C *  READ THE PARAMETERS FROM THE JOB CARD.                          * C
C *  THE PARAMETERS ARE:                                             * C
C *                                                                  * C
C *   IWS   - WINDOW START TIME (MS)                                 * C
C *           DEFAULT - 0                                            * C
C *   IWE   - WINDOW END TIME (MS)                                   * C
C *           DEFAULT - END OF TRACE                                 * C
C *   NTP   - NUMBER OF TRACES TO PROCESS (BALANCE) IF DATA STACKED. * C
C *           IF DATA NOT STACKED, NTP=NTRCD.                        * C
C *   IADD  - ADD ON - DROP ONE FLAG.  0 = NO, 1 = YES.              * C
C *     V1  - VELOCITY TO ADJUST START OF WINDOW (F(M)/MS).          * C
C *     V2  - VELOCITY TO ADJUST END OF WINDOW (F(M)/MS)             * C
C *   IVFLG - TYPE ADJUSTMENT FLAG:                                  * C
C *           0 = LINEAR   1 = HYPERBOLIC                            * C
C *   IOPT  - AVERAGING OPTION:                                      * C
C *           0 = GEOMETRIC MEAN    1 = ARITHMETIC MEAN              * C
C *   IOFMT - OUTPUT FORMAT.  DEFAULT IS SAME AS INPUT.              * C
C *   LRCD  - LAST RECORD TO PROCESS. BLANK IS ALL.                  * C
C *                                                                  * C
C ******************************************************************** C
        READ(CARD,1002)IWS,IWE,NTP,IADD,V1,V2,IVFLG,IOPT,idecon,LRCD
      endif
 1002 FORMAT(T6,2I5,5X,I4,I1,2X,2F5.0,I1,1X,I1,T60,I1,T76,1X,I4)
C *------------------------------------------------------------------* C
C *   CHECK THE PARAMETERS, SETTING DEFAULTS WHERE NECESSARY.        * C
C *------------------------------------------------------------------* C
      IOFMT=IFMT
      IF(IOPT.NE.1)IOPT=0
      IF(IWE.EQ.0)IWE=ITRCLN
      IF(IWE.GT.ITRCLN)IWE=ITRCLN
      IF(IWS.LT.0)IWS=0
      IF(NTRCD.EQ.1)JSTAK=1
      IF(IADD.NE.0)IADD=1
C *------------------------------------------------------------------* C
C *   PUT SOME LIMITATION ON THE POSSIBLE COMBINATIONS OF            * C
C *   JSTAK, NTP, AND IADD.  IF JSTAK=1, THEN IADD MAY BE 0 OR NOT,  * C
C *   BUT IF JSTAK=0, THEN IADD MUST BE ZERO.                        * C
C *   IF JSTAK=0, THEN NTP IS THE NUMBER OF TRACES PER RECORD.       * C
C *   IF JSTAK=1, NTP WILL DEFAULT TO 5, IT MUST BE ODD, MAX 513.   * C
C *------------------------------------------------------------------* C
      IF(JSTAK.EQ.1)GO TO 220
      IF(IADD.EQ.0)GO TO 215
      IER12 = 1
      IADD=0
  215 IF(NTP.LE.0)NTP=NTRCD
      IF(NTP.GT.2048)NTP=2048
      IF(NTP.NE.NTRCD)JSTAK=1
      GO TO 9998
  220 IF(IADD.EQ.0)GO TO 222
      IF(NTP.EQ.0)NTP=5
      NTP=NTP/2*2+1
      IF(NTP.GT.513)NTP=513
      IF(NTP.GE.3)GO TO 9998
      IER13 = 1
      NTP=3
      GO TO 9998
  222 IF(NTP.EQ.0)NTP=NTRCD
      IF(NTP.GT.2048)NTP=2048
      IF(NTP.GE.1)GO TO 9998
      write(iparm1,'(i8)')ntp
      IER14 = 1
      NTP=48
 9997 CONTINUE
      IER11 = 1
      IC=100
      ERRCNT = ERRCNT + 1
 9998 CONTINUE
C
C *------------------------------------------------------------------* C
C *  WRITE THE TAPE HEADER.
C *------------------------------------------------------------------* C
C
      CALL WTAPHD (LUO, IOPT, NTP, IWS, IWE, IADD, IOFMT, LRCD,
     *ERRCNT,idecon, ifrs)
C
C *------------------------------------------------------------------* C
C *  WRITE THE CARD IMAGE USING WRCARD.                              * C
C *------------------------------------------------------------------* C
C
*     IP1=1
*     CALL WRCARD(CARD,IP1,IPR)
      if(icr.gt.0) write(ipr,*)card
C *                                                                  * C
C *------------------------------------------------------------------* C
C *  PRINT THE CARD PARAMETERS AS INPUT.                             * C
C *------------------------------------------------------------------* C
      WRITE(IPR,2000)NTP,IADD,IWS,IWE,V1,V2,IOPT,idecon
 2000 FORMAT(//,15X,'INPUT PROCESSING PARAMETERS ',//,15X,
     *              'NUMBER OF TRACES TO PROCESS = ',I3,/,15X,
     *              'ADD ONE - DROP ONE FLAG     = ',I3,/,15X,
     *              'WINDOW START TIME           = ',I5,/,15X,
     *              'WINDOW END TIME             = ',I5,/,15X,
     *              'WINDOW START ADJ. VELOCITY  = ',F6.2,/,15X,
     *              'WINDOW END ADJ. VELOCITY    = ',F6.2,/,15X,
     *              'AVERAGING OPTION            = ',I3,/,15X,
     *              '   0 = GEOMETRIC MEAN',/,15X,
     *              '   1 = ARITHMETIC MEAN',/,15x,
     *              'DECONVOLUTION OPTION        = ',I3,/,15X,
     *              '   0 = NO',/,15X,
     *              '   1 = YES',//)
C
      IF (IER11 .EQ. 1) CALL ERRSUB(IPR,11)
      IF (IER12 .EQ. 1) CALL ERRSUB(IPR,12)
      IF (IER13 .EQ. 1) CALL ERRSUB(IPR,13)
      IF (IER14 .EQ. 1) CALL ERRSUB(IPR,14)
C
      RETURN
C
      END
      SUBROUTINE POWER2 (NS, LX, LS4, LS24)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - POWER2                                              * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST, 1982                                    * C
C *   REVISION - APRIL, 1983 - JACQUIE VINSON                        * C
C *              CREATED SUBROUTINE FROM IN-LINE CODE                * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE CALCULATES THE POWER OF 2 FOR THE TRANSFORM    * C
C *      AND OTHER PARAMETERS REQUIRED FOR THE TRANSFORM.            * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL POWER2 (NS, LX, LS4, LS24)                                * C
C *                                                                  * C
C *   NS     - NUMBER OF SAMPLES                                     * C
C *   LX     - TRANSFORM LENGTH                                      * C
C *   LS4    - 4 TIMES THE NUMBER OF FREQUENCY SAMPLES               * C
C *   LS24   - 8 TIMES THE NUMBER OF FREQUENCY SAMPLES               * C
C *                                                                  * C
C ******************************************************************** C
C *                                                                  * C
C *   LS - NUMBER OF FREQUENCY SAMPLES TO BE RETURNED.               * C
C *   LX - TRANSFORM LENGTH.                                         * C
C *                                                                  * C
C *------------------------------------------------------------------* C
C *   MINIMUM TRANSFORM LENGTH IS 2**7.                              * C
      LX=128
  230 IF(LX.GE.NS)GO TO 235
      LX=LX+LX
      GO TO 230
  235 CONTINUE
      LS=LX/2+1
      LS2=LS+LS
      LS24=LS2*4
      LS4=4*LS
      SL=LS
      RETURN
      END
      SUBROUTINE TRIN (LUI, IPR,SUM, TA, XN, NS, NSR, ITRKNT, ITRCLN,
     2            LREC, IOPT, NTP, LRCD, IFMT, JSTAK,IADD, IWS, IWE,
     3            V1, V2, IVFLG, KNT,IPASS, IDEAD, IEND, IC, OPRATR,
     4            holdb,ifrs, LUO, INPUT, NIT,ITRWRD, ITHWP1, SZLNHD,
     *            ISZBYT)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - TRIN                                                * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST, 1982                                    * C
C *   REVISION - APRIL, 1983 - JACQUIE VINSON                        * C
C *              CREATED SUBROUTINE FROM IN-LINE CODE                * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE PERFORMS THE 'FRONT END' PROCESSING OF SPBL.   * C
C *      IT READS THE TRACES, WRITES THE TRACES TO DISK AND          * C
C *      COMPUTES THE AMPLITUDE SPECTRUM.                            * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL TRIN (LUI, IPR,  SUM, TA,                                 * C
C *              XN, NS, NSR, ITRKNT, ITRCLN, LREC, IOPT, NTP,       * C
C *              LRCD, IFMT, JSTAK, IADD, IWS, IWE, V1, V2,          * C
C *              IVFLG, KNT, IPASS, IDEAD, IEND, IC)                 * C
C *                                                                  * C
C *   LUI    - LOGICAL UNIT OF INPUT TAPE                            * C
C *   IPR    - LOGICAL UNIT OF PRINTER                               * C
C *   SUM    - DATA BUFFER - SUM OF SPECTRUM                         * C
C *   TA     - DATA BUFFER - DATA TO BE TRANSFORMED                  * C
C *   XN     - SCALE FACTOR                                          * C
C *   NS     - NUMBER OF SAMPLES PER TRACE                           * C
C *   NSR    - SAMPLE INTERVAL                                       * C
C *   ITRKNT - NUMBER OF TRACES PROCESSED                            * C
C *   ITRCLN - TRACE LENGTH IN MS.                                   * C
C *   LREC   - CURRENT RECORD BEING PROCESSED                        * C
C *   IOPT   - AVERAGING FLAG                                        * C
C *   NTP    - NUMBER OF TRACE TO PROCESS                            * C
C *   LRCD   - LAST RECORD TO PROCESS                                * C
C *   IFMT   - FORMAT CODE                                           * C
C *   JSTAK  - STACKED DATA FLAG                                     * C
C *   IADD   - DROP ONE - ADD ONE FLAG                               * C
C *   IWS    - WINDOW START TIME (MS)                                * C
C *   IWE    - WINDOW END TIME (MS)                                  * C
C *   V1     - ADJUSTMENT VELOCITY - WINDOW START                    * C
C *   V2     - ADJUSTMENT VELOCITY - WINDOW END                      * C
C *   IVFLG  - ADJUSTMENT TYPE                                       * C
C *   KNT    - RUNNING COUNT OF NUMBER OF TRACES                     * C
C *   IPASS  - PASS FLAG                                             * C
C *   IDEAD  - RUNNING COUNT OF DEAD TRACES                          * C
C *   IEND   - END OF FILE FLAG                                      * C
C *   IC     - RETURN CODE                                           * C
C *                                                                  * C
C ******************************************************************** C
#include <localsys.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      INTEGER INPUT(4064)
c
      real work1, work2,work3
      REAL TRACE(4064), holdb(*)
      REAL TA(8204),SUM(4097), OPRATR(8204)
c
      character*8 iparm1,iparm2
c
*  EXTERNAL doit1, rzeros,bldrmp
c
      COMMON /PPARM/IPARM1,IPARM2
      common /fftp/N2
      common /work/work1(8204), work2(8204), work3(8204)

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm

c
      DATA IFIRST/0/
      SAVE
      nwds = ns + ITRWRD
      IF(IADD.NE.1.)IDEAD=0
      IF (IFIRST .eq. 0) then
        IFIRST = 1
        IFLGW = 1
        NS2 = NS + NS
        NS4 = NS2 + NS2
C *------------------------------------------------------------------* C
C * COMPUTE THE POWER OF 2 FOR THE TRANFORM.                         * C
C *------------------------------------------------------------------* C
        CALL POWER2 (NS, LX, LS4, LS24)
        ls = ls4/4
C ******************************************************************** C
C *                                                                  * C
C *              READ THE TRACE DATA AND PROCESS IT A RECORD         * C
C *              AT A TIME.                                          * C
C *                                                                  * C
C ******************************************************************** C
        XN=1.
C *------------------------------------------------------------------* C
C *   INITIALIZE RECORD COUNTER, TRACE COUNTER, OUTPUT COUNTER,      * C
C *   END OF DATA FLAG, AND PASS COUNTER, RESPECTIVELY.              * C
C *------------------------------------------------------------------* C
        LREC=0
        KNT=0
        IOKNT=0
        IEND=0
        IPASS=0
        IDEAD = 0
C *------------------------------------------------------------------* C
C *   CALL BLDRMP TO BUILD A 48MS RAMP.                              * C
C *------------------------------------------------------------------* C
        CALL BLDRMP (NSR, IPR)
C *------------------------------------------------------------------* C
C *   READ THE FIRST DATA TRACE. IF NO DATA, ABORT THE JOB.          * C
C *------------------------------------------------------------------* C
      endif
  303 continue
      NIT=0
      CALL RTAPE(LUI,INPUT,NIT)
      IF(NIT.eq.0)then
        IEND=1
        IC=0
        IF(IPASS.GT.0)return   
        CALL ERRSUB(IPR,8)
        IC=100
        return
      endif
c     call saver(input,'RecNum',iirec,TRCHED)
      call saver2(input,ifmt_RecNum,l_RecNum,ln_RecNum,
     :            iirec,1)
c     if(iirec.lt.ifrs)go to 303
	if(iirec .lt. ifrs) then
		call WRTAPE(LUO, INPUT, NIT)
		go to 303
	endif
      ITRKNT=ITRKNT+1
C *------------------------------------------------------------------* C
C *  CLEAR THE SUMMING ARRAY IF THIS IS THE FIRST TRACE IN THE SUM.  * C
C *------------------------------------------------------------------* C
      IF(KNT.eq.0)then
         call vclr(sum,1,ls)
          IF (IADD .NE. 1) IDEAD = 0
      endif
C *------------------------------------------------------------------* C
C *  SET THE RECORD COUNTER AND CHECK FOR DEAD TRACE FLAG.           * C
C *------------------------------------------------------------------* C
c     call saver(input,'RecNum', lrec, TRCHED)
      call saver2(input,ifmt_RecNum,l_RecNum,ln_RecNum,
     :            lrec ,1)
      IF(LREC.gt.LRCD)then
       IC=0
       IEND=1
       return
      endif
C *------------------------------------------------------------------* C
C *  INCREMENT THE READ COUNTER.                                     * C
C *  IF THE TRACE IS DEAD, SKIP CONVERSION.                          * C
C *------------------------------------------------------------------* C
  309 KNT=KNT+1
c     call saver(input,'StaCor', istat, TRCHED)
      call saver2(input,ifmt_StaCor,l_StaCor,ln_StaCor,
     :            istat,1)
      if(istat.ge.30000)then
        IDEAD=IDEAD+1
       call vclr(input(ITHWP1),1,ns)
      endif
  310 CONTINUE
C *------------------------------------------------------------------* C
C *  CONVERT THE DATA IF NECESSARY. GET THE DATA INTO ARRAY "RDATA". * C
C *------------------------------------------------------------------* C
      call vmov(input(1),1,trace(1),1,nwds)
  320 CONTINUE
C *------------------------------------------------------------------* C
C *  DETERMINE THE TEMP DISK STORAGE ADDRESS. IF DOING ADD ONE-      * C
C *  DROP ONE, THE NEW TRACE REPLACES THE TRACE TO BE DROPPED.       * C
C *------------------------------------------------------------------* C
      IFILE=KNT
C *------------------------------------------------------------------* C
C *  IF NOT WORKING ON STACKED DATA OR THE ADD ONE-DROP ONE FLAG     * C
C *  IS NOT SET, THE STORAGE ADDRESS IS JUST THE CURRENT COUNT.      * C
C *------------------------------------------------------------------* C
      IF(JSTAK.NE.1.OR.IADD.NE.1)GO TO 325
      IF(IPASS.GT.0.AND.JSTAK.NE.0)IFILE=MOD(IPASS,NTP)
      IF(IFILE.EQ.0)IFILE=NTP
  325 CONTINUE
      iaddr = (ifile-1)*nwds + 1
c     call saver(input,'StaCor', istat, TRCHED)
      call saver2(input,ifmt_StaCor,l_StaCor,ln_StaCor,
     :            istat,1)
      IF (istat .GE. 30000) GO TO 330
C *------------------------------------------------------------------* C
C *  GO GET THE TRANSFORM.                                           * C
C *------------------------------------------------------------------* C
C     IF(MODE.NE.0)GO TO 330
C *------------------------------------------------------------------* C
C *  CLEAR THE TRANSFORM AREA.                                       * C
C *------------------------------------------------------------------* C
      call vclr(ta,1,ns)
C *------------------------------------------------------------------* C
C *  COMPUTE THE WINDOW PARAMETERS AND MOVE DATA TO TRANSFORM AREA.  * C
C *------------------------------------------------------------------* C
c     call saver(input,'DstUsg', idist,TRCHED)
      call saver2(input,ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     :            idist,1)

      DIST=idist
      CALL DISCOR(IWS,IWE,V1,V2,DIST,LWS,LWE,IVFLG,NSR)
      IF(LWE.GT.ITRCLN)LWE=ITRCLN
      IF(LWS.LT.0)LWS=0
      JWS=LWS/NSR+1
      JWE=LWE/NSR+1
      LW=JWE-JWS+1
      IF(LW.GT.NS)LW=NS
      call vmov(trace(jws+ITRWRD),1,ta,1,lw)
      N2 = lx
      CALL DOIT1(NS,TA,N2,SUM,IOPT,WORK1,WORK2,WORK3)
  330 CONTINUE
C *------------------------------------------------------------------* C
C *  WRITE THE FIRST TRACE TO HOLDING AREA.                          * C
C *------------------------------------------------------------------* C
      call vmov(trace,1,holdb(iaddr),1,nwds)
C *------------------------------------------------------------------* C
C *   READ THE NEXT TRACE.  CHECK TO SEE IF THE NUMBER OF TRACES     * C
C *   TO BE BALANCED HAVE BEEN READ.                                 * C
C *------------------------------------------------------------------* C
      IF(KNT.LT.NTP)GO TO 303
  500 CONTINUE
  550 RETURN
      END
      SUBROUTINE TROUT (LUO, IPR, SUM, TA, XN,
     *  NS, NSR, NTP, NTRCD, IOFMT, JSTAK,
     *  IADD, IWS, IWE, V1, V2, IVFLG, KNT,IOPT,
     *  IPASS, IDEAD, IEND, IC, OPRATR, ITRCLN,holdb, idecon,
     *  ITRWRD, ITHWP1, SZLNHD,ISZBYT)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - TROUT                                               * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST, 1982                                    * C
C *   REVISION - APRIL, 1983 - JACQUIE VINSON                        * C
C *              CREATED SUBROUTINE FROM IN-LINE CODE                * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE PERFORMS THE 'FINAL' PROCESSING FOR SPBL.      * C
C *      IT WILL PERFORM THE SPECTRAL REPLACEMENT, INVERSE THE       * C
C *      TRANSFORM AND OUTPUT THE TRACE.                             * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL TROUT (LUO, IPR, SUM, TA, XN,      * C
C *               NS, NSR, NTP, NTRCD, IOFMT,                        * C
C *               JSTAK, IADD, KNT, IPASS, IDEAD, IEND, IC)          * C
C *                                                                  * C
C *   LUO    - LOGICAL UNIT OF OUTPUT TAPE                           * C
C *   IPR    - LOGICAL UNIT OF PRINTER                               * C
C *   SUM    - DATA BUFFER - SUM OF SPECTRUM                         * C
C *   TA     - DATA BUFFER - DATA TO BE TRANSFORMED                  * C
C *   XN     - SCALE FACTOR                                          * C
C *   NS     - NUMBER OF SAMPLES PER TRACE                           * C
C *   NSR    - SAMPLE INTERVAL                                       * C
C *   NTP    - NUMBER OF TRACE TO PROCESS                            * C
C *   NTRCD  - NUMBER OF TRACES PER RECORD                           * C
C *   IOFMT  - FORMAT CODE                                           * C
C *   JSTAK  - STACKED DATA FLAG                                     * C
C *   IADD   - DROP ONE - ADD ONE FLAG                               * C
C *   IWS    - WINDOW START TIME (MS)                                * C
C *   IWE    - WINDOW END TIME (MS)                                  * C
C *   V1     - ADJUSTMENT VELOCITY - WINDOW START                    * C
C *   V2     - ADJUSTMENT VELOCITY - WINDOW END                      * C
C *   IVFLG  - ADJUSTMENT TYPE                                       * C
C *   KNT    - RUNNING COUNT OF NUMBER OF TRACES                     * C
C *   IPASS  - PASS FLAG                                             * C
C *   IDEAD  - RUNNING COUNT OF DEAD TRACES                          * C
C *   IEND   - END OF FILE FLAG                                      * C
C *   IC     - RETURN CODE                                           * C
C *                                                                  * C
C ******************************************************************** C
#include <localsys.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
c	parameter (KDIM = 4000 + ITRWRD)
c     REAL TRACE(KDIM), OUTPUT(KDIM),holdb(*)
      REAL TRACE(4064), OUTPUT(4064),holdb(*)
      real work1, work2, work3
      REAL TA(8204),SUM(4097), OPRATR(8204)
c
      character*8 iparm1,iparm2
c
*  EXTERNAL DOIT3,RSTORE
c
      COMMON /PPARM/IPARM1,IPARM2
      common /work/work1(8204), work2(8204), work3(8204)
      common /fftp/n2
      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm

c
      DATA IFIRST/0/, LWS/0/, LWE/0/, LS/0/
c
      SAVE
      IF (IFIRST .eq. 0) then
        nwds = ns + ITRWRD
        IFIRST = 1
        IFLGR = 2
        IOKNT = 0
        NS2 = NS + NS
        NS4 = NS2 + NS2
        LEN = (ns + ITRWRD) * ISZBYT
C *------------------------------------------------------------------* C
C * COMPUTE THE POWER OF 2 FOR THE TRANFORM.                         * C
C *------------------------------------------------------------------* C
        CALL POWER2 (NS, LX, LS4, LS24)
        ls = lx
      endif
  500 CONTINUE
C *------------------------------------------------------------------* C
C *   CALL THE FILTER COMPUTATION ROUTINE IF REQUIRED.               * C
C *------------------------------------------------------------------* C
      KNT2=KNT/2+1
C *------------------------------------------------------------------* C
C *   THE FIRST TIME THROUGH WANT TO OUTPUT THE FIRST HALF OF        * C
C *   THE DATA IF DOING ADD ONE - DROP ONE.  EACH OTHER TIME THROUGH * C
C *   WILL OUTPUT ONLY ONE TRACE UNTIL THE EOF IS REACH( IEND = 1).  * C
C *------------------------------------------------------------------* C
      NUM=KNT2
      IF(IADD.EQ.0)NUM=KNT
      IF(IADD.EQ.1.AND.IPASS.GT.0.AND.IEND.EQ.0)NUM=1
      IF(IADD.EQ.1.AND.IPASS.GT.0.AND.IEND.EQ.1)NUM=KNT2-1
      DO 530 I=1,NUM
C *------------------------------------------------------------------* C
C *   GET THE FILE TO BE READ. COMPUTE IT AS MODULUS IF PASS GT 1.   * C
C *------------------------------------------------------------------* C
      IOUT=I
      IF(IPASS.EQ.0)GO TO 502
      IF(IADD.EQ.0)GO TO 502
      IIKNT=IOKNT+1
      IOUT=MOD(IIKNT,NTP)
      IF(IOUT.EQ.0)IOUT=NTP
  502 CONTINUE
C *------------------------------------------------------------------* C
C *   READ THE FILE.                                                 * C
C *------------------------------------------------------------------* C
      iaddr = (iout-1)*nwds + 1
      call vmov(holdb(iaddr),1,trace,1,nwds)
C *------------------------------------------------------------------* C
C *   CALL RZEROS TO COUNT THE NUMBER OF LEADING ZEROS IN THE TRACE. * C
C *------------------------------------------------------------------* C
c     call saver(trace,'StaCor',istat,TRCHED)
      call saver2(trace,ifmt_StaCor,l_StaCor,ln_StaCor,
     :            istat,1)
      IF (istat .LT. 30000)CALL rzeros (trace(ITHWP1), NS, lzeros)
      IF (lzeros.ge.ns-48) then
c       call saver(trace,'RecNum',irec,TRCHED)    
c       call saver(trace,'TrcNum',itrc,TRCHED)
        call saver2(trace,ifmt_RecNum,l_RecNum,ln_RecNum,
     :              irec,1)
        call saver2(trace,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :              itrc,1)
        write(iparm1,'(i8)')irec
        write(iparm2,'(i8)')itrc
        CALL ERRSUB (IPR, 15)
        istat = 30000
c       call savew(trace,'StaCor', istat, TRCHED)
        call savew2(trace,ifmt_StaCor,l_StaCor,ln_StaCor,
     :              istat,1)
      endif
      IF(XN.EQ.0.0)then
        istat = 30000
c       call savew(trace,'StaCor', istat, TRCHED)
        call savew2(trace,ifmt_StaCor,l_StaCor,ln_StaCor,
     :              istat,1)
      endif
      IF(istat.ge.30000)then
        call vclr(trace(ITHWP1),1,ns)
      else 
        N2 = lx
        CALL DOIT3(NS,trace(ITHWP1),N2,OPRATR,WORK1,WORK2,WORK3,
     *  idecon)
        CALL RSTORE (trace(ITHWP1), IPR,lzeros)
      endif
      call vmov(trace,1,output,1,nwds)
C *------------------------------------------------------------------* C
C *   WRITE THE PROCESSED TRACE.                                     * C
C *------------------------------------------------------------------* C
      CALL WRTAPE(LUO,OUTPUT,LEN)
C *------------------------------------------------------------------* C
C *   SET THE OUTPUT COUNTER.                                        * C
C *------------------------------------------------------------------* C
      IOKNT=IOKNT+1
      IF(NTRCD.NE.1)GO TO 527
      JCHK=0
      GO TO 528
  527 JCHK=MOD(IOKNT,NTRCD)
c 528 call saver(output,'RecNum', jrcd,TRCHED)
  528 call saver2(output,ifmt_RecNum,l_RecNum,ln_RecNum,
     :              jrcd,1)
C *------------------------------------------------------------------* C
C *   IF A RECORD PROCESSED, CALL THE RECORDS PROCESSED              * C
C *   PRINTING ROUTINE.                                              * C
C *------------------------------------------------------------------* C
      IF(I.EQ.KNT.AND.JSTAK.NE.1)CALL RIPRNT(JRCD,IPR)
      IF(JSTAK.EQ.1.AND.JCHK.EQ.0)CALL RIPRNT(JRCD,IPR)
  530 CONTINUE
C *------------------------------------------------------------------* C
C *  GO TO PROCESS NEXT RECORD.                                      * C
C *  INCREMENT THE PASS FLAG.                                        * C
C *------------------------------------------------------------------* C
      IPASS=IPASS+1
      IKNT=KNT
      KNT=0
C *------------------------------------------------------------------* C
C *  IF IADD = 1, WILL READ ONLY ONE TRACE, SO ONLY DECREMENT THE    * C
C *  KNT BY 1.                                                       * C
C *------------------------------------------------------------------* C
      IF(IADD.EQ.1)KNT=IKNT-1
C *------------------------------------------------------------------* C
C *   IF ADD-ONE-DROP-ONE OPTION WAS SPECIFIED,                      * C
C *   SUBTRACT CURRENT SUM FROM SUM OF AMPLITUDE SPECTRUM.           * C
C *   Have to compute spectrum of the trace just output (from the    * C
C *   input trace) and then subtract from SUM.                       * C
C *------------------------------------------------------------------* C
*     IF (IEND .EQ. 1) GO TO 550
*     IF (IADD .EQ. 0 .OR. JSTAK .NE. 1) GO TO 550
      if(iend.ne.1.and.iadd.ne.0.and.jstak.eq.1)then
        IOUT = MOD(IPASS, NTP)
        IF (IOUT .EQ. 0) IOUT = NTP
        iaddr = (iout-1)*nwds + 1
        call vmov(holdb(iaddr),1,trace,1,nwds)
c       call saver(trace,'StaCor',istat,TRCHED)
        call saver2(trace,ifmt_StaCor,l_StaCor,ln_StaCor,
     :              istat,1)
        if(istat.ge.30000)then
          IF (IDEAD .GT. 0) IDEAD = IDEAD - 1
        else
c          call saver(trace,'DstSgn', idist, TRCHED)
           call saver2(trace,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     :                 idist,1)
           dist = idist
C
           CALL DISCOR(IWS,IWE,V1,V2,DIST,LWS,LWE,IVFLG,NSR)
C
           IF (LWE.GT.ITRCLN) LWE=ITRCLN
           IF (LWS.LT.0) LWS=0
           JWS=LWS/NSR+1
           JWE=LWE/NSR+1
           LW=JWE-JWS+1
           IF (LW.GT.NS) LW=NS
C
         call vclr(ta,1,ns)
         call vmov(trace(jws + ITRWRD),1,ta,1,lw)
         N2 = lx
         CALL DOIT1(NS,TA,N2,OUTPUT,IOPT,WORK1,WORK2,WORK3)
         LS=LX/2+1
         call vsub(sum,1,output,1,sum,1,ls)
        endif
      endif
  550 CONTINUE
C
      RETURN
      END
      SUBROUTINE DISCOR (BEG,END,VEL1,VEL2,DIST,BEG1,END1,VFLAG,ISI)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - DISCOR                                              * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST,1982                                     * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                  P R O P R I E T A R Y                           * C
C *             TO BE MAINTAINED IN CONFIDENCE                       * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      SUBROUTINE TO FIND THE FIRST NON-ZERO SAMPLE ON A TRACE     * C
C *    SUBROUTINE TO ADJUST BEG AND END SAMPLE NUMBERS FOR A WINDOW  * C
C *    BY A SUPPLIED CORRECTIONAL VELOCITY. CORRECTION MAY BE        * C
C *    HYPERBOLIC OR LINEAR.                                         * C
C *    USAGE -                                                       * C
C *                                                                  * C
C *     CALL DISCOR(BEG,END,VEL1,VEL2,DIST,BEG1,END1,VFLAG,ISI)      * C
C *                                                                  * C
C *    WHERE                                                         * C
C *   BEG =  ORIGINAL BEGINNING WINDOW TIME(MS)                      * C
C *   BEG1 = ADJUSTED BEGINNING WINDOW TIME(MS)                      * C
C *   END  = ORIGINAL ENDING WINDOW TIME(MS)                         * C
C *   END1 = ADJUSTED ENDING WINDOW TIME(MS)                         * C
C *   DIST = TRACE DISTANCE (F/M)                                    * C
C *   VEL1 = ADJUSTMENT VELOCITY FOR BEGINNING TIME(F/MS;M/MS)       * C
C *   VEL2 = ADJUSTMENT VELOCITY FOR ENDING TIME (F/MS;M/MS)         * C
C *   VFLAG= TYPE ADJUSTMENT FLAG                                    * C
C *          0 - LINEAR                                              * C
C *          1 - HYPERBOLIC                                          * C
C *                                                                  * C
C********************************************************************* C
      INTEGER BEG, BEG1, END, END1, VFLAG
*
      B=0.0 
      DIST=ABS(DIST)
      SI=ISI
      IF (VEL1.NE.B.OR.VEL2.NE.B) GO TO 10
      BEG1 = BEG
      END1 = END
      RETURN
   10 CONTINUE
      DSQ = DIST * DIST
      IF (VEL1.NE.0.0) GO TO 20
      BEG1 = BEG
      GO TO 40
   20 IF (VFLAG.EQ.0) GO TO 30
      TBEG = BEG
      TBEG = SQRT(TBEG * TBEG * VEL1 * VEL1 + DSQ)/VEL1
      BEG1 = TBEG + .5
      BEG1 = (BEG1/SI) * SI
      GO TO 40
   30 BEG1 = BEG + DIST/VEL1
      BEG1 = (BEG1/SI) * SI
   40 IF (VEL2.NE.0.0) GO TO 50
      END1 = END
      GO TO 70
   50 IF (VFLAG.EQ.0) GO TO 60
      TEND = END
      TEND = SQRT(TEND * TEND * VEL2 * VEL2 + DSQ)/VEL2
      END1 = TEND + .5
      END1 = (END1/SI) * SI
      GO TO 70
   60 END1 = END + DIST/VEL2
      END1 = (END1/SI) * SI
   70 RETURN
      END
      SUBROUTINE ERRSUB(IPR,N)
C ******************************************************************** C
C *                                                                  * C
C *   SUBROUTINE - ERRSUB                           ENTRY - ERRSUB   * C
C *   LANGUAGE - FORTRAN                                             * C
C *   AUTHOR - R. CRIDER                                             * C
C *   DATE WRITTEN - 3/82                                            * C
C *   MODIFICATION HISTORY -                                         * C
C *                                                                  * C
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *                                                                  * C
C *  SUBROUTINE TO PRINT ERROR MESSAGE.                              * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *                                                                  * C
C *     CALL ERRSUB(IPR,N)                                           * C
C *                                                                  * C
C *   INPUT IS...                                                    * C
C *           IPR - I*4 - LOGICAL UNIT NUMBER OF PRINT DEVICE.       * C
C *            N  - I*4 - ERROR MESSAGE POINTER.                     * C
C *                                                                  * C
C *   OUTPUT IS...                                                   * C
C *          PRINTED MESSAGE ONLY.                                   * C
C *                                                                  * C
C *   SUBROUTINES CALLED -  NONE                                     * C
C *                                                                  * C
C ******************************************************************** C
      character*8 iparm1,iparm2
      COMMON /PPARM/IPARM1,IPARM2
      WRITE(IPR,9000)
      WRITE(IPR,9000)
 9000 FORMAT(' ')
      IF(N.GT.10)GO TO 2
      GO TO (
     *5,15,25,35,45,65,75,85,95),N
C     1  2  3  4  5  6  7  8  9 10     VALUES OF N
    2 NN=N-10
      GO TO (105,115,125,135,145),NN
C             11 12   13  14  15
      RETURN
    5 WRITE(IPR,10)
   10 FORMAT(' ',T10,'*** M0120 *** ERROR DETECTED IN SUBROUTINE ',
     *'RTAPHD.',
     */,1X,T10,'END OF FILE ENCOUNTERED WHILE ATTEMPTING TO READ THE',
     *' LINE HEADER ON THE INPUT DATA SET (NTAP).',/,1X,T10,
     *' ENSURE THAT YOUR INPUT DATA SET IS VALID BEFORE RESUBMITTING',
     *' YOUR JOB.')
      RETURN
   15 WRITE(IPR,20)IPARM1
   20 FORMAT(' ',T10,'*** M0123 *** ERROR DETECTED IN SUBROUTINE ',
     *'RTAPHD.',
     */,1X,T10,'THE NUMBER OF SAMPLES PER TRACE ON THE INPUT DATA',
     *' SET (',a8,' ) EXCEEDS THE PROGRAM MAXIMUM OF 4000.',
     */,1X,T10,'REDUCE THE NUMBER OF SAMPLES PER TRACE TO NO MORE',
     *' THAN 4000 BEFORE RESUBMITTING YOUR JOB.')
      RETURN
   25 WRITE(IPR,30)IPARM1
   30 FORMAT(' ',T10,'*** M0125 *** ERROR DETECTED IN SUBROUTINE ',
     *'RTAPHD.',
     */,1X,T10,'THE NUMBER OF TRACES PER RECORD ON THE INPUT DATA',
     *' SET (',a8,' ) EXCEEDS THE PROGRAM MAXIMUM OF 2048.',
     */,1X,T10,'REDUCE THE NUMBER OF TRACES PER RECORD TO NO MORE',
     *' THAN 2048 BEFORE RESUBMITTING YOUR JOB.')
      RETURN
   35 WRITE(IPR,40)IPARM1
   40 FORMAT(' ',T10,'*** M0121 *** ERROR DETECTED IN SUBROUTINE ',
     *'RTAPHD.',
     */,1X,T10,'THE FORMAT OF THE INPUT DATA SET (',a8,') IS NOT 3.',
     */,1X,T10,'ENSURE THAT THE FORMAT OF YOUR INPUT DATA',
     *' SET IS 3 BEFORE RESUBMITTING YOUR JOB.')
      RETURN
   45 WRITE(IPR,50)IPARM1
   50 FORMAT(' ',T10,'*** M0141 *** ERROR DETECTED IN SUBROUTINE ',
     *'READCD.',
     */,1X,T10,'THE DATA CARD READ WAS NOT A ',A8,' CARD.',
     */,1X,T10,'ENSURE THAT YOU HAVE THE PROPER CARD INPUT',
     *' BEFORE RESUBMITTING YOUR JOB.')
      RETURN
   65 WRITE(IPR,70)
   70 FORMAT(' ',T10,'*** M0142 *** WARNING FROM SUBROUTINE TRIN.',
     */,1X,T10,'THE NUMBER OF POINTS SPECIFIED FOR THE FILTER',
     *' EXCEEDS THE PROGAM MAXIMUM OF NINE (9).',/,1X,T10,'THE',
     *' NUMBER OF POINTS HAS BEEN RESET TO THE MAXIMUM AND PROCESSING',
     *' CONTINUES.')
      RETURN
   75 WRITE(IPR,80)
   80 FORMAT(' ',T10,'*** M0200 *** ERROR DETECTED IN SUBROUTINE ',
     *'TRIN.',
     */,1X,T10,'END OF FILE ENCOUNTERED ON THE INPUT TAPE WHILE',
     *' ATTEMPTING TO READ THE FIRST DATA TRACE ',/,1X,T10,
     *'ENSURE THAT YOU HAVE A VALID DATA SET BEFORE',
     *' RESUBMITTING YOUR JOB.')
      RETURN
   85 WRITE(IPR,90)
   90 FORMAT(' ',T10,'*** M0201 *** ERROR DETECTED IN MAIN PROGRAM.',
     */,1X,T10,'END OF FILE ENCOUNTERED ON THE INPUT TAPE WHILE',
     *' ATTEMPTING TO READ THE REQUIRED NUMBER OF DATA TRACES.',/,1X,
     *T10,'ENSURE THAT YOUR DATA SET HAS THE PROPER NUMBER OF TRACES'
     *' BEFORE RESUBMITTING YOUR JOB.')
      RETURN
   95 WRITE(IPR,100)
  100 FORMAT(' ',T10,'*** M0203 *** ERROR DETECTED IN SUBROUTINE ',
     *'OPENAC.',/,1X,T10,'ERROR ENCOUNTERED ATTEMPTING TO OPEN',
     *' THE DISK DATA SET.',/,1X,T10,'SEE SVC STATUS CODE FOR '
     *'EXPLANATION.')
      RETURN
  105 WRITE(IPR,110)
  110 FORMAT(' ',T10,'*** M0140 *** ERROR DETECTED IN SUBROUTINE ',
     *'READCD.',
     */,1X,T10,'NO DATA CARD WAS FOUND. CODE A PROPER 1SPBL CARD',
     *' BEFORE RESUBMITTING YOUR JOB.')
      RETURN
  115 WRITE(IPR,120)
  120 FORMAT(' ',T10,'*** M0204 *** WARNING FROM SUBROUTINE READCD.',
     */,1X,T10,'THE ADD ONE - DROP ONE OPTION IS INVALID FOR',
     *' UNSTACK DATA.',/,1X,T10,'THE FLAG HAS BEEN RESET AND'
     *' PROCESSING CONTINUES WITH THE NUMBER OF TRACES SET TO',
     *' THE NUMBER OF TRACES PER RECORD.')
      RETURN
  125 WRITE(IPR,130)
  130 FORMAT(' ',T10,'*** M0205 *** WARNING FROM SUBROUTINE READCD.',
     */,1X,T10,'THE NUMBER OF TRACES INVOLVED IN THE ADD ONE - DROP',
     *' ONE OPTION MUST BE AT LEAST 3.',/,10X,'THE NUMBER OF TRACES',
     *' HAS BEEN RESET TO 3 AND PROCESSING CONTINUES.')
      RETURN
  135 WRITE(IPR,140)IPARM1
  140 FORMAT(' ',T10,'*** M0206 *** WARNING FROM SUBROUTINE READCD.',
     */,1X,T10,'THE NUMBER OF TRACES TO PROCESS (',a8,') IS LESS THAN',
     *' 1 FOR THE NO ADD ONE DROP ONE OPTION.',/,10X,'THE NUMBER OF'
     *' TRACES HAS BEEN RESET TO 48 AND PROCESSING CONTINUES.')
  145 WRITE(IPR,150)IPARM1,IPARM2
  150 FORMAT(' ',T10,'*** M0207 *** WARNING FROM SUBROUTINE TROUT.',
     */,1X,T10,'THE TRACE DATA FOR RECORD ',a8,' TRACE ', a8,
     *' IS ALL ZEROS.', /, 10X,
     *'THE TRACE HAS BEEN KILLED AND PROCESSING CONTINUES.')
      RETURN
      END
      subroutine strclr(x,lx)
      character x*(*)
      do 1000  i= 1,lx
       x(i:i) = ' '
 1000 continue
      return
      end
