C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln ( ntap, otap,  cardin,
     *lucrd,
     *iws,iwe, ntp,iadd,v1,v2,ivflg,iopt,idecon,ifrs, lrcd)
c     FORTRAN by M. A. Miller   4-14-89
c     Modified by R. L. Crider 4-27-90
c
c     this routine processes the command line arguments for use in
c     program SPBL on SUN.
c
#include <f77/localsys.h>
#include <f77/iounit.h>
      character ntap*(*), otap*(*), cardin*(*)
      logical     there, decon
      integer argis
C
	  ntap = ' '
      call argstr ('-N',ntap,' ',' ')
	  otap = ' '
      call argstr ('-O',otap,' ',' ')
      cardin = ' '
      call argstr ('-D',cardin,' ',' ')
      call noblnk(cardin,lc)
      if(cardin(1:1) .ne. ' ') then
	    inquire(file = cardin, exist = there)
	    if(.not.there)then
	     write(LER, '(3a)')'   File ',cardin,' not found.'
	     print *,'   File ',cardin,' not found.'
		 call ccexit (100)
		endif
        open(unit=lucrd, file=cardin, status='old',
     *         form='formatted',access='sequential')
        rewind (lucrd)
      else
        lucrd = -1
        call argi4('-ws',iws,0,0)
        call argi4('-we',iwe,0,0)
        call argi4('-nt',ntp,0,0)
        decon = .false.
        decon = (argis('-ad').gt.0)
        iadd = 0
        if(decon)  iadd = 1
        call argr4('-v1',v1,0,0)
        call argr4('-v2',v2,0,0)
        call argi4('-vfl',ivflg,0,0)
        call argi4('-op',iopt,0,0)
        decon = .false.
        decon = (argis('-dk').gt.0)
        idecon = 0
        if(decon)idecon = 1
        call argi4('-rs',ifrs,0,0)
        call argi4('-re',lrcd,0,0)
      endif
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM SPBL................Spectral Balancing'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]      (may be pipe)     : Input data file name'
         write(LER,*)
     :' -O [otap]      (may be pipe)     : Output data file name'
         write(LER,*)
     :' -D [cardin](optional,no default) : Card data file name'
         write(LER,*)
     :' Optional command line parameter input'
         write(LER,*)
     :' -ws [ws]      (default = 0)      : Window start time (ms)'
         write(LER,*)
     :' -we [we]      (default = eot)    : Window end time (ms)'
         write(LER,*)
     :' -nt [nt]  (default = traces      : Number traces in spatial'
         write(LER,*)
     :'                per record)       : window'
         write(LER,*)
     :' -ad [ad]   (default = no)        : Add one/drop one option'
         write(LER,*)
     :' -v1 [v1]      (default = 0)      : Velocity for window start'
         write(LER,*)
     :'                                  : time adjustmet(x/ms)'
         write(LER,*)
     :' -v2 [v2]      (default = 0)      : Velocity for window end'
         write(LER,*)
     :'                                  : time adjustmet (x/ms)'
         write(LER,*)
     :' -vfl [vfl] (default = linear)    : Window correction type'
         write(LER,*)
     :'                                  : 0 = linear, 1 = hyperbolic'
         write(LER,*)
     :' -op [op]   (default=0)           : Averging type: '
         write(LER,*)
     :'                                  : 0=geometric, 1=arithmetic'
         write(LER,*)
     :' -dk [dk]      (default = no)     : If present, do deconvolution'
         write(LER,*)
     :' -rs [rs]  (default = first)      : Start seq. rec. to process'
         write(LER,*)
     :' -re [op]   (default = last)      : End seq. rec. to process'
         write(LER,*)
c2345678901234567890123456789012345678901234567890123456789012345678901234567890
     :'(SPBL outputs ALL input records, processing only records rs thru 
     :re)'
       write(LER,*)
     :'Usage:  ',
     :' spbl -N[ntap] -O[otap] -D[cardin] '
       write(LER,*) '  or ' 
       write(LER,*)
     :'Usage:  ',
     :' spbl -N[ntap] -O[otap] -ws[ws] -we[we] -nt[ntr] -ad[ad] '
       write(LER,*)
     :'      -v1[v1] -v2[v2] -vfl[vfl] -op[op] -dk[dk] -rs[rs]',
     :' -re[re] '
       write(LER,*)
     :'***************************************************************'
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CCEXIT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CCEXIT  (ICODE)                                                 *
C  ARGUMENTS:                                                          *
C      ICODE   INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C                                                                     *
C
      SUBROUTINE CCEXIT (ICODE)
C
#include <f77/localsys.h>
#include <f77/iounit.h>
      WRITE (LER,1000) ICODE
 1000 FORMAT(' PROGRAM TERMINATION:  EXIT CODE = ',I6)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FPTOI                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FPTOI  (I2,R4,NS,ITT)                                           *
C  ARGUMENTS:                                                          *
C      I2      INTEGER*2  ??IOU*  (*) -                                *
C      R4      REAL       ??IOU*  (*) -                                *
C      NS      INTEGER    ??IOU*      -                                *
C      ITT     INTEGER    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine fptoi (i2,r4,ns,itt)
#include <f77/localsys.h>
#include <f77/iounit.h>
*#ifdef SUNSYSTEM
      INTEGER*2 i2(*)
*#endif
*#ifdef CRAYSYSTEM
*      INTEGER i2(*)
*#endif
      integer ns, itt, i
      real r4(*)
      do 10 i = 1,ns
      i2(i) = ifix(r4(i))
   10 continue
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ITOFP                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ITOFP  (I2,R4,NS)                                               *
C  ARGUMENTS:                                                          *
C      I2      INTEGER*2  ??IOU*  (*) -                                *
C      R4      REAL       ??IOU*  (*) -                                *
C      NS      INTEGER    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine itofp (i2,r4,ns)
#include <f77/localsys.h>
#include <f77/iounit.h>
*#ifdef SUNSYSTEM
      INTEGER*2 i2(*)
*#endif
*#ifdef CRAYSYSTEM
*      INTEGER i2(*)
*#endif
      integer ns, i, ival
      real r4(*)
      do 10 i = 1,ns
      ival = i2(i)
      r4(i) = float(ival)
   10 continue
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RIPRNT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RIPRNT  (IR,LUP)                                                *
C      RICLR  (LUP)                                                    *
C  ARGUMENTS:                                                          *
C      IR      INTEGER  ??IOU* -                                       *
C      LUP     INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUP  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine riprnt(ir,lup)
      integer ris(20)
      data ncount/0/
	save ris, ncount
  100 format('   RI PROCESSED ',20i5)
      ncount=ncount+1
      if(ncount.lt.20)then
         ris(ncount)=ir
      else
         ris(ncount)=ir
         write(lup,100)(ris(k),k=1,ncount)
         ncount=0
      endif
      return
      entry riclr(lup)
      write(lup,100)(ris(k),k=1,ncount)
      return
      end
