C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C     ----------------	  Main Routine -----------------------
c
c Changes:
c --------
c
c May 22, 2002: added FreQst, FreQnd and SmpFlt assignments to the
c               output line header for use with downstream applications
c Garossino
c
c Aug 8, 2001: fixed verbal routine to report correct taper percent
c              when using cosine taper.  Also changed help subroutine
c              for clarity on this issue.
c Garossino
c
c Jun 28, 1999: fixed logic to calculate number of output volumes
c               to exactly match what is actually output.  Previous
c               logic often said one thing then did another.
c Garossino
c
c Jun 23, 1999: Found major differences between output of rwspec and spec.
c               These were due to differences is bias treatment.  I have
c               made the default bias treatment to be NO bias removal of
c               either the trace or operator.  I added command line options
c               -trbias -opbias to activate either if wanted.
c Garossino
c
c
c Jun 17, 1999: went over code. fixed many indexing errors. fixed
c               many memory faults, changed -int option to only use
c               a temporary dataset if asked.  declared many undeclared
c               variables.  added a verbal subroutine. added many policemen 
c               to prevent routine from crashing on poor parameter choice.
c Garossino
c
c     
c====================================================================
c     Program rwspec to perform a slow Fourier Transform on a sliding window
c     for amplitude analysis
c     This is similar to the stft
c====================================================================
c====================================================================
c     USP Team  James M. Gridley
c     July 1995
c     Requested by Greg Partyka
c====================================================================
c     
c     DECLARE VARIABLES
c     

      implicit none
      
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      
c declare standard USP variables

      integer lhed( SZLNHD )
      integer nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco
      integer luin, luout, lbytes, nbytes, obytes, lbyout
      integer argis, irs, ire, ns, ne, ist, iend, JJ, KK, jerr

      real tri ( SZLNHD )
      real UnitSc

      character name*6, ntap*256, otap*256

      logical verbos

c variables using dynamic memory allocation

      integer sum_size, table_size, t_size
      integer errcd1, errcd2, errcd3, errcd4, abort
      
      real sum, ctable, t, tri_buffer

      pointer ( mem_sum, sum(2) )
      pointer ( mem_ctable, ctable(2) )
      pointer ( mem_t, t(2) )
      pointer ( mem_tri_buffer, tri_buffer(2) )
      
c program dependant variables

      integer nsamp2, window, iwind, ihalf
      integer nskip, nomega, i, itw
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer nrecc

      real tri_out( SZLNHD )

      real dt, dtmsec, radeg, pie, smax 
      real period1, period2, dperiod
      real omega1, omega2, domega

      logical land, trbias, opbias, gaus, phase
      logical normal_energy, normal_live

c initialize variables      
      
      data name /'RWSPEC'/
      data luin / 1 /
      data luout / 2 /
      data lbytes / 0 /
      data nbytes / 0 /
      data obytes / 0 /
      data smax/0./
      data radeg/57.29578/
      data abort/0/

      pie = 4.0 * atan(1.0)

c get online help if requested
      
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0) then
         call help()
         stop
      endif
      
c open printout file

#include <f77/open.h>

c parse command line
      
      call cmdln ( ntap, otap, ist, iend, ns, ne, irs, ire, trbias, 
     :     opbias, window, itw, nskip, land, verbos, omega1, omega2, 
     :     domega, gaus, period1, period2, dperiod, phase, normal_live, 
     :     normal_energy )
      
c open input and output data streams
      
      call getln( luin, ntap, 'r', 0)

c if -int is flagged on the command line the user wants to scale the data
c for input to landmark [land logical variable is .true.] at 8 bit.  In that
c case we need to write to a temp file while global stats are pulled then
c scale at the end.  If -int is not flagged then we don't need to do this.

      if ( land ) then
         call tmpopen(luout)
      else
         call getln ( luout, otap, 'w', 1 )
      endif

c  read line header
      
      lbytes = 0
      call rtape  ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'        no header read on unit ',ntap
         write(LERR,*)'        check existence of data file'
         write(LERR,*)'FATAL'
         write(LER,*)'RWSPEC: no header read on unit ',ntap
         write(LER,*)'        check existence of data file'
         write(LER,*)'FATAL'
         stop
      endif
      
c print hlh to printout file

      call hlhprt ( lhed , lbytes, name, 6, lerr )

c save global parameters
      
      call saver(lhed, 'NumSmp', nsamp , LINHED)
      call saver(lhed, 'SmpInt', nsi   , LINHED)
      call saver(lhed, 'NumTrc', ntrc  , LINHED)
      call saver(lhed, 'NumRec', nrec  , LINHED)
      call saver(lhed, 'UnitSc', UnitSc, LINHED)

      if (UnitSc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          UnitSc = .001
          call savew(lhed, 'UnitSc', UnitSc, LINHED)
      endif
      
c set up pointer to dead trace flag

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      
      if( nsamp .gt. SZLNHD) nsamp=SZLNHD

c convert output sample interval from time units to samples

      if ( nskip .ne. 1 ) nskip = nskip / nsi

c Policeman: watch out for -dto[] less than nsi

      if ( nskip .lt. 1 ) nskip = 1

c====================================================================
c     dtmsec = millisecs or microsecs depending on the sample interval units
c     dt     = secs always
c====================================================================
      
      dt     = real (nsi) * UnitSc
      dtmsec = 1000 * dt
      
c convert processing window start and end times to samples and don't forget that
c time zero is sample one

      iend  = iend/nsi + 1
      ist   = ist/nsi + 1
c      iend  = iend/dtmsec + 1.5
c      ist   = ist/dtmsec + 1

      if ( ist .lt. 1 ) ist = 1
      if ( iend .lt. 2 ) iend = nsamp
      if ( iend .gt. nsamp) iend = nsamp

c     window length [converted to samples] = iwind

      if ( window .eq. 0 ) then
         write(LERR,*)' DFT sampling window must be supplied'
         write(LERR,*)' use -win[] on the command line and '
         write(LERR,*)' try again'
         write(LERR,*)'FATAL'
         write(LER,*)'RWSPEC:'
         write(LER,*)' DFT sampling window must be supplied'
         write(LER,*)' use -win[] on the command line and '
         write(LER,*)' try again'
         write(LER,*)'FATAL'
         stop
      endif

      iwind = int( window / nsi )
      ihalf = iwind / 2

c====================================================================
c     Policeman:  Check to see if input parameters are in 
c     frequency or period
      
      if (omega1 .eq. 0. .and. omega2 .eq. 0. .and. period1 .eq. 
     +     0.  .and.  period2 .eq. 0. ) then
c     Default
         period1 = 2. * nsi * UnitSc
         period2 = iwind * nsi * UnitSc
         dperiod = (abs(period2-period1)/3.)	
     
         
         omega1 = 1./period2
         omega2 = 1./period1
         domega = 1./dperiod
         
      elseif (omega1 .ne. 0. .and. omega2 .ne. 0. .and. omega1
     + .eq. omega2) then
	domega = omega1

      elseif (omega1 .eq. 0. .and. omega2 .eq. 0. .and. period1 
     +        .ne. 0. .and.  period2 .eq. 0.) then
         period2 = iwind * nsi * UnitSc
         omega2 = 1./period1
         omega1 = 1./period2
         
      elseif (omega1 .eq. 0. .and. omega2 .eq. 0. .and. period1
     +        .eq. 0. .and.  period2 .ne. 0.) then
         period1 = 2. * nsi * UnitSc
	 omega1 = 1./period2
         omega2 = 1./period1
         
      elseif (omega1 .eq. 0. .and. omega2 .eq. 0. .and. period1
     +        .ne. 0. .and.  period2 .ne. 0.) then
	 omega1 = 1./period2
	 omega2 = 1./period1
         domega = 1./dperiod
         
      endif
      
c====================================================================
c     now put everything into fequency
c====================================================================
c     Policeman:  for a single input of f1, make sure the code understands
c     that it is only to process the one frequency.
      
      if (period1 .eq. 0. .and. period2 .eq. 0. .and.
     +     omega2 .eq. 0. .and. omega1 .ne. 0. .and. omega2
     +     .ne. 0. ) then
         
         omega2 = omega1
	 domega = omega1
      endif
c====================================================================
c     Calculate the number of time samples for output and number of 
c     frequency decompositions at each time sample
      
      nsamp2 = 0
      write(LERR,*)' '
      write(LERR,*)' Output volume   Central Sample  Central Time'
      write(LERR,*)' -------------   --------------  ------------'
      write(LERR,*)' '

      do i = ist, iend, nskip
         nsamp2 = nsamp2 + 1
         write(LERR,'(4x,i5,10x,i6,10x,i6)' ) nsamp2, i, (i-1)*nsi
      enddo

      write(LERR,*)' '

      nomega = ((omega2-omega1)/domega) + 1

c Policeman to cover for Gridleys hardwire of 256 on the second dimension
c of sum()

      if ( nomega .gt. 256 ) then
         write(lerr,*)' '          
         write(lerr,*)' number of frequencies greater than 256 not'
         write(lerr,*)' allowed, call USP shop for program upgrade'
         write(lerr,*)'FATAL'          
         write(ler,*)'RWSPEC: '          
         write(ler,*)' number of frequencies greater than 256 not'
         write(ler,*)' allowed, call USP shop for program upgrade'
         write(ler,*)'FATAL' 
         stop
      endif

c====================================================================
c     Policeman to keep the number of output samples below USP maximum
      
      if (nsamp2*nomega .gt. 9500) then 
         
         write(LER,*)' '
         write(LER,*)'rwspec:  WARNING:'
         write(LER,*)' '
         write(LER,*)'The number of output samples',nsamp2*nomega,
     :        ' exceeds'
         write(LER,*)'system limits.  Recalculate your parameters ' 
         write(LER,*)'so that the number of output samples does not'
         write(LER,*)'exceed 9500.'
         write(LERR,*)'The number of output samples',nsamp2*nomega,
     :        ' exceeds'
         write(LERR,*)'system limits.  Recalculate your parameters ' 
         write(LERR,*)'so that the number of output samples does not'
         write(LERR,*)'exceed 9500.'
         write(LER,*)' '
         write(LER,*)'rwspec: Abnormal Termination'
         write(LER,*)' '
         write(LERR,*)' '
         write(LERR,*)'rwspec: Abnormal Termination'
         write(LERR,*)' '
         go to 997
      endif
      
c dynamic memory allocation

      sum_size = nsamp * nomega
      table_size = ( iwind + 2 ) * nomega * 2
      t_size = iwind+2

      call galloc ( mem_sum, sum_size * SZSMPD, errcd1, abort)
      call galloc ( mem_ctable, table_size * SZSMPD, errcd2, abort )
      call galloc ( mem_t, t_size * SZSMPD, errcd3, abort )
      call galloc ( mem_tri_buffer, t_size * SZSMPD, errcd4, abort )

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) sum_size * SZSMPD, '  bytes'
         write(LERR,*) table_size * SZSMPD, '  bytes'
         write(LERR,*) 2*t_size * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) sum_size * SZSMPD, '  bytes'
         write(LER,*) table_size * SZSMPD, '  bytes'
         write(LER,*) 2*t_size * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) sum_size * SZSMPD, '  bytes'
         write(LERR,*) table_size * SZSMPD, '  bytes'
         write(LERR,*) 2*t_size * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( sum, 1, sum_size )
      call vclr ( t, 1, t_size )
      call vclr ( ctable, 1, table_size )
      call vclr ( tri_buffer, 1, t_size )

c update and write the output line header

      nsampo = nsamp2 * nomega
      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      obytes = SZTRHD + SZSMPD * nsampo 

      call savew( lhed, 'NumTrc', ntrco  , LINHED)
      call savew( lhed, 'NumRec', nreco, LINHED)
      call savew( lhed, 'NumSmp', nsampo, LINHED)
      call savew(lhed, 'SmpInt', nsi*nskip   , LINHED)

c load line header variables to allow identification of frequency 
c as a function of sample in downstream applications

      call savew ( lhed, 'SmpFlt', domega, LINHED)
      call savew ( lhed, 'FreQst', omega1 , LINHED)
      call savew ( lhed, 'FreQnd', omega2 , LINHED)

      call savhlh( lhed, lbytes, lbyout)
      call wrtape ( luout, lhed, lbyout )

c verbose output of input parameterization

      call verbal( ntap, otap, ist, iend, ns, ne, irs, ire,
     :     nsi, trbias, opbias, window, itw, nskip, land, verbos,
     :     omega1, omega2, domega, gaus,
     :     period1, period2, dperiod, phase, ntrc, nrec, nsamp,
     :     ntrco, nreco, nsampo, nsamp2, nomega, normal_live, 
     :     normal_energy  )
      
c PRECALCULATE TABLES

      call Tables ( ctable, iwind, nomega, opbias, gaus, t, itw, 
     :     ihalf, pie, omega1, omega2, domega, dt )

C BEGIN PROCESSING

c skip to start record

      call recskp ( 1, irs-1, luin, ntrc, lhed )

      DO JJ = irs, ire

c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, lhed )
         
         DO KK = ns, ne

c clear trace time series buffer

            call vclr ( tri, 1, nsamp )
  
c read an input trace
         
            nbytes = 0
            call rtape  ( luin , lhed, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c check for dead trace

            call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,
     1           StaCor, TRACEHEADER)

c process only live traces
            
            IF ( StaCor .ne. 30000) THEN

               call vmov (lhed(ITHWP1), 1, tri, 1, nsamp) 

               call Decompose ( tri, nsamp, tri_buffer, t_size, ist, 
     :              iend, nskip, trbias, nomega, iwind, ihalf, ctable, 
     :              t, sum, radeg, phase, smax, normal_live, 
     :              normal_energy )

               call BuildTrace ( sum, nsamp, nomega, ist, iend, ihalf, 
     :              nskip, tri_out )

            ELSE

c this is a dead trace, make sure output is zero

               call vclr ( tri_out, 1, nsampo )

            ENDIF
            
c output the trace      

            call vmov (tri_out, 1, lhed(ITHWP1), 1, nsampo )
            call wrtape(luout,lhed,obytes)
            
         ENDDO

c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, lhed )

      ENDDO
      
 999  continue
      
      call lbclos(luin)

c again if -int was included on the command line then the user will want to 
c scale this data for 8 bit display.

      if ( land ) goto 1000

      call lbclos(luout)
      write(LERR,*)' Normal Termination'
      write(LER,*)'rwspec: Normal Termination'

      stop

c 8 bit scaling if requested

 1000 continue

      call rwd(luout)

c  swap luout into luin as luout at this point is the temporary
c  file.  Reassign luout with a new getln to provide a real 
c  fortran attachment for the output dataset

      luin = luout
      call getln(luout, otap, 'w', 1)
c====================================================================
c     read lineheader; save key parameters; modify parameters;
c     update header; write out header
      
      lbytes = 0
      call rtape  ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'no header read on temporary file'
         write(LERR,*)'this is very bad...call USP shop as '
         write(LERR,*)'something is hosed in the code'
         write(LERR,*)'FATAL'
         write(LERR,*)'RWSPEC:'
         write(LERR,*)' no header read on temporary file'
         write(LERR,*)' this is very bad...call USP shop as '
         write(LERR,*)' something is hosed in the code'
         write(LERR,*)'FATAL'
         stop
      endif

      call hlhprt ( lhed , lbytes, name, 6, LERR )
      
c====================================================================
c     save certain parameters
      
      call saver(lhed, 'NumSmp', nsamp , LINHED)
      call saver(lhed, 'SmpInt', nsi   , LINHED)
      call saver(lhed, 'NumTrc', ntrc  , LINHED)
      call saver(lhed, 'NumRec', nrec  , LINHED)
      
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
      
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      
      
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      
      nrecc = nrec
      
      call savew( lhed, 'NumSmp', nsamp , LINHED)

c====================================================================
      obytes = SZTRHD + SZSMPD * nsamp

      CALL WRTAPE ( LUOUT, lhed, lbytes   )
c====================================================================

      DO JJ = 1, nrec

         do KK = 1, ntrc

            nbytes = 0
            call rtape  ( luin , lhed, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 998
            endif
            call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
         
            call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,
     1        StaCor, TRACEHEADER)
            
            IF ( StaCor .ne. 30000) THEN

               do i=1,nsamp
                  tri(i)=(tri(i)*(255./smax))-127.
               enddo

            ENDIF
         
            call vmov (tri, 1, lhed(ITHWP1), 1, nsamp)
            call wrtape(luout,lhed,obytes)
         
         ENDDO
      ENDDO
      
 998  continue
      
      write(LER,*)'rwspec:  Normal Termination'
      write(LERR,*)'rwspec:  Normal Termination'
      
 997  call lbclos(luin)
      call lbclos(luout)
      
      stop
      END
      
c---------------------------------------
c     online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>
      
      write(LER,*)' '
      write(LER,*)'         COMMAND LINE ARGUMENTS FOR rwspec'
      write(LER,*)' '
      write(LER,*)'_Input___________Description___________(default)__'
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'-N[ntap]   -- input data set name'
      write(LER,*)'-O[otap]   -- output data set name'
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Design windows:'
      write(LER,*)'-s[ist]  -- start time                    (0 ms)'
      write(LER,*)'-e[iend] -- end time                 (last samp)'
      write(LER,*)'-win[window] -- Window Length             (0 ms)'
      write(LER,*)'-taper[itw] -- Percent Cosine Taper        (0 %)'
      write(LER,*)'-G -- Use Gausian Taper       (no -taper needed)'
      write(LER,*)'-------------------------------------------------'
      write(LER,*)'Desired frequency:'
      write(LER,*)'-fmin[omega1]   -- desired min frequency   (0 hz)'
      write(LER,*)'-fmax[omega2]   -- desired max frequency   (0 hz)'
      write(LER,*)'-fint[domega]   -- desired frequency increment   '
      write(LER,*)'                                           (1 hz)'
      write(LER,*)'-dto[dtout] -- Output Sample Rate      (Input dt)'
      write(LER,*)'-pmin[period1]  -- desired min period      (2*dt)'
      write(LER,*)'-pmax[period2]  -- desired max period       (win)'
      write(LER,*)'-pint[dperiod]  -- desired period increment'
      write(LER,*)'                          (period2 - period1 / 3)'
      write(LER,*)'------------------------------------------------ '
      write(LER,*)'Trace/record limitation:'
      write(LER,*)'-ns[ns]   -- start process trc #       (first tr)'
      write(LER,*)'-ne[ne]   -- end process trc #          (last tr)'
      write(LER,*)'-rs[irs]  -- start process rec #      (first rec)'
      write(LER,*)'-re[ire]  -- end process rec  #        (last rec)'
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Program Options:'
      write(LER,*)'-int       -- Scale data for Landmark conversion'
      write(LER,*)'-trbias      -- remove bias from trace'
      write(LER,*)'-opbias    -- remove bias from operator'
      write(LER,*)'-energy    -- normalize on energy in window'
      write(LER,*)'-live      -- normalize on number of live samples in 
     :window'
      write(LER,*)'-phase     -- Output phase response'
      write(LER,*)'-V         -- verbos printout'
      write(LER,*)' '
      write(LER,*)'=================================================='
      write(LER,*)'Usage:'
      write(LER,*)' rwspec -N[] -O[] -s[] -e[]  -ns[] -ne[] -rs[] '
      write(LER,*)' -re [] -fmin[] -fmax[] -win[] -taper[] -dto[]' 
      write(LER,*)' -fint[] -pmin[] -pmax[] -pint[] '
      write(LER,*)' [-G -energy -live -trbias -opbias -int -phase -V] ]'
      write(LER,*)'=================================================='
      write(LER,*)' '
      write(LER,*)' '
      
      return
      end
      
c-----
c     get command arguments
c     
c     ntap  - C*256  input file name
c     otap  - C*256  output file name
c     vtap  - C*256  velocity tape file
c     s   - I      start time
c     e   - I      stop time
c     ns   - I      start trace
c     ne   - I      stop trace
c     irs   - I      start record
c     ire   - I      end record
c     verbos - L      verbose output or not
c-----
      subroutine cmdln( ntap, otap, ist, iend, ns, ne, irs, ire,
     1     trbias, opbias, window, itw, nskip, land, verbos,
     2     omega1, omega2, domega, gaus, period1, period2 ,dperiod, 
     3     phase, normal_live, normal_energy )
      
#include <f77/iounit.h>
      integer    ist,iend,ns,ne,irs,ire, argis
      integer    window,itw
      integer    nskip

      real       omega1,omega2,domega
      real       period1,period2,dperiod

      character  ntap*(*), otap*(*)

      logical    verbos,land,gaus,phase, trbias, opbias

      call argi4 ('-dto', nskip ,1,1)     

      normal_energy   = ( argis( '-energy' ) .gt. 0 )
      call argi4 ('-e',  iend ,0,0) 

      call argr4 ('-fint', domega ,1.,1.)
      call argr4 ('-fmax', omega2 ,0.,0.)
      call argr4 ('-fmin', omega1 ,0.,0.)

      gaus   = ( argis( '-G' ) .gt. 0 )

      land   = ( argis( '-int' ) .gt. 0 )

      normal_live   = ( argis( '-live' ) .gt. 0 )

      call argi4 ('-ne', ne ,0,0)
      call argi4 ('-ns', ns ,0,0)
      call argstr ('-N', ntap ,' ',' ')

      opbias   = ( argis( '-opbias' ) .gt. 0 )
      call argstr ('-O', otap ,' ',' ')

      phase   = ( argis( '-phase' ) .gt. 0 )
      call argr4 ('-pint', dperiod ,0.,0.)
      call argr4 ('-pmax', period2 ,0.,0.)
      call argr4 ('-pmin', period1 ,0.,0.)
      
      call argi4 ('-re', ire ,0,0)
      call argi4 ('-rs', irs ,1,1)
     
      call argi4 ('-s',  ist ,1,1) 

      trbias   = ( argis( '-trbias' ) .gt. 0 )
      call argi4 ('-taper',itw ,100,100)

      verbos   = ( argis( '-V' ) .gt. 0 )

      call argi4 ('-win', window ,0,0)

      return    
      end
