/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _colorEditor_h
#define _colorEditor_h

/* public include file for use with the Color Editor colorEditor.c */

/* creates but does not display the color editor -- must be called
   before calling any other of the color editor public functions */
Widget CreateColorEditor(Widget topwidget,char *applx,char *subclassx);

/* if value set to 1 -- no limits are display -- set to 0 limits displayed
   by default limits are displayed */
void Set_Color_Limit_Switch(int value);

/* allows changing of defaults -2047 and 2047 to application defined
   need to call this function before calling DisplayColorEditor */
void SetDefaultColorLimits(double b1, double b2);

/* displays color editor */
Widget DisplayColorEditor(void);

/* gets the limit for color num (0 - get_num_colors()-1) */
float get_limit(int num);

/* gets color pixel matching amplitude amp */
Pixel get_color(double amp);

/* gets the number of colors currently defined */
int get_num_colors(void);

/* gets the pixel for color num (0 - get_num_colors()-1) */
Pixel get_pixel(int num);

/* callback function needed in your program -- must be same name 
   this is called whenever the color limits are changed */
void limits_change(Colormap default_colormap);

#endif
