/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <specal.h>

#define EXTERN_KEY

#include <globals.h>
#include <colorch.h>

#define min(a,b)  (((a)<(b)) ? (a): (b))
#define max(a,b)  (((a)<(b)) ? (b): (a))

static int button1_flag=0;

void zoomCB();
void button_pushEH();
void button_releaseEH();
void moving_mouseEH();

static int first_time = 1;

static int scale_x[10],scale_y[10];
static int start_x[10], start_y[10];
static int width[10], height[10];
static int xxwidth[10], xxheight[10];
static int s_x[10], s_y[10], e_x[10], e_y[10];
static int zoom_flag[10];

static XImage *image;
static char *new_data, *old_data;

static XGCValues zoom_gcbvals;
/*static GC zoom_gcb;*/
static int zoom_def[10];

/* This function handles all pushed mouse button events.  */

void button_pushEH(w,client_data,event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	int id;
	id = (int)client_data;

/**********************************************************/

  	if (event->xbutton.button==Button1)
    		button1_flag=1;

  	s_x[id]=event->xbutton.x;
  	s_y[id]=event->xbutton.y;

  	start_x[id]=s_x[id];
  	start_y[id]=s_y[id];

  	e_x[id]=0;
  	e_y[id]=0;

  	width[id]=0;
  	height[id]=0;

  	zoom_flag[id]=1;
}


/* This function handles all released mouse button events.  */
void button_releaseEH(w,client_data,event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
  	int id;
  	int n;
  	Arg   args[5];
	int endx, endy;

/**********************************************************/

  	id = (int)client_data;

  	if (event->xbutton.button==Button1)
    		button1_flag=0;

    	if (event->xbutton.button!=Button1) return;
    	if (zoom_flag[id]!=1) return;

  	zoom_flag[id]=0;


  	XSetFunction(display,Info2d[id].gc2,GXequiv);

  	XSetLineAttributes(display,Info2d[id].gc2,0,
                     LineSolid,CapNotLast,JoinRound);

  	XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 start_x[id],start_y[id],width[id],height[id]);

  	e_x[id] = event->xbutton.x;
  	e_y[id] = event->xbutton.y;

	if(e_x[id] < 0) e_x[id] = 0;
	if(e_x[id] > Info2d[id].pixwidth2-1) e_x[id] = Info2d[id].pixwidth2-1;
	if(e_y[id] < 0) e_y[id] = 0;
	if(e_y[id] > Info2d[id].can_hi2-1) e_y[id] = Info2d[id].can_hi2-1;

  	endx=e_x[id]-s_x[id];
  	endy=e_y[id]-s_y[id];

  	if (endx < 0) {
    		start_x[id]=e_x[id];
    		width[id]=(-1)*endx + 1;
  	} else {
    		start_x[id]=s_x[id];
    		width[id]=endx + 1;
  	}

  	if (endy < 0) {
    		start_y[id]=e_y[id];
    		height[id]=(-1)*endy + 1;
  	} else {
    		start_y[id]=s_y[id];
    		height[id]=endy + 1;
  	}

  	XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 start_x[id],start_y[id],width[id],height[id]);

  	XSetLineAttributes(display,Info2d[id].gc2,line_width,
                     LineSolid,CapNotLast,JoinRound);

  	XSetFunction(display,Info2d[id].gc2,GXcopy);

        Info2d[id].zoomx = start_x[id];
        Info2d[id].zoomy = start_y[id];
        Info2d[id].zoomwid = width[id];
        Info2d[id].zoomht = height[id];



/* remove event handlers for zoom window -- from xsd */
  	XtRemoveEventHandler(Info2d[id].drawa,ButtonPressMask,False,
		(XtEventHandler)button_pushEH, (XtPointer)Info2d[id].thisn);
  	XtRemoveEventHandler(Info2d[id].drawa,ButtonReleaseMask,False,
		(XtEventHandler)button_releaseEH, (XtPointer)Info2d[id].thisn);
  	XtRemoveEventHandler(Info2d[id].drawa,PointerMotionMask,False,
		moving_mouseEH, (XtPointer)Info2d[id].thisn);

	zoomCB(id);
	/*zoomCB(1);*/

}


/* This function handles all mouse movement events.  */
void moving_mouseEH(w,client_data,event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
  	int id;
	int endx, endy;

/*******************************************************************/

  	id = (int)client_data;

  	if (button1_flag) {
  	if (event->xbutton.button!=Button1) return;
  	if (zoom_flag[id]!=1) return;

  	XSetFunction(display,Info2d[id].gc2,GXequiv);

  	XSetLineAttributes(display,Info2d[id].gc2,0,
                     LineSolid,CapNotLast,JoinRound);

  	XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 start_x[id],start_y[id],width[id],height[id]);

  	e_x[id] = event->xbutton.x;
  	e_y[id] = event->xbutton.y;

	if(e_x[id] < 0) e_x[id] = 0;
	if(e_x[id] > Info2d[id].pixwidth2-1) e_x[id] = Info2d[id].pixwidth2-1;
	if(e_y[id] < 0) e_y[id] = 0;
	if(e_y[id] > Info2d[id].can_hi2-1) e_y[id] = Info2d[id].can_hi2-1;

  	endx=e_x[id]-s_x[id];
  	endy=e_y[id]-s_y[id];

  	if (endx < 0) {
    		start_x[id]=e_x[id];
    		width[id]=(-1)*endx + 1;
  	} else {
    		start_x[id]=s_x[id];
    		width[id]=endx + 1;
  	}

  	if (endy < 0) {
    		start_y[id]=e_y[id];
    		height[id]=(-1)*endy + 1;
  	} else {
    		start_y[id]=s_y[id];
    		height[id]=endy + 1;
  	}

  	XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 start_x[id],start_y[id],width[id],height[id]);

  	XSetLineAttributes(display,Info2d[id].gc2,line_width,
                     LineSolid,CapNotLast,JoinRound);

  	XSetFunction(display,Info2d[id].gc2,GXcopy);

        Info2d[id].zoomx = start_x[id];
        Info2d[id].zoomy = start_y[id];
        Info2d[id].zoomwid = width[id];
        Info2d[id].zoomht = height[id];

  }
}

XtEventHandler handle_odomzCB (w, sp, event)
	Widget w ;
	caddr_t sp;
	XEvent *event ;
{
	int id;
   	char   string[80] ;
   	int    ex, ey;
   	int    ax, ay;
   	int    get_x, get_y;
   	Arg args[10];
   	float tf, sf;
   	float temp, temp1, *f1;
	int xfac, yfac;

/**************************************************************/

	id = (int)sp;

   	switch (event->type) {

   	case MotionNotify :

      		ex = event->xmotion.x ;
      		ey = event->xmotion.y ;

        	ax = ex / scale_x[id];
        	ay = ey / scale_y[id];

        	ax = ax + start_x[id];
        	ay = ay + start_y[id];

    		if(ax < Info2d[id].xpos || ay < Info2d[id].ypos ||
			ax >(Info2d[id].pixwidth2-11) || 
			ay > (9 + ph1) ) {

			sprintf(string, " ");
    		}
    		else {

        		get_x = ax - Info2d[id].xpos;
        		get_y = ay - Info2d[id].ypos;

			xfac = get_x/Info2d[id].fact2;
			yfac = get_y/Info2d[id].fact2;

        		tf = (float)(Info2d[id].ncmplx2 - 1 - yfac) 
				* Info2d[id].freqi2;
        		sf = ((float)(xfac) / (float)(Info2d[id].leng2)) - .5;

        
			f1 = Info2d[id].amp;
        		f1 += ((Info2d[id].ncmplx2 - 1 - yfac)
				*(Info2d[id].leng2+1) + xfac);
        
			temp = (*f1);
        		temp1 = temp*Info2d[id].fscal;
		        /*temp1 = temp*fscale;*/

        		sprintf(string,"tf=%5.1f sf=%5.3f amp=%g norm.amp=%10.5f",
           				tf, sf, temp, temp1);
   		}


           	update_odometer2(string, id) ;
           	/*update_odometer(string) ;*/
      		break ;

   	case LeaveNotify :
/* **    Blank out odometer and clear hyperbola if we just left the window */
      		update_odometer2 (" ", id) ;
      		/*update_odometer (" ") ;*/
      		break ;

   	default :
/*
**    This should never happen !!!!!
*/
      		printf("\nunknown event received in handle_eventsCB") ;
      		break ;
   }
}

/* The function performs the zoom of the raster data.  */
void zoomCB(id)
	int id;
{
  	int i,j,k,m,n;
  	int x,y;
  	char *str;
  	unsigned char *data;
  	int get_x, get_y;

   	char *ydata, *xdata;

        char  *ydatac, *xdatac;
        short  *ydatas, *xdatas;
        int  *ydatal, *xdatal;

        int ip;

	Arg args[10];
	Cursor cursor1;
	extern XtEventHandler handle_odomzCB();
   	int vval, vss, vir, vpir, hval, hss, hir,hpir;
   	Boolean	what;
   	String string;

	int dpthrast, quantum;

/******************************************************************/
        if(depth == 8)  {
           dpthrast=sizeof(char);
           quantum=8;
        }
        else if(depth == 15 || depth ==16 )  {
           dpthrast=2*sizeof(char);
           quantum=16;
        }
        else if(depth == 24 || depth ==32 )  {
           dpthrast=4*sizeof(char);
           quantum=32;
        }

	what = True;

        XSynchronize(display, True);

	if((width[id] % 4) != 0) {
        	width[id] = width[id] - (width[id] % 4);
        	e_x[id] = e_x[id] - (width[id] % 4);
	}

        Info2d[id].xwidth = width[id] * scale_x[id];
        Info2d[id].xheight = height[id] * scale_y[id];

        xxwidth[id] = Info2d[id].xwidth + 40;
        xxheight[id] = Info2d[id].xheight + 40;

        n = 0;
        XtSetArg(args[n], XmNwidth, Info2d[id].xwidth); n++;
        XtSetArg(args[n], XmNheight, Info2d[id].xheight); n++;
        XtSetValues(zoomdraw, args,n);

        n = 0;
        if (xxwidth[id] < 700)  {
         	XtSetArg(args[n], XmNwidth, xxwidth[id]); n++;
        }
        else  {
         	XtSetArg(args[n], XmNwidth, 700); n++;
        }

        if (xxheight[id] < 600)  {
         	XtSetArg(args[n], XmNheight, xxheight[id]); n++;
        }
        else  {
         	XtSetArg(args[n], XmNheight, 600); n++;
        }
        XtSetValues(zoomsw, args, n);

        XtAddEventHandler(zoomdraw, PointerMotionMask | LeaveWindowMask,
                False, (XtEventHandler)handle_odomzCB, (XtPointer)id);

        XtManageChild(Info2d[id].zform);
        Info2d[id].zwin = XtWindow(zoomdraw);

/* get and set values for scrollbars */
   	n = 0;
   	XtSetArg (args[n], XmNminimum, &zvmin); n++;
   	XtSetArg (args[n], XmNmaximum, &zvmax); n++;
   	XtGetValues(Info2d[id].zvsb, args, n);

   	n = 0;
   	XtSetArg (args[n], XmNminimum, &zhmin); n++;
   	XtSetArg (args[n], XmNmaximum, &zhmax); n++;
   	XtGetValues(Info2d[id].zhsb, args, n);

	XmScrollBarGetValues(Info2d[id].zvsb, &vval,&vss, &vir, &vpir);
	XmScrollBarSetValues(Info2d[id].zvsb, zvmax - vss, vss, vir, vpir, what);

	XmScrollBarGetValues(Info2d[id].zhsb, &hval, &hss, &hir, &hpir);
	XmScrollBarSetValues(Info2d[id].zhsb, zhmin, hss, hir, hpir, what);

/* end of getting and setting values */

        if(Info2d[id].zoompix != (Pixmap)NULL)
		XFreePixmap(display, Info2d[id].zoompix);

        Info2d[id].zoompix = XCreatePixmap(display, Info2d[id].zwin,
                    Info2d[id].xwidth, Info2d[id].xheight, depth);

        zoom_gcbvals.foreground = WhitePixel(display, DefaultScreen(display));
        zoom_gcbvals.background = BlackPixel(display, DefaultScreen(display));

        XChangeGC(display, Info2d[id].gc2, GCForeground|GCBackground,
          &zoom_gcbvals);

        XFillRectangle(display, Info2d[id].zoompix, Info2d[id].gc2, 0,0,
        		Info2d[id].xwidth, Info2d[id].xheight);

        zoom_gcbvals.foreground = BlackPixel(display, DefaultScreen(display));
        zoom_gcbvals.background = WhitePixel(display, DefaultScreen(display));

        XChangeGC(display, Info2d[id].gc2, GCForeground|GCBackground,
          	&zoom_gcbvals);

        old_data = (char *)calloc(width[id]*height[id], dpthrast);
        new_data = (char *)calloc(Info2d[id].xwidth*Info2d[id].xheight, dpthrast);

        image = XCreateImage(display, DefaultVisual(display, DefaultScreen(display)),
           depth, ZPixmap, 0, old_data, width[id], height[id], quantum, 0);

        get_x = min(s_x[id], e_x[id]);
        get_y = min(s_y[id], e_y[id]);

        image = XGetImage(display, Info2d[id].pixmap2,
                  get_x, get_y, width[id], height[id], AllPlanes, ZPixmap);

        /*image->height = height[id];
        image->bytes_per_line = width[id];*/

/* ** do the duplication */

        /*ydata = new_data;
        xdata = image->data;*/

        for (i=0; i<height[id]; i++) {
         	/*ydata = new_data + i * scale_y[id] * Info2d[id].xwidth;*/

        	if(depth == 8) 
	          ydatac = 
			(char *)(new_data+(i*scale_y[id]*Info2d[id].xwidth*dpthrast)); 
        	else if(depth == 15 || depth ==16 ) 
	          ydatas = 
			(short *)(new_data+(i*scale_y[id]*Info2d[id].xwidth*dpthrast));
        	else if(depth == 24 || depth ==32 ) 
	          ydatal = 
			(int *)(new_data+(i*scale_y[id]*Info2d[id].xwidth*dpthrast));

         	for (j=0; j<scale_y[id]; j++) {

          		/*xdata = image->data + i*width[id];*/

        	    	if(depth == 8) 
	              		xdatac = (char *)(image->data+(i*width[id]*dpthrast));
        	    	else if(depth == 15 || depth ==16 ) 
	              		xdatas = (short *)(image->data+(i*width[id]*dpthrast));
        	    	else if(depth == 24 || depth ==32 ) 
	              		xdatal = (int *)(image->data+(i*width[id]*dpthrast));

          		for (k=0; k < width[id]; k++) {

           			for (m=0;m<scale_x[id];m++) {

            			   /*memcpy(ydata,xdata,1);
            			   ydata++;*/

                                   if(depth == 8) {
			 	      memcpy(ydatac,xdatac,dpthrast);
                                      ydatac++;
                                    }
                                    else if(depth == 15 || depth ==16 ) {
                                      memcpy(ydatas,xdatas,dpthrast);
                                      ydatas++;
                                    }
                                    else if(depth == 24 || depth ==32 ) {
                                      memcpy(ydatal,xdatal,dpthrast);
                                      ydatal++;
                                    }
           			}

           			/*xdata++;*/
              			if(depth == 8) xdatac++;
              			else if(depth == 15 || depth ==16 ) xdatas++;
              			else if(depth == 24 || depth ==32 )  xdatal++;
          		}
         	}
        }

	if(new_image) {
        	new_image->data = NULL;
        	XDestroyImage(new_image);
	}

        new_image = XCreateImage(display,
          	DefaultVisual(display, DefaultScreen(display)),
           	depth, ZPixmap, 0, new_data, Info2d[id].xwidth, Info2d[id].xheight, 
	   	quantum, 0);

        /*new_image->bytes_per_line = Info2d[id].xwidth;*/

        XPutImage(display, Info2d[id].zoompix, Info2d[id].gc2,
                  new_image, 0, 0, 0, 0, Info2d[id].xwidth, Info2d[id].xheight);

        XCopyArea(display, Info2d[id].zoompix, Info2d[id].zwin, Info2d[id].gc2,
           0, 0, Info2d[id].xwidth, Info2d[id].xheight, 0, 0);

        copy_pix = True;

        image->data = NULL;
        XDestroyImage(image);

        XSynchronize(display, False);

        free(new_data);
        free(old_data);

   	cursor1 = XCreateFontCursor (display, XC_plus) ;
   	XDefineCursor(display, Info2d[id].zwin, cursor1) ;

}

void zoom_allCB(w,client_data,event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{

  	extern Widget create_zoom_box();
  	int n;
  	Arg   args[5];
  	int id;
  	String string;
  	String get_val();

/***********************************************************/

  	if(first_time == 1) {
		for (n=0; n<10; n++) {
			scale_x[n] = 1;
			scale_y[n] = 1;
			zoom_flag[n] = 0;
			zoom_def[n] = 0;
        	}
  		first_time = 0;
  	}

  	id = (int)client_data;

/* retrieve the zoom scale parameters */
   	/*XtSetArg(args[0], XmNvalue, &string);
   	string = NULL;

   	XtGetValues(ztexts[0], args[0], 1);*/
   	string = get_val(ztexts[0],args);
   	sscanf(string,"%d", &scale_x[id]);

   	/*XtGetValues(ztexts[1], args[0], 1);*/
   	string = get_val(ztexts[1],args);
   	sscanf(string,"%d", &scale_y[id]);


	if(zoom_def[id] == 0) {
		Info2d[id].zform = create_zoom_box(id);
		zoom_def[id] = 1;
	}

   	if(scale_x[id]  == 0)
      		scale_x[id] = 1 ;
   	if(scale_y[id] == 0)
      		scale_y[id] = 1;

/* set up event handlers for zoom window -- from xsd */

  	XtAddEventHandler(Info2d[id].drawa,ButtonPressMask,False,(XtEventHandler)button_pushEH,
        	(XtPointer)id);
  	XtAddEventHandler(Info2d[id].drawa,ButtonReleaseMask,False,(XtEventHandler)button_releaseEH,
        	(XtPointer)Info2d[id].thisn);
        	/*id);*/
  	XtAddEventHandler(Info2d[id].drawa,PointerMotionMask,False,
		(XtEventHandler)moving_mouseEH, (XtPointer)id);

/* ......end of setupt for zoom */


        if(Info2d[id].zoomTF) {
  		XSetFunction(display,Info2d[id].gc2,GXequiv);

  		XSetLineAttributes(display,Info2d[id].gc2,0,
                     LineSolid,CapNotLast,JoinRound);

  		XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 		Info2d[id].zoomx,Info2d[id].zoomy,Info2d[id].zoomwid,
		 		Info2d[id].zoomht);
  		XSetLineAttributes(display,Info2d[id].gc2,line_width,
                     LineSolid,CapNotLast,JoinRound);

  		XSetFunction(display,Info2d[id].gc2,GXcopy);
        }
        else
                Info2d[id].zoomTF = 1;

    		if (event->xbutton.button!=Button1) return;
    		if (zoom_flag[id]!=1) return;

  		zoom_flag[id]=0;

/* remove event handlers for zoom window -- from xsd */
  		XtRemoveEventHandler(Info2d[id].drawa,ButtonPressMask,False,
			(XtEventHandler)button_pushEH, (XtPointer)id);

  		XtRemoveEventHandler(Info2d[id].drawa,ButtonReleaseMask,False,
			(XtEventHandler)button_releaseEH, (XtPointer)Info2d[id].thisn);
                          /*id);*/

  		XtRemoveEventHandler(Info2d[id].drawa,PointerMotionMask,False,
			(XtEventHandler)moving_mouseEH, (XtPointer)id);

}

void zoom_free(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int id;
/*********************************************************/

	id = (int)client_data;

        if(Info2d[id].zoomTF) {
  		XSetFunction(display,Info2d[id].gc2,GXequiv);

  		XSetLineAttributes(display,Info2d[id].gc2,0,
                     LineSolid,CapNotLast,JoinRound);

  		XDrawRectangle(display,XtWindow(Info2d[id].drawa),Info2d[id].gc2,
                 	Info2d[id].zoomx,Info2d[id].zoomy,Info2d[id].zoomwid,
		 	Info2d[id].zoomht);
  		XSetLineAttributes(display,Info2d[id].gc2,line_width,
                     	LineSolid,CapNotLast,JoinRound);
		
  		XSetFunction(display,Info2d[id].gc2,GXcopy);

          
  		Info2d[id].zoomx = 0;
          	Info2d[id].zoomy = 0;
          	Info2d[id].zoomwid = 0;
          	Info2d[id].zoomht = 0;
          	Info2d[id].zoomTF = 0;
        }
}
