/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <localsys.h>

#include <unistd.h>

#include <Xm/Xm.h>
#include <Xm/ToggleBG.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/LabelG.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/SeparatoG.h>
#include <Xm/BulletinB.h>
#include <Xm/SelectioB.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrollBar.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>

#define CHANGE_LIMITS                9901
#define LOAD_PLTR                    9902
#define SAVE_PLTR                    9903
#define DELETE_PAL                   9904
#define LOAD_PAL                     9905
#define SAVE_PAL                     9906
#define COLOR_INTERP                 9907
#define GRAY_SCALE                   9908
#define RESET_SLIDER                 9909
#define CANCEL_ACTION                9910
#define COLOR_EXIT                   9911
#define COLOR_APPLY                  9912
#define COLOR_CANCEL                 9913
#define COLOR_UNMAP                  9914
#define COLOR_HELP                   9915

#define DIALOG_CARD_CANCEL           9921
#define DIALOG_CARD_ACCEPT           9922
#define DIALOG_LIMIT_CANCEL          9923
#define DIALOG_LIMIT_ACCEPT          9924
#define DIALOG_LIMIT_HELP            9925
#define DIALOG_SAVE_CANCEL           9926
#define DIALOG_SAVE_ACCEPT           9927
#define DIALOG_FILE_ACCEPT           9928
#define DIALOG_SAVEPALETTE_ACCEPT    9929
#define DIALOG_SAVEPALETTE_CANCEL    9930
#define DIALOG_LOAD_ACCEPT           9931
#define DIALOG_LOAD_CANCEL           9932
#define DIALOG_DELETE_ACCEPT         9933
#define DIALOG_DELETE_CANCEL         9934
#define DIALOG_ARBLIMITS_ACCEPT      9935
#define DIALOG_ARBLIMITS_CANCEL      9936

void color2pixel();
void pixel2color();

Widget cform;
extern Colormap colormap;

#define MAX_COLORS 256

Widget color_editor;
extern void unmanageCB();
extern Widget toplevel;

static Widget savepalettes_rowcol;
static Widget pltrsave_widget;

static Display *display;
static int screen;
static int screen_num;

extern Colormap AppCmap; /* Application colormap (private or global) */

Colormap default_cmap;

static Colormap act_default_cmap;
static char *red="red", *blue="blue", *green="green";
static char *dark="dark-\nness", *light="light-\nness";
static char *contrast="contrast  ", *brightness="brightness";
static float linlog_apply, boundary1_apply, boundary2_apply, boundary3_apply;
static float incr_linear_apply, incr_db_apply;
static float linlog_backup, boundary1_backup, boundary2_backup, boundary3_backup;
static float incr_linear_backup, incr_db_backup;
static int num_colors_backup, value_contrast_backup, value_brightness_backup;
static char appl[11];
static char subclass[11];

static unsigned short def_red[MAX_COLORS] = 
{ 0, 0, 0, 0, 0, 20224, 44800, 44800, 44800, 44800, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 44800,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };

static unsigned short def_green[MAX_COLORS] = 
{ 0,   20224, 44800, 44800, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
65280, 44800, 44800, 44800, 44800, 44800, 20224, 20224, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };

static unsigned short def_blue[MAX_COLORS] = 
{ 65280, 44800, 65280, 44800, 65280, 65280, 65280, 65280,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280, 44800,
44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280,
44800, 44800, 44800, 44800, 65280, 65280, 44800, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };

static unsigned long pixel_black, pixel_white;
static unsigned long pixel_red, pixel_green, pixel_blue, pixel_gray, pixel_gray90;
static int num_colors, ncolors;

Widget button[MAX_COLORS], limits[MAX_COLORS-2];
static Widget xbutton[MAX_COLORS], xlimits[MAX_COLORS-2];

static unsigned long int color_pixel[MAX_COLORS];
static XColor color_backup[MAX_COLORS];
static XColor color_save[MAX_COLORS];

static float incr_linear, incr_db;
static float boundary1, boundary2, boundary3;

static int linlog = 1;
static char defaultb1[51], defaultb2[51];
static float color_limits[MAX_COLORS-2];

static char *limitvalue_backup[5];
static char *limitvalue[5] = { "2047.", "0.", "-2047.", "2.0", "2047." };
static int value_contrast=0, value_brightness=0;
XColor current_color;
static int last_moved;
static int last_pos4, last_pos5, pos_diff;
static int count_add_del=0;

static int interp_flag[MAX_COLORS-1];
static char *limitstring[5] = 
{ "Maximum value    ", "Linear Increment ", "Minimum value    ",
  "dB Increment     ", "Value for zero dB" };

/*********************************************/

static char *cardfilename, *pltrfilename, *entry_name;
static double opt1_lin_int, opt1_lin_high, opt1_db_int, opt1_db_zero;
static int opt1_num, opt1_type;
static int selected_item_index;
static char item[300][51];
static int num_items;
static int apply=0;
static int map_flag;
static XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
static FILE *tfp, *fp ,*fph;
static FILE *luin;
static double opt1_lin_int, opt1_lin_high, opt1_db_int, opt1_db_zero;
static short int clr_rr[MAX_COLORS-1], clr_gg[MAX_COLORS-1], clr_bl[MAX_COLORS-1];
static char opt1_str0[11],opt1_str1[11],opt1_str2[11],opt1_str3[11],opt1_str4[11];
static char *parm_temp[5];
static int pos_col, pos_col1, pos_col2, pos_col3, pos_col4;
static int using_defaults;

struct pal_title {
        char length[4];
        short int entry_num;
        char desc[52];
};
 
static struct pal_title titledata;
 
struct pal_rgb {
        char length[4];
        short int num_colors;
        short int contrast;
        short int brightness;
        unsigned short int colors[256][3];
};
 
static struct pal_rgb rgbdata;
 
struct pal_limits {
        char length[4];
        short int limtyp;
        float bound2;
        float incr_lin;
        float bound1;
        float incr_db;
        float bound3;
};
struct pal_arblimits {
        char length[4];
        float pal_arblimits[MAX_COLORS-1];
};
 
static struct pal_limits limitdata;
static struct pal_arblimits arblimitdata;

static float arblimits[MAX_COLORS-1];
static int num_arblimits = MAX_COLORS-1;

Widget arbvalue_text_widgets[MAX_COLORS-1];
 
struct pal_defaults {
        char appl[10];
        char subclass[10];
        char code[4];
        char newline[1];
};
 
static struct pal_defaults defaultdata;
 
/*********************************************/

Widget bb=NULL;
static Widget bbe=NULL;
static Widget button_loadpal=NULL, button_delpal=NULL;
static Widget red_slider=NULL, blue_slider=NULL, green_slider=NULL;
static Widget dark_slider=NULL, light_slider=NULL;
static Widget contrast_slider=NULL, brightness_slider=NULL;
static Widget action[8];
static Widget file_dialog=NULL, savepalette_dialog=NULL, 
		colorlist_dialog=NULL, deletecolorlist_dialog=NULL;
static Widget arb_value_dialog=NULL;
static Widget colorcard_dialog=NULL;
static Widget file_label=NULL;
static Widget palette_text=NULL;
static Widget file_button[2];
static Widget save_dialog=NULL;
static Widget limit_text[6];

static Widget cbar;

static  void create_colorbar();
static  void create_coloreditor_options();
static  void create_savepalette_menu();
static  void create_pltrfile_menu();
static  void set_limit_menu();
static  void color_cb();
static  void slider_moved();
static  void my_slider_moved();
static  void update_color();
static  void getdefaultid();
static  void retrievepalette();
static  void arb_value_dialogCB();
static  void limit_typeCB();

/***************************/
static Widget CreateColorListMenu(), CreateDeleteColorListMenu();
static void openpalette(),getpalette(),setpalette(),deletepalette(),appendpalette();
static void UpdateScreen(),OpenCardFile(),OpenOutputPLTR();
static Boolean SavePLTRFile();
static void savedefaultid(),reset_default_id(),setnewlimits();
static void rgbymc(),ymcrgb();
/***************************/


Visual *visual;
int depth;

int CreateColorEditor (topwidget,applx,subclassx,user_max_colors)
Widget topwidget;
char applx[11], subclassx[11];
int user_max_colors;
{
  int default_depth;
  Visual *default_visual;
  unsigned long int plane_masks[1];
  XVisualInfo visual_info;
  int class;
  int n, i;
  int ret_code;
  int id;
  Arg wargs[51];

  Widget etest;
  int j,istart,iend;
  XColor black,white,rgb_db_def,red,green,blue,gray,gray90;
  int act_max_colors;
  int nplanes;

  static void setzlm();

/* initialize */

  screen_num = 0;
  strcpy( appl, "" );
  strcpy( subclass, "" );
  strcpy( defaultb1, "" );
  strcpy( defaultb2, "" );

  last_moved = 0;
  using_defaults = 1;

  for( i=0;i<MAX_COLORS;i++ ) {
    color_pixel[i] = 0;
  }
  for( i=0;i<MAX_COLORS-2;i++ ) {
    color_limits[i] = 0.0;
  }
  for( i=0;i<MAX_COLORS;i++ ) {
     button[i] = NULL;
     xbutton[i] = NULL;
  }
  for( i=0;i<MAX_COLORS-2;i++ ) {
     limits[i] = NULL;
     xlimits[i] = NULL;
  }
  for( i=0;i<MAX_COLORS;i++ ) {
     color_save[i].pixel = 0;
     color_save[i].red = 0;
     color_save[i].green = 0;
     color_save[i].blue = 0;
     color_save[i].flags = ' ';
     color_save[i].pad = ' ';
     color_backup[i].pixel = 0;
     color_backup[i].red = 0;
     color_backup[i].green = 0;
     color_backup[i].blue = 0;
     color_backup[i].flags = ' ';
     color_backup[i].pad = ' ';
  }
  for( i=0;i<5;i++ ) limitvalue_backup[i] = NULL;
  for( i=0;i<MAX_COLORS-1;i++ ) {
     interp_flag[i] = 0;
  }
  for( i=0;i<MAX_COLORS-1;i++ ) {
     arblimits[i] = 0.0;
     arblimitdata.pal_arblimits[i] = 0.0;
  }
  
  display = (Display *)XtDisplay(topwidget);
  screen=XDefaultScreen(display);
  screen_num = DefaultScreen( display );

  act_max_colors = DisplayCells( display, DefaultScreen(display) );
  nplanes = DisplayPlanes (display, screen);
  if (nplanes > 8) act_max_colors = (int)pow((float)act_max_colors,3);

  if( user_max_colors > MAX_COLORS )
     ncolors = MAX_COLORS;
  else
     ncolors = user_max_colors;

  if( ncolors > act_max_colors ) ncolors = act_max_colors;

  pixel_black = BlackPixel(display, screen_num);
  pixel_white = WhitePixel(display, screen_num);

  strcpy( appl, applx );
  strcpy( subclass, subclassx );

  depth=default_depth  = DefaultDepth(display, screen_num);
  visual=default_visual = DefaultVisual(display, screen_num);
  default_cmap = AppCmap;

   if (default_visual->class==TrueColor
      && (default_depth == 15
         || default_depth == 16
         || default_depth == 24))   {
      printf("  Default %d-bit TrueColor\n", default_depth);
   }
   else if (default_visual->class==PseudoColor) {
      printf("  Default %d-bit PseudoColor\n", default_depth);
   }
   else {
      fprintf(stderr,"Non supported Visual. Default Visual must be:\n");
      fprintf(stderr,"8-bit PseudoColor, 16-bit or 24-bit TrueColor.\n");
      exit(1);
   }


   if (default_visual->class==PseudoColor) {
     XAllocNamedColor(display,default_cmap,"white",&white,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"black",&black,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"red",&red,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"green",&green,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"blue",&blue,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"gray",&gray,&rgb_db_def);
     XAllocNamedColor(display,default_cmap,"gray90",&gray90,&rgb_db_def);
   }
   else {
     XLookupColor(display,default_cmap,"white",&rgb_db_def,&white);
     color2pixel(&white,visual,depth);
     XLookupColor(display,default_cmap,"black",&rgb_db_def,&black);
     color2pixel(&black,visual,depth);
     XLookupColor(display,default_cmap,"red",&rgb_db_def,&red);
     color2pixel(&red,visual,depth);
     XLookupColor(display,default_cmap,"green",&rgb_db_def,&green);
     color2pixel(&green,visual,depth);
     XLookupColor(display,default_cmap,"blue",&rgb_db_def,&blue);
     color2pixel(&blue,visual,depth);
     XLookupColor(display,default_cmap,"gray",&rgb_db_def,&gray);
     color2pixel(&gray,visual,depth);
     XLookupColor(display,default_cmap,"gray90",&rgb_db_def,&gray90);
     color2pixel(&gray90,visual,depth);
   }

   pixel_white = white.pixel;
   pixel_black = black.pixel;
   pixel_red = red.pixel;
   pixel_green = green.pixel;
   pixel_blue = blue.pixel;
   pixel_gray = gray.pixel;
   pixel_gray90 = gray90.pixel;


   if (default_visual->class==PseudoColor) {
     while( 1 ) {

       if (XAllocColorCells (display, default_cmap, False,
                             plane_masks, 0, color_pixel, ncolors)) break;
       ncolors--;
       num_colors = ncolors - 1;

       if( ncolors <= 2 ) {
         fprintf(stderr, "Coloredit: Could not allocate read/write colors.\n");
         fprintf(stderr, "           Color editor will be inactive.");
         color_pixel[0] = pixel_white;
         color_pixel[1] = pixel_black;
         ncolors = 2;
         num_colors = 2;

         for (i=0; i< ncolors; i++) {
           color_save[i].red = def_red[i];
           color_save[i].green = def_green[i];
           color_save[i].blue = def_blue[i];
           color_save[i].pixel = color_pixel[i];
           color_save[i].flags = DoRed | DoGreen | DoBlue;
         }
         return( 0 );
       }   
     }
   }

   num_colors = ncolors - 1;

  if (default_visual->class==TrueColor)   {

    for (i=0; i<ncolors; i++) {
      color_save[i].red = def_red[i];
      color_save[i].green = def_green[i];
      color_save[i].blue = def_blue[i];
      color_save[i].flags = DoRed|DoGreen|DoBlue;

      color2pixel(&color_save[i],default_visual,default_depth);
      color_pixel[i]=color_save[i].pixel;

    }
  }
  else if (default_visual->class==PseudoColor) {

    for (i=0; i< ncolors; i++) {
      color_save[i].red = def_red[i];
      color_save[i].green = def_green[i];
      color_save[i].blue = def_blue[i];
      color_save[i].pixel = color_pixel[i];
      color_save[i].flags = DoRed | DoGreen | DoBlue;
    }

    XStoreColors (display, default_cmap, color_save, ncolors);
  }

  current_color.pixel=color_save[0].pixel;
 
/* initialization for setzlm */

   linlog = 1;
   boundary1 = -2047.;
   boundary2 = 2047.;
   boundary3 = 2047.;
   incr_linear = 0.;
   incr_db = 2.;

   setzlm();
 
   for (i=0; i< MAX_COLORS-1; i++) {
     xbutton[i] = NULL;
     if (i < MAX_COLORS-2) xlimits[i] = NULL;
   }
 
   n = 0;
   XtSetArg (wargs[n], XmNdialogTitle, 
         XmStringCreateLtoR ("Color Editor", XmSTRING_DEFAULT_CHARSET));  n++;

   bb = XmCreateBulletinBoardDialog(topwidget, "coloredit", wargs, n);

   create_colorbar();

   create_coloreditor_options();

   /* get the default color palette from default file */

   getdefaultid(&id);
   if (id > 0) {
     openpalette(&ret_code,"rb");
     if (ret_code == 0) retrievepalette(id);
   }


   return( 1 );
}

static void setzlm()
{
        double aainc;
        int ncs, i;

        if (abs(linlog) == 1) {
                aainc = incr_linear;
                if (incr_linear == 0 && num_colors > 2)
                        aainc = (boundary2 - boundary1) / (num_colors - 2);
                for (i=0; i<num_colors-1; i++)
                        color_limits[i] = boundary2 - aainc * ((num_colors-2)-i);
                if (incr_linear == 0 && num_colors > 2) {
                        if (num_colors % 2 == 0 && boundary1 == -boundary2)
                                color_limits[num_colors/2-1] = 0.;
                        color_limits[num_colors-2] = boundary2;
                }
        }
        else if (abs(linlog) == 2) {
                aainc = fabs(incr_db);
                if (aainc < 0.01) aainc = 0.01;
                ncs = num_colors / 2;
                if (ncs*2 == num_colors) {
                        color_limits[ncs-1] = 0.;
                        ncs = ncs - 1;
                }
                for (i=0; i<ncs; i++) {
                        color_limits[i] = -fabs(boundary3) * pow(10., (aainc*(i)/(-20.)));
                        color_limits[num_colors-2-i] = -color_limits[i];
                }
        }
}
int get_limit(num)
int num;
{
        return color_limits[num];
}
int get_num_colors()
{
        return(num_colors);
}
Pixel get_pixel(num)
int num;
{
        if (num < 0 || num >= num_colors) return(-1);
        return color_pixel[num];
}
static void UpdateLimits()
{
        int i;
        char color_limit_str[51];
        Arg wargs[11];

        void setzlm();


        if( linlog == 0 ) {
           for(i=0;i<ncolors-2;i++) {            
                   strcpy( color_limit_str, "" );
                   sprintf(color_limit_str, "%-14.7g", arblimits[i]);
                   if (i > num_colors-2) sprintf(color_limit_str,"%s"," ");
                   XtSetArg(wargs[0], XmNlabelString,
                           XmStringCreateLtoR(color_limit_str,XmSTRING_DEFAULT_CHARSET));
                   XtSetValues(limits[i], wargs, 1);
           }
        }
        else {

           setzlm();

           /*for(i=ncolors-3; i>=0; i--) {*/
           for(i=0;i<ncolors-2;i++) {            
                   strcpy( color_limit_str, "" );
                   sprintf(color_limit_str, "%-14.7g", (-1) * color_limits[i]);
                   sprintf(color_limit_str, "%-14.7g", color_limits[i]);
                   if (i > num_colors-2) sprintf(color_limit_str,"%s"," ");
                   XtSetArg(wargs[0], XmNlabelString,
                           XmStringCreateLtoR(color_limit_str,XmSTRING_DEFAULT_CHARSET));
                   XtSetValues(limits[i], wargs, 1);
   
                   if (xlimits[i] != NULL) XtSetValues(xlimits[i], wargs, 1);
   
   
           }
        }


                   /* Reset current_color to the working color */

                current_color.pixel = color_pixel[ncolors-1];
                if(visual->class == PseudoColor)
                  XQueryColor(display, default_cmap, &current_color);
                else 
                  pixel2color(&current_color,visual,depth);
}

void SetDefaultColorLimits(b1, b2)
float b1, b2;
{
         if( using_defaults ) {
                using_defaults = 0;
                boundary1 = b1;
                boundary2 = b2;
                incr_linear = 0;
                linlog = 1;
                sprintf(defaultb1,"%.3f",b1);
                sprintf(defaultb2,"%.3f",b2);
                limitvalue[2] = defaultb1;
                limitvalue[0] = defaultb2;

                UpdateLimits();
          }

}
void   DisplayColorEditor()
{
        register int i;

        if (ncolors <= 2) return;

        for (i=0; i< ncolors; i++) {
                color_backup[i] = color_save[i];
        }
        num_colors_backup = num_colors;
        value_contrast_backup = value_contrast;
        value_brightness_backup = value_brightness;

        for (i=0; i<5; i++) limitvalue_backup[i] = limitvalue[i];
 
        linlog_backup = linlog;
        boundary1_backup = boundary1;
        boundary2_backup = boundary2;
        boundary3_backup = boundary3;
        incr_linear_backup = incr_linear;
        incr_db_backup = incr_db;
 
        XtManageChild (bb);
}

static void create_colorbar()
{
        int n;
        int yy, i;
        char nm[10];
        Arg wargs[101];
        char color_limit_str[51];

        XColor colorcell_def, colorcell_def2;
        XColor rgb_db_def;

        static void copy_current_pixel();

        char name[10];
        Widget horz_widget;
        Widget file_sw_widget,file_form;




        /* Create a row of buttons, one for each color to be edited */
        n = 0;
 
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 10); n++;
        XtSetArg(wargs[n], XmNheight, 700); n++;
        XtSetArg(wargs[n], XmNwidth, 160); n++;

        cform = XmCreateForm( bb, "",wargs,n);
        XtManageChild(cform);

        n = 0;
        XtSetArg( wargs[n],XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNleftAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNrightAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNbottomAttachment, XmATTACH_FORM);n++;
        XtSetArg(wargs[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
        /*
        XtSetArg(wargs[n], XmNbottomPosition, 70); n++;
        */
        XtSetArg(wargs[n], XmNscrollingPolicy, XmSTATIC); n++;
        file_sw_widget = XmCreateScrolledWindow(cform,
                                        "file_sw_widget", wargs, n);
        XtManageChild(file_sw_widget);

        n=0;
        file_form = XmCreateForm(file_sw_widget, "file_form", wargs, n);
        XtManageChild(file_form);
 
        n=0;
/*
        XtSetArg(wargs[n], XmNnumColumns, 7); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMNXmPACK_TIGHT); n++;
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 10); n++;
*/
        XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
        cbar = XtCreateManagedWidget("colorpanel",     xmRowColumnWidgetClass,
                                                        file_form, wargs, n);
 
  
        for( i=0;i<ncolors-1;i++) {
           n=0;
           XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
           XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
           XtSetArg(wargs[n], XmNborderWidth, 0); n++;
           XtSetArg(wargs[n], XmNshadowThickness, 0); n++;
           XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
 
           horz_widget=XtCreateManagedWidget("horz",xmRowColumnWidgetClass, cbar,
                    wargs, n);
           n=0;
           XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
           XtSetArg(wargs[n], XmNheight, 5); n++;
           XtSetArg(wargs[n], XmNshadowThickness, 0); n++;
           XtSetArg(wargs[n], XmNborderWidth, 0); n++;
           XtSetArg(wargs[n], XmNmarginTop, 0); n++;

           if (color_save[i].red < 48960 && color_save[i].green < 48960 ||
               color_save[i].green < 48960 && color_save[i].blue < 48960) {
              XtSetArg(wargs[n], XmNforeground, pixel_white); n++;
           }
           else {
              XtSetArg(wargs[n], XmNforeground, pixel_black); n++;
           }

           XtSetArg(wargs[n], XmNtopShadowColor, color_pixel[i]); n++;
           XtSetArg(wargs[n], XmNbottomShadowColor, color_pixel[i]); n++;
           XtSetArg( wargs[n],XmNbackground, color_pixel[i]);n++;

           sprintf(name,"%d",i);
           if( strlen(name) == 1 ) strcat( name, "  " );
           else if( strlen(name) == 2 ) strcat( name, " " );

           button[i] = XtCreateWidget(name,xmPushButtonWidgetClass,horz_widget,wargs,n);
           XtManageChild(button[i]);
           XtAddCallback(button[i],XmNactivateCallback,(XtCallbackProc)copy_current_pixel,(XtPointer) i);

           if (i > num_colors-1)
              XtUnmanageChild(button[i]);
 
           if( i < (ncolors-2) ) {
              if (i > num_colors-2)
                 sprintf(color_limit_str,"%s"," ");
              else {
                 strcpy( color_limit_str, "" );
                 sprintf(color_limit_str, "%-14.7g", (-1.0) * color_limits[i]);
                 sprintf(color_limit_str, "%-14.7g", color_limits[i]);
              }

              n = 0;
              limits[i] = XtCreateManagedWidget(color_limit_str, xmLabelWidgetClass,
                                                        horz_widget, wargs, n);
           }

   }


}
 

static void   create_coloreditor_options()
{
        char cnum[3];
        int n, j;
        Widget push1, push1a, push2, push3;
        Widget w, rc, rca, rc0, rcc, rcok;
        Widget action_text;
        Widget panel, controls;
        Arg wargs[51];
        char action_str[51];
        Widget toggle_action;

        static Widget make_slider();
        static void set_current_pixel();



        n = 0;
        XtSetArg(wargs[n], XmNx, 200); n++;
        XtSetArg(wargs[n], XmNy, 0); n++;
        XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rca = XtCreateManagedWidget("coloroptions", xmRowColumnWidgetClass,
                                                bb, wargs, n);
        n = 0;
        XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,
                                                rca, wargs, n);
        n = 0;
        XtSetArg(wargs[n], XmNspacing, 1); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,
                                                rc, wargs, n);

        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR("\nPLTR Cards",XmSTRING_DEFAULT_CHARSET)); n++;
        w = XtCreateManagedWidget("Cards", xmLabelWidgetClass,
                                        rc0, wargs, n);

        n = 0;
        XtSetArg(wargs[n], XmNheight, 50); n++;
        w = XtCreateManagedWidget("Load", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) LOAD_PLTR);
        XmAddTabGroup(w);

        n = 0;
        colorcard_dialog = XmCreateFileSelectionDialog(w,
                            "file selection dialog", NULL, 0);
        XtAddCallback (colorcard_dialog, XmNokCallback,
                        (XtCallbackProc)color_cb, (XtPointer) DIALOG_CARD_ACCEPT);
        XtAddCallback (colorcard_dialog, XmNcancelCallback,
                        (XtCallbackProc)color_cb, (XtPointer) DIALOG_CARD_CANCEL);

/*NEED TO CHANGE*/

                n = 0;
                XtSetArg(wargs[n], XmNselectionLabelString, XmStringCreateLtoR
                                ("Save As...", XmSTRING_DEFAULT_CHARSET));  n++;
                save_dialog = XmCreatePromptDialog(w, "save dialog", wargs, n);
                XtAddCallback (save_dialog, XmNokCallback,
                                (XtCallbackProc)color_cb, (XtPointer) DIALOG_SAVE_ACCEPT);

        n = 0;
        pltrsave_widget = XtCreateManagedWidget("Save", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(pltrsave_widget, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) SAVE_PLTR);
        XmAddTabGroup(pltrsave_widget);


        n = 0;
        XtSetArg(wargs[n], XmNspacing, 1); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,
                                                rc, wargs, n);
        savepalettes_rowcol = rc0;

        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR("\nPalettes",XmSTRING_DEFAULT_CHARSET)); n++;
        w = XtCreateManagedWidget("Palettes", xmLabelWidgetClass,
                                        rc0, wargs, n);
 
        n = 0;
        w = XtCreateManagedWidget("Load", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) LOAD_PAL);
        button_loadpal = w;
        XmAddTabGroup(w);
 
        n = 0;
        w = XtCreateManagedWidget("Save", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)create_savepalette_menu, NULL );
        XmAddTabGroup(w);
 
        n = 0;
        w = XtCreateManagedWidget("Delete", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) DELETE_PAL);
        button_delpal = w;
        XmAddTabGroup(w);


        n = 0;
        XtSetArg(wargs[n], XmNspacing, 1); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,
                                                rc, wargs, n);



        n = 0;
        XtSetArg(wargs[n], XmNheight, 30); n++;
        w = XtCreateManagedWidget("Gray Scale", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) GRAY_SCALE);
        XmAddTabGroup(w);
 
        n = 0;
        XtSetArg(wargs[n], XmNheight, 30); n++;
        XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR("Interpolate\nColors",XmSTRING_DEFAULT_CHARSET)); n++;
        w = XtCreateManagedWidget("InterpolateColors", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) COLOR_INTERP);
        XmAddTabGroup(w);
 
        n = 0;
        w = XtCreateManagedWidget("Change Limits", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)set_limit_menu, NULL ); 
        XmAddTabGroup(w);

/*
XtAddCallback(w, XmNactivateCallback, color_cb, CHANGE_LIMITS);
*/

 
        n = 0;
        XtSetArg(wargs[n], XmNspacing, 1); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,
                                                rc, wargs, n);
 
        contrast_slider = make_slider(contrast, rc0, 100, -50, 1);
 
        brightness_slider = make_slider(brightness, rc0, 100, -50, 1);
 
        n = 0;
        XtSetArg(wargs[n], XmNmarginWidth, 0); n++;
        XtSetArg(wargs[n], XmNheight, 20); n++;
        w = XtCreateManagedWidget("slider", xmPushButtonWidgetClass, rc0,
                wargs, n);
        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) RESET_SLIDER);
        XmAddTabGroup(w);
 
        n = 0;
        w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
        XtManageChild(w);
 
/* allow user to set option to determine what will happen when a color button is clicked */
 
        strcpy( action_str, "" );
        sprintf(action_str,"%s"," \nAction when palette color is picked:");
        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR(action_str,XmSTRING_DEFAULT_CHARSET)); n++;
        action_text = XtCreateManagedWidget("action_text", xmLabelWidgetClass,
                                        rca, wargs, n);
 
        n = 0;
        XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
        XtSetArg(wargs[n], XmNnumColumns, 2 ); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
        XtSetArg(wargs[n], XmNspacing, 4); n++;
        XtSetArg(wargs[n], XmNradioBehavior, True); n++;
        XtSetArg(wargs[n], XmNradioAlwaysOne, True); n++;
        toggle_action = XtCreateManagedWidget("toggle_action",
                xmRowColumnWidgetClass,
                rca,
                wargs,
                n);

 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Insert Working Color above",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    /*XtSetArg(wargs[n], XmNsensitive, False); n++;*/
    action[0] = XtCreateManagedWidget("button0",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 

    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Delete",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    /*XtSetArg(wargs[n], XmNsensitive, False); n++;*/
    action[1] = XtCreateManagedWidget("button1",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Replace with Working Color",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[2] = XtCreateManagedWidget("button2",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Copy to Working Color",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[3] = XtCreateManagedWidget("button3",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Set Interpolation\nBreakpoints",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[4] = XtCreateManagedWidget("button4",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 

    XmToggleButtonGadgetSetState(action[0], False, False);
    XmToggleButtonGadgetSetState(action[1], False, False);
    XmToggleButtonGadgetSetState(action[2], False, False);
    XmToggleButtonGadgetSetState(action[3], True, False);
    XmToggleButtonGadgetSetState(action[4], False, False);
 
        n = 0;
        w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
        XtManageChild(w);
 

 
/* Create a row column widget containing three sliders,
   one for each color component. */
 
        n = 0;
        XtSetArg(wargs[n], XmNmarginHeight, 20); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
        XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg(wargs[n], XmNspacing, 5); n++;
        controls = XtCreateManagedWidget("sliderpanel", xmRowColumnWidgetClass,
                                                rca, wargs, n);
 
 
/* Create working color button */
 
        n = 0;
        XtSetArg(wargs[n], XmNheight, 255); n++;
        XtSetArg(wargs[n], XmNbackground, color_pixel[ncolors-1]); n++;
        XtSetArg(wargs[n], XmNtopShadowColor, color_pixel[ncolors-1]); n++;
        XtSetArg(wargs[n], XmNbottomShadowColor, color_pixel[ncolors-1]); n++;
        XtSetArg(wargs[n], XmNmarginHeight, 15); n++;

        if (color_save[ncolors-1].red < 48960 && color_save[ncolors-1].green < 48960 ||
            color_save[ncolors-1].green < 48960 && color_save[ncolors-1].blue < 48960) {
           XtSetArg(wargs[n], XmNforeground, pixel_white); n++; 
        }
        else { 
           XtSetArg(wargs[n], XmNforeground, pixel_black); n++; 
        }

        XtSetArg(wargs[n], XmNlabelString,
        XmStringCreateLtoR(" w \n o \n r \n k \n i \n n \n g \n  \n c \n o \n l \n o \n r ",
		XmSTRING_DEFAULT_CHARSET)); n++;
        button[ncolors-1] = XtCreateManagedWidget("w", xmPushButtonWidgetClass,
                        controls, wargs, n);
 
        red_slider = make_slider(red, controls, 255, 0, 0);
        green_slider = make_slider(green, controls, 255, 0, 0);
        blue_slider = make_slider(blue, controls, 255, 0, 0);
        light_slider = make_slider(light, controls, 255, 0, 0);
        dark_slider = make_slider(dark, controls, 255, 0, 0);
 
        set_current_pixel(NULL,color_pixel[ncolors-1]);

        
/*
        XSetWindowColormap(display,XtWindow(red_slider),default_cmap);
        XSetWindowColormap(display,XtWindow(green_slider),default_cmap);
        XSetWindowColormap(display,XtWindow(blue_slider),default_cmap);
        XSetWindowColormap(display,XtWindow(light_slider),default_cmap);
        XSetWindowColormap(display,XtWindow(dark_slider),default_cmap);
        XSetWindowColormap(display,XtWindow(topwidget),default_cmap);
*/


 
        n = 0;
        XtSetArg(wargs[n], XmNborderWidth, 20); n++;
        XtSetArg(wargs[n], XmNheight, 20); n++;
        w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
        XtManageChild(w);
 


/* quit button */

        n = 0;
        XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
        XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
        XtSetArg(wargs[n], XmNspacing,50); n++;
        XtSetArg(wargs[n], XmNmarginHeight,0); n++;
        XtSetArg(wargs[n], XmNmarginWidth, 30); n++;
        rcok = XmCreateRowColumn(rca, "rcok", wargs, n);
        XtManageChild (rcok);
 
        n = 0;
        XtSetArg(wargs[n], XmNshowAsDefault, 1); n++;
        push1 = XtCreateManagedWidget("OK", xmPushButtonWidgetClass,
                rcok, NULL, 0 );   
        XtAddCallback(push1, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) COLOR_EXIT);
        XmAddTabGroup(push1);
 
        n = 0;
        push1a = XtCreateManagedWidget("Apply", xmPushButtonWidgetClass,
                rcok, NULL, 0 );   
        XtAddCallback(push1a, XmNactivateCallback, (XtCallbackProc)color_cb, (XtPointer) COLOR_APPLY);
        XmAddTabGroup(push1a);

        n = 0;
        push2 = XtCreateManagedWidget("Cancel", xmPushButtonWidgetClass,
                rcok, NULL, 0 );   
        XtAddCallback(push2, XmNactivateCallback, /*unmanageCB, bb*/(XtCallbackProc)color_cb,
		(XtPointer) COLOR_CANCEL);
	XtAddCallback(bb, XmNunmapCallback, (XtCallbackProc)color_cb, (XtPointer) COLOR_UNMAP);

        n = 0;
        XtSetArg(wargs[n], XmNdefaultButton, push1); n++;
        XtSetArg(wargs[n], XmNcancelButton, push2); n++;
        XtSetValues(bb,wargs,n);


     
}


static Widget make_slider(name, parent, size, start, dir)
char *name;
Widget parent;
int size, start, dir;
{
        Widget w;
        int n, max, slider_size;
        XColor colorcell_def;
        XColor rgb_db_def;
        Arg wargs[51];
        unsigned long bwpixel;

 
/* Create a Valuator widget */
        n = 0;
        if (strcmp(name, dark) == 0) {
/*
                colorcell_def.pixel = BlackPixel(display, screen_num);
*/
                bwpixel=pixel_black;
                XtSetArg(wargs[n], XmNshowValue, False); n++;
        }
        else if (strcmp(name, light) == 0) {
/*
                colorcell_def.pixel = WhitePixel(display, screen_num);
*/
                bwpixel=pixel_white;
                XtSetArg(wargs[n], XmNshowValue, False); n++;
        }
        else if (strcmp(name, brightness) != 0 && strcmp(name, contrast) != 0) {
/*
                XAllocNamedColor(display, default_cmap, name,
                                &colorcell_def, &rgb_db_def);
*/
                if( strcmp(name,red) == 0 ) {
                   bwpixel= pixel_red;
                } else if( strcmp(name,green) == 0 ) {
                   bwpixel= pixel_green;
                } else if( strcmp(name,blue) == 0 ) {
                   bwpixel= pixel_blue;
                }
                XtSetArg(wargs[n], XmNshowValue, True); n++;
        }
        else {
                XtSetArg(wargs[n], XmNshowValue, True); n++;
        }
        if (strcmp(name, brightness) != 0 && strcmp(name, contrast) != 0) {
                XtSetArg(wargs[n], XmNtopShadowColor, bwpixel/*colorcell_def.pixel*/); n++;
        }
        XtSetArg(wargs[n], XmNmaximum, start+size); n++;
        XtSetArg(wargs[n], XmNminimum, start); n++;
        XtSetArg(wargs[n], XmNscaleMultiple, 1); n++;
 
/* not size+1 change */

        if (dir == 0) {
                XtSetArg(wargs[n], XmNprocessingDirection, XmMAX_ON_BOTTOM); n++;
                XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
                XtSetArg(wargs[n], XmNheight, size+1); n++;
                XtSetArg(wargs[n], XmNscaleWidth, 20); n++;
                XtSetArg(wargs[n], XmNscaleHeight, size+1); n++;
        }
        else {
                XtSetArg(wargs[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
                XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
                XtSetArg(wargs[n], XmNwidth, size+1); n++;
                XtSetArg(wargs[n], XmNscaleHeight, 20); n++;
                XtSetArg(wargs[n], XmNscaleWidth, size+1); n++;
        }
 
        XtSetArg(wargs[n], XmNtitleString, XmStringCreateLtoR(name, XmSTRING_DEFAULT_CHARSET)); n++;    
        w = XtCreateManagedWidget(name, xmScaleWidgetClass, parent,
                wargs, n);

/*
if( strcmp(name,red)==0 || strcmp(name,green)==0 || strcmp(name,blue)==0 ) {
        XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)my_slider_moved, name);
        XtAddCallback(w, XmNdragCallback, (XtCallbackProc)my_slider_moved, name);
}
else
{
*/
        XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)slider_moved, name);
        XtAddCallback(w, XmNdragCallback, (XtCallbackProc)slider_moved, name);
/*
}
*/

        return(w);

}

static void copy_current_pixel(w, number, call_data)
Widget w;
int number;
caddr_t call_data;
{
        int i, n;
        int div;
        int max_col;
        char msgbuf[80];
        Widget message_box;
        char label_str[51];
        Arg wargs[51];

        void update_color();
        static Widget DisplayMsg();

                  
        if (XmToggleButtonGadgetGetState(action[3]) == True) {

/* copy color to working color */
           div = 256;
           current_color.flags = DoRed | DoGreen | DoBlue;
 
/* Get the current color components of the selected button */
 
           current_color.pixel = color_pixel[number];
           if(visual->class == PseudoColor)
             XQueryColor(display, default_cmap, &current_color);
           else 
             pixel2color(&current_color,visual,depth);
 
/* Set the slider values to the respective RGB positions */
 
           XmScaleSetValue(red_slider, (int)current_color.red / div);
           XmScaleSetValue(green_slider, (int)current_color.green / div);
           XmScaleSetValue(blue_slider, (int)current_color.blue / div);
 
           max_col = (int)current_color.red;
           if ((int)current_color.green > max_col) max_col = (int)current_color.green;
           if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
           XmScaleSetValue(dark_slider, max_col / div);
           last_pos5 = max_col/div;
 
           max_col = current_color.red;
           if ((int)current_color.green < max_col) max_col = (int)current_color.green;
           if ((int)current_color.blue < max_col) max_col = (int)current_color.blue;
           XmScaleSetValue(light_slider, max_col / div);
           last_pos4 = max_col/div;
           last_moved = 0;
 
           if(visual->class == TrueColor) 
             color_pixel[ncolors-1]=current_color.pixel;
           else 
             current_color.pixel = color_pixel[ncolors-1];

           color_save[ncolors-1] = current_color;

           update_color();

        }
        else if (XmToggleButtonGadgetGetState(action[2]) == True) {

/* replace a color */
           if (value_contrast != 0) {
              sprintf(msgbuf,"Contrast must be set to zero before replacing a color.");
              message_box = DisplayMsg(bb,msgbuf,1);
              XtManageChild (message_box);
           }
           else {
              current_color.flags = DoRed | DoGreen | DoBlue;
 
              /* Get the current color components of the working color */
 
              current_color.pixel = color_pixel[ncolors-1];
              if(visual->class == PseudoColor)
                XQueryColor(display, default_cmap, &current_color);
              else 
                pixel2color(&current_color,visual,depth);
 
              if(visual->class == TrueColor)
                color_pixel[number] = current_color.pixel;
              else 
                current_color.pixel = color_pixel[number];

              color_save[number] = current_color;

              update_color();

           }
        }
        else if (XmToggleButtonGadgetGetState(action[1]) == True) {

/* delete a color */
           if (num_colors > 2) {
              for (i=number; i<num_colors-1; i++) {
                current_color.pixel = color_pixel[i+1];
                if(visual->class == PseudoColor)
                  XQueryColor(display, default_cmap, &current_color);
                else 
                  pixel2color(&current_color,visual,depth);

                if(visual->class == TrueColor) 
                  color_pixel[i]=current_color.pixel;
                else 
                  current_color.pixel = color_pixel[i];

                color_save[i] = current_color;
              }

/* handle arblimits */
              for (i=number; i<num_colors-1; i++) {
                arblimits[i] = arblimits[i+1];
              }

              arblimits[num_colors-1] = 0.0;
              num_colors--;

              update_color();

              XtUnmanageChild(button[num_colors]);
              if (xbutton[num_colors] != NULL)
                 XtUnmanageChild(xbutton[num_colors]);
 
              /* Reset current_color to the working color */
 
              current_color.pixel = color_pixel[ncolors-1];
              if(visual->class == PseudoColor)
                XQueryColor(display, default_cmap, &current_color);
              else 
                pixel2color(&current_color,visual,depth);
 
              count_add_del--;
              UpdateLimits();
           }
        }
        else if (XmToggleButtonGadgetGetState(action[0]) == True) {
/* insert a color */
           if (num_colors < (ncolors-1)/*40*/) {

              for (i=number;i<num_colors;i++) {

                 current_color.pixel = color_pixel[i];
                 if(visual->class == PseudoColor)
                   XQueryColor(display, default_cmap, &current_color);
                 else 
                   pixel2color(&current_color,visual,depth);
                 
                 if(visual->class == TrueColor) 
                   color_pixel[i+1]=current_color.pixel;
                 else 
                   current_color.pixel = color_pixel[i+1];

                 color_save[i+1] = current_color;
              }

/* handle arblimits */
              for( i=num_colors-1;i>number;i-- ) {
                 arblimits[i] = arblimits[i-1];
              }
              arblimits[number]=0.0;

              current_color.pixel = color_pixel[ncolors-1];
              if(visual->class == PseudoColor)
                XQueryColor(display, default_cmap, &current_color);
              else 
                pixel2color(&current_color,visual,depth);

              if(visual->class == TrueColor) 
                color_pixel[number]=current_color.pixel;
              else 
                current_color.pixel = color_pixel[number/*+1*/];

              color_save[number/*+1*/] = current_color;
 
              XtManageChild(button[num_colors]);
              if (xbutton[num_colors] != NULL)
                 XtManageChild(xbutton[num_colors]);

              num_colors++;
              update_color();
 
              count_add_del++;
              UpdateLimits();
           }
        }
        else if (XmToggleButtonGadgetGetState(action[4]) == True) {
/* set breakpoint for interpolation */
           if (interp_flag[number] == 0) {
              interp_flag[number] = 1;
              sprintf(label_str,"*%5d", number+1);
           }
           else {
              interp_flag[number] = 0;
              sprintf(label_str,"%6d", number+1);
           }

           n = 0;
           XtSetArg(wargs[n], XmNlabelString,
              XmStringCreateLtoR(label_str, XmSTRING_DEFAULT_CHARSET)); n++;
           XtSetValues (button[number],wargs,n);

           if (xbutton[num_colors] != NULL) {
              sprintf(label_str,"%2d", number+1);
              XtSetValues (xbutton[number],wargs,n);
           }
        }
}

static void slider_moved(w, which_slider, call_data)
Widget w;
char *which_slider;
XmScaleCallbackStruct *call_data;
{
/* Set the appropriate color components of the global
   current_color structure, depending on which color
   slider has moved. */

	int sliderpos, k1, k2, k3, k6, k7, mult, max_col, div;

	mult = 256;
	div = mult;
	sliderpos = call_data->value;
	k1 = strcmp(which_slider, red);
	k2 = strcmp(which_slider, green);
	k3 = strcmp(which_slider, blue);
	k6 = strcmp(which_slider, contrast);
	k7 = strcmp(which_slider, brightness);

	if(!k1) {
		current_color.red   = sliderpos * mult;
		last_moved = 1;
	}
	else if(!k2) {
		current_color.green = sliderpos * mult;
		last_moved = 2;
	}
	else if(!k3) {
		current_color.blue  = sliderpos * mult;
		last_moved = 3;
	}
	else if(!strcmp(which_slider, light)) {
		pos_diff = sliderpos - last_pos4;
		last_pos4 = sliderpos;
		if (last_moved != 4) {
	  		XmScaleGetValue(red_slider, &pos_col);
			pos_col1 = pos_col + pos_diff;
	  		XmScaleGetValue(green_slider, &pos_col);
			pos_col2 = pos_col + pos_diff;
	  		XmScaleGetValue(blue_slider, &pos_col);
			pos_col3 = pos_col + pos_diff;
	  		XmScaleGetValue(dark_slider, &pos_col);
			pos_col4 = pos_col + pos_diff;
		}
		else {
			pos_col1 += pos_diff;
			pos_col2 += pos_diff;
			pos_col3 += pos_diff;
			pos_col4 += pos_diff;
		}

		pos_col = pos_col1;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.red = pos_col;

		pos_col = pos_col2;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.green = pos_col;

		pos_col = pos_col3;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.blue = pos_col;

		pos_col = pos_col4;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;

	  	XmScaleSetValue(red_slider, current_color.red);
	  	XmScaleSetValue(green_slider, current_color.green);
	  	XmScaleSetValue(blue_slider, current_color.blue);
	  	XmScaleSetValue(dark_slider, pos_col);
		last_pos5 = pos_col;
		current_color.red *= mult;
		current_color.green *= mult;
		current_color.blue *= mult;
		last_moved = 4;
	}
	else if(!strcmp(which_slider, dark)) {
		pos_diff = sliderpos - last_pos5;
		last_pos5 = sliderpos;
		if (last_moved != 5) {
	  		XmScaleGetValue(red_slider, &pos_col);
			pos_col1 = pos_col + pos_diff;
	  		XmScaleGetValue(green_slider, &pos_col);
			pos_col2 = pos_col + pos_diff;
	  		XmScaleGetValue(blue_slider, &pos_col);
			pos_col3 = pos_col + pos_diff;
	  		XmScaleGetValue(light_slider, &pos_col);
			pos_col4 = pos_col + pos_diff; 
		}
		else {
			pos_col1 += pos_diff;
			pos_col2 += pos_diff;
			pos_col3 += pos_diff;
			pos_col4 += pos_diff;
		}

		pos_col = pos_col1;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.red = pos_col;

		pos_col = pos_col2;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.green = pos_col;

		pos_col = pos_col3;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;
		current_color.blue = pos_col;

		pos_col = pos_col4;
		if (pos_col > 255) pos_col = 255;
		if (pos_col < 0) pos_col = 0;

	  	XmScaleSetValue(red_slider, current_color.red);
	  	XmScaleSetValue(green_slider, current_color.green);
	  	XmScaleSetValue(blue_slider, current_color.blue);
	  	XmScaleSetValue(light_slider, pos_col);
		last_pos4 = pos_col;
		current_color.red *= mult;
		current_color.green *= mult;
		current_color.blue *= mult;
		last_moved = 5;
	}
	else if (!k6) {
	  	XmScaleGetValue(contrast_slider, &value_contrast);
	}
	else if (!k7) {
	  	XmScaleGetValue(brightness_slider, &value_brightness);
	}

        if(visual->class == TrueColor) {
          color2pixel(&current_color,visual,depth);
	  color_pixel[ncolors-1] = current_color.pixel;
        }
        else 
	  current_color.pixel = color_pixel[ncolors-1];

	/* Update the color button. */
	if (k6 || k7) color_save[ncolors-1] = current_color;

	update_color();

	if (!k1 || !k2 || !k3) {
	  max_col = current_color.red;
	  if ((int)current_color.green > max_col) max_col = (int)current_color.green;
	  if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
	  XmScaleSetValue(dark_slider, max_col / div);
	  last_pos5 = max_col/div;

	  max_col = current_color.red;
	  if ((int)current_color.green < max_col) max_col = (int)current_color.green;
	  if ((int)current_color.blue < max_col) max_col = (int)current_color.blue;
	  XmScaleSetValue(light_slider, max_col / div);
	  last_pos4 = max_col/div;
	}
}

static void my_slider_moved(w, which_slider, call_data)
  Widget w;
  char *which_slider;
  XmScaleCallbackStruct *call_data;
{
  extern Visual *visual;
  extern int depth;
  int a;

  a=0;
  if( strcmp(which_slider,"red")==0 ) {
     color_save[ncolors-1].red = call_data->value;
  }
  else if( strcmp(which_slider,"green")==0 ) {
     color_save[ncolors-1].green = call_data->value;
  }
  else if( strcmp(which_slider,"blue")==0 ) {
     color_save[ncolors-1].blue = call_data->value;
  }

  if(visual->class == PseudoColor)
    XStoreColor(display,default_cmap,&color_save[ncolors-1]);
  else {
    color2pixel(&color_save[ncolors-1],visual,depth);
    color_pixel[ncolors-1] = color_save[ncolors-1].pixel;
  }

}

static void update_color()
{
   extern Visual *visual;
   extern int depth;
/*
*   Update the current color button
*/
        XColor color_temp[MAX_COLORS];
        unsigned char rs[MAX_COLORS];
        unsigned char gs[MAX_COLORS];
        unsigned char bs[MAX_COLORS];
        unsigned char r1[MAX_COLORS];
        unsigned char g1[MAX_COLORS];
        unsigned char b1[MAX_COLORS];

        register int i;
        int value;
        int half, edge;
        float x, xinc;
        int n;
        Arg wargs[51];

        for (i=0; i<num_colors; i++) {
                r1[i] = (unsigned char)(color_save[i].red / 256);
                g1[i] = (unsigned char)(color_save[i].green / 256);
                b1[i] = (unsigned char)(color_save[i].blue / 256);
        }

        half = num_colors / 2;                  /* distance to center */
        if (value_contrast > 0) {               /* increase contrast */
                edge = half * value_contrast / 50;
                xinc = (float)(num_colors-1) / (float)(num_colors-1-2*edge);

                for (i=edge, x=0; i<num_colors-edge; i++, x+=xinc) {
                        rs[i] = r1[(int)x];
                        gs[i] = g1[(int)x];
                        bs[i] = b1[(int)x];

}
                memset((char *)rs, (int)r1[0], edge);
                memset((char *)gs, (int)g1[0], edge);
                memset((char *)bs, (int)b1[0], edge);
 
                memset((char *)&rs[num_colors-edge], (int)r1[num_colors-1], edge);
                memset((char *)&gs[num_colors-edge], (int)g1[num_colors-1], edge);
                memset((char *)&bs[num_colors-edge], (int)b1[num_colors-1], edge);
        }
        else {                                  /* decrease contrast */
                edge = -half * value_contrast / 50;
                xinc = (float)(num_colors-1-2*edge) / (float)(num_colors-1);
                if (xinc < 0.) xinc = 0.;

                for (i=0, x=edge; i<num_colors; i++, x+=xinc) {
                        rs[i] = r1[(int)x];
                        gs[i] = g1[(int)x];
                        bs[i] = b1[(int)x];
                }
        }
 
        value = value_brightness * 255 / 50;
        if (value_brightness > 0) {             /* increase brightness */
                for (i=0; i<num_colors; i++) {
                        register int t;
                        r1[i] = ((t=(int)rs[i]+value) >= 256) ? 255 : t;
                        g1[i] = ((t=(int)gs[i]+value) >= 256) ? 255 : t;
                        b1[i] = ((t=(int)bs[i]+value) >= 256) ? 255 : t;
                }
        }
        else {                                  /* decrease brightness */
                for (i=0; i<num_colors; i++) {
                        register int t;
                        r1[i] = ((t=(int)rs[i]+value) < 0) ? 0 : t;
                        g1[i] = ((t=(int)gs[i]+value) < 0) ? 0 : t;
                        b1[i] = ((t=(int)bs[i]+value) < 0) ? 0 : t;
                }
        }
 
/* make sure foreground is visible on background */


        for (i=0; i<num_colors; i++) {

                color_temp[i] = color_save[i];
                color_temp[i].red = r1[i] * 256;
                color_temp[i].green = g1[i] * 256;
                color_temp[i].blue = b1[i] * 256;

                if(visual->class == TrueColor)  {
                  color2pixel(&color_temp[i],visual,depth);
                  color_pixel[i]=color_temp[i].pixel;

                  XtSetArg(wargs[0], XmNbackground, color_temp[i].pixel);
                  XtSetValues (button[i], wargs, 1);
                }

                if (color_temp[i].red < 48960 && color_temp[i].green < 48960 ||
                        color_temp[i].green < 48960 && color_temp[i].blue < 48960)
                   XtSetArg(wargs[0], XmNforeground, pixel_white);
                else
                   XtSetArg(wargs[0], XmNforeground, pixel_black);

                XtSetValues (button[i], wargs, 1);
        }
 
        if(visual->class == PseudoColor)
          XStoreColors(display, default_cmap, color_temp, num_colors);
 

/* undo above for last button, the working color */

        if (color_save[ncolors-1].red < 48960 
		&& color_save[ncolors-1].green < 48960 
		|| color_save[ncolors-1].green < 48960 
		&& color_save[ncolors-1].blue < 48960)
           XtSetArg(wargs[0], XmNforeground, pixel_white);
        else
           XtSetArg(wargs[0], XmNforeground, pixel_black);
        XtSetValues (button[ncolors-1], wargs, 1);
 
        if(visual->class == PseudoColor)
          XStoreColor(display, default_cmap, &color_save[ncolors-1]);

        else if(visual->class == TrueColor)  {
          color2pixel(&color_save[ncolors-1],visual,depth);
          color_pixel[ncolors-1]=color_save[ncolors-1].pixel;

          XtSetArg(wargs[0], XmNbackground, color_save[ncolors-1].pixel);
          XtSetValues (button[ncolors-1], wargs, 1);
        }
}

static Widget DisplayMsg (parent,message,kind_of_msg)
        Widget          parent;         /*  parent widget       */
        char            *message;
        int             kind_of_msg;
{
   XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
        Widget          button;
        Widget          message_box;    /*  Message Dialog      */
        Arg             args[10];       /*  arg list            */
        register int    n;              /*  arg count           */

        /* XmString        title_string = NULL;   *NOT USED* */
        XmString        message_string = NULL;


        static void DialogDestroyMessageCB();



        /*      Generate message to display.
        */
        message_string = XmStringCreateLtoR (message, XmSTRING_DEFAULT_CHARSET);


        /*      Create MessageBox dialog.
        */
        n = 0;
        XtSetArg (args[n], XmNmessageString, message_string);  n++;


        if (kind_of_msg == 1) {
                XBell (XtDisplay(parent), 100);
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("ERROR", XmSTRING_DEFAULT_CHARSET));  n++;
                message_box = XmCreateErrorDialog (parent, "errorbox", args, n);
        }
        else if (kind_of_msg == 2) {
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("INFORMATION", XmSTRING_DEFAULT_CHARSET));  n++;
                message_box = XmCreateInformationDialog (parent, "informationbox", args, n);
        }
        else if (kind_of_msg == 3) {
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("MESSAGE", XmSTRING_DEFAULT_CHARSET));  n++;
                message_box = XmCreateMessageDialog (parent, "messagebox", args, n);
        }
        else if (kind_of_msg == 4) {
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("QUESTION", XmSTRING_DEFAULT_CHARSET));
n++;
                message_box = XmCreateQuestionDialog (parent, "questionbox", args, n);
        }
        else if (kind_of_msg == 5) {
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("WARNING", XmSTRING_DEFAULT_CHARSET));  n++;
                message_box = XmCreateWarningDialog (parent, "warningbox", args, n);
        }
        else if (kind_of_msg == 6) {
                XtSetArg (args[n], XmNdialogTitle, XmStringCreateLtoR ("WORKING", XmSTRING_DEFAULT_CHARSET));  n++;              
                message_box = XmCreateWorkingDialog (parent, "workingbox", args, n);
        }
     
          
        button = XmMessageBoxGetChild (message_box, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild (button);
 
        button = XmMessageBoxGetChild (message_box, XmDIALOG_HELP_BUTTON);
        XtUnmanageChild (button);
 
        XtAddCallback(message_box, XmNokCallback, (XtCallbackProc)DialogDestroyMessageCB, NULL);
 
        /*      Free strings and return MessageBox.                              
        */
/*        if (title_string) XtFree (title_string);   *NOT USED* */
        if (message_string) XmStringFree (message_string);
        return (message_box);
}

static void DialogDestroyMessageCB (w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
        XtDestroyWidget (w);
}

static void create_savepalette_menu(w,client,call)
Widget w;
caddr_t *client,*call;
{
        Widget rc01,rc2,label,seper,push1,push2;
 
        XmString xmstring;
        XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
 
        Arg args[51];
        int argcnt;
 
if( savepalette_dialog == NULL ) {
        argcnt = 0;
        savepalette_dialog = XmCreateFormDialog(w, "save", NULL, 0 );       

        argcnt = 0;
        rc01 = XmCreateRowColumn(savepalette_dialog, "workarea", NULL, 0 );       
        XtManageChild(rc01);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR("SAVE PALETTE MENU\n\n", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(label);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR("Enter a description of this palette:", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(label);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNcolumns, 50 ); argcnt++;
        XtSetArg(args[argcnt], XmNmaxLength, 50); argcnt++;
        palette_text = XmCreateText(rc01, "text", args, argcnt);
        XtManageChild(palette_text);
 
        argcnt = 0;
        seper = XmCreateSeparatorGadget(rc01, "sepe", args, argcnt);
        XtManageChild(seper);
 
        argcnt = 0;           
        XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
        XtSetArg(args[argcnt], XmNentryAlignment, XmALIGNMENT_CENTER); argcnt++;
        XtSetArg(args[argcnt], XmNspacing, 40); argcnt++;
        XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
        XtSetArg(args[argcnt], XmNmarginHeight,10); argcnt++;
        XtSetArg(args[argcnt], XmNmarginWidth, 40); argcnt++;
        rc2 = XmCreateRowColumn(rc01, "rc2", args, argcnt);
        XtManageChild (rc2);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
        push1 = XmCreatePushButtonGadget(rc2, "OK", args, argcnt);
        XtManageChild(push1);
 

        argcnt = 0;
        XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
        push2 = XmCreatePushButtonGadget(rc2, "Cancel", args, argcnt);
        XtManageChild(push2);

        XtAddCallback(push1, XmNactivateCallback, (XtCallbackProc)color_cb, 
		(XtPointer) DIALOG_SAVEPALETTE_ACCEPT);
        XtAddCallback(push2, XmNactivateCallback, (XtCallbackProc)color_cb, 
		(XtPointer) DIALOG_SAVEPALETTE_CANCEL);

        argcnt = 0;                                                                     
        XtSetArg(args[argcnt], XmNdefaultButton, push1); argcnt++;
        XtSetArg(args[argcnt], XmNcancelButton, push2); argcnt++;
        XtSetValues(savepalette_dialog,args,argcnt);
 
}

   XtManageChild( savepalette_dialog );
}

static void create_pltrfile_menu(w,client,call)
Widget w;
caddr_t *client,*call;
{
        Widget rc01,rc02,rc2,label,seper,push1;
        XmString xmstring;
        XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

 
        static char *flabel[] = {       "Replace Existing File",
                                        "Cancel Save"
                                };
 
        Arg args[51];
        int argcnt;
        int i;
 
/* this is for saving a pltr file */

if( file_dialog == NULL ) {

        argcnt = 0;
        file_dialog = XmCreateFormDialog(w, "save", NULL, 0 );    
 
        argcnt = 0;
        rc01 = XmCreateRowColumn(file_dialog, "workarea", NULL, 0 );    
        XtManageChild(rc01);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR("OUTPUT PLTR FILE STATUS MENU\n\n", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(label);
 
        argcnt=0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR("Output PLTR file already exists:", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(label);
 
        /* dataset name will be put in this one */
        argcnt=0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR(" ", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        file_label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(file_label);
 
        argcnt=0;
        XtSetArg(args[argcnt], XmNlabelString,
        XmStringCreateLtoR(" ", XmSTRING_DEFAULT_CHARSET)); argcnt++;
        label = XmCreateLabelGadget(rc01, "label", args, argcnt);
        XtManageChild(label);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
        XtSetArg(args[argcnt], XmNradioAlwaysOne, True); argcnt++;
        XtSetArg(args[argcnt], XmNradioBehavior, True); argcnt++;
        XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
        XtSetArg(args[argcnt], XmNnumColumns, 15); argcnt++;
        XtSetArg(args[argcnt], XmNspacing, 15); argcnt++;
        rc02 = XmCreateRowColumn(rc01, "file", args, argcnt);
        XtManageChild(rc02);

                argcnt = 0;
                XtSetArg(args[argcnt], XmNlabelString, XmStringCreateLtoR(
                        "Replace Existing File",
                        XmSTRING_DEFAULT_CHARSET)); argcnt++;
                file_button[0] = XtCreateManagedWidget("button",
                        xmToggleButtonGadgetClass,
                        rc02,
                        args,
                        argcnt);
                XmToggleButtonGadgetSetState(file_button[0], False, True);

                argcnt = 0;
                XtSetArg(args[argcnt], XmNlabelString, XmStringCreateLtoR(
                        "Cancel Save",
                        XmSTRING_DEFAULT_CHARSET)); argcnt++;
                file_button[1] = XtCreateManagedWidget("button",
                        xmToggleButtonGadgetClass,
                        rc02,
                        args,
                        argcnt);
                XmToggleButtonGadgetSetState(file_button[1], False, True);
 
 
        XmToggleButtonGadgetSetState(file_button[0], False, True);
        XmToggleButtonGadgetSetState(file_button[1], True, False);
 
        argcnt = 0;
        seper = XmCreateSeparatorGadget(rc01, "sepe", args, argcnt);
        XtManageChild(seper);

        argcnt = 0;           
        XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
        XtSetArg(args[argcnt], XmNentryAlignment, XmALIGNMENT_CENTER); argcnt++;
        XtSetArg(args[argcnt], XmNspacing, 40); argcnt++;
        XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
        XtSetArg(args[argcnt], XmNmarginHeight,10); argcnt++;
        XtSetArg(args[argcnt], XmNmarginWidth, 40); argcnt++;
        rc2 = XmCreateRowColumn(rc01, "rc2", args, argcnt);
        XtManageChild (rc2);
         
        argcnt = 0;
        XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
        push1 = XmCreatePushButtonGadget(rc2, "OK", args, argcnt);
        XtManageChild(push1);

        XtAddCallback(push1, XmNactivateCallback, (XtCallbackProc)color_cb, 
		(XtPointer) DIALOG_FILE_ACCEPT);

        argcnt = 0;                                                              
        XtSetArg(args[argcnt], XmNdefaultButton, push1); argcnt++;
        XtSetValues(file_dialog,args,argcnt);

}

/*
   XtManageChild( file_dialog );
*/
 
}

static void set_limit_menu(w,client,call)
Widget w;
caddr_t *client,*call;
{
        Widget action_text, push1, push2, push3, rc1, rc2, rc3, rc4, rc5, rc3a;
        Widget rc6,push4;
        Widget seper, label0,labels_widget;
        int n, i, fldlen;
        XmString xmstring;
        Arg wargs[51];
        char label_str[51];
        Widget toggle_action;

 
if( bbe == NULL ) {
    bbe = XmCreateFormDialog(w, "limitedit", NULL, 0);
 
    n = 0;
    rc1 = XmCreateRowColumn(bbe, "workarea", NULL, 0);
    XtManageChild(rc1);
 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString,
    XmStringCreateLtoR("              COLOR CONTOUR SPECIFICATION MENU\n\n",
                XmSTRING_DEFAULT_CHARSET)); n++;
    label0 = XmCreateLabelGadget(rc1, "label1", wargs, n);
    XtManageChild(label0);
 
    n = 0;
    XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
    XtSetArg(wargs[n], XmNspacing, 30 ); n++;
    XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
    rc3 = XmCreateRowColumn(rc1, "workarea", wargs, n);
    XtManageChild(rc3);
 
    n = 0;
    XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
    rc3a = XmCreateRowColumn(rc3, "workarea", wargs, n);
    XtManageChild(rc3a);
 
    strcpy( label_str, "" );
    sprintf(label_str,"%s","Increment\nType");
    n = 0;
    XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLtoR(label_str,XmSTRING_DEFAULT_CHARSET)); n++;
    action_text = XtCreateManagedWidget("action_text", xmLabelWidgetClass,
                                    rc3a, wargs, n);
 
    n = 0;
    XtSetArg(wargs[n], XmNx, 250); n++;
    XtSetArg(wargs[n], XmNy, 150); n++;
    XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
    XtSetArg(wargs[n], XmNspacing, 50); n++;
    XtSetArg(wargs[n], XmNradioBehavior, True); n++;
    XtSetArg(wargs[n], XmNradioAlwaysOne, True); n++;
    toggle_action = XtCreateManagedWidget("toggle_action",
                xmRowColumnWidgetClass,
                rc3a,
                wargs,
                n);
     
 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Linear",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[5] = XtCreateManagedWidget("button4",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "dB",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[6] = XtCreateManagedWidget("button5",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);
 
    n = 0;
    XtSetArg(wargs[n], XmNlabelString, XmStringCreateLtoR(
                "Arbitrary",
                XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(wargs[n], XmNset, True); n++;
    action[7] = XtCreateManagedWidget("button5",
                xmToggleButtonGadgetClass,
                toggle_action,
                wargs,
                n);

 
    XmToggleButtonGadgetSetState(action[7], False, False);
    XmToggleButtonGadgetSetState(action[6], False, False);
    XmToggleButtonGadgetSetState(action[5], True, False);
    XtAddCallback(action[5], XmNvalueChangedCallback, (XtCallbackProc)limit_typeCB,
	(XtPointer) 1 );
    XtAddCallback(action[6], XmNvalueChangedCallback, (XtCallbackProc)limit_typeCB,
	(XtPointer) 2 );
    XtAddCallback(action[7], XmNvalueChangedCallback, (XtCallbackProc)limit_typeCB,
	(XtPointer) 0 );
 
        n = 0;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
        seper = XmCreateSeparatorGadget(rc3, "sepe", wargs, n);
        XtManageChild(seper);
 
    n = 0;
    XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
    XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN ); n++;
    rc4 = XmCreateRowColumn(rc3, "workarea", wargs, n);
    XtManageChild(rc4);
 
 
        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
        XmStringCreateLtoR("Linear:", XmSTRING_DEFAULT_CHARSET)); n++;
        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
        XtManageChild(labels_widget);
 
for (i=0; i<5; i++) {
                n = 0;
                XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
                XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
                XtSetArg(wargs[n], XmNspacing, 10 ); n++;
                rc5 = XmCreateRowColumn(rc4, "workarea", wargs, n);
                XtManageChild(rc5);
                XmAddTabGroup(rc5);
 
                n = 0;
                XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR(limitstring[i], XmSTRING_DEFAULT_CHARSET)); n++;
                labels_widget = XmCreateLabelGadget(rc5, "label", wargs, n);
                XtManageChild(labels_widget);
 
                fldlen = 10;
                if (i == 3) fldlen = 5;
                n = 0;
                XtSetArg(wargs[n], XmNcolumns, fldlen ); n++;
                XtSetArg(wargs[n], XmNmaxLength, fldlen ); n++;
                limit_text[i] = XmCreateText(rc5, "text", wargs, n);
                XtManageChild(limit_text[i]);
 
                if (i == 2) {
                        n = 0;
                        XtSetArg(wargs[n], XmNlabelString,
                        XmStringCreateLtoR("Note:  If increment is zero,\nit will be calculated.",
                                XmSTRING_DEFAULT_CHARSET)); n++;
                        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
                        XtManageChild(labels_widget);
 
                        n = 0;
                        XtSetArg(wargs[n], XmNlabelString,
                        XmStringCreateLtoR("If increment is not zero,\nminimum value will be calculated.",
                                XmSTRING_DEFAULT_CHARSET)); n++;
                        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
                        XtManageChild(labels_widget);
 
                        n = 0;
                        XtSetArg(wargs[n], XmNlabelString,
                        XmStringCreateLtoR("Values greater than maximum value\nwill use highest color.",
                                XmSTRING_DEFAULT_CHARSET)); n++;
                        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
                        XtManageChild(labels_widget);
 
 n = 0;
                        XtSetArg(wargs[n], XmNlabelString,
                        XmStringCreateLtoR("Values less than minimum value\nwill use lowest color.",
                                XmSTRING_DEFAULT_CHARSET)); n++;
                        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
                        XtManageChild(labels_widget);
 
                        n = 0;
                        seper = XmCreateSeparatorGadget(rc4, "sepe", wargs, n);
                        XtManageChild(seper);
 
                        n = 0;
                        XtSetArg(wargs[n], XmNlabelString,
                        XmStringCreateLtoR("dB:", XmSTRING_DEFAULT_CHARSET)); n++;
                        labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
                        XtManageChild(labels_widget);
                }
       } 
 
      n = 0;
      seper = XmCreateSeparatorGadget(rc4, "sepe", NULL, 0);
      XtManageChild(seper);
 
    n = 0;
    XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
    XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN ); n++;
    rc6 = XmCreateRowColumn(rc4, "workarea", wargs, n);
    XtManageChild(rc6);

                   
      n = 0;
      push4 = XmCreatePushButtonGadget(rc6, "View/Change Arbitrary Limits", wargs, n);
      XtManageChild(push4);
      XtAddCallback(push4, XmNactivateCallback, (XtCallbackProc)arb_value_dialogCB, NULL );
 
      n = 0;
      seper = XmCreateSeparatorGadget(rc1, "sepe", NULL, 0);
      XtManageChild(seper);

      n = 0;                
      XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
      XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
      XtSetArg(wargs[n], XmNspacing, 50); n++;
      XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
      XtSetArg(wargs[n], XmNmarginHeight,10); n++;
      XtSetArg(wargs[n], XmNmarginWidth, 100); n++;
      rc2 = XmCreateRowColumn(rc1, "rc2", wargs, n);
      XtManageChild (rc2);

      n = 0;
      XtSetArg(wargs[n], XmNshowAsDefault, 1); n++;
      push1 = XmCreatePushButtonGadget(rc2, "OK", wargs, n);
      XtManageChild(push1);

      n = 0;
      push2 = XmCreatePushButtonGadget(rc2, "Cancel", wargs, n);
      XtManageChild(push2);

      n = 0;
      push3 = XmCreatePushButtonGadget(rc2, "Help", wargs, n);
      XtManageChild(push3);

      XtAddCallback(push1, XmNactivateCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_LIMIT_ACCEPT);
      XtAddCallback(push2, XmNactivateCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_LIMIT_CANCEL);
      XtAddCallback(push3, XmNactivateCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_LIMIT_HELP);

      n = 0;                                                                  
 
      XtSetArg(wargs[n], XmNdefaultButton, push1); n++;
      XtSetArg(wargs[n], XmNcancelButton, push2); n++;
      XtSetValues(bbe,wargs,n);

}
      if (linlog == 0) {
        XmToggleButtonGadgetSetState(action[5], False, False);
        XmToggleButtonGadgetSetState(action[6], False, False);
        XmToggleButtonGadgetSetState(action[7], True, False);
      }
      else if (linlog == 1) {
        XmToggleButtonGadgetSetState(action[5], True, False);
        XmToggleButtonGadgetSetState(action[6], False, False);
        XmToggleButtonGadgetSetState(action[7], False, False);
      }
      else {
        XmToggleButtonGadgetSetState(action[6], True, False);
        XmToggleButtonGadgetSetState(action[5], False, False);
        XmToggleButtonGadgetSetState(action[7], False, False);
      }
      for (i=0; i<5; i++) {
        XmTextSetString (limit_text[i], limitvalue[i]);
      }

    
   XtManageChild( bbe );
}

 
static void set_current_pixel(w, number)
Widget w;
int number;
{
        int div;
        int max_col;
 
        div = 256;
        current_color.flags = DoRed | DoGreen | DoBlue;
 
/* Get the current color components of the selected button */
 
        current_color.pixel = number;
        if(visual->class == PseudoColor)
          XQueryColor(display, default_cmap, &current_color);
        else 
          pixel2color(&current_color,visual,depth);
 
/* Set the slider values to the respective RGB positions */
 
        XmScaleSetValue(red_slider, (int)current_color.red / div);
        XmScaleSetValue(green_slider, (int)current_color.green / div);
        XmScaleSetValue(blue_slider, (int)current_color.blue / div);
 
        max_col = (int)current_color.red;
        if ((int)current_color.green > max_col) max_col = (int)current_color.green;
        if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
        XmScaleSetValue(dark_slider, max_col / div);
        last_pos5 = max_col/div;
 
        max_col = current_color.red;
        if ((int)current_color.green < max_col) max_col = (int)current_color.green;
        if ((int)current_color.blue < max_col) max_col = (int)current_color.blue;
        XmScaleSetValue(light_slider, max_col / div);
        last_pos4 = max_col/div;
        last_moved = 0;
 
}

static void color_cb(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int cnt_low;
	int low, high;
	int red_low, green_low, blue_low;
	int red_high,green_high,blue_high;
	double red_incr, green_incr, blue_incr;
	int i, j, temp, n;
	char *limitstr;
	Widget message_box;
	char msgbuf[80];
	int ret_code;
	int lunit;
	int recs;
	char *help_path;
	char guide_file[255];
        Arg wargs[51];

	switch ((int)client_data)
	{
	case CHANGE_LIMITS:
  		if (linlog == 0) {
			XmToggleButtonGadgetSetState(action[5], False, False);
			XmToggleButtonGadgetSetState(action[6], False, False);
			XmToggleButtonGadgetSetState(action[7], True, False);
		}
  		else if (linlog == 1) {
			XmToggleButtonGadgetSetState(action[5], True, False);
			XmToggleButtonGadgetSetState(action[6], False, False);
			XmToggleButtonGadgetSetState(action[7], False, False);
		}
		else {
			XmToggleButtonGadgetSetState(action[6], True, False);
			XmToggleButtonGadgetSetState(action[5], False, False);
			XmToggleButtonGadgetSetState(action[7], False, False);
		}
                for (i=0; i<5; i++) {
		   XmTextSetString (limit_text[i], limitvalue[i]);
		}
		XtManageChild(bbe);
		break;

	case DELETE_PAL:
		openpalette(&ret_code, "rb");
		if (ret_code == 0 ) {
			getpalette(&ret_code);
			if (num_items > 0) {
				XtSetSensitive(button_delpal,False);
				XtSetSensitive(button_loadpal,False);
				deletecolorlist_dialog = CreateDeleteColorListMenu(bb);
				XtManageChild(deletecolorlist_dialog);
				selected_item_index = -1;
			}
			else {
				sprintf(msgbuf,"No palettes are available for deletion.");
				message_box = DisplayMsg(bb,msgbuf,5);
				XtManageChild (message_box);
			}
		}
		break;

	case LOAD_PAL:
		openpalette(&ret_code, "rb");
		if (ret_code == 0 ) {
			getpalette(&ret_code, &lunit);
			if (num_items > 0) {
				XtSetSensitive(button_delpal,False);
				XtSetSensitive(button_loadpal,False);
				colorlist_dialog = CreateColorListMenu(bb);
				XtManageChild(colorlist_dialog);
				selected_item_index = -1;
			}
			else {
				sprintf(msgbuf,"No palettes are available for loading.");
				message_box = DisplayMsg(bb,msgbuf,5);
				XtManageChild (message_box);
			}
		}
		break;

	case SAVE_PAL:
		XtManageChild(savepalette_dialog);
		break;

	case LOAD_PLTR:
		XtManageChild(colorcard_dialog);
		break;

	case SAVE_PLTR:
                n = 0;
                XtSetArg(wargs[n], XmNtextString,
                XmStringCreateLtoR (pltrfilename, charset));  n++;
                XtSetValues(save_dialog, wargs, n);
                XtManageChild (save_dialog);
		break;

	case GRAY_SCALE:
		if (num_colors > 1) {
			for (i=0; i<num_colors; i++) {
				current_color.red = 
					(int)((float)(num_colors - i - 1) /
						(float)(num_colors - 1) * 255.) * 256;
				current_color.green = current_color.red;
				current_color.blue = current_color.red;

                                if (visual->class==TrueColor)   {
                                  color2pixel(&current_color,visual,depth);
				  color_pixel[i]=current_color.pixel;
                                }
                                else 
				  current_color.pixel = color_pixel[i];

				color_save[i] = current_color;
			}

			current_color.pixel = color_pixel[ncolors-1];
                        if(visual->class == PseudoColor)
                          XQueryColor(display, default_cmap, &current_color);
                        else 
                          pixel2color(&current_color,visual,depth);

			value_contrast = 0;
			value_brightness = 0;
  			XmScaleSetValue(contrast_slider, value_contrast);
  			XmScaleSetValue(brightness_slider, value_brightness);

			update_color();
		}
		break;


	case RESET_SLIDER:
		value_contrast = 0;
		value_brightness = 0;
  		XmScaleSetValue(contrast_slider, value_contrast);
  		XmScaleSetValue(brightness_slider, value_brightness);
		update_color();
		break;

	case COLOR_INTERP:
		low = -1;
		for (i=0; i<num_colors; i++) {
			if (interp_flag[i] == 1) {
				low = i;
				break;
			}
		}
		if (low < 0) break;
		for (i=low+1; i<num_colors; i++) {
			if (interp_flag[i] == 1) {
				high = i;

				current_color.pixel = color_pixel[low];
                                if(visual->class == PseudoColor)
                                  XQueryColor(display, default_cmap, &current_color);
                                else 
                                  pixel2color(&current_color,visual,depth);

				red_low = current_color.red;
				green_low = current_color.green;
				blue_low = current_color.blue;

				current_color.pixel = color_pixel[high];
                                if(visual->class == PseudoColor)
                                  XQueryColor(display, default_cmap, &current_color);
                                else 
                                  pixel2color(&current_color,visual,depth);

				red_high = current_color.red;
				green_high = current_color.green;
				blue_high = current_color.blue;

				red_incr = (double)(red_high - red_low) /
						(double)(high - low);
				green_incr = (double)(green_high - green_low) /
						(double)(high - low);
				blue_incr = (double)(blue_high - blue_low) /
						(double)(high - low);

				for (i=low+1,j=1; i<high; ++i,++j) {
					current_color.red =
						red_low + (int)(j * red_incr);
					if (current_color.red > 64408)
						current_color.red =
							current_color.red / 256 * 256;
					else
						current_color.red =
						((int)current_color.red + 128) / 256 * 256;

					current_color.green =
						green_low + (int)(j * green_incr);
					if (current_color.green > 64408)
						current_color.green =
						(int)current_color.green / 256 * 256;
					else
						current_color.green =
						((int)current_color.green + 128) / 256 * 256;

					current_color.blue =
						blue_low + (int)(j * blue_incr);
					if (current_color.blue > 64408)
						current_color.blue =
						(int)current_color.blue / 256 * 256;
					else
						current_color.blue =
						((int)current_color.blue + 128) / 256 * 256;

                                        if (visual->class==TrueColor)   {
                                          color2pixel(&current_color,visual,depth);
				  	  color_pixel[i]=current_color.pixel;
                                        }
                                        else
				  	  current_color.pixel = color_pixel[i];

					color_save[i] = current_color;
				}
				update_color();
				low = high;
			}
		}

		current_color.pixel = color_pixel[ncolors-1];
                if(visual->class == PseudoColor)
                  XQueryColor(display, default_cmap, &current_color);
                else 
                  pixel2color(&current_color,visual,depth);

		break;

	case COLOR_EXIT:
		map_flag = 1;

/* added this to trigger a redraw with the new color palette if
 * apply has not been done - Joe M. Wade 6/25/03
 */
                if (visual->class != PseudoColor) {
		  if (apply == 0) limits_change();
		  }
		else if (count_add_del != 0)
		  limits_change();

		count_add_del = 0;
		XtUnmanageChild(bb);
		apply = 0;
		break;

	case COLOR_HELP:
       		sprintf(msgbuf,"Help not available");
       		message_box = DisplayMsg(bb,msgbuf,2);
		XtManageChild (message_box);
		break;

	case COLOR_APPLY:
		limits_change();
		count_add_del = 0;
		apply = 1;
		break;

	case COLOR_UNMAP:
		if (map_flag == 0) color_cb(w, COLOR_CANCEL, call_data);
		map_flag = 0;
		XtUnmanageChild(bb);
		break;

	case COLOR_CANCEL:
		map_flag = 2;
		XtUnmanageChild(bb);

		if (num_colors < num_colors_backup) {
			for (i=num_colors; i<num_colors_backup; i++) {
				XtManageChild(button[i]);
				if (xbutton[i] != NULL) XtManageChild(xbutton[i]);
			}
		}
		else if (num_colors > num_colors_backup) {
			for (i=num_colors-1; i>num_colors_backup-1; i--) {
				XtUnmanageChild(button[i]);
				if (xbutton[i] != NULL) XtUnmanageChild(xbutton[i]);
			}
		}

		for (i=0; i< ncolors; i++) {
			color_save[i] = color_backup[i];
		}

/* Added color_pixel setting to put the pixel array back in
 * order with the restored color palette so the data will 
 * be replotted correctly - Joe M. Wade 6/25/03 */

                if (visual->class==TrueColor)   {
		  for (i=0; i< ncolors; i++) {
		   current_color = color_save[i];
                   color2pixel(&current_color,visual,depth);
		   color_pixel[i]=current_color.pixel;
		   }
                }

		for (i=0; i<5; i++) limitvalue[i] = limitvalue_backup[i];

		count_add_del = 0;
		if ((num_colors != num_colors_backup ||
			linlog != linlog_backup ||
			linlog == 1 &&
				(boundary1 != boundary1_backup ||
				boundary2 != boundary2_backup ||
				incr_linear != incr_linear_backup) ||
			linlog == 2 &&
				(boundary3 != boundary3_backup ||
				incr_db != incr_db_backup) ) && apply == 1 )
			count_add_del = 1;

		num_colors = num_colors_backup;
		value_contrast = value_contrast_backup;
		value_brightness = value_brightness_backup;

		XmScaleSetValue(contrast_slider, value_contrast);
		XmScaleSetValue(brightness_slider, value_brightness);

		linlog = linlog_backup;
		boundary1 = boundary1_backup;
		boundary2 = boundary2_backup;
		boundary3 = boundary3_backup;
		incr_linear = incr_linear_backup;
		incr_db = incr_db_backup;
		UpdateLimits();

/* added this to trigger a redraw with the restored color palette -
 * Joe M. Wade 6/25/03
 */
                if (visual->class != PseudoColor) {
		  if (apply != 0) limits_change();
		  }
		else if (count_add_del != 0) {
		  count_add_del = 0;
		  limits_change();
		}
		update_color();
		apply = 0;

		break;

	case DIALOG_CARD_CANCEL:
	  	XtUnmanageChild (colorcard_dialog);
		break;

	case DIALOG_CARD_ACCEPT:
		{
		XmFileSelectionBoxCallbackStruct *fcb =
			(XmFileSelectionBoxCallbackStruct *) call_data;

		/* get the filename from the file selection box */
		XmStringGetLtoR(fcb->value, charset, &cardfilename);

		XtUnmanageChild (colorcard_dialog);

		OpenCardFile();
		if (opt1_num > 0) {
			value_contrast = 0;
			value_brightness = 0;
			UpdateScreen();
  			XmScaleSetValue(contrast_slider, value_contrast);
  			XmScaleSetValue(brightness_slider, value_brightness);
		  }
		}
		break;


	case DIALOG_LIMIT_HELP:
		break;

	case DIALOG_LIMIT_CANCEL:
	  	XtUnmanageChild (bbe);
		break;

	case DIALOG_LIMIT_ACCEPT:
		for (i=0; i<5; i++) {
			limitstr = XmTextGetString (limit_text[i]);
			if (Float_Checks(limitstr) == 1) {
				sprintf(msgbuf,"Value is not a valid number for %s",
					limitstring[i]);
				message_box = DisplayMsg(bb,msgbuf,1);
				XtManageChild (message_box);
				break;
			}
		}
		if (Float_Checks(limitstr) == 1) break;

		if (atof(XmTextGetString (limit_text[0])) 
			<= atof(XmTextGetString (limit_text[2]))) {
			sprintf(msgbuf,"Maximum value must be greater than minimum value");
			message_box = DisplayMsg(bb,msgbuf,1);
			XtManageChild (message_box);
			break;
		}

		if (atof(XmTextGetString (limit_text[1])) < 0) {
			sprintf(msgbuf,"Linear increment cannot be negative");
			message_box = DisplayMsg(bb,msgbuf,1);
			XtManageChild (message_box);
			break;
		}

		if (atof(XmTextGetString (limit_text[3])) 
			< 0.1 || atof(XmTextGetString (limit_text[3])) > 50.) {
			sprintf(msgbuf,"dB increment is out of range");
			message_box = DisplayMsg(bb,msgbuf,1);
			XtManageChild (message_box);
			break;
		}

                if (XmToggleButtonGadgetGetState(action[6]) == True) linlog = 2;
                else if (XmToggleButtonGadgetGetState(action[5]) == True) linlog = 1;
		else linlog = 0;

                for (i=0; i<5; i++) limitvalue[i] = XmTextGetString (limit_text[i]);

		boundary2 = atof(limitvalue[0]);
		incr_linear = atof(limitvalue[1]);
		boundary1 = atof(limitvalue[2]);
		incr_db = atof(limitvalue[3]);
		boundary3 = atof(limitvalue[4]);
		XtUnmanageChild (bbe);
		count_add_del = 999999;
                       UpdateLimits();
		break;

	case DIALOG_SAVE_ACCEPT:
                {
                XmSelectionBoxCallbackStruct *scb =
                                 (XmSelectionBoxCallbackStruct *) call_data;

                /* get the filename string from the file selection box */
                XmStringGetLtoR(scb->value, charset, &pltrfilename);

                OpenOutputPLTR();

                XtUnmanageChild (save_dialog);
                }
		break;

	case DIALOG_SAVE_CANCEL:
		break;

	case DIALOG_FILE_ACCEPT:
		if (XmToggleButtonGadgetGetState(file_button[0]) == True) SavePLTRFile();
		XtUnmanageChild(file_dialog);
		break;

	case DIALOG_SAVEPALETTE_ACCEPT:
		openpalette(&ret_code, "r+b");
		if (ret_code == 0 ) {
			appendpalette(&ret_code);
			if (ret_code != 0) break;
		}
		XtUnmanageChild(savepalette_dialog);
		break;

	case DIALOG_SAVEPALETTE_CANCEL:
		XtUnmanageChild(savepalette_dialog);
		break;

	case DIALOG_LOAD_CANCEL:
		XtUnmanageChild(colorlist_dialog);
		XtSetSensitive(button_loadpal,True);
		XtSetSensitive(button_delpal,True);
		break;

	case DIALOG_LOAD_ACCEPT:
                {
                XmSelectionBoxCallbackStruct *scb =
                                 (XmSelectionBoxCallbackStruct *) call_data;

                /* get the item string from the selection box */

		XmStringGetLtoR(scb->value, charset, &entry_name);
		for (i=0; i<num_items; i++) {
			if (strcmp(entry_name,item[i]) == 0) {
				selected_item_index = i + 1;
				break;
			}
		}
		XtUnmanageChild(colorlist_dialog);
		openpalette(&ret_code, "rb");
		if (ret_code == 0) setpalette(&ret_code);
		XtSetSensitive(button_loadpal,True);
		XtSetSensitive(button_delpal,True);
		}
		break;

	case DIALOG_DELETE_CANCEL:
		XtUnmanageChild(deletecolorlist_dialog);
		XtSetSensitive(button_loadpal,True);
		XtSetSensitive(button_delpal,True);
		break;

	case DIALOG_DELETE_ACCEPT:
                {
                XmSelectionBoxCallbackStruct *scb =
                                 (XmSelectionBoxCallbackStruct *) call_data;

                /* get the item string from the selection box */

		XmStringGetLtoR(scb->value, charset, &entry_name);
		for (i=0; i<num_items; i++) {
			if (strcmp(entry_name,item[i]) == 0) {
				selected_item_index = i + 1;
				break;
			}
		}
		XtUnmanageChild(deletecolorlist_dialog);
		openpalette(&ret_code, "r+b");
		if (ret_code == 0) deletepalette(&ret_code);
		XtSetSensitive(button_loadpal,True);
		XtSetSensitive(button_delpal,True);
		}
		break;

        case DIALOG_ARBLIMITS_ACCEPT:
                {
                char *buffer_ptr=NULL;
                char buffer[256];

                for( i=0;i<num_colors-1;i++ ) {
                   buffer_ptr = XmTextGetString( arbvalue_text_widgets[i] );
                   if( buffer_ptr == NULL ){ 
                      message_box = DisplayMsg(bb,"Arbitrary limit cannot be blank",1);
                      XtManageChild (message_box);
                      return;
                   }
                   strcpy( buffer, buffer_ptr);
                   sscanf( buffer, "%f", &arblimits[i] );
                }
                XtUnmanageChild( arb_value_dialog );
                /* sort in ascending order */
                bubble_sort3( &arblimits[0], NULL, (num_colors-1) );
                }
                break;

        case DIALOG_ARBLIMITS_CANCEL:
                XtUnmanageChild( arb_value_dialog );
                break;

	default:
		fprintf(stderr,"Warning: in color_cb\n");
		break;
	}
}

/****************************************************************************************/

static void openpalette(ret_code,mode)
int *ret_code;
char *mode;
{
	char *palettename = ".colorpalette256";
        char nntap[200];
	char *ppth;

	Widget message_box;
	char msgbuf[80];

	*ret_code = 0;

	ppth = getenv("HOME");
	sprintf (nntap, "%s/%s\0", ppth,palettename);

	luin = fopen(nntap, mode);
	if (luin == NULL) {
		luin = fopen(nntap, "ab+");
		fclose(luin);
		luin = fopen(nntap, mode);
		if (luin == NULL) {
			sprintf(msgbuf,"Unable to open file\n%s",nntap);
			message_box = DisplayMsg(bb,msgbuf,5);
			XtManageChild (message_box);
			*ret_code = 100;
		}
		return;
	}
}
static void getpalette(ret_code)
int *ret_code;
{
	int i;

	*ret_code = 0;
	num_items = 0;

	while (1) {
                i=fread(&titledata,sizeof(struct pal_title),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
}
#endif
		if (titledata.entry_num > 0 ) {
			sprintf(item[num_items], "%.50s", titledata.desc);
			memset(&item[num_items][50], '\0', 1);
			num_items++;
			if (num_items >= 300) break;
		}
                i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&rgbdata.length,1);
		HTOCS(&rgbdata.num_colors,3);
		HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"rgbdata.length = """);
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",rgbdata.length[indx]);
fprintf(stderr,"""\n");
fprintf(stderr,"num_colors = %d\n",rgbdata.num_colors);
fprintf(stderr,"contrast = %d\n",rgbdata.contrast);
fprintf(stderr,"brightness = %d\n",rgbdata.brightness);
for (i=0; i<rgbdata.num_colors; i++) {
 fprintf(stderr,"  %d - %d %d %d \n",i,rgbdata.colors[i][1],rgbdata.colors[i][2],rgbdata.colors[i][3]);
 }
}
#endif
                i=fread(&limitdata,sizeof(struct pal_limits),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&limitdata,1);
		HTOCS(&limitdata.limtyp,1);
		HTOCL(&limitdata.bound2,5);
#endif
                if( (int)limitdata.limtyp == 0 ) {
                   i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
		   if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   HTOCL(&arblimitdata,1);
		   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
                }
	}

	fclose(luin);
}
static void setpalette(ret_code)
int *ret_code;
{
	int num_save;
	int id;
	int i;

	*ret_code = 0;
	num_items = 0;

	id = 0;

	while (1) {
		id++;
                i=fread(&titledata,sizeof(struct pal_title),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"db1 titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
}
#endif
		if (titledata.entry_num > 0) {
			num_items++;
			if (num_items == selected_item_index) {
				savedefaultid(&id);

                                i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                                i=fread(&limitdata,sizeof(struct pal_limits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
				HTOCL(&rgbdata.length,1);
				HTOCS(&rgbdata.num_colors,3);
				HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
				HTOCL(&limitdata,1);
				HTOCS(&limitdata.limtyp,1);
				HTOCL(&limitdata.bound2,5);
#endif
                                if( (int)limitdata.limtyp == 0 ) {
                                   i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
				   HTOCL(&arblimitdata,1);
				   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
				   }

				if ((int)limitdata.limtyp != 0) setnewlimits();
				break;
			}
			else {
                                i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                                i=fread(&limitdata,sizeof(struct pal_limits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
				HTOCL(&rgbdata.length,1);
				HTOCS(&rgbdata.num_colors,3);
				HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
				HTOCL(&limitdata,1);
				HTOCS(&limitdata.limtyp,1);
				HTOCL(&limitdata.bound2,5);
#endif
                                if( (int)limitdata.limtyp == 0 ) {
                                   i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
				   HTOCL(&arblimitdata,1);
				   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
				   }
			}

		}
		else {
                        i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                        i=fread(&limitdata,sizeof(struct pal_limits),1,luin);

#if ( BYTE_ORDER == LITTLE_ENDIAN )
			HTOCL(&rgbdata.length,1);
			HTOCS(&rgbdata.num_colors,3);
			HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
			HTOCL(&limitdata,1);
			HTOCS(&limitdata.limtyp,1);
			HTOCL(&limitdata.bound2,5);
#endif
                        if( (int)limitdata.limtyp == 0 ) {
                           i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
			   HTOCL(&arblimitdata,1);
			   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
			   }
		}
	}

	fclose(luin);

        linlog = (int)limitdata.limtyp;
	num_save = num_colors;
	num_colors = rgbdata.num_colors;
/* NEED THIS CHECK */
        if( num_colors > ncolors-1 ) num_colors = num_save;
	value_contrast = rgbdata.contrast;
	value_brightness = rgbdata.brightness;

	for (i=0; i<num_colors; i++) {
		current_color.red = rgbdata.colors[i][0];
		current_color.green = rgbdata.colors[i][1];
		current_color.blue = rgbdata.colors[i][2];

                if (visual->class==TrueColor)   {
                   color2pixel(&current_color,visual,depth);
		   color_pixel[i]=current_color.pixel;
                }
                else 
		  current_color.pixel = color_pixel[i];
		color_save[i] = current_color;
	}
 
        for (i=0; i<MAX_COLORS-1; i++) {
                   arblimits[i] = arblimitdata.pal_arblimits[i]; 
                }

	XmScaleSetValue(contrast_slider, value_contrast);
	XmScaleSetValue(brightness_slider, value_brightness);
	update_color();

	current_color.pixel = color_pixel[ncolors-1];
        if(visual->class == PseudoColor)
          XQueryColor(display, default_cmap, &current_color);
        else 
          pixel2color(&current_color,visual,depth);

	if (num_save > num_colors) {
                XtUnmanageChild( cbar );
		for (i=num_colors; i<num_save; i++) {
			XtUnmanageChild(button[i]);
			if (xbutton[i] != NULL)
				XtUnmanageChild(xbutton[i]);
		}
                XtManageChild( cbar );
	}
	else if (num_save < num_colors) {
                XtUnmanageChild( cbar );
		for (i=num_save; i<num_colors; i++) {
			XtManageChild(button[i]);
			if (xbutton[i] != NULL)
				XtManageChild(xbutton[i]);
		}
                XtManageChild( cbar );
	}


	UpdateLimits();
}
static void deletepalette(ret_code)
int *ret_code;
{
	int i;
	int id;
	int leng;

	char *plen;

	*ret_code = 0;
	num_items = 0;

	id = 0;

	while (1) {
                i = fread(&titledata,sizeof(struct pal_title),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"db2 titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
}
#endif
		id++;
		if (titledata.entry_num > 0) {
			num_items++;
			if (num_items == selected_item_index) {
				if (fseek(luin, -sizeof(struct pal_title), SEEK_CUR) == 0) {
					titledata.entry_num = 0;
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
#endif
                                        i = fwrite(&titledata,sizeof(struct pal_title),1,luin);
					reset_default_id(&id);
				}
				break;
			}
		}

                i = fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                i = fread(&limitdata,sizeof(struct pal_limits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&rgbdata.length,1);
		HTOCS(&rgbdata.num_colors,3);
		HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
		HTOCL(&limitdata,1);
		HTOCS(&limitdata.limtyp,1);
		HTOCL(&limitdata.bound2,5);
#endif
                if( (int)limitdata.limtyp == 0 ) {
                   i = fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   HTOCL(&arblimitdata,1);
		   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
		   }
	}
	fclose(luin);
}
static void appendpalette(ret_code)
int *ret_code;
{
	char *plen;
	int nrecs, id, i, ok;
	char *description;
	char msgbuf[50];
	Widget message_box;
	long int leng;

	*ret_code = 0;

	ok = 0;
	description = XmTextGetString (palette_text);
	for (i=0; i<strlen(description); i++) {
		if (memcmp(description, " ", 1) != 0) {
			ok = 1;
			break;
		}
	}
	if (ok == 0) {
        	sprintf(msgbuf,"Description cannot be blank");
      		message_box = DisplayMsg(bb,msgbuf,1);
        	XtManageChild (message_box);
		*ret_code = 100;
		fclose(luin);
        	return;
	}

	nrecs = 0;
	id = 0;

#ifdef DEBUG
fprintf(stderr,"appendpalette:\n");
#endif
	while (1) {
                i=fread(&titledata,sizeof(struct pal_title),1,luin);
		if (i <= 0) break;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"db3 titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
}
#endif
		if (titledata.entry_num == 0) {
			id = nrecs + 1;
			if (fseek(luin, -sizeof(struct pal_title), SEEK_CUR) != 0) return;
			break;
		}
                i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                i=fread(&limitdata,sizeof(struct pal_limits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&rgbdata.length,1);
		HTOCS(&rgbdata.num_colors,3);
		HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
		HTOCL(&limitdata,1);
		HTOCS(&limitdata.limtyp,1);
		HTOCL(&limitdata.bound2,5);
#endif
                if( (int)limitdata.limtyp == 0 ) {
                   i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   HTOCL(&arblimitdata,1);
		   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
		   }

		nrecs++;
	}

	if (id == 0) {
		id = nrecs + 1;
		if (fseek(luin, 0L, SEEK_END) != 0) return;
	}

	savedefaultid(&id);

	rgbdata.num_colors = num_colors;
	rgbdata.contrast = value_contrast;
	rgbdata.brightness = value_brightness;

	for (i=0; i<num_colors; i++) {
		rgbdata.colors[i][0] = color_save[i].red;
		rgbdata.colors[i][1] = color_save[i].green;
		rgbdata.colors[i][2] = color_save[i].blue;
	}

	titledata.entry_num = 1;
	memset(titledata.desc, 0x20, sizeof(titledata.desc));
	sprintf(titledata.desc, "%s", description);
	XtFree(description);

	limitdata.limtyp = (short)linlog;
	limitdata.bound2 = boundary2;
	limitdata.incr_lin = incr_linear;
	limitdata.bound1 = boundary1;
	limitdata.incr_db = incr_db;
	limitdata.bound3 = boundary3;
        for( i=0;i<MAX_COLORS-1;i++ ) {
           arblimitdata.pal_arblimits[i] = arblimits[i];
/*
           limitdata.arblimits[i] = arblimits[i];
*/
        }

	plen = (char *)&leng;

#ifdef DEBUG
{
int indx;
fprintf(stderr,"RGB data to go to new palette ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"rgbdata.length = """);
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",rgbdata.length[indx]);
fprintf(stderr,"""\n");
fprintf(stderr,"num_colors = %d\n",rgbdata.num_colors);
fprintf(stderr,"contrast = %d\n",rgbdata.contrast);
fprintf(stderr,"brightness = %d\n",rgbdata.brightness);
for (i=0; i<rgbdata.num_colors; i++) {
 fprintf(stderr,"  %d - %d %d %d \n",i,rgbdata.colors[i][1],rgbdata.colors[i][2],rgbdata.colors[i][3]);
 }
}
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	HTOCL(&titledata,1);
	HTOCS(&titledata.entry_num,1);
	HTOCL(&rgbdata.length,1);
	HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
	HTOCS(&rgbdata.num_colors,3);
	HTOCL(&limitdata,1);
	HTOCS(&limitdata.limtyp,1);
	HTOCL(&limitdata.bound2,5);
#endif
        fwrite(&titledata,sizeof(struct pal_title),1,luin);

        fwrite(&rgbdata,sizeof(struct pal_rgb),1,luin);

        fwrite(&limitdata,sizeof(struct pal_limits),1,luin);

        if( linlog == 0 ) {
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	   HTOCL(&arblimitdata,1);
	   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
           fwrite(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
        }

	fclose(luin);

	current_color.pixel = color_pixel[ncolors-1];
        if(visual->class == PseudoColor)
          XQueryColor(display, default_cmap, &current_color);
        else 
          pixel2color(&current_color,visual,depth);
}
int Float_Checks (int_string)
char *int_string;
{
    char str_ints[15];
    char temp[100];
    int string_len;
    register int i,j;
    int found,found1;
    int code;
    int num_dot;
    int num_e;
    int i_num_e;

    i_num_e = -1;
    num_e = 0;
    num_dot = 0;
    sprintf (str_ints, "0123456789.eE+-");
    code = 0;
    sprintf(temp,"%s",int_string);
    string_len = strlen(temp);
    found1 = 0;
    for (i=0; i<string_len; i++) {
       found = 0;
       for (j=0; j<15; j++) {
          if (memcmp(&temp[i],&str_ints[j],1) == 0) {
             found = 1;
/* check for imbedded blanks */
             if (found1 == 2) {
                code = 1;
                return(code);
                }
             if (j == 10) {
                num_dot++;
                if (num_dot > 1 || num_e > 0) {
                        code = 1;
                        return(code);
                }
             } 
             if (j == 11 || j == 12) {
                num_e++;
                if (num_e > 1 || i < string_len-4 || found1 == 0) {
                        code = 1;
                        return(code);
                }
                i_num_e = i;
             }  
             if (j >= 13) {
                if (found1 == 1 && i-1 != i_num_e) {
                        code = 1;
                        return(code);
                }
             }
             found1 = 1;
             break;
             }
          }
       if (found == 0) {
		/* leading blanks */
          if (found1 == 0 && memcmp(&temp[i]," ",1) == 0);
		/* trailing blanks */
          else if (found1 >= 1 && memcmp(&temp[i]," ",1) == 0) found1 = 2;
		/* otherwise invalid integer */
          else {
             code = 1;
             break;
             }
          }
       }     
    return(code);
}      
void UpdateScreen()
{
	int mult, i;
        int num_save;

	mult = 256;

	for (i=0; i<opt1_num; i++) {
		current_color.red   = clr_rr[opt1_num-i-1] * mult;
		current_color.green = clr_gg[opt1_num-i-1] * mult;
		current_color.blue  = clr_bl[opt1_num-i-1] * mult;

                if (visual->class==TrueColor)   {
                   color2pixel(&current_color,visual,depth);
		   color_pixel[i]=current_color.pixel;
                }
		else 
                   current_color.pixel = color_pixel[i];

		color_save[i] = current_color;
	}

/* ANOTHER CHECK */
        if( opt1_num > ncolors-1 ) opt1_num = ncolors-1;
        
/* update_color uses num_colors value; must go into update_color with
*  number of colors read from pltr file; this is to fix bug that when
*  pltr card file number of colors is greater than what currently
*  allocated, not showing proper colors and need to reload pltr deck
*/
        num_save = num_colors;
        num_colors = opt1_num;
/* NEED THIS CHECK */
                if( num_colors > ncolors-1 ) num_colors = num_save;
	/* Update the color button. */
	update_color();
        num_colors = num_save;

	linlog = opt1_type;
	boundary1 = 0.;
	boundary2 = opt1_lin_high;
	incr_linear = opt1_lin_int;
	boundary3 = opt1_db_zero;
	incr_db = opt1_db_int;

	sprintf(opt1_str2,"%s","0.");
	parm_temp[0] = &opt1_str0[0];
	parm_temp[1] = &opt1_str1[0];
	parm_temp[2] = &opt1_str2[0];
	parm_temp[3] = &opt1_str3[0];
	parm_temp[4] = &opt1_str4[0];

	for (i=0; i<5; i++) limitvalue[i] = parm_temp[i];


	if (num_colors < opt1_num) {
/* NEED THIS CHECK */
           if( opt1_num <= ncolors-1 ) {
                XtUnmanageChild( cbar );
		for (i=num_colors; i<opt1_num; i++) {
			XtManageChild(button[i]);
			if (xbutton[i] != NULL) XtManageChild(xbutton[i]);
		}
		num_colors = opt1_num;
                XtManageChild( cbar );
           }
	}
	else if (num_colors > opt1_num) {
                XtUnmanageChild( cbar );
		for (i=num_colors-1; i>opt1_num-1; i--) {
			XtUnmanageChild(button[i]);
			if (xbutton[i] != NULL) XtUnmanageChild(xbutton[i]);
		}
		num_colors = opt1_num;
                XtManageChild( cbar );
	}
	count_add_del = 0;
	UpdateLimits();
}
void OpenCardFile()
{
	FILE *fp;
	char msgbuf[80];
	Widget message_box;
	char line[82], *buffer;
	char temp[11],temp2[11];
	char ttemp[12];
	int i;
	int clr_bb[MAX_COLORS-1], clr_yy[MAX_COLORS-1], clr_mm[MAX_COLORS-1], clr_cc[MAX_COLORS-1];
	int color_count;
	int sum1, sum2;
        int numclr40, numclr256;

	struct colr1rec {
		char colr1[5];
		char blank1[2];
		char incr[3];
		char interval_lin[10];
		char level_high[10];
		char blank2[3];
		char display_opt[2];
		char interval_db[5];
		char zero_db_value[10];
/* NEED */
		char blank3[3];
		char numclr[2];
		char blank4[1];
		char trace_fill[4];
		char blank5[20];
                char numclr256[3];
	};

	struct colr1rec colr1data;

	struct colr2rec {
		char colr2[5];
		char blank6[2];
		char color_code1[8];
		char blank7[2];
		char color_code2[8];
		char blank8[2];
		char color_code3[8];
		char blank9[2];
		char color_code4[8];
		char blank10[2];
		char color_code5[8];
		char blank11[25];
	};

	struct colr2rec colr2data;

	struct color_code {
		char color_bb[2];
		char color_yy[2];
		char color_mm[2];
		char color_cc[2];
	};

	struct color_code color_data;

	opt1_num = 0;

 	if ((fp = fopen(cardfilename, "r")) == NULL) {
        	sprintf(msgbuf,"Unable to open parameter file\n%s",cardfilename);
      		message_box = DisplayMsg(bb,msgbuf,5);
        	XtManageChild (message_box);
        	return;
	}

	/* read first record */
	buffer = &line[0];
/*NEED*/
  	if (fgets(buffer, 84, fp) == NULL) {
       		sprintf(msgbuf,"Unable to read data from file\n%s",cardfilename);
        	message_box = DisplayMsg(bb,msgbuf,5);
       		XtManageChild (message_box);
       		fclose(fp);
       		return;
	}

	for (i=0; i<MAX_COLORS-1/*40*/; i++) {
		clr_bb[i] = 0;
		clr_yy[i] = 0;
		clr_mm[i] = 0;
		clr_cc[i] = 0;
	}
	color_count = 0;
	sum1 = 0;
	sum2 = 0;

	while(1) {
		if (memcmp(buffer,"1COLR",5) == 0) {
			sum1++;
/*NEED*/
			memcpy(colr1data.colr1, line, 83);

			memcpy(temp, colr1data.interval_lin, 10);
			temp[10] = '\0';
			for (i=9; i>=0; i--) {
				if (memcmp (&temp[i]," ",1) == 0) memset(&temp[i],0X30,1);
				else break;
			}
			opt1_lin_int = atof(temp);
			if (opt1_lin_int == 0.) {
				opt1_lin_int = 409.4;
				sprintf(temp,"%s","409.4");
			}
			sprintf(opt1_str1,"%s",temp);

			memcpy(temp, colr1data.level_high, 10);
			temp[10] = '\0';
			for (i=9; i>=0; i--) {
				if (memcmp (&temp[i]," ",1) == 0) memset(&temp[i],0X30,1);
				else break;
			}
			opt1_lin_high = atof(temp);
			if (opt1_lin_high == 0.) {
				opt1_lin_high = 2047.;
				sprintf(temp,"%s","2047.");
			}
			sprintf(opt1_str0,"%s",temp);

			memcpy(temp, colr1data.interval_db, 5);
			temp[5] = '\0';
			for (i=4; i>=0; i--) {
				if (memcmp (&temp[i]," ",1) == 0) memset(&temp[i],0X30,1);
				else break;
			}
			opt1_db_int = atof(temp);
			if (opt1_db_int == 0.) {
				opt1_db_int = 2.;
				sprintf(temp,"%s","2.");
			}
			sprintf(opt1_str3,"%s",temp);

			memcpy(temp, colr1data.zero_db_value, 10);
			temp[10] = '\0';
			for (i=9; i>=0; i--) {
				if (memcmp (&temp[i]," ",1) == 0) memset(&temp[i],0X30,1);
				else break;
			}
			opt1_db_zero = atof(temp);
			if (opt1_db_zero == 0.) {
				opt1_db_zero = 2047.;
				sprintf(temp,"%s","2047.");
			}
			sprintf(opt1_str4,"%s",temp);

/* NEED */
                        memcpy(temp, colr1data.numclr, 2 );
                        temp[2] = '\0';
                        for (i=1; i>=0; i--) {
                                if (memcmp (&temp[i]," ",1) == 0) memset(&temp[i],
0X30,1);
                                else break;
                        }
	                memcpy(temp2, colr1data.numclr256, 3);
	                temp2[3] = '\0';
		        for (i=2; i>=0; i--) {
			   if (memcmp (&temp2[i]," ",1) == 0) memset(&temp2[i],0X30,1);
			   else break;
         		}

			opt1_num = atoi(temp);

                        numclr40 = opt1_num; numclr256 = atoi(temp2);
                        if( numclr256 == 0 ) opt1_num = numclr40;
                        else opt1_num = numclr256;

/* be sure opt1_num get adjusted if too large */
			if (opt1_num > MAX_COLORS-1/*40*/) opt1_num = MAX_COLORS-1/*40*/;

			if     (memcmp(colr1data.incr,"db ",3) == 0 ||
				memcmp(colr1data.incr,"DB ",3) == 0 ||
				memcmp(colr1data.incr," db",3) == 0 ||
				memcmp(colr1data.incr," DB",3) == 0 ||
				memcmp(colr1data.incr," dB",3) == 0 ||
				memcmp(colr1data.incr," Db",3) == 0 ||
				memcmp(colr1data.incr,"dB ",3) == 0 ||
				memcmp(colr1data.incr,"Db ",3) == 0 ) opt1_type = 2;
			else opt1_type = 1;
		}
		else if (memcmp(buffer,"2COLR",5) == 0 && color_count < opt1_num/*MAX_COLORS-1*//*40*/) {
			sum2++;
			memcpy(colr2data.colr2, line, 80);
			memcpy(color_data.color_bb  , colr2data.color_code1, 8);
			memcpy(temp, color_data.color_bb, 2);
			temp[2] = '\0';
			clr_bb[color_count] = atoi(temp);
			memcpy(temp, color_data.color_yy, 2);
			temp[2] = '\0';
			clr_yy[color_count] = atoi(temp);
			memcpy(temp, color_data.color_mm, 2);
			temp[2] = '\0';
			clr_mm[color_count] = atoi(temp);
			memcpy(temp, color_data.color_cc, 2);
			temp[2] = '\0';
			clr_cc[color_count] = atoi(temp);
			ymcrgb (clr_cc[color_count], clr_mm[color_count],
				clr_yy[color_count], clr_bb[color_count],
				&clr_rr[color_count], &clr_gg[color_count],
				&clr_bl[color_count]);
			color_count++;

			memcpy(color_data.color_bb  , colr2data.color_code2, 8);
			memcpy(temp, color_data.color_bb, 2);
			temp[2] = '\0';
			clr_bb[color_count] = atoi(temp);
			memcpy(temp, color_data.color_yy, 2);
			temp[2] = '\0';
			clr_yy[color_count] = atoi(temp);
			memcpy(temp, color_data.color_mm, 2);
			temp[2] = '\0';
			clr_mm[color_count] = atoi(temp);
			memcpy(temp, color_data.color_cc, 2);
			temp[2] = '\0';
			clr_cc[color_count] = atoi(temp);
			ymcrgb (clr_cc[color_count], clr_mm[color_count],
				clr_yy[color_count], clr_bb[color_count],
				&clr_rr[color_count], &clr_gg[color_count],
				&clr_bl[color_count]);
			color_count++;

			memcpy(color_data.color_bb  , colr2data.color_code3, 8);
			memcpy(temp, color_data.color_bb, 2);
			temp[2] = '\0';
			clr_bb[color_count] = atoi(temp);
			memcpy(temp, color_data.color_yy, 2);
			temp[2] = '\0';
			clr_yy[color_count] = atoi(temp);
			memcpy(temp, color_data.color_mm, 2);
			temp[2] = '\0';
			clr_mm[color_count] = atoi(temp);
			memcpy(temp, color_data.color_cc, 2);
			temp[2] = '\0';
			clr_cc[color_count] = atoi(temp);
			ymcrgb (clr_cc[color_count], clr_mm[color_count],
				clr_yy[color_count], clr_bb[color_count],
				&clr_rr[color_count], &clr_gg[color_count],
				&clr_bl[color_count]);
			color_count++;


			memcpy(color_data.color_bb  , colr2data.color_code4, 8);
			memcpy(temp, color_data.color_bb, 2);
			temp[2] = '\0';
			clr_bb[color_count] = atoi(temp);
			memcpy(temp, color_data.color_yy, 2);
			temp[2] = '\0';
			clr_yy[color_count] = atoi(temp);
			memcpy(temp, color_data.color_mm, 2);
			temp[2] = '\0';
			clr_mm[color_count] = atoi(temp);
			memcpy(temp, color_data.color_cc, 2);
			temp[2] = '\0';
			clr_cc[color_count] = atoi(temp);
			ymcrgb (clr_cc[color_count], clr_mm[color_count],
				clr_yy[color_count], clr_bb[color_count],
				&clr_rr[color_count], &clr_gg[color_count],
				&clr_bl[color_count]);
			color_count++;

			memcpy(color_data.color_bb  , colr2data.color_code5, 8);
			memcpy(temp, color_data.color_bb, 2);
			temp[2] = '\0';
			clr_bb[color_count] = atoi(temp);
			memcpy(temp, color_data.color_yy, 2);
			temp[2] = '\0';
			clr_yy[color_count] = atoi(temp);
			memcpy(temp, color_data.color_mm, 2);
			temp[2] = '\0';
			clr_mm[color_count] = atoi(temp);
			memcpy(temp, color_data.color_cc, 2);
			temp[2] = '\0';
			clr_cc[color_count] = atoi(temp);
			ymcrgb (clr_cc[color_count], clr_mm[color_count],
				clr_yy[color_count], clr_bb[color_count],
				&clr_rr[color_count], &clr_gg[color_count],
				&clr_bl[color_count]);
			color_count++;
		}
		if (fgets(buffer, 84, fp) == NULL) break;
	}
	fclose(fp);

   	if (sum1 == 0 && sum2 == 0) {
       		sprintf(msgbuf,"File does not contain any 1PLTR or 2PLTR cards\n%s",cardfilename);
        	message_box = DisplayMsg(bb,msgbuf,5);
        	XtManageChild (message_box);
        	return;
        }

   	if (sum1 == 0) {
       		sprintf(msgbuf,"File does not contain any 1PLTR cards.\nBoth 1PLTR and 2PLTR cards are required.\n%s",cardfilename);
        	message_box = DisplayMsg(bb,msgbuf,5);
        	XtManageChild (message_box);
        	return;
        }

   	if (sum2 == 0) {
       		sprintf(msgbuf,"File does not contain any 2PLTR cards.\nBoth 1PLTR and 2PLTR cards are required.\n%s",cardfilename);
        	message_box = DisplayMsg(bb,msgbuf,5);
        	XtManageChild (message_box);
		opt1_num = 0;
        	return;
        }
}
Boolean SavePLTRFile()
{
	Widget message_box;
	char msgbuf[80];
	double incr_actual;
	char temp[11], temp2[11];
	int i, j, md;
	int y,m,c;
	int div;
 
	struct colr1rec {
		char colr1[5];
		char blank1[2];
		char incr[3];
		char interval_lin[10];
		char level_high[10];
		char blank2[3];
		char display_opt[2];
		char interval_db[5];
		char zero_db_value[10];
/* NEED TO BE CHANGED IF 4 DIGIT NUM COLORS POSSIBLE */
		char blank3[3];
		char numclr[2];
		char blank4[1];
		char trace_fill[4];
		char blank5[20];
		char numclr256[3];
		char eof1[1];
	};

	struct colr1rec colr1data;

	struct colr2rec {
		char colr2[5];
		char blank6[2];
		char color_code1[8];
		char blank7[2];
		char color_code2[8];
		char blank8[2];
		char color_code3[8];
		char blank9[2];
		char color_code4[8];
		char blank10[2];
		char color_code5[8];
		char blank11[25];
		char eof2[1];
	};

	struct colr2rec colr2data;

	struct color_code {
		char color_bb[2];
		char color_yy[2];
		char color_mm[2];
		char color_cc[2];
	};

	struct color_code color_data;

    if ((tfp = fopen(pltrfilename, "w")) == NULL) {
	sprintf(msgbuf,"Unable to open file for write access");
	message_box = DisplayMsg(bb,msgbuf,1);
	XtManageChild (message_box);
       return(False);;
    }
	memset(colr1data.colr1,0X20,80);
	memset(colr1data.eof1,'\n',1);

	sprintf(temp,"1COLR");
	memcpy(colr1data.colr1, temp, 5);

	if (linlog == 2) sprintf(temp," DB");
	else sprintf(temp,"LIN");
	memcpy(colr1data.incr, temp, 3);

	sprintf(temp,"%10s",limitvalue[0]);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i]," ",1) != 0) {
			memset(&temp[i+1],'\0',1);
			sprintf(temp2,"%10s", temp);
			sprintf(temp,"%10s", temp2);
			break;
		}
	}
	memcpy(colr1data.level_high, temp, 10);

	if (incr_linear == 0.) {
		incr_actual = (boundary2 - boundary1) / (num_colors-2);
		sprintf(temp,"%10.9g",incr_actual);
	}
	else {
		sprintf(temp,"%10s",limitvalue[1]);
		for (i=9; i>=0; i--) {
			if (memcmp (&temp[i]," ",1) != 0) {
				memset(&temp[i+1],'\0',1);
				sprintf(temp2,"%10s", temp);
				sprintf(temp,"%10s", temp2);
				break;
			}
		}
	}
	memcpy(colr1data.interval_lin, temp, 10);

	sprintf(temp,"%10s",limitvalue[3]);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i]," ",1) != 0) {
			memset(&temp[i+1],'\0',1);
			sprintf(temp2,"%10s", temp);
			sprintf(temp,"%10s", temp2);
			break;
		}
	}
	memcpy(colr1data.interval_db, temp, 10);

	sprintf(temp,"%10s",limitvalue[4]);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i]," ",1) != 0) {
			memset(&temp[i+1],'\0',1);
			sprintf(temp2,"%10s", temp);
			sprintf(temp,"%10s", temp2);
			break;
		}
	}
	memcpy(colr1data.zero_db_value, temp, 10);

/* NEED TO BE CHANGED IF 4 DIGIT NUM COLORS POSSIBLE */
        if( num_colors > 40 ) sprintf(temp,"%2d",40);
	else sprintf(temp,"%2d",num_colors);
	memcpy(colr1data.numclr, temp, 2);

	sprintf(temp,"%3d",num_colors);
	memcpy(colr1data.numclr256, temp, 3);

	/* write to a temp file */

	fwrite(colr1data.colr1, sizeof(char), 84, tfp);

	div = 256;
	sprintf(temp,"2COLR");
	memcpy(colr2data.colr2, temp, 5);
	memset(colr2data.blank6,0X20,75);
	memset(colr2data.eof2,'\n',1);
	j = 0;

	for (i=num_colors-1; i>=0; i--) {
		md = j % 5;
		if (md == 0) memset(colr2data.blank6,0X20,75);

		current_color.pixel = color_pixel[i];
                if(visual->class == PseudoColor)
                  XQueryColor(display, default_cmap, &current_color);
                else 
                  pixel2color(&current_color,visual,depth);

		rgbymc ((int)current_color.red/div, (int)current_color.green/div, (int)current_color.blue/div,
			&y, &m, &c);

		sprintf (temp, " 0%2d%2d%2d", y,m,c);
		memcpy(color_data.color_bb, temp, 8);

		if (md == 0) memcpy(colr2data.color_code1, color_data.color_bb, 8);
		else if (md == 1) memcpy(colr2data.color_code2, color_data.color_bb, 8);
		else if (md == 2) memcpy(colr2data.color_code3, color_data.color_bb, 8);
		else if (md == 3) memcpy(colr2data.color_code4, color_data.color_bb, 8);
		else if (md == 4) memcpy(colr2data.color_code5, color_data.color_bb, 8);

		if (md == 4 || i == 0) fwrite(colr2data.colr2, sizeof(char), 81, tfp);
		j++;
	}
 
    /* flush and close the temp file */
    if (fflush(tfp) != 0) fprintf(stderr,"Warning: unable to flush file.\n");
    if (fclose(tfp) != 0) fprintf(stderr,"Warning: unable to close file.\n");

    return(True);
}
void OpenOutputPLTR()
{
	Widget message_box;
	char msgbuf[80];
	Arg args[1];

	if ((tfp = fopen(pltrfilename, "r")) != NULL) {
		fclose(tfp);
		/* file already exists - pop up menu to see what user wants to do */

                if( file_dialog == NULL ) create_pltrfile_menu(pltrsave_widget,NULL,NULL);

		XtSetArg(args[0], XmNlabelString,
			XmStringCreateLtoR(pltrfilename, charset));
		XtSetValues(file_label, args, 1);
		XmToggleButtonGadgetSetState(file_button[0], False, False);
		XmToggleButtonGadgetSetState(file_button[1], True, False);

;
		XtManageChild (file_dialog);
		return;
	}

	SavePLTRFile();
}
static Widget CreateColorListMenu(bb)
Widget bb;
{
        XmString        list_item[200];
	static Widget	selection_box;
	Widget		wid;
	Arg al[10];
	int ac;
	int i;
	
	static int first=1;

        for ( i = 0;  i < num_items;  i++ )
                list_item[i] = XmStringCreateLtoR (item[i], charset);

	if (first) {
	first = 0;
        ac = 0;
        XtSetArg (al[ac], XmNshadowThickness, 1);  ac++;
        XtSetArg (al[ac], XmNshadowType, XmSHADOW_OUT);  ac++;
        XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
        XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
        XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
        XtSetArg (al[ac], XmNlistLabelString,
                        XmStringCreateLtoR ("Palettes Available for Loading:",
                                                 charset));  ac++;
        XtSetArg (al[ac], XmNselectionLabelString,
                        XmStringCreateLtoR ("Active Dialog", charset));  ac++;
        selection_box = XmCreateSelectionBox (bb, "selection_box",
                        al, ac);
 
        XtAddCallback (selection_box, XmNcancelCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_LOAD_CANCEL);
        XtAddCallback (selection_box, XmNokCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_LOAD_ACCEPT);

        wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(wid);

	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_APPLY_BUTTON);
	XtUnmanageChild(wid);
/**
	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_SELECTION_LABEL);
	XtUnmanageChild(wid);
**/

	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_TEXT);
	/*XtSetSensitive(wid, False);*/
	}
	else {
		ac = 0;
		XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
		XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
		XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
		XtSetValues (selection_box, al, ac);
	}

	selected_item_index = 1;
	return(selection_box);
}
static Widget CreateDeleteColorListMenu(bb)
Widget bb;
{
        XmString        list_item[200];
	static Widget	selection_box;
	Widget		wid;
	Arg al[10];
	int ac;
	int i;
	
	static int first=1;

        for ( i = 0;  i < num_items;  i++ )
                list_item[i] = XmStringCreateLtoR (item[i], charset);

	if (first) {
	first = 0;
        ac = 0;
        XtSetArg (al[ac], XmNshadowThickness, 1);  ac++;
        XtSetArg (al[ac], XmNshadowType, XmSHADOW_OUT);  ac++;
        XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
        XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
        XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
        XtSetArg (al[ac], XmNlistLabelString,
                        XmStringCreateLtoR ("Palettes Available for Deletion:",
                                                 charset));  ac++;
        XtSetArg (al[ac], XmNselectionLabelString,
                        XmStringCreateLtoR ("Active Dialog", charset));  ac++;
        selection_box = XmCreateSelectionBox (bb, "selection_box",
                        al, ac);

        XtAddCallback (selection_box, XmNcancelCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_DELETE_CANCEL);
        XtAddCallback (selection_box, XmNokCallback, (XtCallbackProc)color_cb,
	(XtPointer) DIALOG_DELETE_ACCEPT);

        wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(wid);

	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_APPLY_BUTTON);
	XtUnmanageChild(wid);
/**
	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_SELECTION_LABEL);
	XtUnmanageChild(wid);
**/

	wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_TEXT);
	/*XtSetSensitive(wid, False);*/
	}
	else {
		ac = 0;
		XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
		XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
		XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
		XtSetValues (selection_box, al, ac);
	}

	selected_item_index = 1;
	return(selection_box);
}
static void savedefaultid(id)
int *id;
{
	char *filename = ".colorpalette256_defs";
	char datbuf[100];
	char filedefaults[200];
	int i, l1, l2;
	char *ppth;

	l1 = strlen(appl);
	if (l1 > 10) l1 = 10;
	l2 = strlen(subclass);
	if (l2 > 10) l2 = 10;

	ppth = getenv("HOME");
	sprintf (filedefaults, "%s/%s\0", ppth,filename);

	fp = fopen(filedefaults,"r+");
	if (fp != NULL) {
		while(1) {
			i = fread(datbuf, sizeof(char), sizeof(defaultdata), fp);
			memcpy(defaultdata.appl, datbuf, sizeof(defaultdata));
			if (feof(fp) != 0) {
				memset (defaultdata.appl, 0x20, sizeof(defaultdata));
				memcpy (defaultdata.appl, appl, l1);
				memcpy (defaultdata.subclass, subclass, l2);
				sprintf(defaultdata.code, "%-4d", *id);
				memset(defaultdata.newline, '\n', 1);
				memcpy(datbuf, defaultdata.appl, sizeof(defaultdata));
				fseek (fp, 0L, SEEK_END);
				i = fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
				break;
			}
			if (strncmp(appl, defaultdata.appl, l1) == 0 &&
				(l1 == 10 ||
				memchr(&defaultdata.appl[l1], '\0', 1) != NULL ||
				strncmp(&defaultdata.appl[l1], " ", 1) == 0) &&

				strncmp(subclass, defaultdata.subclass, l2) == 0 &&
				(l2 == 10 ||
				memchr(&defaultdata.subclass[l2], '\0', 1) != NULL ||
				strncmp(&defaultdata.subclass[l2], " ", 1) == 0))
			{

				sprintf(defaultdata.code, "%-4d", *id);
				fseek (fp, -i, SEEK_CUR);
				memset(defaultdata.newline, '\n', 1);
				memcpy(datbuf, defaultdata.appl, sizeof(defaultdata));
				i = fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
				break;
			}
		}
		fclose(fp);
	}
	else  {
		fp = fopen(filedefaults,"w");
		if (fp != NULL) {
			memset (defaultdata.appl, 0x20, sizeof(defaultdata));
			memcpy (defaultdata.appl, appl, l1);
			memcpy (defaultdata.subclass, subclass, l2);
			sprintf(defaultdata.code, "%-4d", *id);
			memset(defaultdata.newline, '\n', 1);
			memcpy(datbuf, defaultdata.appl, sizeof(defaultdata));
			i = fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
			fclose(fp);
		}
	}
}
static void reset_default_id(id)
int *id;
{
	char datbuf[100];
	char filedefaults[200];
	int i, l1, l2;
	static int zero=0;
	int notdone;

	char *palettename = ".colorpalette256_defs";
	char *ppth;

	l1 = strlen(appl);
	if (l1 > 10) l1 = 10;
	l2 = strlen(subclass);
	if (l2 > 10) l2 = 10;

	ppth = getenv("HOME");
	sprintf (filedefaults, "%s/%s\0", ppth,palettename);

	notdone = 1;
	while (notdone) {
		fp = fopen(filedefaults,"r+");
		notdone = 0;
		if (fp != NULL) {
			while(1) {
				i = fread(datbuf, sizeof(char), sizeof(defaultdata), fp);
				memcpy(defaultdata.appl, datbuf, sizeof(defaultdata));
				if (feof(fp) != 0) break;
				if (atoi(defaultdata.code) == *id) {
					sprintf(defaultdata.code, "%-4d", zero);
					fseek (fp, -i, SEEK_CUR);
					memset(defaultdata.newline, '\n', 1);
					memcpy(datbuf, defaultdata.appl, sizeof(defaultdata));
					i = fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
					notdone = 1;
					break;
				}
			}
			fclose(fp);
		}
	}
}
static void setnewlimits()
{
	static long int zero=0;
	register int i;
	char temp[22];

	linlog = (int)limitdata.limtyp;
	boundary2 = limitdata.bound2;
	incr_linear = limitdata.incr_lin;
	boundary1 = limitdata.bound1;
	incr_db = limitdata.incr_db;
	boundary3 = limitdata.bound3;
	sprintf(temp, "%-20.10f", boundary2);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i],"0",1) != 0) {
			memset(&temp[i+1],'\0',1);
			break;
		}
	}
	strncpy(opt1_str0, temp, 10);
	memset(&opt1_str0[10], '\0', 1);
	sprintf(temp, "%-20.10f", incr_linear);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i],"0",1) != 0) {
			memset(&temp[i+1],'\0',1);
			break;
		}
	
	}
	strncpy(opt1_str1, temp, 10);
	memset(&opt1_str1[10], '\0', 1);
	sprintf(temp, "%-20.10f", boundary1);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i],"0",1) != 0) {
			memset(&temp[i+1],'\0',1);
			break;
		}
	}
	strncpy(opt1_str2, temp, 10);
	memset(&opt1_str2[10], '\0', 1);
	sprintf(temp, "%-20.4f", incr_db);
	for (i=4; i>=0; i--) {
		if (memcmp (&temp[i],"0",1) != 0) {
			memset(&temp[i+1],'\0',1);
			break;
		}
	}
	strncpy(opt1_str3, temp, 10);
	memset(&opt1_str3[5], '\0', 1);
	sprintf(temp, "%-20.10f", boundary3);
	for (i=9; i>=0; i--) {
		if (memcmp (&temp[i],"0",1) != 0) {
			memset(&temp[i+1],'\0',1);
			break;
		}
	}
	strncpy(opt1_str4, temp, 10);
	memset(&opt1_str4[10], '\0', 1);
	parm_temp[0] = &opt1_str0[0];
	parm_temp[1] = &opt1_str1[0];
	parm_temp[2] = &opt1_str2[0];
	parm_temp[3] = &opt1_str3[0];
	parm_temp[4] = &opt1_str4[0];

	for (i=0; i<5; i++) limitvalue[i] = parm_temp[i];
}
static void rgbymc(r, g, b, y, m, c)
int r, g, b;
int *y, *m, *c;
{
    int ib, im, ic, iy;
    float minn;
    float C, M, Y;

    C = 255. - r;
    M = 255. - g;
    Y = 255. - b;

    C = (C/255.)*16. + 0.5;
    M = (M/255.)*16. + 0.5;
    Y = (Y/255.)*16. + 0.5;

    ic = (int)C;
    im = (int)M;
    iy = (int)Y;

    *c = ic;
    *m = im;
    *y = iy; 
}
static void
ymcrgb(c, m, y, bk, r, g, b)
int c, m, y, bk;
short int *r, *g, *b;
{
	int cc,mm,yy;
	float rr, gg, bb;

	if (bk > 0) {
		cc = c + bk;
		mm = m + bk;
		yy = y + bk;
		if (cc > 16) cc = 16;
		if (mm > 16) mm = 16;
		if (yy > 16) yy = 16;
	}
	else {
		cc = c;
		mm = m;
		yy = y;
	}

      rr = 16 - cc;
      gg = 16 - mm;
      bb = 16 - yy;
     
      rr = (rr/16.) * 255.;
      gg = (gg/16.) * 255.;
      bb = (bb/16.) * 255.;

      *r = (short int)rr;
      *g = (short int)gg;
      *b = (short int)bb;
}
void getdefaultid(id)
int *id;
{
        char *filename = ".colorpalette256_defs";
        char datbuf[100];
        char filedefaults[200];
        int i, l1, l2;
        char *ppth;
 
        *id = 0;
 
        ppth = getenv("HOME");
        sprintf (filedefaults, "%s/%s\0", ppth,filename);
 
        fp = fopen(filedefaults,"r");
        if (fp != NULL) {
                l1 = strlen(appl);
                l2 = strlen(subclass);
                while(1) {
                        i = fread(datbuf, sizeof(char), sizeof(defaultdata), fp);                        memcpy(defaultdata.appl, datbuf, sizeof(defaultdata));
                        if (feof(fp) != 0) break;
 
                        if (strncmp(appl, defaultdata.appl, l1) == 0 &&
                                (l1 == 10 ||
                                memchr(&defaultdata.appl[l1], '\0', 1) != NULL ||                                strncmp(&defaultdata.appl[l1], " ", 1) == 0) &&
 
                                strncmp(subclass, defaultdata.subclass, l2) == 0
&&
                                (l2 == 10 ||
                                memchr(&defaultdata.subclass[l2], '\0', 1) != NULL ||
                                strncmp(&defaultdata.subclass[l2], " ", 1) == 0))                        {
                                *id = atoi(defaultdata.code);
                                break;
                        }
                }
                fclose(fp);
        }        
}
void retrievepalette(item)
int item;
{
	int num_save;
	int i, j;

	for (j=1; j<item; j++) {
                fread(&titledata,sizeof(struct pal_title),1,luin);
                fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                fread(&limitdata,sizeof(struct pal_limits),1,luin);

#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&titledata,1);
		HTOCS(&titledata.entry_num,1);
		HTOCL(&rgbdata.length,1);
		HTOCS(&rgbdata.num_colors,3);
		HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
		HTOCL(&limitdata,1);
		HTOCS(&limitdata.limtyp,1);
		HTOCL(&limitdata.bound2,5);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"db4 titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"rgbdata.length = """);
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",rgbdata.length[indx]);
fprintf(stderr,"""\n");
fprintf(stderr,"num_colors = %d\n",rgbdata.num_colors);
fprintf(stderr,"contrast = %d\n",rgbdata.contrast);
fprintf(stderr,"brightness = %d\n",rgbdata.brightness);
for (i=0; i<rgbdata.num_colors; i++) {
 fprintf(stderr,"  %d - %d %d %d \n",i,rgbdata.colors[i][1],rgbdata.colors[i][2],rgbdata.colors[i][3]);
 }
}
#endif
                if( (int)limitdata.limtyp == 0 ) {
                  fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		  HTOCL(&arblimitdata,1);
		  HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
		  }

	}

        i=fread(&titledata,sizeof(struct pal_title),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	HTOCL(&titledata,1);
	HTOCS(&titledata.entry_num,1);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"db5 titledata.length = ");
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",titledata.length[indx]);
fprintf(stderr,"\n");
fprintf(stderr,"titledata.entry_num = %d\n",titledata.entry_num);

fprintf(stderr,"titledata.desc = ");
for (indx=0; indx<52; indx+=1) 
fprintf(stderr,"%c",titledata.desc[indx]);
fprintf(stderr,"\n");
}
#endif

	if (titledata.entry_num > 0 && i > 0) {
                i=fread(&rgbdata,sizeof(struct pal_rgb),1,luin);
                i=fread(&limitdata,sizeof(struct pal_limits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		HTOCL(&rgbdata.length,1);
		HTOCS(&rgbdata.num_colors,3);
		HTOCS(&rgbdata.colors,rgbdata.num_colors*3);
		HTOCL(&limitdata,1);
		HTOCS(&limitdata.limtyp,1);
		HTOCL(&limitdata.bound2,5);
#endif
#ifdef DEBUG
{
int indx;
fprintf(stderr,"rgbdata.length = """);
for (indx=0; indx<4; indx+=1) 
  fprintf(stderr,"%c",rgbdata.length[indx]);
fprintf(stderr,"""\n");
fprintf(stderr,"num_colors = %d\n",rgbdata.num_colors);
fprintf(stderr,"contrast = %d\n",rgbdata.contrast);
fprintf(stderr,"brightness = %d\n",rgbdata.brightness);
for (i=0; i<rgbdata.num_colors; i++) {
 fprintf(stderr,"  %d - %d %d %d \n",i,rgbdata.colors[i][1],rgbdata.colors[i][2],rgbdata.colors[i][3]);
 }
}
#endif
                if( (int)limitdata.limtyp == 0 ) {
                   i=fread(&arblimitdata,sizeof(struct pal_arblimits),1,luin);
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   HTOCL(&arblimitdata,1);
		   HTOCS(&arblimitdata.pal_arblimits,MAX_COLORS-1);
#endif
		   }

		if ((int)limitdata.limtyp != 0) setnewlimits();

                linlog = (int)limitdata.limtyp;
		num_save = num_colors;
		num_colors = rgbdata.num_colors;
                if( num_colors > ncolors-1 ) num_colors = ncolors-1;
/*
fprintf(stderr, "pallett %d   %d   %f   %f   %f\n",num_colors,linlog,limitdata.bound1,limitdata.bound2,limitdata.bound3);fflush(stderr);
*/
/* NEED THIS CHECK */
                if( num_colors > ncolors-1 ) num_colors = num_save;
		value_contrast = rgbdata.contrast;
		value_brightness = rgbdata.brightness;

		for (i=0; i<num_colors; i++) {
			current_color.red = rgbdata.colors[i][0];
			current_color.green = rgbdata.colors[i][1];
			current_color.blue = rgbdata.colors[i][2];

                        if (visual->class==TrueColor)   {
                          color2pixel(&current_color,visual,depth);
			  color_pixel[i]=current_color.pixel;
                        }
                        else 
			  current_color.pixel = color_pixel[i];

			color_save[i] = current_color;
		}
		for (i=0; i<MAX_COLORS-1; i++) {
                   arblimits[i] = arblimitdata.pal_arblimits[i];
                }

		XmScaleSetValue(contrast_slider, value_contrast);
		XmScaleSetValue(brightness_slider, value_brightness);
		update_color();

		current_color.pixel = color_pixel[ncolors-1];
                if(visual->class == PseudoColor)
                  XQueryColor(display, default_cmap, &current_color);
                else 
                  pixel2color(&current_color,visual,depth);

		if (num_save > num_colors) {
                        XtUnmanageChild( cbar );
			for (i=num_colors; i<num_save; i++) {
				XtUnmanageChild(button[i]);
				if (xbutton[i] != NULL)
					XtUnmanageChild(xbutton[i]);
			}
                        XtManageChild( cbar );
		}
		else if (num_save < num_colors) {
                   /*if( num_colors < ncolors-1 ) {*/
                        XtUnmanageChild( cbar );
			for (i=num_save; i<num_colors; i++) {
				XtManageChild(button[i]);
				if (xbutton[i] != NULL)
					XtManageChild(xbutton[i]);
			}
                        XtManageChild( cbar );
                   /*} else num_colors = num_save;*/
		}

		UpdateLimits();

		using_defaults = 0;
	}


	fclose(luin);
}
Pixel get_color(amp)
float amp;
{
        int high, low;
        int midvalue, prv_midvalue;

      
        prv_midvalue = -1;
        low = 0;
        high = num_colors - 1;

        while(1) {
                midvalue = (low + high) / 2;
                if (midvalue == prv_midvalue) {
                   return color_pixel[num_colors-1];
                }
                prv_midvalue = midvalue;

                if (amp <= color_limits[midvalue] &&
                        (midvalue == 0 || amp > color_limits[midvalue-1])) {
                            return color_pixel[midvalue];
                }
                else if (amp < color_limits[midvalue]) high = midvalue;
                else low = midvalue;
          }
}


static void arb_value_dialogCB(w,client,call)
Widget w;
caddr_t *client,*call;
{
        Widget rc01,rc2,label,seper,push1,push2;
        Widget vform, av_sw_widget,av_form, avbar;
        Widget horz_widget,dum_label;
        char name[51];
        Widget message_box;
 
        XmString xmstring;
        XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
 
        Arg args[51];
        Arg wargs[51];
        int argcnt,n,i;
        char buffer[256];

if( linlog != 0 ) {
   message_box = DisplayMsg(bb,"Arbitrary Limits has not been selected",1);
   XtManageChild (message_box);
   return;
}

if( arb_value_dialog != NULL ) {
   XtDestroyWidget( arb_value_dialog );
   arb_value_dialog = NULL;
}
if( arb_value_dialog == NULL ) {
        n = 0;
        XtSetArg( wargs[n],XmNdialogTitle, XmStringCreateLtoR ("Arbitrary Limits", XmSTRING_DEFAULT_CHARSET) );n++;
        arb_value_dialog = XmCreateFormDialog(bbe, "Arb", wargs,n );

        /* Create a row of buttons, one for each color to be edited */
        n = 0;
                    
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 10); n++;
        XtSetArg(wargs[n], XmNheight, 500); n++;
        XtSetArg(wargs[n], XmNwidth, 230); n++;
        vform = XmCreateForm( arb_value_dialog, "vform",wargs,n);
        XtManageChild(vform);
 
        n = 0;
        XtSetArg( wargs[n],XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNleftAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNrightAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNbottomAttachment, XmATTACH_FORM);n++;
        XtSetArg(wargs[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
        /*
        XtSetArg(wargs[n], XmNbottomPosition, 70); n++;
        */
        XtSetArg(wargs[n], XmNscrollingPolicy, XmSTATIC); n++;
        av_sw_widget = XmCreateScrolledWindow(vform,
                                        "file_sw_widget", wargs, n);
        XtManageChild(av_sw_widget);
 
        n=0;
        av_form = XmCreateForm(av_sw_widget, "file_form", wargs, n);
        XtManageChild(av_form);
 
        n=0;
        XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
        avbar = XtCreateManagedWidget("colorpanel",     xmRowColumnWidgetClass,
                                                        av_form, wargs, n);
/* want one less than number of buttons */
        
        for( i=0;i<num_colors-1;i++) {
           n=0;
           XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
           XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
           XtSetArg(wargs[n], XmNborderWidth, 0); n++;
           XtSetArg(wargs[n], XmNshadowThickness, 0); n++;
           XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
           horz_widget=XtCreateManagedWidget("horz",xmRowColumnWidgetClass, avbar,
                    wargs, n);
           n=0;
 
           sprintf(name,"%d",i);
           if( strlen(name) == 1 ) strcat( name, "  " );
           else if( strlen(name) == 2 ) strcat( name, " " );

           n = 0;
           XtSetArg(wargs[n], XmNlabelString,
                XmStringCreateLtoR(name,XmSTRING_DEFAULT_CHARSET)); n++;
           dum_label = XtCreateManagedWidget("arb", xmLabelWidgetClass,
                                                        horz_widget, wargs, n);

           sprintf(buffer, "%-14.7g", arblimits[i] );
           argcnt = 0;
           XtSetArg(args[argcnt], XmNcolumns, 15 ); argcnt++;
           XtSetArg(args[argcnt], XmNvalue, buffer);argcnt++;
           arbvalue_text_widgets[i] = XmCreateText(horz_widget, "text", args, argcnt);
           XtManageChild(arbvalue_text_widgets[i]);

 
        }
 

 
        n = 0;
        XtSetArg( wargs[n],XmNtopAttachment, XmATTACH_WIDGET);n++;
        XtSetArg( wargs[n],XmNleftAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNrightAttachment, XmATTACH_FORM);n++;
        XtSetArg( wargs[n],XmNtopWidget, vform );n++;
        seper = XmCreateSeparatorGadget(arb_value_dialog, "sepe", wargs, n);
        XtManageChild(seper);
 
        argcnt = 0;           
        XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
        XtSetArg(args[argcnt], XmNentryAlignment, XmALIGNMENT_CENTER); argcnt++;
        XtSetArg(args[argcnt], XmNspacing, 40); argcnt++;
        XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
        XtSetArg(args[argcnt], XmNmarginHeight,10); argcnt++;
        XtSetArg(args[argcnt], XmNmarginWidth, 40); argcnt++;
        XtSetArg( args[argcnt],XmNtopAttachment, XmATTACH_WIDGET);argcnt++;
        XtSetArg( args[argcnt],XmNleftAttachment, XmATTACH_FORM);argcnt++;
        XtSetArg( args[argcnt],XmNrightAttachment, XmATTACH_FORM);argcnt++;
        XtSetArg( args[argcnt],XmNtopWidget, seper );argcnt++;
        rc2 = XmCreateRowColumn(arb_value_dialog, "rc2", args, argcnt);
        XtManageChild (rc2);

        argcnt = 0;          
        XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
        push1 = XmCreatePushButtonGadget(rc2, "OK", args, argcnt);
        XtManageChild(push1);

                              
        argcnt = 0;
        XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
        push2 = XmCreatePushButtonGadget(rc2, "Cancel", args, argcnt);
        XtManageChild(push2);
 
        XtAddCallback(push1, XmNactivateCallback, (XtCallbackProc)color_cb,
		(XtPointer) DIALOG_ARBLIMITS_ACCEPT);
        XtAddCallback(push2, XmNactivateCallback, (XtCallbackProc)color_cb,
		(XtPointer)  DIALOG_ARBLIMITS_CANCEL);
 
        argcnt = 0;
        XtSetArg(args[argcnt], XmNdefaultButton, push1); argcnt++;
        XtSetArg(args[argcnt], XmNcancelButton, push2); argcnt++;
        XtSetValues(arb_value_dialog,args,argcnt);
 
}
 
   XtManageChild( arb_value_dialog );
}

void limit_typeCB(widget, itype, call)
Widget widget;
int itype;
XmToggleButtonCallbackStruct *call;
{
  int n;
  Arg arg[5];
  char buffer[256];

  /*************************************************************************
  ** set the type input flag
  *************************************************************************/
  if( call->reason == XmCR_VALUE_CHANGED ) {
     if( call->set == True ) linlog = itype;
  }


}

void color2pixel(XColor *color, Visual *visual, int depth)
{
   if (depth == 15) {
      color->pixel = ((color->red & 0xf800)>>1)
         + ((color->green & 0xf800)>>6)
         + ((color->blue & 0xf800)>>11);

   } else if (depth == 16) {
      color->pixel = ((color->red & 0xf800))
         + ((color->green & 0xfc00)>>5)
         + ((color->blue & 0xf800)>>11);

   } else if (depth == 24) {
      if(visual->red_mask == 0xff0000) {
        color->pixel = ((color->red & 0xff00)<<8)
           + ((color->green & 0xff00))
           + ((color->blue & 0xff00)>>8);
      }
      else {
        color->pixel = ((color->red & 0xff00)>>8)
           + ((color->green & 0xff00))
           + ((color->blue & 0xff00)<<8);
      }
   }

   return;
}

void pixel2color(XColor *color, Visual *visual, int depth)
{

#ifdef DEBUG
fprintf(stderr,"pixel2color: depth %d red_mask = 0x%08x\n",
	depth, visual->red_mask);
fprintf(stderr,"             green_mask = 0x%08x blue_mask = 0x%08x\n",
	visual->green_mask,visual->blue_mask);
#endif

   if (depth == 15) {
      color->red = ((color->pixel & visual->red_mask)<<1);
      color->green = ((color->pixel & visual->green_mask)<<6);
      color->blue = ((color->pixel & visual->blue_mask)<<11);

   } else if (depth == 16) {
      color->red = ((color->pixel & visual->red_mask));
      color->green = ((color->pixel & visual->green_mask)<<5);
      color->blue = ((color->pixel & visual->blue_mask)<<11);

   } else if (depth == 24) {
      if(visual->red_mask == 0xff0000) {
        color->red = ((color->pixel & visual->red_mask)>>8);
        color->green = ((color->pixel & visual->green_mask));
        color->blue = ((color->pixel & visual->blue_mask)<<8);
      }
      else {
        color->red = ((color->pixel & visual->red_mask)<<8);
        color->green = ((color->pixel & visual->green_mask));
        color->blue = ((color->pixel & visual->blue_mask)>>8);
      }
   }

   return;
}
