/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* Changes

   Nov 12 2001,
     Added logic to allow for UnitSc from USP line header.  Default
     if undefined is UnitSc = 0.001 which is the standard default
     in USP.  This allows the routine to deal with any type of data.
     The old logic was based on nsi > 32, need I say more.
   Garossino  */


#include "specal.h"
#include <localsys.h>
#define EXTERN_KEY

#include "globals.h"
#include "colorch.h"
#include "app_resources.h"

#define CONVERT2(word) (short)(((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff)
#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))

char *lines[4];

static char *input_file = NULL;
static char *old_input_file = NULL;
static char *filename = NULL;

Widget	file_select;
Widget	shell, menu_bar;
Widget	tog1d, tog4d, tog2d, tog3d, radio;
Widget	tog1p, tog2p, tog3p, radio2;

void	rdsp(), rman2();
void	rman2d();

Widget	DisplayData;
Widget  sep1, sep2, odometer;
Widget selfile;
Widget	form;
Widget nofile;

XtEventHandler handle_odomCB();
XtCallbackProc manage_widgetCB(), unmanage_widgetCB();
XtCallbackProc	adj_colorsCB();
XtEventHandler handle_odom2CB();

void unshow_d();

Font font;

Cursor cursor, cursor1;
Colormap AppCmap;


/*..cmam........................*/
extern Widget CreateColorEditor();
extern Widget DisplayColorEditor();
static Widget bb_Color;

static XtAppContext *app_con;

int	display_width, display_height;

int	scltyp;

/* create the menubar */
static Widget CreateMenuBar (parent)
	Widget	parent;
{
 	Widget	menubar;
	int	narg;
	Arg	arg[4];
	Arg	wargs[6];
	int	n;
	Widget	pulldown, cascade, button;
	Widget pulldown1, pulldown2;
	extern XtCallbackProc manage_widgetCB();
        XmString lstring;

        narg=0;
        XtSetArg(arg[narg], XmNorientation, XmHORIZONTAL); narg++ ;
        XtSetArg(arg[narg], XmNpacking, XmPACK_TIGHT); narg++ ;
        XtSetArg(arg[narg], XmNentryAlignment, XmALIGNMENT_CENTER); narg++ ;
     
	menubar = XmCreateMenuBar (parent, "menubar", arg, narg);
	XtManageChild(menubar);

/* create the buttons on the menubar */
	pulldown = XmCreatePulldownMenu (menubar, "pulldown", NULL, 0);

/* file button */
        narg = 0;
        XtSetArg(arg[narg], XmNsubMenuId, pulldown); narg ++;
        cascade = XmCreateCascadeButton(menubar, "File", arg, narg);
        XtManageChild(cascade);

        selfile = XmCreatePushButton(pulldown, "SelectFile", NULL, 0);
        XtAddCallback(selfile,XmNactivateCallback,fileact,NULL);
        XtManageChild(selfile);

        button = XmCreatePushButton(pulldown, "Exit", NULL, 0);
        XtAddCallback(button,XmNactivateCallback,quit_callback, NULL);
        XtManageChild(button);

/* display button */
	pulldown1= XmCreatePulldownMenu (menubar, "pulldown", NULL, 0);

        narg = 0;
        XtSetArg(arg[narg], XmNsubMenuId, pulldown1); narg ++;
        DisplayData = XmCreateCascadeButton(menubar, "Display", arg, narg);
	XtSetArg(arg[0], XmNsensitive, True);
	XtSetValues(DisplayData, arg, 1);
        XtManageChild(DisplayData);

        set_parm = XmCreatePushButton(pulldown1, "Set Parms", NULL, 0);
        XtAddCallback(set_parm,XmNactivateCallback,
		(XtCallbackProc)manage_widgetCB, parm_panel_dialog /* parm_panel */);
        XtManageChild(set_parm);

        redisp1 = XmCreatePushButton(pulldown1, "Display 1-D", NULL, 0);
        XtAddCallback(redisp1,XmNactivateCallback,rdsp, (XtPointer)1);
        XtManageChild(redisp1);

/*.......add selection box for 2-d spectra.....*/
        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                 XmStringCreate("Display 2-D", XmSTRING_DEFAULT_CHARSET)); n ++;
        XtSetArg(wargs[n], XmNfillOnArm, FALSE); n ++;
        XtSetArg(wargs[n], XmNhighlightOnEnter, FALSE); n ++;
        XtSetArg(wargs[n], XmNtraversalOn, FALSE); n ++;
        redisp2 = XtCreateManagedWidget("pulldown2",
                        xmPushButtonWidgetClass, pulldown1, wargs, n);
 
/*.........2-D.....beginning of selecting data files.............*/
        n = 0;
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 40); n++;
        XtSetArg(wargs[n], XmNdialogTitle,
           (lstring=XmStringCreate("Select 2-D File",
            XmSTRING_DEFAULT_CHARSET))); n++;
 
        pop_up_2d = XmCreateBulletinBoardDialog(pulldown1, "pop3", wargs, n);
        XmStringFree(lstring);
 
        n = 0;
        XtSetArg(wargs[n], XmNwidth, 100); n ++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n ++;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n ++;
        XtSetArg(wargs[n], XmNnumColumns, 1); n ++;
        XtSetArg(wargs[n], XmNresizeWidth, True); n ++;
        XtSetArg(wargs[n], XmNresizeHeight, True); n ++;
        pop_up2d = XtCreateManagedWidget("popup2",
                             xmRowColumnWidgetClass, pop_up_2d, wargs, n);
 
        XtAddCallback(redisp2,XmNactivateCallback,rman2d, NULL);
 
        kitems[0] = XtCreateWidget("Available Data Files",
                                        xmLabelWidgetClass, pop_up2d, NULL, 0);
        XtSetArg(wargs[0], XmNseparatorType, XmDOUBLE_LINE);
        kitems[1] = XmCreateSeparatorGadget(pop_up2d, "separator",  wargs, 1);
        XtManageChildren(kitems, 2);
 
/*.........2-D........end of creating popup for selecting data files.....*/
 
/*.......end of 2-d spectra selection box...............*/

        redisp3 = XmCreatePushButton(pulldown1, "Display Phase", NULL, 0);

        XtAddCallback(redisp3,XmNactivateCallback,rdsp, (XtPointer)3);
        XtManageChild(redisp3);

	return(menubar);
}

/*   Put this function at front of your program to make it *    global */
char * scalloc(nelem, elsize)
	unsigned  int   nelem, elsize;
{
    char *result;

    if((result = (char *)calloc(nelem, elsize)) == (char *)0)
    {
        printf("cannot calloc %d bytes/words\n", nelem);
        exit(1);
    }
    return result;
}

/**************************************************************************
*   Function do_2d reads from the input data set and computes
*   the two-dimensional Fourier transform and its amplitude spectrum.
*   This spectrum is then graphed and placed in a Pixmap, which is
*   returned.
*
*  NOTE: This returns a PIXMAP
*
*   The "calling" sequence is:
*   Pixmap
*        do_2d(ns, smp_st, lwin, rec_st, rec_end, ntpr, lui, dpy, id)
*
*
*
*    int ns        - Number of samples per trace on the input data set.
*
*    int smp_st    - starting sample for the temporal window.
*
*    int lwin      - length of the temporal window to be tranformed.
*
*    int rec_st    - starting record for the spatial window.
*
*    int rec_end   - ending record for the spatial window.
*
*    int ntpr      - number of traces per record on the input data set.
*
*    int lui       - logical unit for the input data set (must be
*                    open for read.)
*    Display *dpy  - Connection to the X server
*
*    XID id        - the Xid of the drawable (window)
*
*     NOTE:  The offset to the data past the trace header MUST be
*            defined as ITRWRD.  For SIS data, on the SUN, this is 64.
***************************************************************************/

void do_2d(ns,smp_st,lwin,rec_st,trc_st,trc_end,rec_end,
	   trc_incr,ntpr,lui,dpy,id, sp)
	int ns,smp_st, lwin, rec_st,trc_st,trc_end, rec_end,trc_incr, ntpr, lui;
	Display *dpy;
	XID id;
	Desc2d *sp;
{

	extern Visual *visual;
	int i, j, k, m, irec, itrc, lclr;
	int iflag, iflg;
    	int one, two;
    	int indx;
    	int scale, offset;
    	int nbytes, count;
    	int p1;
    	int half, halfp1, halfm1;
    	int len_trans, len2;
    	int len_sp, ndo;
    	int pw, ph;
    	int pw_src, ph_src;
    	int bitmap_pad, bytes_per_line;
	int next_rec, next_trc;

	float	minval;

	int	n, fi;

	void	get_file2();

	int	ix, iy;
	int	length;

	float local_max, temp, coffset;
	float local_maxx, maxvalx;
	float local_min;
    	float *px, *py, *pt;
    	float *pamp, *hold, *hamp, *kamp;
    	float *htemp;
    	float *tr, *y, *f1;
    	float *x;
	float xx1;

	Pixel maxcol, mincol;

    	char *c1, *c2;
	char	*pixout;

        unsigned char  *c1c, *c2c;
        unsigned short  *c1s, *c2s, tmps;
        unsigned int  *c1l, *c2l, tmpl;
        int ip;


	int	ii, jj, l;
	float	*p0;
	char	ctmp;
	int 	pos;
	int	xadd, yadd;
	int	xdim, ydim;
	int	*index;
	float	*freqs;
	int	fny, nl, label_inc;
	int 	kntr, x1, x2, xl;
	int	jpos, ipos;
	char	*time;

	Arg	args[5];
	int	nargs;
	int	iread;
	int	iwmax, ihmax;
	int	iwmaxx, ihmaxx;

	int	sttrc1;


/*  X stuff */

	void unshow_z();
	extern XtCallbackProc unmanage_widgetCB();
	extern XtCallbackProc manage_widgetCB();

	Widget  aline;

	extern Widget create_zoom_box();
	void create_zoom_parm();
	void zoom_free();
        void unshow_2d();
        void repaint_proc();
	void display_it2();
	static void	xs_ok_callback();

        XmString lstring;
    	int             scr;
    	XColor          color;

	Pixel	the_color;
	Pixel	get_color();

    	XImage          *local_image;
    	Colormap        cmap;
    	Pixmap          local = 0;

	static int	first_time = 1;
	static int	convert=0;

        int ntps, ntpi, pct;
        float pi;
        float scalar, xone;
	int st_tap, end_tap;


        int dpthrast, quantum;


        if(depth == 8)  {
           dpthrast=sizeof(char);
           quantum=8;
        }
        else if(depth == 15 || depth ==16 )  {
           dpthrast=2*sizeof(char);
           quantum=16;
        }
        else if(depth == 24 || depth ==32 )  {
           dpthrast=4*sizeof(char);
           quantum=32;
        }

	if (first_time) {
		first_time = 0;

                if(visual->class != PseudoColor) {
		   if ((depth == 15) || (depth == 16)) {
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		     if (visual->red_mask != 0x0000f800) convert = 1;
		     else convert = 0;
#endif
#if ( BYTE_ORDER == BIG_ENDIAN )
		     if (visual->red_mask != 0x00ff0000) convert = 1;
		     else convert = 0;
#endif
		   }
		   else if ((depth == 24) || (depth == 32)) {
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		   if (visual->red_mask != 0x00ff0000) convert = 1;
		   else convert = 0;
#endif
#if ( BYTE_ORDER == BIG_ENDIAN )
		   if (visual->red_mask != 0x000000ff) convert = 1;
		   else convert = 0;
#endif
		   }
		}
	}
	

/*.............increment counter -- check that it does not exceed
...........................dimension == 10 (for now)...............*/

	if(kselect > 9) {
/* ..............create a dialog message box ..............*/

          printf("For 2-D analysis, number of displays limited to 10\n");

          nargs = 0;
          XtSetArg(args[nargs], XmNcolormap, AppCmap); nargs++;
          XtSetArg(args[nargs], XmNdialogTitle,
           (lstring=XmStringCreate("Error:too many 2-d displays",
            XmSTRING_DEFAULT_CHARSET))); nargs++;
 
          ktoo = XmCreateMessageDialog(bboard, "trinc", args, nargs);
          XmStringFree(lstring);
          XtUnmanageChild(
                        XmMessageBoxGetChild (ktoo, XmDIALOG_CANCEL_BUTTON));
          XtUnmanageChild(
                        XmMessageBoxGetChild (ktoo, XmDIALOG_HELP_BUTTON));
 
          for (i = 0; i < 3; i ++) {
             lines[i] = (char *)calloc(50, sizeof(char));
          }

          strcpy(lines[0],"2-D Analysis has been selected:");
          strcpy(lines[1],"10 displays are allowed, and 10");
          strcpy(lines[2],"have already been generated!!!!");
  
          lstring = (XmString) NULL;
          lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
                          XmSTRING_DEFAULT_CHARSET));
          lstring = XmStringConcat(lstring, XmStringSeparatorCreate());
          lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
                          XmSTRING_DEFAULT_CHARSET));
          lstring = XmStringConcat(lstring, XmStringCreate(lines[2],
                          XmSTRING_DEFAULT_CHARSET));
  
          nargs = 0;
          XtSetArg(args[nargs], XmNmessageString,lstring); nargs ++;
          XtSetValues(ktoo, args, nargs);
          XmStringFree(lstring);
          XtAddCallback(ktoo,XmNokCallback,xs_ok_callback, parm_panel);
   
          for (i = 0; i < 3; i ++)
             free(lines[i]);
  
          XBell(display,50);
          XtManageChild(ktoo);
          return;
        }

 /*...............end of error dialog...................*/

	sp->thisn = kselect;

/*...............create widgets for this 2_D display....*/
        n=0;
	XtSetArg(args[n], XmNwidth, 500); n++;
	XtSetArg(args[n], XmNheight, 500); n++;

	ii = (kselect+1) * 20;
        XtSetArg(args[n], XmNx, ii); n++;

	ii +=50;
        XtSetArg(args[n], XmNy, ii); n++;
        XtSetArg(args[n], XmNcolormap, AppCmap); n++;

        lines[0] = (char *)calloc(50, sizeof(char));
	sprintf(lines[0],"2-D #%d",kselect+1);

        sp->topa=XtAppCreateShell(lines[0],"move", topLevelShellWidgetClass,dpy,args,n);

        XtResizeWindow(sp->topa);

	free(lines[0]);

	n = 0;
	sp->forma = XmCreateForm(sp->topa, "toplev", args, n);
	XtManageChild (sp->forma);

/* *  Build the drawing area, attach a scrolled window to it.  */
        j = 0;
        XtSetArg(args[j], XmNheight, 20); j ++;
        XtSetArg(args[j], XmNorientation, XmHORIZONTAL); j ++;
        sp->roco = XtCreateManagedWidget("rowcol3",
                             xmRowColumnWidgetClass, sp->forma, args, j);

        n = 0;
        XtSetArg(args[n], XmNlabelString,
                    XmStringCreate("Dismiss", XmSTRING_DEFAULT_CHARSET)); n ++;
        sp->butd = XtCreateManagedWidget("pub1a",
                               xmPushButtonWidgetClass, sp->roco, args, n);
        XtAddCallback(sp->butd, XmNactivateCallback, unshow_2d, (XtPointer)sp->thisn);
        XtAddCallback(sp->butd, XmNactivateCallback, zoom_free, (XtPointer)sp->thisn);
 
        n = 0;
        XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
        XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
	XtSetArg(args[n], XmNvisualPolicy, XmVARIABLE); n++;
	XtSetArg(args[n], XmNscrollBarPlacement, XmBOTTOM_RIGHT); n++;
	
	XtSetArg(args[n], XmNwidth, 500);
	XtSetArg(args[n], XmNheight, 500);

        sp->viewa = XtCreateManagedWidget("view",
                         xmScrolledWindowWidgetClass, sp->forma, args, n);
 
/* ** Setup scrollbars */
 
        n = 0 ;
        XtSetArg (args[n], XmNverticalScrollBar, &sp->vvsb) ; n++ ;
        XtGetValues (sp->viewa, args, n) ;
 
        n = 0 ;
        XtSetArg (args[n], XmNhorizontalScrollBar, &sp->vhsb) ; n++ ;
        XtGetValues (sp->viewa, args, n) ;
/* ........end of scrollbar setup................*/
 
	n = 0;
	XtSetArg(args[n], XmNmarginHeight, 0); n ++;
	XtSetArg(args[n], XmNmarginWidth, 0); n++;
 
        sp->drawa = XtCreateManagedWidget("draw",
                         xmDrawingAreaWidgetClass, sp->viewa, args, n);
        n = 0;
        XtSetArg(args[n], XmNworkWindow, sp->drawa); n++;
        XtSetArg (args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
 
        XtSetValues(sp->viewa, args, n);
        XtAddCallback(sp->drawa, XmNexposeCallback,
                                                get_file2, (XtPointer)sp->thisn);
 
/* add a button for changing colormap on 2-d display */

        n = 0;
        XtSetArg(args[n], XmNlabelString,
            XmStringCreate("ChangeColorScale", XmSTRING_DEFAULT_CHARSET)); n ++;

        sp->butcc = XtCreateManagedWidget("pub4a",
                                xmPushButtonWidgetClass, sp->roco, args, n);

        XtAddCallback(sp->butcc, XmNactivateCallback, (XtCallbackProc)adj_colorsCB,
		(XtPointer)sp->thisn);
 
/* end of changing colormap button additions */
 
/* add a button for zooming on 2-d display */
        create_zoom_parm(sp->thisn);

        n = 0;
        XtSetArg(args[n], XmNlabelString,
            XmStringCreate("Zoom", XmSTRING_DEFAULT_CHARSET)); n ++;
        sp->butz = XtCreateManagedWidget("pub4a",
                                xmPushButtonWidgetClass, sp->roco, args, n);
 
        n = 0;
        XtSetArg(args[n], XmNx, 10); n++;
        XtSetArg(args[n], XmNy, 40); n++;
        XtSetArg(args[n], XmNdialogTitle, (lstring=XmStringCreate("Zoom Options",
            XmSTRING_DEFAULT_CHARSET))); n++;
 
        sp->pop_upz = XmCreateBulletinBoardDialog(sp->forma, "pop3", args, n);
        XmStringFree(lstring);
 
        XtAddCallback(sp->butz,XmNactivateCallback,(XtCallbackProc)manage_widgetCB,
                sp->pop_upz);

        for (i = 0; i < 2; i ++) {
           lines[i] = (char *)calloc(50, sizeof(char));
        }

        sprintf(lines[0],"Define Zoom");
        XtSetArg(args[0], XmNy, 0);
        sp->kline0 = XtCreateManagedWidget(lines[0],
                                   xmPushButtonWidgetClass,sp->pop_upz, args, 1);
        XtAddCallback(sp->kline0, XmNactivateCallback,
                           (XtCallbackProc)unmanage_widgetCB, sp->pop_upz);
        XtAddCallback(sp->kline0, XmNactivateCallback,
                           (XtCallbackProc)manage_widgetCB, sp->zoom_parm_panel);
 
        sprintf(lines[1],"Dismiss Zoom");
        XtSetArg(args[0], XmNy, 35);
        sp->kline1 = XtCreateManagedWidget(lines[1],
                                   xmPushButtonWidgetClass,sp->pop_upz, args, 1);

        XtAddCallback(sp->kline1,XmNactivateCallback,unshow_z, (XtPointer)sp->thisn);
        XtAddCallback(sp->kline1,XmNactivateCallback,zoom_free, (XtPointer)sp->thisn);
        XtAddCallback(sp->kline1, XmNactivateCallback,
                           (XtCallbackProc)unmanage_widgetCB, sp->pop_upz);

	free(lines[0]);
	free(lines[1]);
 
/* end of zooming button additions */
 
/*...define positions within forma...*/
        n = 0;
        XtSetArg(args[n], XmNwidth, 500); n++;
        XtSetArg(args[n], XmNheight, 20); n++;
        sp->odom = XmCreateDrawingArea (sp->forma, "odometer", args, n);

        XtManageChild (sp->odom) ;
 
        n = 0;
        XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
        sep2 = XmCreateSeparator(sp->forma, "sep1", args, n);

        XtManageChild(sep2);
/*................................................................*/
 
        n = 0 ;
        XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
        XtSetValues (sp->odom, args, n) ;
 
 
 
/*................................................................*/
        n = 0 ;
        XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
        XtSetArg (args[n], XmNtopWidget, sp->odom) ; n++ ;
        XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
        XtSetValues (sep2, args, n) ;
/*................................................................*/

        n = 0 ;
        XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
        XtSetArg (args[n], XmNtopWidget, sep2) ; n++ ;
        XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
        XtSetValues (sp->roco, args, n) ;
/*................................................................*/
 
 
        n = 0 ;
        XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
        XtSetArg (args[n], XmNtopWidget, sp->roco) ; n++ ;
        XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
        XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
        XtSetValues (sp->viewa, args, n) ;

/* *   Compute the length of the temporal transform (len_trans),
*   the number of complex pairs (ncmplx), and the actual length
*   of the temporal transform (len_trans+2) */

        len_trans = 16;
        while (len_trans < lwin)    len_trans *=2;

        ncmplx = len_trans/2 + 1;
        len2 = len_trans*2 + 2;
 
/* *   allocate space for the trace data (tr) and for a work
*   space for the temporal transform (y) */

	tr = (float *)scalloc(ns + ITRWRD, (int)sizeof(float));

/* *   Compute the number of traces to read (ndo) */
        ndo = rec_end - rec_st;
        ndo *= ntpr;
        ndo = ndo - trc_st + 1 + trc_end;
        ndo = (ndo - trc_incr )/ trc_incr + 1;

        yadd = 22 + (int)(num_font.height + letter_font.height) +20;
        can_hi = 820;

        xadd = 22 + (int)(3.*num_font.width) + (int)(letter_font.width)+ 10;
        pixwidth = 1026;

	xpos = xadd - 10;
	ypos = 10;

/* *   Compute the length of the spatial transform (len_k_xform),
*   and the actual length of the transform (len_sp); */

        len_k_xform = 16;
        while (len_k_xform < ndo)    len_k_xform *=2;
 
/*.............make length of spatial transform a minimum of 256....*/
        if(len_k_xform < 256) len_k_xform = 256;

        len_sp = len_k_xform + len_k_xform + 2;

	fi = len2;
	if(len_sp > len2) fi = len_sp;

        y = (float *)scalloc(fi, (int)sizeof(float));

/* *   Allocate the workspace for the spatial transform (x)
*   and for the spatial spectrum (amp) */

        j = len_sp * len2;
        if(hold2d) free(hold2d);

	hold2d = (float *)scalloc(j, (int)sizeof(float));
        x = hold2d;
        j = (len_k_xform + 1) * ncmplx;


/*  free old amp if one exists */
        sp->amp = (float *)scalloc(j, (int)sizeof(float));

   	lclr = 2 * lwin;
	one = 1;
	two = 2;
	maxval = 0;
	maxvalx = 0.;
        minval = 9999999.;
    
	px = x;
        py = y;
        pt = tr;
        pamp = sp->amp;
        irec = 0;
        itrc = 0;

/*  next_rec and next_trc are variables expected by get_next  */

        next_rec = rec_st;
        next_trc = trc_st;

/*  *   Allocate some work space needed to "unwrap" the spectrum */

        hamp = (float *)scalloc(((len_k_xform+1)*ncmplx), (int)sizeof(float));
        kamp = (float *)scalloc(len_k_xform+1, (int)sizeof(float));
        /*hamp = (float *)scalloc(((len_k_xform+1)*ncmplx), sizeof(float));
        kamp = (float *)scalloc(len_k_xform+1, sizeof(float));*/

/*...........generate cosine taper function for temporal.............*/
        if(lwin < nss) {
           pi = 3.14159265;
           pct = 10;
	   xone = 1.;
           ntpi = (int)(.01*pct*lwin/2);

           artap = (float *)scalloc(lwin,(int)sizeof(float));
           /*artap = (float *)scalloc(lwin,sizeof(float));*/

           vfill_(&xone, artap, &one, &lwin);

/*.........allow for si in microseconds...................*/
	   st_tap = st_win/smpint;

	   if(st_tap == 0) st_tap = 1;

/*.........allow for si in microseconds...................*/
	   end_tap = end_win/smpint;
	   if(end_tap == 0) end_tap = nss;

           if(st_tap > 1) {
              for(i=0; i<ntpi; i++) {
                 artap[i] = (float)(1-cos(pi*i/ntpi))/2;
              }
           }

           if(end_tap < nss) {
                          for(i=0; i<ntpi; i++) {
                                artap[lwin-1-i] = (float)(1-cos(pi*i/ntpi))/2;
                          }
           }

/*...........generate cosine taper function for spatial.............*/
 	   ntps = (int)(.01*pct*ndo/2);
	   srtap = (float *)scalloc(ndo,(int)sizeof(float));
	   /*srtap = (float *)scalloc(ndo,sizeof(float));*/
	   vfill_(&xone, srtap, &one, &ndo);

	   if(st_tap > 1) {
	     for(i=0; i<ntps; i++) {
		srtap[i] = (float)(1-cos(pi*i/ntps))/2;
	     }
	   }

	   if(end_tap < nss) {
 	     for(i = 0; i<ntps; i++) {
		srtap[ndo-1-i] = (float)(1-cos(pi*i/ntps))/2;
	     }
	   }
        }
 
/*.............end of generating taper func.............*/

/* 071991 mam find the first trace specified */
        iread = 0;

/*.............................
        while(!iread) {
             nbytes =0;
             rtape(luin, tr, &nbytes);

             if(nbytes) {
                saver(tr,"RecNum", &irec, TRCHED);
                saver(tr,"TrcNum", &itrc, TRCHED);
             }
             else {
                printf("Error reading input file %s\n", input_file);
                printf("Looking for start record %d ,trace %d\n",
                                st_rec, st_trc);
                printf("Last read record %d trace %d\n", irec, itrc);
                                exit(-1);
             }

             if (irec == st_rec && itrc == st_trc) iread = 1;
         }
...........................*/

         iselect = 0;
	 if(st_rec > 1) {
	   for (i = 1; i < st_rec; i++) {
	      skipt(luin,lntr);
	   }
	 }

	 if(st_trc > 1) {
	    sttrc1 = st_trc - 1;
	    skipt(luin,sttrc1);
  	 }

/* .......................................... */

/* *   Do the temporal transform */

        hold = px;
	px -= len2;

	for (i = 1; i <= ndo; i++) {

/* 071091 mam read next record............*/
            nbytes = 0;
            rtape(luin, tr, &nbytes);
/*.........................................*/
    	    if (!nbytes) {
       		printf("Error reading input file %s\n", input_file);
       		printf("Trying to read sequential trace number %d\n", i);
       		printf("Last read record %d trace %d\n", irec, itrc);
       		exit(-1);
     	    }

            saver(pt, "RecNum", &irec, TRCHED);
            saver(pt, "TrcNum", &itrc, TRCHED);


	    vclr_(py, &one, &len2);
	    vmov_(pt + ITRWRD + smp_st - 1, &one, py, &one, &lwin);

/*.............use cosine taper if data is windowed.................*/
            if(lwin < nss) {
                vmul_(py,&one,artap,&one,py,&one,&lwin);
		scalar = srtap[i-1];
		if(scalar < 1.0)
		    vsmul_(py,&one,&scalar,py,&one,&lwin);
  	    }

	    iflag = 1;
	    rfft_(py, &len_trans, &iflag);
	    iflag = 3;
	    scale = 1;
	    rfftsc_(py, &len_trans, &iflag, &scale);

/* *  Store the temporal transforms end-to-end in x */
   	    px += len2;
	    vmov_(py, &one, px, &one, &len2);

	}


/* *  Do the spatial transform */

        px = hold;
        hold = pamp;
        pamp -= (len_k_xform) + 1;

	half = (len_k_xform)/2;
        halfp1 = half + 1;
        halfm1 = half - 1;

	for ( i= 0; i < ncmplx; i++) {
		vclr_(py, &one, &len_sp);

/*   grab the real part of the transform  */
		vmov_(px, &len2, py, &two, &ndo);

/*   grab the imaginary  part of the transform  */
		vmov_(px + 1, &len2, py + 1, &two, &ndo);

		iflag = 1;
		cfft_(py, &len_k_xform, &iflag);
		cfftsc_(py, &len_k_xform);
		cvabs_(py, &two, kamp, &one, &len_k_xform);
		maxv_(kamp, &one, &local_max, &indx, &len_k_xform);

		if (local_max > maxval) {
			maxval = local_max;
			iwmax = indx - 1;
			ihmax = i;
		}

		minv_(kamp, &one, &local_min, &indx, &len_k_xform);

   	        if(local_min < minval) minval = local_min;

/*  "Unwrap" the transform  */
                htemp = hamp + half;

		vmov_(kamp, &one, htemp, &one, &halfp1);
                vmov_(kamp+halfp1, &one, hamp+1, &one, &halfm1);

		*hamp = *(hamp + len_k_xform);
		pamp += (len_k_xform) + 1;
                j = len_k_xform + 1;

		vmov_(hamp, &one, pamp, &one, &j);
                maxv_(hamp, &one, &local_maxx, &indx, &j);

                if (local_maxx > maxvalx) {
                        maxvalx = local_maxx;
                        iwmaxx = indx - 1;
                        ihmaxx = i;
		}

                px += 2;

	}
        pamp = hold;

/*  *    Now graph the spectrum */

	one = 1;
        iflg = 1;
        pw_src = len_k_xform + 1;  	 /*  nk  */
        ph_src = ncmplx;  		 /*  nf  */


	scr = DefaultScreen(dpy);
	sp->cmap = AppCmap;

	one = 1;
	pw = pixwidth;
	ph = can_hi;

/* *   Create the pixmap for drawing */

        if (pw_src > pw)  pw = pw_src;
        if (ph_src > ph)  ph = ph_src;
        if (pw_src <= pw/3 && ph_src <= ph/3) {
     	   factor = 3;
	}
        else if (pw_src <= pw/2 && ph_src <= ph/2) {
	   factor = 2;
	}
        else {
    	   factor = 1;
	}

	pw = pw_src * factor;
	ph = ph_src * factor;
	pixwidth = pw;
	can_hi = ph;

    	count = pw_src * ph_src;

/*................................*/
	pws1 = pw_src;
	phs1 = ph_src;
/*................................*/

	xdim = pw + xadd;
        if (xdim < (int)(strlen(input_file) * 6 + xadd)) xdim = (strlen(input_file) * 6 + xadd);

	ydim = ph + yadd;

	XSynchronize(dpy, True);

	sp->pixmap2 = XCreatePixmap(dpy, id, xdim, ydim, depth);
	if (!(sp->pixmap2))
		printf("  Creation failed for pixmap %d\n", kselect);

	gcvals.foreground = WhitePixel(dpy, DefaultScreen(dpy));
	gcvals.background = BlackPixel(dpy, DefaultScreen(dpy));
	sp->gc2 = XCreateGC(dpy, sp->pixmap2, GCForeground|GCBackground,
			&gcvals);
	first_time = 0;

/* *    Fill the rectangle to clear it for drawing */

	XFillRectangle(dpy, sp->pixmap2, sp->gc2, 0, 0, xdim, ydim);

	gcvals.foreground = BlackPixel(dpy, DefaultScreen(dpy));
	gcvals.background = WhitePixel(dpy, DefaultScreen(dpy));
	XChangeGC(dpy, sp->gc2, GCForeground | GCBackground, &gcvals);

	XSynchronize(dpy, False);

/* set label values for frequency axis (vertical) 
   assume asmpint in milliseconds*/
	fnyqst = 1000./(2. * asmpint);
	label_inc = 5;

        fny = (int)fnyqst;
        nl = (int)(fnyqst/ (float)label_inc) + 2;

        index = (int *)scalloc(nl, (int)sizeof(int));
        freqs = (float *)scalloc(nl, (int)sizeof(float));

        /*index = (int *)scalloc(nl, sizeof(int));
        freqs = (float *)scalloc(nl, sizeof(float));*/

	freq_incr = fnyqst/(float)(ncmplx-1);
        k = 0;

        for (i = 0; i <= fny; i+= label_inc) {
                freqs[k] = (float)i;
                index[k] = (int)(freqs[k]/freq_incr);
                k++;
        }

/* end of setting label values */

/* label the frequency axis (vertical) */
        kntr = 0;
	x2 = xadd - 11;
	x1 = x2 - 10;

/* time = (char *)scalloc(80, sizeof(char)); */

	time = (char *)scalloc(256, sizeof(char)); /* bumped 7/28/00 jmw */

        for (i = 0; i < ncmplx; i++) {
		k = ncmplx - i - 1;
                jpos = k * factor + 10;

                if( i == index[kntr]) {
                        XDrawLine(dpy, sp->pixmap2, sp->gc2,

                    	x1, jpos, x2, jpos);
                        sprintf(time,"%d", (int)freqs[kntr]);
			xl = strlen(time);
                        ipos = x1 -2 - xl*num_font.width;

                        XDrawString(dpy, sp->pixmap2, sp->gc2,
                                ipos, jpos, time, xl);

                        kntr++;
                }
        }

        ipos = 5;

        jpos = (ncmplx/2.)*factor + 11 - 4*letter_font.height;
        sprintf(time,"T");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"E");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"M");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"P");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"O");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"R");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"A");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"L");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos, jpos, time, strlen(time));


/* end of labeling the frequency axis (vertical) */

/* label the horizontal axis (decay) */

	ipos = xadd - 10;
	jpos = ph + 10;
	XDrawLine(dpy, sp->pixmap2, sp->gc2, ipos, jpos, ipos, jpos + 10);

	sprintf(time,"-.5");
	XDrawString(dpy, sp->pixmap2, sp->gc2, ipos - num_font.width,
		jpos + 12 + num_font.height, time, strlen(time));

	ipos = ipos + pw - factor;
        XDrawLine(dpy, sp->pixmap2, sp->gc2, ipos, jpos, ipos, jpos + 10);

        sprintf(time,"+.5");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos - num_font.width,
                jpos + 12 + num_font.height, time, strlen(time));

	ipos = (ipos + xadd - 9) / 2;
        XDrawLine(dpy, sp->pixmap2, sp->gc2, ipos, jpos, ipos, jpos + 10);

        sprintf(time,"0");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos - num_font.width/2,
                jpos + 12 + num_font.height, time, strlen(time));

	ipos = ipos - 2.5*letter_font.width;
	jpos = ydim - 20;
        sprintf(time,"SPATIAL");
        XDrawString(dpy, sp->pixmap2, sp->gc2, ipos,
                jpos, time, strlen(time));

/* end of labeling for horizontal axis (decay) */

/* ..... label with filename .... */

        sprintf(time,"%s",input_file);
	ix = xadd - 10;
	iy = ydim - 5;
        XDrawString(dpy, sp->pixmap2, sp->gc2,
                        ix, iy, time, strlen(time));

/*..... end of filename labeling..*/

/*.................add pushbutton label for 2d display......*/
        files2[kselect] = (char *)calloc(1024, sizeof(char));
        sprintf(files2[kselect],
		"Window %d:%s:r%d t%d #%d s%d e%d",
		kselect+1,input_file,rec_st,
		trc_st,ndo,smp_st,lwin);

        kitems[kselect+2] = XtCreateManagedWidget(files2[kselect],
                                   xmPushButtonWidgetClass,pop_up2d, NULL, 0);

        XtAddCallback(kitems[kselect+2], XmNactivateCallback,
                                                get_file2, (XtPointer)sp->thisn);
        XtAddCallback(kitems[kselect+2], XmNactivateCallback,
                                (XtCallbackProc)unmanage_widgetCB, pop_up_2d);

/*.......define title for this window...........*/
        nargs = 0;
        XtSetArg(args[nargs], XmNtitle,files2[kselect]); nargs ++;
        XtSetValues(sp->topa, args, nargs);
/*...........................................................*/

        fscale = 2047./maxval;
        coffset = 0;
        f1 = pamp;
        px= x;

/*............................*/
        phs1 = ph_src;
        pws1 = pw_src;
/*............................*/

	pt = px;
        for (i = 0; i < phs1; i++) {
		for (j = 0; j < pws1; j++) {
	    		px = pt + (phs1 - (i+1)) * pws1 + j;
            		temp = (*f1);
			xx1 = (temp * fscale + coffset);
			*px = xx1;
        		f1 ++;
		}
	}

/* 4-2-91 mam expand picture by factor in both dimensions */

	count = pw * ph;
	pixout = (char *)scalloc(count, dpthrast);

	/*c1 = pixout;
	c2 = c1;*/
        if(depth == 8)
	  { c1c = (unsigned char *)pixout; c2c=c1c;}
        else if(depth == 15 || depth ==16 )
	  { c1s = (unsigned short *)pixout; c2s=c1s;}
        else if(depth == 24 || depth ==32 )
	  { c1l = (unsigned int *)pixout; c2l=c1l;}

	p0 = x;

/*......................*/
        ph1 = ph;
        pw1 = pw;
/*......................*/

        maxcol = 0;
        mincol = 29;

	for (i = 0; i < ph1; i += factor) {

	   for (j = 0; j < pw1; j += factor) {

		the_color = get_color(*p0++);
		if(the_color > maxcol) maxcol = the_color;
		else if (the_color < mincol) mincol = the_color;

		ii = i;

		for (k = 1; k <= factor; k++) {
			jj = j;

			for (l = 0; l < factor; l++) {
				pos = ii * pw1 + jj;

				/*c1 = c2 + pos;*/
                                if(depth == 8) c1c = (c2c+pos);
                                else if(depth == 15 || depth ==16 ) c1s = (c2s+pos);
                                else if(depth == 24 || depth ==32 ) c1l = (c2l+pos);


                		/*memset (c1, (int)the_color, 1);*/
                                for(ip=0; ip< 1; ip++) {
                                   if(depth == 8)
                                     *(c1c)=(unsigned char)the_color;
                                   else if(depth == 15 || depth ==16 )
                                     *(c1s)=(unsigned short)the_color;
                                   else if(depth == 24 || depth ==32 )
                                     *(c1l)=(unsigned int)the_color;
                                }

				jj++;
			}
			ii++;
		}
	   }
	}

        bytes_per_line = 0;
        bitmap_pad = quantum;
        offset = 0;

	if (convert) {
          if(depth == 15 || depth ==16 ) {
	    c1s = (unsigned short *)pixout;
	    for (i=0; i<count; i++) {
	      tmps = (unsigned short) CONVERT2(*(c1s+i));
	      *(c1s+i) = tmps;
	      }
	    }
          else if(depth == 24 || depth ==32 ) {
	    c1l = (unsigned int *)pixout;
	    for (i=0; i<count; i++) {
	      tmpl = (unsigned int) CONVERT4(*(c1l+i));
	      *(c1l+i) = tmpl;
	      }
	    }
	  }

        local_image = XCreateImage(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
	        depth, ZPixmap, offset, pixout, pw1, ph1, 
          	bitmap_pad, bytes_per_line);

	XPutImage(dpy, sp->pixmap2, sp->gc2, local_image, 0, 0, xpos, ypos,
			pw1, ph1);

	free(pixout);

/* ... free allocates .*/
	free(index);
	free(freqs);
	free(time);
	free(tr);
	free(y);
	free(hamp);
	free(kamp);

	if(lwin < nss) {
		free(artap);
		free(srtap);
	}

	can_hi = ydim;
	pixwidth = xdim;

        sp->can_hi2 = can_hi;
        sp->pixwidth2 = pixwidth;
        sp->ncmplx2 = ncmplx;
        sp->freqi2 = freq_incr;
        sp->fact2 = factor;
        sp->leng2 = len_k_xform;
        sp->xpos = xpos;
        sp->ypos = ypos;
        sp->ph1 = ph1;
        sp->pw1 = pw1;
        sp->phs1 = phs1;
        sp->pws1 = pws1;
        sp->fscal = fscale;


        XtRealizeWidget(sp->topa);

        sp->xid2 = XtWindow(sp->drawa);
        cursor = XCreateFontCursor (dpy, XC_cross) ;
        XDefineCursor(dpy, sp->xid2, cursor) ;

	return;
}


/* *   Some global values */

void get_data();
void canvas_repaint_proc();

XFontStruct *font1;
XmFontList the_font_list;

void repaint_zoom();
void advance_display();

void get_data()
{

        int   i, j, n, nbytes, loc;
        int   irec, itrc;
	int	nargs;
    	int    one, two;
    	/*int   lineheader[1500];*/
        int   len_c;
        int   iflag, iscl;
        int   iread, len_trans;
        int   max_loc;
        int   label_inc;
        int   next_rec, next_trc;
        int   st_smp, end_smp, lwin;

        int   len_k_xform;
        int   len_sp;
	int	len2;

        float   *trace = NULL;
        float   *sdata = NULL;
        float   *ldata = NULL;
	float	maxdb;
        float   *ydata = NULL;
	float   *piece = NULL;

/*...............these are for interpolating amps by cubic spline...*/
	float	*allfreq = NULL;
	float	*splcoef = NULL;
	float	*splamp = NULL;
	float	ri,yj,yp1,ypn,xfreq;
	int	nfreq,k;
	float	*wrksp = NULL;
	float	zero;

/*..................................................................*/
        char    *ctemp = NULL;
        char   *label = NULL;
	Arg	args[2];


	XmString lstring;
	static void	xs_ok_callback();
	void	get_file(), graph_log(), graph_amp(), graph_ph();
	void	do_2d();
    	void compute_phase();
	int lmove, poff;

	void display_it();
        /*extern void vmov, rfft, rfftsc, cvabs, vclr, maxv;*/
	int	trcinc1;
	extern XtCallbackProc unmanage_widgetCB();
	int	sttrc1;

        int ntpi, pct;
        float pi;
        float xone;

/***************************************************************************/
        xone = 1.;
        one = 1;
        two = 2;
        ntr = 1;
	zero = 1.e-20;

	irec = 0;
	itrc = 0;

        num_files = 0;

        if(st_rec == 0) st_rec = 1;
        if(end_rec == 0) end_rec = st_rec;

        pix_per_trace = 1;

        num_files = 1;

        pix_per_sample = 100;

/*.........allow for si in microseconds...........*/
        st_smp = st_win/smpint;
        end_smp = end_win/smpint;

        if (end_smp == 0) end_smp = nss;
	if(st_smp == 0) st_smp = 1;

        lwin = end_smp - st_smp + 1;

	if(st_trc == 0) st_trc = 1;
        if (!end_trc) end_trc = lntr;


        if (spec_type == 1) {
/* ..................2-d amplitude spectrum ....................*/

	   if(trc_incr != 1) {
/* create a dialog message box */
		printf("For 2-D analysis, trace increment must = 1\n");

		nargs = 0;
		XtSetArg(args[nargs], XmNdialogTitle, 
           		(lstring=XmStringCreate("Trace Increment Error",
            		XmSTRING_DEFAULT_CHARSET))); nargs++;

                trinc = XmCreateMessageDialog(bboard, "trinc", args, nargs);
		XmStringFree(lstring);

                XtUnmanageChild(
                        XmMessageBoxGetChild (trinc, XmDIALOG_CANCEL_BUTTON));
                XtUnmanageChild(
                        XmMessageBoxGetChild (trinc, XmDIALOG_HELP_BUTTON));

                for (i = 0; i < 2; i ++) {

                 	/*if(lines[i]) free(lines[i]);*/
                 	lines[i] = (char *)calloc(50, sizeof(char));
                }

                strcpy(lines[0],"2-D Analysis has been selected:");
                strcpy(lines[1],"Trace Increment will be set = 1");

                lstring = (XmString) NULL;
                lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
                        XmSTRING_DEFAULT_CHARSET));

                lstring = XmStringConcat(lstring, XmStringSeparatorCreate());
                lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
                        XmSTRING_DEFAULT_CHARSET));

                nargs = 0;
                XtSetArg(args[nargs], XmNmessageString,lstring); nargs ++;
                XtSetValues(trinc, args, nargs);
                XmStringFree(lstring);

                XtAddCallback(trinc,XmNokCallback,xs_ok_callback, parm_panel);

		nargs = 1;
                strcpy(lines[0],"1");
		XtSetArg(args[0], XmNvalue, lines[0]);
		XtSetValues(texts[8], args, nargs);

  		XBell(display,50);
                XtManageChild(trinc);

		free(lines[0]);
		free(lines[1]);

                return;
           }

	   kselect ++;
           do_2d(nss, st_smp, lwin, st_rec,st_trc,
			end_trc, end_rec, trc_incr, lntr,
                        luin, display, xid, &(Info2d[kselect]));

	   spec_flag = 2;

	   XtSetArg(args[0], XmNsensitive, True);
	   XtSetValues(redisp2, args, 1);

	   display_it2(kselect);

           return;
        }


/* .............1-d amplitude or phase spectrum ..............*/

        ntrace = end_rec - st_rec;
        ntrace *= lntr;
        ntrace = ntrace - st_trc + 1 + end_trc;
        ntrace = (ntrace + trc_incr -1 )/trc_incr;
	trcinc1 = trc_incr - 1;

        if(ntrace > 50) {
           printf(" Number of traces for analysis (%d) exceeds maximum (50)\n",
		ntrace);
           printf(" Reduce the number of traces requested\n");

/* create a dialog message box */
	   nargs = 0;
	   XtSetArg(args[nargs], XmNdialogTitle,
           		(lstring=XmStringCreate("Error: Total No. Traces Requested",
            		XmSTRING_DEFAULT_CHARSET))); nargs++;

  	   gt50 = XmCreateMessageDialog(bboard, "gt50", args, nargs);
	   XmStringFree(lstring);

	   XtUnmanageChild(
			XmMessageBoxGetChild (gt50, XmDIALOG_CANCEL_BUTTON));
	   XtUnmanageChild(
			XmMessageBoxGetChild (gt50, XmDIALOG_HELP_BUTTON));

	   for (i = 0; i < 3; i ++) {
		 /*if(lines[i]) free(lines[i]);*/
		 lines[i] = (char *)calloc(50, sizeof(char));
 	   }

	   sprintf(lines[0],"The number of traces requested (%d)",ntrace);
           strcpy(lines[1], "exceeds maximum of 50 for a 1-D analysis.");
           strcpy(lines[2], "Reduce the number of traces requested.");

	   lstring = (XmString) NULL;
	   lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
			XmSTRING_DEFAULT_CHARSET));

	   lstring = XmStringConcat(lstring, XmStringSeparatorCreate());
	   lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
			XmSTRING_DEFAULT_CHARSET));

	   lstring = XmStringConcat(lstring, XmStringSeparatorCreate());
	   lstring = XmStringConcat(lstring, XmStringCreate(lines[2],
			XmSTRING_DEFAULT_CHARSET));

	   nargs = 0;
	   XtSetArg(args[nargs], XmNmessageString,lstring); nargs ++;
	   XtSetValues(gt50, args, nargs);
	   XmStringFree(lstring);

	   XtAddCallback(gt50, XmNokCallback, xs_ok_callback, parm_panel);

  	   XBell(display,50);

	   XtManageChild(gt50);

	   for (i = 0; i < 3; i ++)
		free(lines[i]);

	   return;
        }

/*...........generate cosine taper function.............*/
        if(lwin < nss) {
           pi = 3.14159265;
           pct = 10;
           ntpi = (int)(.01*pct*lwin/2);

           artap = (float *)scalloc(lwin,(int)sizeof(float));
           /*artap = (float *)scalloc(lwin,sizeof(float));*/

           vfill_(&xone, artap, &one, &lwin);

           if(st_smp > 1) {
              for(i=0; i<ntpi; i++) {
                 artap[i] = (float)(1-cos(pi*i/ntpi))/2;
              }
           }

           if(end_smp < nss) {
              for(i=0; i<ntpi; i++) {
                 artap[lwin-1-i] = (float)(1-cos(pi*i/ntpi))/2;
              }
           }
        }
 
/*.............end of generating taper func.............*/

        ctemp = (char *)calloc((MAX_FILENAME_LEN + 1), sizeof(char));
        label = (char *)calloc((MAX_FILENAME_LEN + 9) , sizeof(char));

        ns = nss;

        len_trans = 16;

        while (len_trans < lwin) len_trans *= 2;

	/*len2 = len_trans*2 + 2;*/
	len2 = len_trans + 2;
        ncmplx = len_trans/2 + 1;

/*...........allow for si in microseconds............*/
        fnyqst = 1000./(2.* asmpint);
        freq_incr = fnyqst/(float)(ncmplx -1);

    	trace = (float *)scalloc(nss + ITRWRD, (int)sizeof(float));
        ydata = (float *)scalloc(len2,  (int)sizeof(float));
        sdata = (float *)scalloc(ncmplx,  (int)sizeof(float));

    	/*trace = (float *)scalloc(nss + ITRWRD, sizeof(float));
        ydata = (float *)scalloc(len2,  sizeof(float));
        sdata = (float *)scalloc(ncmplx,  sizeof(float));*/

/* remove any existing old items */
	if(spec_type == 0 || spec_type == 3) {
	      if(ntracea > 0) {
                for (i = 2; i < ntracea + 2; i++) {
                        if (nitems[i])
                                XtDestroyWidget(nitems[i]);
                }
	      }
	}
	else {
	      if(ntracep > 0) {
                for (i = 2; i < ntracep + 2; i++) {
                        if (nitemsp[i])
                                XtDestroyWidget(nitemsp[i]);
                }
	      }
	}

        can_bias_y = (int)(6* num_font.height);

        can_hi = 600 + can_bias_y;
        if (((int)can_hi/8)* 8 != can_hi) {
                        can_hi = ((int)can_hi/8 + 1) * 8;
        }

        can_bias_x = pix_per_trace + 8*num_font.width + 13;

        if (ntrace <= 1) {
/* ......make select and animate unselectable for ntrace=1 .........*/
		nargs = 0;
		XtSetArg(args[nargs], XmNsensitive, FALSE); nargs ++;
		XtSetValues(buttona3, args, nargs);
		XtSetValues(buttona2, args, nargs);
        }

/* 071991 mam find the first trace specified */
	iselect = 0;
     	if(st_rec > 1) {
                      	for (i = 1; i < st_rec; i++) {
                                skipt(luin,lntr);
                        }
        }

        if(st_trc > 1) {
                        sttrc1 = st_trc - 1;
                        skipt(luin,sttrc1);
        }

	iread = 1;
/* .......................................... */

/*...........compute array of frequencies for cubic spline interpolation.*/
	nfreq = display_width - can_bias_x - 60;

	if(spec_type == 3) {
        	ldata = (float *)scalloc(nfreq, (int)sizeof(float));
        	/*ldata = (float *)scalloc(nfreq, sizeof(float));*/
	}

        allfreq = (float *)scalloc(ncmplx,  (int)sizeof(float));
        splcoef = (float *)scalloc(ncmplx,  (int)sizeof(float));
        splamp = (float *)scalloc(nfreq,  (int)sizeof(float));

        /*allfreq = (float *)scalloc(ncmplx,  sizeof(float));
        splcoef = (float *)scalloc(ncmplx,  sizeof(float));
        splamp = (float *)scalloc(nfreq,  sizeof(float));*/

	xfreq = 0.0;
	for (i=0;i<ncmplx;i++) {
		allfreq[i] = xfreq;
		xfreq += freq_incr;
	}

        pixwidth = nfreq + can_bias_x + 20;
        if (((int)pixwidth/8)* 8 != pixwidth) {
                        pixwidth = ((int)pixwidth/8 + 1) * 8;
        }

        nargs = 0;
        XtSetArg(args[nargs], XmNheight, can_hi); nargs ++;
        XtSetArg(args[nargs], XmNwidth, pixwidth); nargs++;
        XtSetValues(draw_area, args, nargs);

/*.......................................................................*/

        num_files = ntrace;
        for (n = 0; n < ntrace; n++) {

		if(!iread) {
			if(trc_incr > 1) {
			   skipt(luin, trcinc1);
			}
			nbytes = 0;
			rtape(luin, trace, &nbytes);
		}
		else {
			nbytes = 0;
			rtape(luin, trace, &nbytes);
			iread = 0;
		}

                if (!nbytes) {
                        printf("Error reading input file %s\n", input_file);
                        printf("Last read record %d trace %d\n", irec, itrc);
                        exit(-1);
                }

                j = n;
                saver(trace,"RecNum", &irec, TRCHED);
                saver(trace,"TrcNum", &itrc, TRCHED);

		if(spec_type == 0 || spec_type == 3) {

                        if(files[j]) free(files[j]);

                        files[j] = (char *)calloc(MAX_FILENAME_LEN + 1,
                        	sizeof(char));

                        sprintf(files[j],"Record %d Trace %d", irec, itrc);

			i = n + 2;
                        nitems[i] = XtCreateManagedWidget(files[j],
                                   xmPushButtonWidgetClass,pop_up2, NULL, 0);

                        XtAddCallback(nitems[i], XmNactivateCallback,
                                                get_file, (XtPointer)n);
			XtAddCallback(nitems[i], XmNactivateCallback,
				(XtCallbackProc)unmanage_widgetCB, pop_up_amp);
		}
		else {
                        if(filesp[j]) free(filesp[j]);

                        filesp[j] = (char *)calloc(MAX_FILENAME_LEN + 1, 
                                sizeof(char));

                        sprintf(filesp[j],"Record %d Trace %d", irec, itrc);

                        i = n + 2;
                        nitemsp[i] = XtCreateManagedWidget(filesp[j],
                                   xmPushButtonWidgetClass,pop_up2p, NULL, 0);

                        XtAddCallback(nitemsp[i], XmNactivateCallback,
                                                get_file, (XtPointer)n);
			XtAddCallback(nitemsp[i], XmNactivateCallback,
				(XtCallbackProc)unmanage_widgetCB, pop_up_ph);

		}

/*    DO THE TRANSFORM, etc  */
                vclr_(ydata, &one, &len2);

/* ... 1-d amplitude spectrum ... */
	        if(spec_type == 0 || spec_type == 3) {
                        vmov_(trace + ITRWRD + st_smp-1,&one,ydata,&one,&lwin);

/*.............use cosine taper if data is windowed.................*/
                        if(lwin < nss)
                                vmul_(ydata,&one,artap,&one,ydata,&one,&lwin);

                        iflag = 1;
                        rfft_(ydata, &len_trans, &iflag);

                        iflag = 3;
                        iscl = 1;
                        rfftsc_(ydata, &len_trans, &iflag, &iscl);

                        iselect = j;
                        label_inc = 10;

/*.....allow for si in microseconds...........*/
/*		if(smpint > 32) label_inc = 1000;*/
/*............................................*/

                        cvabs_(ydata, &two, sdata, &one, &ncmplx);

/*.........create array of second derivatives.......*/
			yp1 = 1.e+31;
			ypn = 1.e+31;

			freqi = fnyqst/(float)(nfreq-1);
			spline(allfreq-1,sdata-1,ncmplx,yp1,ypn,splcoef-1);

			ri = 0.0;
			for (i=0;i<nfreq;i++) {
	   			splint(allfreq-1,sdata-1,splcoef-1,ncmplx,ri,&yj);
	   			splamp[i] = yj;
	   			ri +=freqi;
			}

                        maxv_(splamp, &one, &maxval, &max_loc, &nfreq);
			vclip_(splamp,&one,&zero,&maxval,splamp,&one,&nfreq);

			if(spec_type == 0) {
                        	graph_amp(splamp, display, xid, fnyqst, nfreq,
                                 	freqi, label_inc);
			}
			else {
				vdbcon_(splamp,&one,&maxval,ldata,&one,&nfreq,&one);
        			minv_(ldata, &one, &maxdb, &max_loc, &nfreq);
                        	graph_log(ldata, display, xid, fnyqst, nfreq,
                                 	freqi, label_inc, maxdb);
			}
		}
		else {
/* ... phase spectrum ... */
	/* check phase type */

			switch (phase_type) {

/*.....allow for si in microseconds.............*/
/*.....window offset expressed in same units as sample interval....*/

			case 0:  poff = ph_off / smpint;  break;
			case 1:  maxv_(trace + ITRWRD + st_smp - 1, &one,
			 		&maxval, &max_loc, &lwin);
			 	poff = max_loc - 1;  break;

			case 2:  maxmgv_(trace + ITRWRD + st_smp - 1, &one,
			 		&maxval, &max_loc, &lwin);
			 	poff = max_loc - 1;  break;
			}

			if(poff == 0) {
			   vmov_ (trace + ITRWRD + st_smp - 1, &one,
			   ydata, &one, &lwin);
			}
			else {
			   lmove = lwin - poff;
			   vmov_(trace + ITRWRD + st_smp - 1 + poff, &one,

			   ydata, &one, &lmove);
			   piece = ydata + len_trans - poff;
			   vmov_(trace + ITRWRD + st_smp - 1, &one,

			   piece, &one, &poff);
			}

                        iflag = 1;
                        rfft_(ydata, &len_trans, &iflag);

                        iflag = 3;
                        iscl = 1;
                        rfftsc_(ydata, &len_trans, &iflag, &iscl);

                        iselect = j;
                        label_inc = 10;

/*.....allow for si in microseconds...........*/
/*		if(smpint > 32) label_inc = 1000;*/
/*............................................*/

			compute_phase(ydata, sdata, ncmplx);

/*.........create array of second derivatives.......*/
			yp1 = 1.e+31;
			ypn = 1.e+31;
			freqi = fnyqst/(float)(nfreq-1);

			spline(allfreq-1,sdata-1,ncmplx,yp1,ypn,splcoef-1);

			ri = 0.0;
			for (i=0;i<nfreq;i++) {
	   		    splint(allfreq-1,sdata-1,splcoef-1,ncmplx,ri,&yj);

	   		    splamp[i] = yj;
	   		    ri +=freqi;
			}
/*..................................................*/

			graph_ph(splamp, display, xid, fnyqst, nfreq,
				freqi, label_inc);
	  	}
        }

        iselect = 0;

/* if no. of traces < 40, set no. columns in menu to one */
	n = 1;

	if(ntrace < 40)
		XtSetArg(args[n], XmNnumColumns, 1);
	else
		XtSetArg(args[n], XmNnumColumns, 2);

	if(spec_type == 0 || spec_type == 3)
		XtSetValues(pop_up2, args, n);
	else
		XtSetValues(pop_up2p, args, n);

/* ... free the allocates ... */
	free(ctemp);
	free(label);
	free(trace);
	free(ydata);
	free(sdata);

/*....free allocated space for 2nd deriv spline interp...*/
	free(allfreq);
	free(splcoef);
	free(splamp);

        if(lwin < nss) free(artap);

/*.......................................................*/
	if(spec_type == 3) free(ldata);

        spec_flag = spec_type + 1;
        XtSetArg(args[0], XmNsensitive, True);

        if(spec_flag == 1) {
/*.....................1-d amplitude linear spectra.........*/
          XtSetValues(redisp1, args, 1);

          pixwidth1 = pixwidth;
          can_hi1 = can_hi;
          ncmplx1 = nfreq;

          can_bias_x1 = can_bias_x;
          can_bias_y1 = can_bias_y;

          ntracea = ntrace;
          num_files = ntracea;
          numpt1 = numpt - 1;
          scltyp = 0;
/*.......*/
	  freqi1 = freqi;
        }
/*.....................1-d amplitude log spectra.........*/
        else if(spec_flag == 4) {
          XtSetValues(redisp1, args, 1);
          pixwidth1 = pixwidth;
          can_hi1 = can_hi;
          ncmplx1 = nfreq;
          can_bias_x1 = can_bias_x;
          can_bias_y1 = can_bias_y;
          ntracea = ntrace;
          num_files = ntracea;
          numpt1 = numpt - 1;
          scltyp = 1;
/*.......*/
	  freqi1 = freqi;
        }
        else {
/*.....................1-d phase spectra.................*/
          XtSetValues(redisp3, args, 1);
          pixwidth3 = pixwidth;
          can_hi3 = can_hi;
          ncmplx3 = nfreq;
          can_bias_x3 = can_bias_x;
          can_bias_y3 = can_bias_y;
          ntracep = ntrace;
          num_files = ntracep;
/*.......*/
	  freqi3 = freqi;
        }
        display_it();
}

static void fileselCB (w, client_data, call_data)
	Widget  w;
	XmFileSelectionBoxCallbackStruct *call_data;
	caddr_t client_data;
{
        Arg     arg[2];
	int	lineheader[3000], nbytes;
	int	ival;
	char *temp;
        char    sw01[4];
        int     error;
	XmString lstring;
	/*char	*lines[4];*/
	int	i;

/**********************************************************/
        sprintf(sw01,"%s","off");

        if (filename != NULL) {
                XtFree(filename);
                filename  = NULL;
        }

	temp = (char *)calloc(255, sizeof(char));
	if(strncmp((char *)input_file," ",1)) {
		/*old_input_file = input_file;
		input_file = " ";*/
                strcpy(old_input_file, input_file);
                strcpy(input_file, " ");
		lbclos(luin);
	}

        XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &filename);

/* open requested file - get line header info, put in panel items */
        luin = 0;
        lbopen(&luin, filename, "r");
        if (luin == -1) {
                        printf("Could not open sis file: %s\n",
                                filename);
                        exit(-1);
        }

        sisabort(luin,sw01);

        rtape(luin, lineheader, &nbytes);

        siserror(luin,&error);
        if(error > 0) {
                printf("...ERROR... input file is probably not SIS format\n");
		printf("***input file specified=%s***\n", filename);
        	lbclos(luin);
		free(temp);
                return;
        }

        if (!nbytes) {
                        printf("Error reading input line header\n");
                        exit(-1);
        }

        /*input_file = filename;*/
        strcpy(input_file,filename);
        for (i = 0; i < 2; i ++) {
            /*if(lines[i]) free(lines[i]);*/
            lines[i] = (char *)calloc(256, sizeof(char));
        }

        strcpy(lines[0],"Input Dataset:");
        strcpy(lines[1],input_file);

        lstring = (XmString) NULL;
        lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
        		XmSTRING_DEFAULT_CHARSET));
        lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
                        XmSTRING_DEFAULT_CHARSET));

        XtSetArg(arg[0], XmNlabelString, lstring);
        XtSetValues(nhead[2], arg, 1);

	free(lines[0]);
	free(lines[1]);

        saver(lineheader, "NumSmp", &nss, LINHED);
        saver(lineheader, "NumTrc", &lntr, LINHED);
        saver(lineheader, "NumRec", &nrec, LINHED);
        saver(lineheader, "SmpInt", &smpint, LINHED);
	saver(lineheader, "UnitSc", &unitsc, LINHED);

/* fix for UnitSc */

	if ( unitsc == 0.0 ) unitsc = 0.001;

	asmpint = ((float)smpint *  unitsc) * 1000.0;

/*.......allow for sample interval in microseconds........*/
/*..........to convert si from microseconds to milleseconds
		divide it by 1000. .......................*/

	/*	if(smpint <= 32)
		asmpint = (float)smpint;
	else
	asmpint = (float)smpint/1000.; */

/*........................................................*/

	ival = 1;
/* start record */
	sprintf(temp, "%d", ival);
	/*sprintf(temp, "%d", krec);*/
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[4], arg, 1);

/* start trace */
	sprintf(temp, "%d", ival);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[5], arg, 1);

/* end record */
	/*ival = krec + nrec - 1;
	sprintf(temp, "%d", ival);*/
	sprintf(temp, "%d", nrec);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[6], arg, 1);

/* end trace */
	sprintf(temp, "%d", lntr);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[7], arg, 1);

/* trace increment */
	ival = 1;
	sprintf(temp, "%d", ival);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[8], arg, 1);

/* window start */
	ival = 0;
	sprintf(temp, "%d", ival);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[9], arg, 1);

/* window end */
/*...express window in same units as sample interval...*/
	ival = nss * smpint;
	sprintf(temp, "%d", ival);
	XtSetArg(arg[0], XmNvalue, temp);
	XtSetValues(texts[10], arg, 1);

	
/* end of added code */

        XtUnmanageChild(file_select);
	free(temp);

}

static void fileact (w, client_data, call_data)
	Widget  w;
	caddr_t client_data, call_data;
{
	Arg arg[1];

	XtSetArg(arg[0], XmNsensitive, True);
	XtSetValues(set_parm, arg, 1);
	XtSetValues(DisplayData, arg, 1);

        XtManageChild(file_select);

}

void exitCB(w,client_data,call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	lbclos(luin);
  	exit(0);
}

static void
quit_callback(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
  	Arg	args[2];
  	Widget dialog;
  	int nargs;
  	XmString lstring;

/*******************************************************************************/

	XBell(display,50);

  	nargs = 0;
  	XtSetArg(args[nargs], XmNdialogTitle,
           	(lstring=XmStringCreate("Exit Verification",
            	XmSTRING_DEFAULT_CHARSET))); nargs++;

  	XtSetArg(args[nargs],XmNmessageString,XmStringCreateLtoR("Do you want to exit?",
		XmSTRING_DEFAULT_CHARSET)); nargs ++;

  	dialog=XmCreateQuestionDialog(w,"Exit Verification",args,nargs);
	
  	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	
  	XmStringFree(lstring);
	
  	XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)exitCB,0);
	
  	XtManageChild(dialog);
}

Widget
create_quit_button(label, parent, width, x, y)
	char    *label;
	Widget  parent;
	int width, x, y;
{
        Arg     wargs[5];
        Widget  w;
        int n;

        n = 0;
        w = XtCreateManagedWidget("Quit", xmPushButtonWidgetClass,
                        parent, NULL, 0);

        XtSetArg(wargs[n], XtNlabel, label); n++;
        XtSetArg(wargs[n], XmNwidth, width); n++;
        XtSetArg(wargs[n], XmNx, x); n++;
        XtSetArg(wargs[n], XmNy, y); n++;
        XtSetValues(w, wargs, n);

        XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)quit_callback, NULL);

        return (w);
}

Widget
create_parm_panel(label, parent)
	char *label;
	Widget parent;
{

        Widget tlabel;
        Widget bboard, pb_dismiss, pb_ok;
	Widget pb_old;
	Widget fileget;
        Arg wargs[20], args[5];
        XmString lstring;
        String string;
        int j, k, l, m, n, x1 = 0, x2 = 225;
        int yloc, xloc, twidth;
        void get_parms();
	void	tog_change();
	void		get_old();
	/*char	*lines[4];*/
	int	i;
	extern XtCallbackProc unmanage_widgetCB();
	Widget labrt;

/*******************************************************************************/

        twidth = 100;

/* *  Build scrolled window to hold the parameter options */

   	n = 0 ;
   	XtSetArg(wargs[n], XmNcolormap, AppCmap); n++;
   	XtSetArg(wargs[n], XtNlabel, label); n++;
   	XtSetArg(wargs[n], XmNmappedWhenManaged, TRUE) ; n++ ;
   	XtSetArg(wargs[n], XmNheight, 800); n++;
   	XtSetArg(wargs[n], XmNwidth, 600); n++;
   	XtSetArg(wargs[n], XmNdialogTitle,
           (lstring=XmStringCreate("New Parameter Entry Panel",
            XmSTRING_DEFAULT_CHARSET))); n++;
   	parm_panel_dialog = XmCreateFormDialog (parent, "bboarddg", wargs, n) ;

   	n = 0 ;
   	XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC) ; n++ ;
   	XtSetArg(wargs[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED) ; n++ ;
   	XtSetArg(wargs[n], XmNvisualPolicy, XmVARIABLE) ; n++ ;
   	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   	parm_panel_sw = XmCreateScrolledWindow (parm_panel_dialog, "bboardsw", wargs, n) ;

   	XtManageChild(parm_panel_sw);
/*
*   Create an instance of a Bulletin Board Dialog to manage all of the
*   label and text widgets
*/
        n = 0;
        XtSetArg(wargs[n], XmNcolormap, AppCmap); n++;
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 40); n++;
        XtSetArg(wargs[n], XmNheight, 780); n++;
        bboard = XmCreateBulletinBoard(parm_panel_sw, "parmboard", wargs, n);

XmStringFree(lstring);

/*
*	create a header
*/
	lstring = XmStringCreateLtoR("PARAMETERS", XmSTRING_DEFAULT_CHARSET);
        nhead[0] = XmCreateLabel(bboard,"PARAMETERS", NULL, 0);
	XtSetArg(wargs[0], XmNalignment, XmALIGNMENT_CENTER);
	XtSetArg(wargs[1], XmNy, 0);
	XtSetArg(wargs[2], XmNlabelString, lstring);
	XtSetValues(nhead[0], wargs, 3);
        XtSetArg(wargs[0], XmNseparatorType, XmDOUBLE_LINE);
	XtSetArg(wargs[1], XmNx, 0);
	XtSetArg(wargs[2], XmNy, 40);
	XtSetArg(wargs[3], XmNwidth, 400);
        nhead[1] = XmCreateSeparatorGadget(bboard, "separator",  wargs, 4);

        for (i = 0; i < 2; i ++) {
                 /*if(lines[i]) free(lines[i]);*/
                 lines[i] = (char *)calloc(50, sizeof(char));
        }

        /*lines[0] = "Input Dataset:";
	lines[1] = input_file;*/

        strcpy(lines[0],"Input Dataset:");
        strcpy(lines[1],input_file);

        lstring = (XmString) NULL;
        lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
                        XmSTRING_DEFAULT_CHARSET));
        lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
                        XmSTRING_DEFAULT_CHARSET));

        xloc = 0;
 	yloc = 80;
        nhead[2] = XtCreateWidget("dataset", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(nhead[2], wargs, k);

        XtSetArg(wargs[0], XmNseparatorType, XmDOUBLE_LINE);
        XtSetArg(wargs[1], XmNx, 0);
        XtSetArg(wargs[2], XmNy, 110);
        XtSetArg(wargs[3], XmNwidth, 400);
        nhead[3] = XmCreateSeparatorGadget(bboard, "separator",  wargs, 4);

	free(lines[0]);
	free(lines[1]);

        XtManageChildren(nhead, 4);

/*
*  Create some label and text widgets
*/

        yloc = 120;
        /*yloc = 60;*/
        xloc = 0;
	j = 1;

/* added 022191 mam toggle button on parmpanel */

        xloc = 0;
        labels[j] = XtCreateManagedWidget("p4", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Type of Spectrum?",
                 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);

/* put toggle selection in for spectrum type */
        k = 0;
	xloc = 175;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
	XtSetArg(wargs[k], XmNentryClass, xmToggleButtonGadgetClass); k ++;
	radio = XmCreateRowColumn(bboard, "rad", wargs, k);
	XtManageChild(radio);

	tog1d = XmCreateToggleButtonGadget(radio,"tog1d",NULL,0);
        lstring = XmStringCreateLtoR("1-D Amplitude Spectrum-Linear Scale",
                 XmSTRING_DEFAULT_CHARSET);
	k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
	XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog1d, wargs, k);
	XtAddCallback(tog1d, XmNvalueChangedCallback, tog_change,(XtPointer)1);
        XmStringFree(lstring);

        tog4d = XmCreateToggleButtonGadget(radio,"tog4d",NULL,0);
        lstring = XmStringCreateLtoR("1-D Amplitude Spectrum-Log Scale",
                 XmSTRING_DEFAULT_CHARSET);
        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog4d, wargs, k);
        XtAddCallback(tog4d, XmNvalueChangedCallback, tog_change, (XtPointer)7);
        XmStringFree(lstring);

        tog2d = XmCreateToggleButtonGadget(radio,"tog2d",NULL,0);
        lstring = XmStringCreateLtoR("2-D Amplitude Spectrum",
                 XmSTRING_DEFAULT_CHARSET);
        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
	XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog2d, wargs, k);
        XtAddCallback(tog2d, XmNvalueChangedCallback, tog_change, (XtPointer)2);
        XmStringFree(lstring);

        tog3d = XmCreateToggleButtonGadget(radio,"tog3d",NULL,0);
        lstring = XmStringCreateLtoR("Phase Spectrum",
                 XmSTRING_DEFAULT_CHARSET);
        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog3d, wargs, k);
        XtAddCallback(tog3d, XmNvalueChangedCallback, tog_change, (XtPointer)3);
        XmStringFree(lstring);

	XtManageChild(tog1d);
	XtManageChild(tog4d);
	XtManageChild(tog2d);
	XtManageChild(tog3d);

        XmToggleButtonGadgetSetState(tog1d, True, False);
        XmToggleButtonGadgetSetState(tog4d, False, False);
        XmToggleButtonGadgetSetState(tog2d, False, False);
        XmToggleButtonGadgetSetState(tog3d, False, False);
	spec_type = 0;

        j++;

/* end of new button on parmpanel */

/*
*       create a header for phase reference parameters
*/
        XtSetArg(wargs[0], XmNseparatorType, XmSINGLE_DASHED_LINE);
        XtSetArg(wargs[1], XmNx, 0);
        XtSetArg(wargs[2], XmNy, 230);
        XtSetArg(wargs[3], XmNwidth, 400);
        phead[0] = XmCreateSeparatorGadget(bboard, "separator",  wargs, 4);

        /*if(lines[0]) free(lines[0]);*/
        lines[0] = (char *)calloc(50, sizeof(char));
        /*lines[0] = "Phase Reference Parameters:";*/

        strcpy(lines[0],"Phase Reference Parameters:");
        lstring = (XmString) NULL;
        lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
                        XmSTRING_DEFAULT_CHARSET));

        xloc = 0;
        yloc = 250;
        phead[1] = XtCreateWidget("dataset", xmLabelWidgetClass, bboard,
                                NULL, 0);

        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(phead[1], wargs, k);

        XtManageChildren(phead, 2);
	free(lines[0]);

/*
*  Create some label and text widgets
*/

        yloc = 290;
        xloc = 0;

/* added 022191 mam toggle button on parmpanel */

        xloc = 0;
        labels[j] = XtCreateManagedWidget("p4", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Reference Point?",
                 XmSTRING_DEFAULT_CHARSET);

        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);

/* put toggle selection in for phase reference type */
        k = 0;
        xloc = 175;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNentryClass, xmToggleButtonGadgetClass); k ++;
        radio2 = XmCreateRowColumn(bboard, "rad", wargs, k);

        XtManageChild(radio2);

        tog1p = XmCreateToggleButtonGadget(radio2,"tog1p",NULL,0);
        lstring = XmStringCreateLtoR("Start of Window",
                 XmSTRING_DEFAULT_CHARSET);

        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog1p, wargs, k);

        XtAddCallback(tog1p, XmNvalueChangedCallback, tog_change, (XtPointer)4);

        XmStringFree(lstring);

        tog2p = XmCreateToggleButtonGadget(radio2,"tog2p",NULL,0);
        lstring = XmStringCreateLtoR("Max. Amp. in Window",
                 XmSTRING_DEFAULT_CHARSET);
        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog2p, wargs, k);
        XtAddCallback(tog2p, XmNvalueChangedCallback, tog_change, (XtPointer)5);
        XmStringFree(lstring);

        tog3p = XmCreateToggleButtonGadget(radio2,"tog3p",NULL,0);
        lstring = XmStringCreateLtoR("Max. Abs. Amp. in Window",
                 XmSTRING_DEFAULT_CHARSET);
        k = 0;
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetArg(wargs[k], XmNindicatorType, XmONE_OF_MANY); k ++;
        XtSetValues(tog3p, wargs, k);
        XtAddCallback(tog3p, XmNvalueChangedCallback, tog_change, (XtPointer)6);
        XmStringFree(lstring);

        XtManageChild(tog1p);
        XtManageChild(tog2p);
        XtManageChild(tog3p);

        XmToggleButtonGadgetSetState(tog1p, True, False);
        XmToggleButtonGadgetSetState(tog2p, False, False);
        XmToggleButtonGadgetSetState(tog3p, False, False);
        phase_type = 0;

        j++;
        yloc = 400;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p1", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        /*lstring = XmStringCreateLtoR("Offset from Start of Window(msec)?",*/
        lstring = XmStringCreateLtoR("Offset from Start of Window?",
                 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p1a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2 + 110;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XmStringFree(lstring);
        lstring = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNvalue, ""); k++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        XtSetArg(wargs[0], XmNseparatorType, XmSINGLE_DASHED_LINE);
        XtSetArg(wargs[1], XmNx, 0);
        XtSetArg(wargs[2], XmNy, 430);
        XtSetArg(wargs[3], XmNwidth, 400);
        phead[2] = XmCreateSeparatorGadget(bboard, "separator",  wargs, 4);

        XtManageChild(phead[2]);


        yloc = 450;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p1", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Start Record Number?",
        	 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p1a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XmStringFree(lstring);
        lstring = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNvalue, ""); k++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p2", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Start Trace Number?",
        	 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p2a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XmStringFree(lstring);
        lstring = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNvalue, ""); k++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p3", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("End Record Number?",
        	 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p3a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XmStringFree(lstring);
        lstring = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNvalue, ""); k++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p7", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("End Trace Number?",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p7a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p8", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Trace Increment?",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;

        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p8a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p9", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Window Start Time?",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p9a", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;

        yloc += 40;
        xloc = 0;
        labels[j] = XtCreateManagedWidget("p6", xmLabelWidgetClass, bboard,
                                NULL, 0);
        k = 0;
        XtSetArg(wargs[k], XmNy, yloc);  k++;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        lstring = XmStringCreateLtoR("Window End Time?",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg(wargs[k], XmNlabelString, lstring); k ++;
        XtSetValues(labels[j], wargs, k);
        k = 1;
        texts[j] = XtCreateManagedWidget("p6b", xmTextWidgetClass,
                                        bboard, NULL, 0);
        xloc = x2;
        XtSetArg(wargs[k], XmNx, xloc); k ++;
        XtSetArg(wargs[k], XmNwidth, twidth); k ++;
        XtSetValues(texts[j], wargs, k);
        XmStringFree(lstring);
        j++;


        pb_dismiss = XtCreateManagedWidget("Cancel", xmPushButtonWidgetClass,
                        bboard, NULL, 0);
        XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB,
        	parm_panel_dialog);
        yloc += 40;
        m = 0;
        XtSetArg(wargs[m], XmNx, 0); m++;
        XtSetArg(wargs[m], XmNy, yloc); m++;
        XtSetValues(pb_dismiss, wargs, m);

        pb_ok = XtCreateManagedWidget("OK", xmPushButtonWidgetClass,
                        bboard, NULL, 0);
        XtAddCallback(pb_ok, XmNactivateCallback, get_parms, NULL);
        m = 0;
        XtSetArg(wargs[m], XmNx, 80); m++;
        XtSetArg(wargs[m], XmNy, yloc); m++;
        XtSetValues(pb_ok, wargs, m);

        pb_old = XtCreateManagedWidget("Previous Settings",
                        xmPushButtonWidgetClass,bboard, NULL, 0);
        XtAddCallback(pb_old, XmNactivateCallback, get_old, NULL);
        m = 0;
        XtSetArg(wargs[m], XmNx, 120); m++;
        XtSetArg(wargs[m], XmNy, yloc); m++;
        XtSetValues(pb_old, wargs, m);

	XtManageChild(bboard);
	XtManageChild(parm_panel_sw);
        return (bboard);
}

void
slider_val(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	XmScaleCallbackStruct *call_data;
{
	int itime;

        if(oldtid != NULL) {
		XtRemoveTimeOut(oldtid);
                oldtid = NULL; 
        }

	itime = call_data->value;
	atime = (unsigned long) itime;

	if(atime > 0) {
			(void)animation(itime, NULL);
	}
}

void animation(itime,  tid)
	XtPointer itime;
	XtIntervalId	tid;
{

        iselect +=1;
        if (iselect >= num_files) iselect = 0;

        canvas_repaint_proc(draw_area);

	if(oldtid != NULL) {
		XtRemoveTimeOut(oldtid);
	}

	oldtid = XtAppAddTimeOut((XtAppContext)app_con, atime, (XtTimerCallbackProc)animation, itime);
}



main ( argc, argv)
	int		argc;
	char		**argv;
{
        extern Colormap default_cmap;

        Arg      wargs[10], args[20], rc_args[20];
        int j, k, l, n, m;

        void unshow_2();
        void repaint_proc();
        void display_it(), animate_show();
	void zoom_free();
        void unshow_d();

        XmString  string;
	int	argcnt;
	XmString	lstring;

	int	nargs, i;
	void	xs_ok_callback();

	XtCallbackProc	adj_colorsCB();

	Widget  aline;

	void unshow_z();

	int	screen_num;

	extern Widget create_zoom_box();

	void create_zoom_parm();

	extern XtCallbackProc manage_widgetCB();
	extern XtCallbackProc unmanage_widgetCB();

        Visual *visual;
        int ncfree;

/***************************************************************************/

/* *  Initialize some global variable */
	argcnt = 0;
	nds = 1;
	ntrace = 0;
	ntracea = 0;
	ntracep = 0;
	iselect = 0;
	kselect = -1;
        input_file = NULL;
	old_input_file = NULL;
	old_srec = 0;
	old_strc = 0;
	new_open = 0;
        data = NULL;
        maxval = 2047;

	old_parms = 0;

	tid = NULL;
	oldtid = NULL;

	for (j=0; j<10; j++) {
		Info2d[j].zoomTF = 0;
		Info2d[j].zoomx = 0;
		Info2d[j].zoomy = 0;
		Info2d[j].zoomwid = 0;
		Info2d[j].zoomht = 0;
	}


	toplevel = XtAppInitialize((XtAppContext*)&app_con,(String)"Spec2D",NULL, 0,
		&argc, argv, app_defs, NULL, 0);


        display = (Display *)XtDisplay(toplevel);
	screen_num = DefaultScreen(display);

        visual = DefaultVisual(display, screen_num);
        default_cmap = AppCmap = DefaultColormap( display, screen_num );

        if(visual->class == PseudoColor)  {
          ncfree  = CopyColormapToPrivate( display, AppCmap, &AppCmap, 64 );
          printf("Created a private colormap with %d free colors...\n", ncfree);
        }

        n=0;
        XtSetArg (args[n], XmNtitle, "X/Motif SPECtral AnaLysis"); n++;
        XtSetArg(args[n], XtNcolormap, AppCmap); n++;
        XtSetValues (toplevel, args, n) ;


	display_width = DisplayWidth(display, screen_num);
	display_height = DisplayHeight(display, screen_num);

        gcvals.foreground = BlackPixel(display, DefaultScreen(display));
        gcvals.background = WhitePixel(display, DefaultScreen(display));
        gc = XCreateGC(display, RootWindowOfScreen(XtScreen(toplevel)),
                       GCForeground|GCBackground, &gcvals);

        font = XLoadFont (display, "9x15") ;
        gcvals.foreground = BlackPixel(display, DefaultScreen(display));
        gcvals.background = WhitePixel(display, DefaultScreen(display));
        gcvals.font = font;
        gc_odometer = XCreateGC(display, RootWindowOfScreen(XtScreen(toplevel)),
                         GCForeground|GCBackground|GCFont, &gcvals);


        XtAppSetFallbackResources(
                XtDisplayToApplicationContext(display),app_defs);

        n = 0;
        form = XmCreateForm (toplevel, "toplev", args, n) ;
        XtManageChild (form) ;

        filename = (char *)calloc((MAX_FILENAME_LEN + 1), sizeof(char));
        input_file = (char *)calloc((MAX_FILENAME_LEN + 1), sizeof(char));
        old_input_file = (char *)calloc((MAX_FILENAME_LEN + 1), sizeof(char));

        strcpy(input_file," ");
        strcpy(old_input_file," ");

	(void)CreateColorEditor(toplevel, "specal", "SPECAL",128);


/* *  Create a Bulletin Board widget to manage the other widgets */

	XtVaSetValues(toplevel,XmNcolormap,AppCmap,NULL); argcnt++;

        bboard = XtCreateManagedWidget("bboard", xmBulletinBoardWidgetClass,
                                form, args, argcnt);

        bboard2= XtCreateManagedWidget("rowcol", xmBulletinBoardWidgetClass,
                                bboard, NULL, 0);

        parm_panel = create_parm_panel("parmpanel", bboard2);

        font1 = XLoadQueryFont(display, "9x15");
        the_font_list = XmFontListCreate(font1, XmSTRING_DEFAULT_CHARSET);

        num_font.width = XmStringWidth(the_font_list,
              XmStringCreate("4", XmSTRING_DEFAULT_CHARSET));

        num_font.height = XmStringHeight(the_font_list,
              XmStringCreate("9", XmSTRING_DEFAULT_CHARSET));

        letter_font.width = XmStringWidth(the_font_list,
              XmStringCreate("a", XmSTRING_DEFAULT_CHARSET));

        letter_font.height = XmStringHeight(the_font_list,
              XmStringCreate("W", XmSTRING_DEFAULT_CHARSET));

        pl_font.width = XmStringWidth(the_font_list,
              XmStringCreate("*", XmSTRING_DEFAULT_CHARSET));

        pl_font.height = XmStringHeight(the_font_list,
              XmStringCreate("*", XmSTRING_DEFAULT_CHARSET));

/* *  Build the drawing area, attach a scrolled window to it.  */
        n = 0;
        XtSetArg(wargs[n], XmNx, 0); n++;
        XtSetArg(wargs[n], XmNy, 0); n++;
        bboard3 = XtCreateWidget("bboard3",
                                 xmBulletinBoardWidgetClass, bboard, wargs, n);
        j = 0;
        XtSetArg(rc_args[j], XmNheight, 20); j ++;
        XtSetArg(rc_args[j], XmNorientation, XmHORIZONTAL); j ++;
        rowcol3 = XtCreateManagedWidget("rowcol3",
                             xmRowColumnWidgetClass, bboard3, rc_args, j);
        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                    XmStringCreate("Dismiss", XmSTRING_DEFAULT_CHARSET)); n ++;
        buttona1 = XtCreateManagedWidget("pub1a",
                               xmPushButtonWidgetClass, rowcol3, wargs, n);
        XtAddCallback(buttona1, XmNactivateCallback, unshow_d, NULL);

        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                 XmStringCreate("Select Data", XmSTRING_DEFAULT_CHARSET)); n ++;
	XtSetArg(wargs[n], XmNfillOnArm, FALSE); n ++;
	XtSetArg(wargs[n], XmNhighlightOnEnter, FALSE); n ++;
	XtSetArg(wargs[n], XmNtraversalOn, FALSE); n ++;
        buttona2 = XtCreateManagedWidget("pulldown2",
                        xmPushButtonWidgetClass, rowcol3, wargs, n);

/*.................beginning of selecting data files.............*/
        n = 0;
        XtSetArg(wargs[n], XmNx, 10); n++;
        XtSetArg(wargs[n], XmNy, 40); n++;
        XtSetArg(wargs[n], XmNdialogTitle, (lstring=XmStringCreate("Select Data File",
            XmSTRING_DEFAULT_CHARSET))); n++;
 
        pop_up_ph = XmCreateBulletinBoardDialog(rowcol3, "pop3", wargs, n);
        pop_up_amp = XmCreateBulletinBoardDialog(rowcol3, "pop3", wargs, n);

        XmStringFree(lstring);
 
	n = 0;
        XtSetArg(wargs[n], XmNwidth, 40); n ++;
        XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n ++;
        XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n ++;
        XtSetArg(wargs[n], XmNnumColumns, 2); n ++;
        XtSetArg(wargs[n], XmNresizeWidth, True); n ++;
        XtSetArg(wargs[n], XmNresizeHeight, True); n ++;
        pop_up2p = XtCreateManagedWidget("popup2",
                             xmRowColumnWidgetClass, pop_up_ph, wargs, n);

        pop_up2 = XtCreateManagedWidget("popup2",
                             xmRowColumnWidgetClass, pop_up_amp, wargs, n);

        XtAddCallback(buttona2,XmNactivateCallback,rman2, NULL);

        nitems[0] = XtCreateWidget("Available Data Files",
                                        xmLabelWidgetClass, pop_up2, NULL, 0);
        XtSetArg(wargs[0], XmNseparatorType, XmDOUBLE_LINE);
        nitems[1] = XmCreateSeparatorGadget(pop_up2, "separator",  wargs, 1);
        XtManageChildren(nitems, 2);

        nitemsp[0] = XtCreateWidget("Available Data Files",
                                        xmLabelWidgetClass, pop_up2p, NULL, 0);
        XtSetArg(wargs[0], XmNseparatorType, XmDOUBLE_LINE);
        nitemsp[1] = XmCreateSeparatorGadget(pop_up2p, "separator",  wargs, 1);
        XtManageChildren(nitemsp, 2);

/*....................end of creating popup for selecting data files.....*/

        n = 0;
	XtSetArg(wargs[n], XmNpacking, XmPACK_NONE); n++;
        XtSetArg(wargs[n], XmNwidth, 390); n++;
        XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
        rowcol4 = XtCreateWidget("rowcol4",
                                xmRowColumnWidgetClass, bboard3, wargs, n);
        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                   XmStringCreate("Dismiss", XmSTRING_DEFAULT_CHARSET)); n ++;
        buttonb1 = XtCreateManagedWidget("dismissb",
                                xmPushButtonWidgetClass, rowcol4, wargs, n);
        XtAddCallback(buttonb1, XmNactivateCallback, unshow_2, NULL);

        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                  XmStringCreate("Advance Display", XmSTRING_DEFAULT_CHARSET));
                  n ++;
	XtSetArg(wargs[n], XmNx, (letter_font.width*8 + 12)); n ++;
        buttonb2 = XtCreateManagedWidget("advance",
                                xmPushButtonWidgetClass, rowcol4, wargs, n);
        XtAddCallback(buttonb2, XmNactivateCallback, advance_display, NULL);

        n = 0;
	XtSetArg(wargs[n], XmNx, (letter_font.width*24 + 20)); n ++;
        XtSetArg(wargs[n], XmNmaximum, 1000); n++;
        XtSetArg(wargs[n], XmNminimum,    0); n++;
        XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
        XtSetArg(wargs[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
        XtSetArg(wargs[n], XmNscaleWidth, 200); n++;
	XtSetArg(wargs[n], XmNscaleHeight, 20); n++;
        XtSetArg(wargs[n], XmNtitleString,
                        XmStringCreate("Timer (milliseconds)",
                         	XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(wargs[n], XmNshowValue, True); n++;
        slider1 = XtCreateManagedWidget("timer",
                                xmScaleWidgetClass, rowcol4, wargs, n);

        XtAddCallback(slider1, XmNvalueChangedCallback, (XtCallbackProc)slider_val, NULL);
        XtAddCallback(slider1, XmNdragCallback, (XtCallbackProc)slider_val, NULL);


        n = 0;
        XtSetArg(wargs[n], XmNlabelString,
                 XmStringCreate("Animate", XmSTRING_DEFAULT_CHARSET)); n ++;
        buttona3 = XtCreateManagedWidget("pub3a",
                                xmPushButtonWidgetClass, rowcol3, wargs, n);
        XtAddCallback(buttona3, XmNactivateCallback, animate_show, NULL);

        n = 0;
        XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
        XtSetArg(wargs[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
        XtSetArg(wargs[n], XmNvisualPolicy, XmVARIABLE); n++;
        view_window = XtCreateManagedWidget("view",
                         xmScrolledWindowWidgetClass, bboard3, wargs, n);

/* ** Setup scrollbars */

        n = 0 ;
        XtSetArg (args[n], XmNverticalScrollBar, &vvsb) ; n++ ;
        XtGetValues (view_window, args, n) ;

        n = 0 ;
        XtSetArg (args[n], XmNhorizontalScrollBar, &vhsb) ; n++ ;
        XtGetValues (view_window, args, n) ;

/* ........end of scrollbar setup................*/

        n = 0;
        XtSetArg(wargs[n], XmNmarginHeight, 0); n ++;
        XtSetArg(wargs[n], XmNmarginWidth, 0); n++;

        draw_area = XtCreateManagedWidget("draw",
                         xmDrawingAreaWidgetClass, view_window, wargs, n);

	n = 0;
        XtSetArg(wargs[n], XmNworkWindow, draw_area); n++;
        XtSetArg (wargs[n], XmNresizePolicy, XmRESIZE_ANY); n++;
	XtSetValues(view_window, wargs, n);
        XtAddCallback(draw_area, XmNexposeCallback,
                                                repaint_proc, NULL);

        n = 0;
   	XtSetArg(wargs[n], XmNcolormap, AppCmap); n++;
        XtSetArg(wargs[n], XmNdirMask, NULL); n ++;
        XtSetArg(wargs[n],XmNlistVisibleItemCount,25); n ++;
	XtSetArg(wargs[n], XmNfilterLabelString,
	XmStringCreate("Directory to list",
		XmSTRING_DEFAULT_CHARSET));  n ++;
        XtSetArg(wargs[n], XmNdialogTitle,
           	(lstring=XmStringCreate("Select File",
            	XmSTRING_DEFAULT_CHARSET))); n++;

        file_select = XmCreateFileSelectionDialog(bboard2,
                        "fileselectiondialog", wargs, n);

        XtAddCallback(file_select, XmNokCallback,
                        (XtCallbackProc)fileselCB, NULL);

/*......to bring up parm panel when file is selected....*/

        XtAddCallback(file_select,XmNokCallback,xs_ok_callback,
                	parm_panel_dialog);

        XtAddCallback(file_select, XmNcancelCallback,
                        (XtCallbackProc)unmanage_widgetCB, file_select);

        XmStringFree(lstring);

        n = 0;
        XtSetArg(wargs[n], XmNdialogTitle,
           	(lstring=XmStringCreate("No File Selected",
            	XmSTRING_DEFAULT_CHARSET))); n++;

        nofile = XmCreateMessageDialog(bboard, "nofile", wargs, n);
        XtUnmanageChild( XmMessageBoxGetChild (nofile, XmDIALOG_CANCEL_BUTTON));
        XtUnmanageChild( XmMessageBoxGetChild (nofile, XmDIALOG_HELP_BUTTON));
        XmStringFree(lstring);

        for (i = 0; i < 2; i ++) {
            lines[i] = (char *)calloc(50, sizeof(char));
        }

        strcpy(lines[0],"Input file must be selected before selecting");
        strcpy(lines[1],"OK from the parameter selection menu");

        lstring = (XmString) NULL;
        lstring = XmStringConcat(lstring, XmStringCreate(lines[0],
                        XmSTRING_DEFAULT_CHARSET));
        lstring = XmStringConcat(lstring, XmStringSeparatorCreate());
        lstring = XmStringConcat(lstring, XmStringCreate(lines[1],
                        XmSTRING_DEFAULT_CHARSET));
        nargs = 0;
        XtSetArg(args[nargs], XmNmessageString,lstring); nargs ++;
        XtSetValues(nofile, args, nargs);

        XmStringFree(lstring);

        XtAddCallback(nofile, XmNokCallback, (XtCallbackProc)unmanage_widgetCB,
                	nofile);

	free(lines[0]);
	free(lines[1]);

        menu_bar = CreateMenuBar (form);

/*................................................................*/
   	n = 0;
        XtSetArg(args[n], XmNheight, 20); n ++;
   	odometer = XmCreateDrawingArea (form, "odometer", args, n);
   	XtManageChild (odometer) ;

   	n = 0;
   	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   	sep1 = XmCreateSeparator(form, "sep1", args, n);
   	XtManageChild(sep1);
/*................................................................*/

   	n = 0 ;
   	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetValues (menu_bar, args, n) ;

/*................................................................*/
   	n = 0 ;
   	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   	XtSetArg (args[n], XmNtopWidget, menu_bar) ; n++ ;
   	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetValues (odometer, args, n) ;

   	n = 0 ;
   	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   	XtSetArg (args[n], XmNtopWidget, odometer) ; n++ ;
   	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetValues (sep1, args, n) ;
/*................................................................*/

   	n = 0 ;
   	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   	XtSetArg (args[n], XmNtopWidget, sep1) ; n++ ;
   	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   	XtSetValues (bboard, args, n) ;

	XtSetArg(args[0], XmNsensitive, False);
	XtSetValues(set_parm, args, 1);
	XtSetValues(redisp1, args, 1);
	XtSetValues(redisp2, args, 1);
	XtSetValues(redisp3, args, 1);

        XtRealizeWidget(toplevel);
        xid = XtWindow(draw_area);
   	cursor = XCreateFontCursor (display, XC_cross) ;
   	XDefineCursor(display, xid, cursor) ;

	n = 0;
        XtSetArg(args[n], XmNheight, 30); n++;
        XtSetArg(args[n], XmNwidth, 235); n++;
        XtSetValues(toplevel, args, n);

        XtAppMainLoop((XtAppContext)app_con);

}


static void rman2(w, client_data, call_data)
	caddr_t client_data;
	caddr_t call_data;
{
 
	if(spec_flag == 1 || spec_flag == 4)
        	XtManageChild(pop_up_amp);
	else
		XtManageChild(pop_up_ph);
}

static void rman2d(w, client_data, call_data)
	caddr_t client_data;
	caddr_t call_data;
{
 
                XtManageChild(pop_up_2d);
}


static void rdsp(w, client_data, call_data)
	Widget w;
	int client_data;
	caddr_t call_data;
{
	iselect = 0;
	spec_flag = client_data;

	if (spec_flag == 1 && scltyp == 1) spec_flag = 4;

	switch (spec_flag) {
	 	case 1: num_files = ntracea; display_it(); break;
	 	/*case 2: num_files = 1; display_it2(); break;*/
	 	case 3: num_files = ntracep; display_it(); break;
	 	case 4: num_files = ntracea; display_it(); break;
	}

	/*if (spec_flag == 1 && scltyp == 1) spec_flag = 4;

	display_it();*/
 
}

void display_it()
{
        Arg args[2];
        Arg arg[2];
        int n;
	int width, height;
	int	swid,vwid,sht,vht;
	int	maxsw, maxsh, maxvw, maxvh;

   	int vval, vss, vir, vpir, hval, hss, hir,hpir;
   	Boolean      what;
	int sht80;

/**********************************************************************/
        what = True;

	maxsw = display_width - 10;
	maxsh = display_height - 30;
	maxvw = maxsw - 5;
	maxvh = maxsh - 110;

	switch (spec_flag) {
   	case 1:  width = pixwidth1;
            	height = can_hi1;
            	break;
   	/*case 2:  width = pixwidth2;
            	height = can_hi2;
            	break;*/
   	case 3:  width = pixwidth3;
            	height = can_hi3;
            	break;
   	case 4:  width = pixwidth1;
            	height = can_hi1;
            	break;
	}

/* depending on spectral-type selected, set the "select data" and
        "animate" buttons either sensitive or not sensitive */

	/*if(spec_flag == 2)
	  {*/
/* 2-d spectrum selected - set not sensitive */
	/*XtUnmanageChild(buttona2);
	XtUnmanageChild(buttona3);
	XtManageChild(buttona4);
	XtManageChild(buttona5);

	  }
	else
	  {*/
/* 1-d or phase spectrum selected - set sensitive */
	XtManageChild(buttona2);
	XtManageChild(buttona3);
	/*XtUnmanageChild(buttona4);
	XtUnmanageChild(buttona5);*/

	/*}*/

	if(width > maxvw - 5)     /* horiz sb */ {
		if(height + 130 > maxvh)   /* both h & v sb */ {
			swid = maxsw;
			sht = maxsh;
			vht = sht - 110;
			vwid = swid - 30; 
		}
		else     /* only horiz xb */ {
			swid = maxsw;
			vwid = swid - 5;
			vht = height + 55;
			sht = vht + 115;
		}
	}
	else    /* no horiz sb */ {
		if(height + 35 > maxvh)     /* vert sb */ {
			if(width + 35 > maxvw)   /* both v & h sb */ {
				swid = maxsw;
				sht = maxsh;
				vht = sht - 110;
				vwid = swid - 35;
			}
			else    /* only vert sb */ {
				sht = maxsh;
				vht = sht - 110;
				vwid = width + 35;
				swid = vwid + 35;
			}
		}
		else   /* no sb needed */ {
			vht = height + 10;
			sht = vht + 115;
			/*sht = vht + 110;*/
			vwid = width + 10;
			swid = vwid + 15;
		}
	}

	if(spec_flag != 2 && swid < 400) {
		swid = 420;
		vwid = 400;
	}

	/*if(spec_flag == 2 && swid < 400)*/
	if(spec_flag == 2 && swid < 500) {
		swid = 500;
		/*swid = 400;*/
	}

        n = 0;
        XtSetArg(args[n], XmNheight, height); n ++;
        XtSetArg(args[n], XmNwidth, width); n++;
        XtSetValues(draw_area, args, n);

        n = 0;
        XtSetArg(arg[n], XmNheight, vht); n++;
        XtSetArg(arg[n], XmNwidth, vwid); n++;
        XtSetValues(view_window, arg, n);

	n = 0;
        XtSetArg(arg[n], XmNheight, sht); n++;
        XtSetArg(arg[n], XmNwidth, swid); n++;
        XtSetValues(toplevel, arg, n);

/* get and set values for scrollbars */
        n = 0;
   	XtSetArg (args[n], XmNminimum, &vvmin); n++;
   	XtSetArg (args[n], XmNmaximum, &vvmax); n++;
   	XtGetValues(vvsb, args, n);

   	n = 0;
   	XtSetArg (args[n], XmNminimum, &vhmin); n++;
   	XtSetArg (args[n], XmNmaximum, &vhmax); n++;
   	XtGetValues(vhsb, args, n);

        XmScrollBarGetValues(vvsb, &vval,&vss, &vir, &vpir);
        XmScrollBarSetValues(vvsb, vvmax - vss, vss, vir, vpir, what);

        XmScrollBarGetValues(vhsb, &hval, &hss, &hir, &hpir);
        XmScrollBarSetValues(vhsb, vhmin, hss, hir, hpir, what);

/* end of getting and setting values */

/*...	XtUnmanageChild(menu_bar);...*/


	XtSetArg(arg[0], XmNsensitive, False);
	XtSetValues(DisplayData, arg,1);
	XtSetValues(selfile, arg,1);

	XtAddEventHandler(draw_area, PointerMotionMask | LeaveWindowMask,
		False, (XtEventHandler)handle_odomCB, (XtPointer)spec_flag);
		/*False, handle_odomCB, XtWindow(draw_area));*/

        XtManageChild(bboard3);

}


void display_it2(ind)
	int ind;
{
        Arg args[2];
        Arg arg[2];
        int n;
        int width, height;
        int     vwid,vht;
	int vval, vss, vir, vpir, hval, hss, hir,hpir;
   	Boolean      what;

/***************************************************************************/
        what = True;
 
   	width = Info2d[ind].pixwidth2;
        height = Info2d[ind].can_hi2;
 
        n = 0;
        XtSetArg(args[n], XmNheight, height); n ++;
        XtSetArg(args[n], XmNwidth, width); n++;
        XtSetValues(Info2d[ind].drawa, args, n);

	vht = height + 30;

	if(vht > display_height) vht = display_height - 60;

	vwid = 500;

        /*n = 0;
        XtSetArg(arg[n], XmNheight, vht); n++;
        XtSetArg(arg[n], XmNwidth, vwid); n++;
        XtSetValues(Info2d[ind].viewa, arg, n);*/

/* set size of top level of this window (topa) */
	vwid += 5;
	vht += 50;

	Info2d[ind].topht = vht;
	Info2d[ind].topwid = vwid;

	/*n = 0;
	XtSetArg(arg[n], XmNheight, vht); n++;
	XtSetArg(arg[n], XmNwidth, vwid); n++;
	XtSetValues(Info2d[ind].forma, arg, n);*/


	/*XtSetValues(Info2d[ind].topa, arg, n);*/
/*.............................................*/

 
/* get and set values for scrollbars */

   	n = 0;
   	XtSetArg (args[n], XmNminimum, &vvmin); n++;
   	XtSetArg (args[n], XmNmaximum, &vvmax); n++;
   	XtGetValues(Info2d[ind].vvsb, args, n);
 
   	n = 0;
   	XtSetArg (args[n], XmNminimum, &vhmin); n++;
   	XtSetArg (args[n], XmNmaximum, &vhmax); n++;
   	XtGetValues(Info2d[ind].vhsb, args, n);
 
        XmScrollBarGetValues(Info2d[ind].vvsb, &vval,&vss, &vir, &vpir);
        XmScrollBarSetValues(Info2d[ind].vvsb, vvmax - vss, vss,
		vir, vpir, what);
 
        XmScrollBarGetValues(Info2d[ind].vhsb, &hval, &hss, &hir, &hpir);
        XmScrollBarSetValues(Info2d[ind].vhsb, vhmin, hss, hir,
		hpir, what);

/* end of getting and setting values */
 
	XtManageChild(Info2d[ind].butd);
	XtManageChild(Info2d[ind].butcc);
	XtManageChild(Info2d[ind].butz);
 
        XtAddEventHandler(Info2d[ind].drawa,PointerMotionMask | LeaveWindowMask,
                False, (XtEventHandler)handle_odom2CB, (XtPointer)Info2d[ind].thisn);
                /*False, handle_odomCB, XtWindow(Info2d[ind].drawa));*/
 
        n = 0;
        XtSetArg(arg[n], XmNheight, vht); n++;
        XtSetArg(arg[n], XmNwidth, vwid); n++;
        XtSetValues(Info2d[ind].topa, arg, n);

	XtResizeWindow(Info2d[ind].topa);
	XtMapWidget(Info2d[ind].topa);

        /*XtManageChild(Info2d[ind].topa);*/
        /*XtManageChild(Info2d[ind].forma);*/
        /*XtManageChild(Info2d[ind].window);*/
        /*   XtManageChild(Info2d[ind].aboard);   */
 
}


static void get_parms(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
        static int n = 1;
        int k;
	int nargs, i;
	static void xs_ok_callback();
	XmString	lstring;
	/*char	*lines[2];*/
        Arg   arg[2], args[2];
        String temp, get_val();
	int	nskip;

/*******************************************************************************/

	XtUnmanageChild(parm_panel_dialog); /*	XtUnmanageChild(bboard2); */

	if(strncmp((char *)input_file," ",1) == 0) {
  		XBell(display,50);
                XtManageChild(nofile);
        	return;
        }


	temp = NULL;

        temp = get_val(texts[3], arg);
        sscanf(temp,"%d", &ph_offset);
        ph_off = ph_offset;

        temp = get_val(texts[4], arg);
        sscanf(temp,"%d", &s_record);
        st_rec = s_record;

        temp = get_val(texts[5], arg);
        sscanf(temp,"%d", &s_trace);
        st_trc = (float)s_trace;

        temp = get_val(texts[6], arg);
        sscanf(temp,"%d", &e_record);
        end_rec = e_record;

        temp = get_val(texts[7], arg);
        sscanf(temp,"%d", &e_trace);
        end_trc = e_trace;

        temp = get_val(texts[8], arg);
        sscanf(temp,"%d", &trc_incr);

	if(trc_incr == 0) {
		trc_incr = 1;
		printf("setting trc_incr = 1\n");
	}

        temp = get_val(texts[9], arg);
        sscanf(temp,"%d", &st_win);

        temp = get_val(texts[10], arg);
        sscanf(temp,"%d", &end_win);

	/*printf("input_file=%s\n", input_file);*/

	if(!new_open) {
        	rwd(luin);
		nskip = 1;
        	/*nskip = (st_rec - krec) * lntr + (st_trc - ktrc) + 1;*/
        	skipt(luin, nskip);
	}

	new_open = 0;

/*.......save these parameters for 'previous settings' button to use...*/
	old_spec_type = spec_type;
	old_phase_type = phase_type;
	old_ph_offset = ph_offset;

	old_s_rec = s_record;
	old_e_rec = e_record;

	old_s_tr = s_trace;
	old_e_tr = e_trace;

	old_tr_inc = trc_incr;
	old_s_win = st_win;
	old_e_win = end_win;

	old_parms = 1;
/*.....................................................................*/
						
        get_data();


}


String get_val(w, ar)
	Widget w;
	Arg *ar;
{

        static int n = 1;
        String  ch;

        XtSetArg(ar[0], XmNvalue, &ch);
        XtGetValues(w, ar, n);

        return (ch);
}

void animate_show(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	int	value;

	value = 0.0;

	XmScaleSetValue(slider1, value);

        XtUnmanageChild(rowcol3);
        XtManageChild(rowcol4);
}

void unshow_d(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
        Arg arg[2];
        int n;

        n = 0;
        XtSetArg(arg[n], XmNheight, 30); n++;
        XtSetArg(arg[n], XmNwidth, 235); n++;
        XtSetValues(toplevel, arg, n);

        n = 0.0;
        XmScaleSetValue(slider1, n);

	/*if(spec_flag == 2 && copypix) {

		XtUnmanageChild(zform);
		XFreePixmap(display, copypix);
		copypix = NULL;

		XtRemoveEventHandler(zoomdraw, PointerMotionMask, False,
			handle_odomCB, XtWindow(zoomdraw));
	}*/

	XtRemoveEventHandler(draw_area, PointerMotionMask, False,
		(XtEventHandler)handle_odomCB, (XtPointer)spec_flag);
		/*handle_odomCB, XtWindow(draw_area));*/

        XtUnmanageChild(bboard3);

        XtSetArg(arg[0], XmNsensitive, True);
        XtSetValues(set_parm, arg, 1);
        XtSetValues(DisplayData, arg, 1);
        XtSetValues(selfile, arg, 1);

	spec_flag = 0;

}

void unshow_2d(w, client_data, call_data)
	Widget w;
	int client_data;
	caddr_t call_data;
{
	extern XtEventHandler handle_odom2CB();
	extern XtEventHandler handle_odomzCB();

        Arg arg[2];
        int n,i;

/***********************************************************************/

	i = client_data;

	if(Info2d[i].zoompix) {
        	XtUnmanageChild(Info2d[i].zform);
        	XFreePixmap(display, Info2d[i].zoompix);
		Info2d[i].zoompix = NULL;
        	XtRemoveEventHandler(zoomdraw, PointerMotionMask, False,
                	(XtEventHandler)handle_odomzCB, (XtPointer)zoomdraw);
	}

	XtRemoveEventHandler(Info2d[i].drawa, PointerMotionMask, False,
		(XtEventHandler)handle_odom2CB, (XtPointer)Info2d[i].thisn);
		/*handle_odomCB, XtWindow(Info2d[i].drawa));*/

        /*   XtUnmanageChild(Info2d[i].aboard);   */
        /*XtUnmanageChild(Info2d[i].topa);*/
        /*XtUnmanageChild(Info2d[i].forma);*/
        /*XtUnmanageChild(Info2d[i].window);*/

        /*n = 0;
        XtSetArg(arg[n], XmNheight, 0); n++;
        XtSetArg(arg[n], XmNwidth, 0); n++;
        XtSetValues(Info2d[i].topa, arg, n);*/
	XtUnmapWidget(Info2d[i].topa);

        XtSetArg(arg[0], XmNsensitive, True);
        XtSetValues(DisplayData, arg, 1);

}


void unshow_z(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	extern XtEventHandler handle_odomzCB();

        Arg arg[2];
        int i;

	i = (int)client_data;

	if(Info2d[i].zoompix) {
        	XtUnmanageChild(Info2d[i].zform);
        	XFreePixmap(display, Info2d[i].zoompix);
		Info2d[i].zoompix = NULL;
        	XtRemoveEventHandler(zoomdraw, PointerMotionMask, False,
                	(XtEventHandler)handle_odomzCB, (XtPointer)zoomdraw);
                	/*handle_odomCB, XtWindow(zoomdraw));*/
	}
}

void unshow_2(w, client_data, call_data)
	Widget w;
	Widget client_data;
	caddr_t call_data;
{
        if(oldtid != NULL)
                {XtRemoveTimeOut(oldtid);
                 oldtid = NULL; }

        XtUnmanageChild(rowcol4);
        XtManageChild(rowcol3);
}

void repaint_proc(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
        canvas_repaint_proc(draw_area);
}

void advance_display(item)
	Widget          item;
{
	int	value;

	if(oldtid != NULL)
		{XtRemoveTimeOut(oldtid);
		 oldtid = NULL; }

	value = 0.0;
	XmScaleSetValue(slider1, value);

        iselect +=1;
        if (iselect >= num_files)
                iselect = 0;

        canvas_repaint_proc(draw_area);
}

void canvas_repaint_proc(can)
	Widget  can;
{

        unsigned long  plane;
        int pw, ph;
	Pixmap	*local_pix;

        plane = 1;

	switch (spec_flag) {
   	case 1: local_pix = pixmap1 + iselect;
	   	pw = pixwidth1;
	   	ph = can_hi1;
	   	break;
   	/*case 2: local_pix = pixmap2 + iselect;
	   	pw = pixwidth2;
	   	ph = can_hi2;
           	break;*/
   	case 3: local_pix = pixmap3 + iselect;
	   	pw = pixwidth3;
	   	ph = can_hi3;
           	break;
   	case 4: local_pix = pixmap1 + iselect;
	   	pw = pixwidth1;
	   	ph = can_hi1;
	   	break;
	}

        /*XCopyPlane(display, *local_pix, xid, gc, 0, 0, pw, ph, 0, 0, plane);*/
        XCopyArea(display, *local_pix, xid, gc, 0, 0, pw, ph, 0, 0);


}

 
void graph_log(datai, dpy, id, fnyqst, ncmplx, freq_incr, label_inc,maxdb)
	Display         *dpy;
	XID                     id;
	float           *datai, fnyqst, freq_incr;
	int                     ncmplx, label_inc;
	float           maxdb;
/*   Creates the image to be displayed by creating a
*    Pixmap (drawable) and drawing the data to it.  The
*    pixmap is then assigned to the server image.
*/
{
 
        GC                      gclocal;
        XGCValues               gcvals;

        int                     i, j, iaddr, ma, mb, k;
        int                     offset2, offset, ipos;
        int                     compare;
        int                     jpos, ibias;
        int                     one, i1;
        int                     base_pos;
        int                     scr, pcolor;
        int                     kntr;
        int                     *index = NULL;
        int                     nl, fny;
        int                     pw, ph;
 
        float                   temp, tpix;
        int             	sec;
        /*float                 temp, tpix, sec;*/
        float                   *freqs = NULL;
 
        char                    *time;
 
        XColor                  color;
        Colormap                cmap;
        int     ix, iy;
        Pixmap  *local;
        int     iipos;
        int maxlab, compdb, numlab;
 
/*******************************************************************/
 
/* *   Create the pixmap for drawing */
 
        fny = (int)fnyqst;
        nl = (int)(fnyqst/ (float)label_inc) + 2;

        index = (int *)calloc(nl, sizeof(int));
        freqs = (float *)calloc(nl, sizeof(float));

        k = 0;
        for (i = 0; i < fny; i+= label_inc) {
                freqs[k] = (float)i;
                index[k] = (int)(freqs[k]/freq_incr);
                k++;
        }
 
        scr = DefaultScreen(dpy);
        cmap = AppCmap;
 
        /*maxlab = maxdb - .999999;
        compdb = 6;

        if(!(maxlab % compdb)) {
        	maxlab = (maxdb-6)/6;
		maxlab = maxlab * 6;
	}

        numlab = -maxlab / 6;
	numlab += 1;*/

	maxlab = -102;
	compdb = 6;
	numlab = 18;

	numpt = 17*25 + 1;
	/*...numpt = 17*50 + 1;...*/
        /*numpt = numlab*50 + 1;*/
        /*numpt = numlab*100 + 1;*/
	/*printf("maxlab=%d  numlab=%d  numpt=%d   maxdb=%f10.5\n",
		maxlab,numlab,numpt,maxdb);*/
 
        base_pos = numpt + can_bias_y;
        /*base_pos = 500 + can_bias_y;*/

        one = 1;
        compare =  25;

        /*compare =  50;*/
        /*compare =  100;*/

        time = (char *)calloc(80, sizeof(char));
        tpix = (float)pix_per_trace;

        local = pixmap1+iselect;

        if(*local) XFreePixmap(dpy, *local);

        pw = pixwidth;
 
        while (can_hi < (numpt + can_bias_y)) {
                can_hi += 50;
        }
 
        ph = can_hi;

        *local = XCreatePixmap(dpy, id, pw, ph, depth);
        if (!(*local))
                printf("  Creation failed for pixmap %d\n", iselect);

        gcvals.foreground = WhitePixel(dpy, DefaultScreen(dpy));
        gcvals.background = BlackPixel(dpy, DefaultScreen(dpy));
        gclocal = XCreateGC(dpy, *local, GCForeground|GCBackground,
                        &gcvals);

/* *    Fill the rectangle to clear it for drawing */

        XFillRectangle(dpy, *local, gclocal, 0, 0, pixwidth,
                        can_hi);

        gcvals.foreground = BlackPixel(dpy, DefaultScreen(dpy));
        gcvals.background = WhitePixel(dpy, DefaultScreen(dpy));
        XChangeGC(dpy, gclocal, GCForeground | GCBackground, &gcvals);

/* ... annotate the vertical amplitude axis ... */

        ipos = can_bias_x - pix_per_trace;
        ma =  can_bias_y;

        XDrawLine(dpy, *local, gclocal, ipos - 11, ma, ipos, ma);

        sec = 0.;
        sprintf(time,"%4d", sec);
        jpos = (ipos - 13)- strlen(time) * num_font.width;

        if (jpos < 0) jpos = 0;

        k = ma + num_font.height/3;
        if (k < 0) k = 0;

        XDrawString(dpy, *local, gclocal, jpos, k,
                time, strlen(time));

        for (i=1; i < numpt; i++) {
                ma = i -1 + can_bias_y;
                mb = i + can_bias_y;
                XDrawLine(dpy, *local, gclocal, ipos, ma, ipos, mb);

                if (!(i % compare)) {
                        sec += -6;
                        /*sec = (500- (float)i) / 500;*/
                        XDrawLine(dpy, *local, gclocal, ipos - 11, mb, ipos, mb);

                        sprintf(time,"%4d", sec);
                        jpos = (ipos - 13)- strlen(time) * num_font.width;

                        if (jpos < 0) jpos = 0;

                        k = mb + num_font.height/3;
                        if (k < 0) k = 0;

                        XDrawString(dpy, *local, gclocal, jpos, k,
                                time, strlen(time));
                }
        }
 
        jpos = numpt/2 + can_bias_y - 7*letter_font.height;
        /*jpos = 250 + can_bias_y - 9*letter_font.height;*/
        ipos = 5;
        sprintf(time,"A");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"M");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"P");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"L");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"I");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"T");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"U");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"D");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"E");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + 2*letter_font.height;
        sprintf(time,"I");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"N");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + 2*letter_font.height;
        sprintf(time,"d");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"B");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));
 
/* ... draw the spectrum ... */
        k = 0;
        i1 = -1;
        ibias = can_bias_x;
	temp = -datai[0];

	/*if(temp < -100.) temp = -100.;*/
        if(temp > 100.) temp = 100.;

        offset = (int)((temp/6) * 25);
        /*..offset = (int)((-datai[0]/6) * 25);..*/
        offset += can_bias_y;
        /*offset = (int)((-datai[0]/6) * 50);*/
        /*offset = (int)((-datai[0]/6) * 100);*/

        /*for (i=0; i < ncmplx; i++)*/
        for (i=1; i < ncmplx; i++) {
                ipos = i * pix_per_trace;
                ipos += ibias;

                i1++;

                /*iaddr = i; ...not used...*/
                /*temp = (float)(datai[i] / maxval);
                if (fabs(temp) > 1) temp =  1;
                if (temp < 0) {
                        printf(" temp = %f\n", temp);
                        temp = 0;
                }*/

                temp = -datai[i];
		/*if(temp < -100.) temp = -100.;*/
                if(temp > 100.) temp = 100.;

                /*offset = (int)(500 - temp*500);*/
                offset2 = offset;
                offset = (int)((temp/6)*25);
                /*offset = (int)((temp/6)*50);*/
                /*offset = (int)((temp/6)*100);*/
                offset += can_bias_y;

                mb = i + can_bias_x;

                XDrawLine(dpy, *local, gclocal,
                        mb, offset2, mb, offset);
                        /*mb, offset, mb, base_pos);*/
        }
 
 
/* ... annotate the horizontal frequency axis ... */
        kntr = 0;
        iipos = ibias;

        for (i = 0; i < ncmplx; i++) {
                if( i == index[kntr]) {
                   ipos = i * pix_per_trace + ibias;

                   if((ipos-iipos) > 3*num_font.width || i == 0) {
                           XDrawLine(dpy, *local, gclocal,
                   	 	   ipos, base_pos, ipos, base_pos + 12);
   
                           sprintf(time,"%d", (int)freqs[kntr]);
                           jpos = base_pos + 12 + num_font.height;
   
                           XDrawString(dpy, *local, gclocal,
                                   ipos, jpos, time, strlen(time));
   
                           iipos = ipos;
                   }
                   else {
                           XDrawLine(dpy, *local, gclocal,
                    		   ipos, base_pos, ipos, base_pos + 8);
                   }
                   kntr++;
                }
        }
 
/* ..... label with filename .... */
        sprintf(time,"%s",input_file);

        ix = can_bias_x + 5;
        iy = can_bias_y + numpt + 60;
        /*iy = can_bias_y + 560;*/
        XDrawString(dpy, *local, gclocal,
                        ix, iy, time, strlen(time));
 
        ix = can_bias_x + 5;
        iy = can_bias_y + numpt + 80;
        /*iy = can_bias_y + 580;*/
        XDrawString(dpy, *local, gclocal, ix, iy,
                files[iselect], strlen(files[iselect]) );
 
        XFreeGC(dpy, gclocal);
 
/* ... free the allocates ... */
        free(freqs);
        free(index);
        free(time);
}


void graph_amp(datai, dpy, id, fnyqst, ncmplx, freq_incr, label_inc)
	Display         *dpy;
	XID                     id;
	float           *datai, fnyqst, freq_incr;
	int                     ncmplx, label_inc;
/*   Creates the image to be displayed by creating a
*    Pixmap (drawable) and drawing the data to it.  The
*    pixmap is then assigned to the server image.
*/
{

        GC                              gclocal;
        XGCValues               gcvals;

        int                             i, j, iaddr, ma, mb, k;
        int                             offset, ipos;
        int                             compare;
        int                             jpos, ibias;
        int                             one, i1;
        int                             base_pos;
        int                     scr, pcolor;
        int                             kntr;
        int                             *index = NULL;
        int                             nl, fny;
        int                             pw, ph;

        float                   temp, tpix, sec;
        float                   *freqs = NULL;

        char                    *time;

        XColor                  color;
        Colormap                cmap;
	int	ix, iy;
	Pixmap	*local;
	int	iipos;

/*******************************************************************************/

/* *   Create the pixmap for drawing */

        fny = (int)fnyqst;
        nl = (int)(fnyqst/ (float)label_inc) + 2;

        index = (int *)calloc(nl, sizeof(int));
        freqs = (float *)calloc(nl, sizeof(float));

        k = 0;
        for (i = 0; i < fny; i+= label_inc) {
                freqs[k] = (float)i;
                index[k] = (int)(freqs[k]/freq_incr);
                k++;
        }

        scr = DefaultScreen(dpy);
        cmap = AppCmap;

        base_pos = 500 + can_bias_y;
	numpt = 500;
        one = 1;
    	compare =  100;

/* - bumped up to 256 bytes - Jun 2, 2000 - joe m. wade */

        time = (char *)calloc(/* 80 */ 256, sizeof(char));
        tpix = (float)pix_per_trace;

	local = pixmap1+iselect;
        if(*local) XFreePixmap(dpy, *local);

	pw = pixwidth;
	ph = can_hi;

        *local = XCreatePixmap(dpy, id, pw, ph, depth);
        if (!(*local))
                printf("  Creation failed for pixmap %d\n", iselect);

        gcvals.foreground = WhitePixel(dpy, DefaultScreen(dpy));
        gcvals.background = BlackPixel(dpy, DefaultScreen(dpy));
        gclocal = XCreateGC(dpy, *local, GCForeground|GCBackground, &gcvals);

/* *    Fill the rectangle to clear it for drawing */

        XFillRectangle(dpy, *local, gclocal, 0, 0, pixwidth, can_hi);

        gcvals.foreground = BlackPixel(dpy, DefaultScreen(dpy));
        gcvals.background = WhitePixel(dpy, DefaultScreen(dpy));
        XChangeGC(dpy, gclocal, GCForeground | GCBackground, &gcvals);

/* ... annotate the vertical amplitude axis ... */

        ipos = can_bias_x - pix_per_trace;
        ma =  can_bias_y;
        XDrawLine(dpy, *local, gclocal, ipos - 11, ma, ipos, ma);

        sec = 1.;
        sprintf(time,"%5.2f", sec);

        jpos = (ipos - 13)- strlen(time) * num_font.width;
        if (jpos < 0) jpos = 0;

        k = ma + num_font.height/3;
        if (k < 0) k = 0;

        XDrawString(dpy, *local, gclocal, jpos, k,
                time, strlen(time));

        for (i=1; i < 500; i++) {
                ma = i -1 + can_bias_y;
                mb = i + can_bias_y;

                XDrawLine(dpy, *local, gclocal, ipos, ma, ipos, mb);

                if (!(i % compare)) {
                        sec = (500- (float)i) / 500;
                        XDrawLine(dpy, *local, gclocal, ipos - 11, mb, ipos, mb);

                        sprintf(time,"%5.2f", sec);

                        jpos = (ipos - 13)- strlen(time) * num_font.width;
                        if (jpos < 0) jpos = 0;

                        k = mb + num_font.height/3;
                        if (k < 0) k = 0;

                        XDrawString(dpy, *local, gclocal, jpos, k,
                                time, strlen(time));
                }
        }

        jpos = 250 + can_bias_y - 9*letter_font.height;
        ipos = 5;
        sprintf(time,"N");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"O");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"R");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"M");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"A");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"L");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"I");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"Z");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        sprintf(time,"E");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"D");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + 2*letter_font.height;
        sprintf(time,"A");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"M");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"M");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"L");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"I");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"T");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"U");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"D");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));

        jpos = jpos + letter_font.height;
        sprintf(time,"E");
        XDrawString(dpy, *local, gclocal, ipos, jpos, time, strlen(time));


/* ... draw the spectrum ... */

        k = 0;
        i1 = -1;
        ibias = can_bias_x;

        for (i=0; i < ncmplx; i++) {
                ipos = i * pix_per_trace;
                ipos += ibias;
                i1++;
                iaddr = i;
                temp = (float)(datai[i] / maxval);

                if (fabs(temp) > 1) temp =  1;

                if (temp < 0) {
                        /*printf(" temp = %f\n", temp);*/
                        temp = 0;
                }

                offset = (int)(500 - temp*500);
                offset += can_bias_y;

                mb = i + can_bias_x;

                XDrawLine(dpy, *local, gclocal,
                        mb, offset, mb, base_pos);
        }


/* ... annotate the horizontal frequency axis ... */
        kntr = 0;
	iipos = ibias;

        for (i = 0; i < ncmplx; i++) {
                if( i == index[kntr]) {
                	ipos = i * pix_per_trace + ibias;
			if((ipos-iipos) > 3*num_font.width || i == 0) {
                        	XDrawLine(dpy, *local, gclocal,
                    			ipos, base_pos, ipos, base_pos + 12);

                        	sprintf(time,"%d", (int)freqs[kntr]);

                        	jpos = base_pos + 12 + num_font.height;
                        	XDrawString(dpy, *local, gclocal,
                                	ipos, jpos, time, strlen(time));

				iipos = ipos;
		   	}
			else {
                        	XDrawLine(dpy, *local, gclocal,
                    			ipos, base_pos, ipos, base_pos + 8);
		   	}
                        kntr++;
                }
        }

/* ..... label with filename .... */
        sprintf(time,"%s",input_file);

	ix = can_bias_x + 5;
	iy = can_bias_y + 560;
        XDrawString(dpy, *local, gclocal, ix, iy, time, strlen(time));

 	ix = can_bias_x + 5;
	iy = can_bias_y + 580;
	XDrawString(dpy, *local, gclocal, ix, iy, 
			files[iselect], strlen(files[iselect]) );

        XFreeGC(dpy, gclocal);

/* ... free the allocates ... */
	free(freqs);
	free(index);
	free(time);
}


void get_file(w, client_data, call_data)
	Widget w;
	int client_data;
	caddr_t call_data;
{
        iselect = client_data;
        canvas_repaint_proc(draw_area);
}


void get_file2(w, client_data, call_data)
	Widget w;
	int client_data;
	caddr_t call_data;
{
	int i,pw,ph;
	GC gcl;
	unsigned long plane;
        Arg arg[2];
	int n;

/****************************************************************************/
	plane = 1;

        i = client_data;

	pw = Info2d[i].pixwidth2;
	ph = Info2d[i].can_hi2;
	gcl = Info2d[i].gc2;

        n = 0;
        XtSetArg(arg[n], XmNheight, ph); n++;
        XtSetArg(arg[n], XmNwidth, pw); n++;
        XtSetValues(Info2d[i].drawa, arg, n);

        XCopyArea(display, Info2d[i].pixmap2, Info2d[i].xid2, gcl, 0, 0, pw, ph, 0, 0);
 
        if(Info2d[i].zoomTF) {
  		XSetFunction(display,gcl,GXequiv);
 
  		XSetLineAttributes(display,gcl,0,
                     LineSolid,CapNotLast,JoinRound);

  		XDrawRectangle(display,XtWindow(Info2d[i].drawa),gcl,

                Info2d[i].zoomx,Info2d[i].zoomy,Info2d[i].zoomwid,
		Info2d[i].zoomht);
 
  		XSetLineAttributes(display,gcl,line_width,
                     LineSolid,CapNotLast,JoinRound);
 
  		XSetFunction(display,gcl,GXcopy);
        }

        XtAddEventHandler(Info2d[i].drawa,PointerMotionMask | LeaveWindowMask,
                False, (XtEventHandler)handle_odom2CB, (XtPointer)Info2d[i].thisn);

        /*n = 0;
        XtSetArg(arg[n], XmNheight, Info2d[i].topht); n++;
        XtSetArg(arg[n], XmNwidth, Info2d[i].topwid); n++;
        XtSetValues(Info2d[i].forma, arg, n);*/

	/*XtResizeWindow(Info2d[i].topa);*/

        /*XtSetValues(Info2d[i].topa, arg, n);*/

	XtMapWidget(Info2d[i].topa);

	/*   XtManageChild(Info2d[i].aboard);   */

}

Pixel get_pixel_by_name(dpy, name)
	Display *dpy;
	char *name;
{
        extern Visual *visual;

        int scr = DefaultScreen(dpy);

        Colormap cmap = AppCmap; /* DefaultColormap(dpy, scr); */
        XColor color, ignore;

        if(visual->class == PseudoColor)
          if (XAllocNamedColor(dpy, cmap, name, &color, &ignore))
             return (color.pixel);
          else {
                printf("Warning: Couldn't allocate color %s\n", name);
                return (BlackPixel(dpy, scr));
          }
        else {
          XLookupColor(dpy, cmap, name, &ignore, &color);
          color2pixel(&color,visual,depth);
        }
        return (color.pixel);
}

static void xs_ok_callback(w, client_data, call_data)
        Widget  w;
        caddr_t client_data;
        XmAnyCallbackStruct     *call_data;
{

        XtUnmanageChild(w);
		XtManageChild((Widget)client_data);
}


void tog_change (w, client_data, call_data)
	Widget          w;              /*  widget id           */
	caddr_t         client_data;    /*  data from application   */
	caddr_t         call_data;      /*  data from widget class  */
{
	switch ( (int)client_data) {

   	case 1:/*1-D Amplitude Spectrum-Linear Scale*/
        	XmToggleButtonGadgetSetState(tog2d, False, False);
        	XmToggleButtonGadgetSetState(tog3d, False, False);
        	XmToggleButtonGadgetSetState(tog4d, False, False);
        	XmToggleButtonGadgetSetState(tog1d, True, False);
		spec_type = 0;
		break;

   	case 2:/* 2-D Amplitude Spectrum */
        	XmToggleButtonGadgetSetState(tog1d, False, False);
        	XmToggleButtonGadgetSetState(tog3d, False, False);
        	XmToggleButtonGadgetSetState(tog4d, False, False);
        	XmToggleButtonGadgetSetState(tog2d, True, False);
		spec_type = 1;
		break;

   	case 3: /* Phase Spectrum */
        	XmToggleButtonGadgetSetState(tog1d, False, False);
        	XmToggleButtonGadgetSetState(tog2d, False, False);
        	XmToggleButtonGadgetSetState(tog4d, False, False);
        	XmToggleButtonGadgetSetState(tog3d, True, False);
        	spec_type = 2;
		break;

   	case 4: 
        	XmToggleButtonGadgetSetState(tog2p, False, False);
        	XmToggleButtonGadgetSetState(tog3p, False, False);
        	XmToggleButtonGadgetSetState(tog1p, True, False);
        	phase_type = 0;
        	break;

   	case 5:
        	XmToggleButtonGadgetSetState(tog1p, False, False);
        	XmToggleButtonGadgetSetState(tog3p, False, False);
        	XmToggleButtonGadgetSetState(tog2p, True, False);
        	phase_type = 1;
        	break;

   	case 6:
        	XmToggleButtonGadgetSetState(tog1p, False, False);
        	XmToggleButtonGadgetSetState(tog2p, False, False);
        	XmToggleButtonGadgetSetState(tog3p, True, False);
        	phase_type = 2;
        	break;
	
   	case 7: /* 1-D Amplitude Spectrum-Log Scale */
        	XmToggleButtonGadgetSetState(tog1d, False, False);
        	XmToggleButtonGadgetSetState(tog2d, False, False);
        	XmToggleButtonGadgetSetState(tog3d, False, False);
        	XmToggleButtonGadgetSetState(tog4d, True, False);
        	spec_type = 3;
		break;

        }
}


void graph_ph(datai, dpy, id, fnyqst, ncmplx, freq_incr, label_inc)
	Display         *dpy;
	XID                     id;
	float           *datai, fnyqst, freq_incr;
	int                     ncmplx, label_inc;
/*   Creates the image to be displayed by creating a
*    Pixmap (drawable) and drawing the data to it.  The
*    pixmap is then assigned to the server image.
*/
{

        GC                              gclocal;
        XGCValues               gcvals;
        int                             i, j, iaddr, ma, mb, k;
        int                             offset, ipos;
        int                             jpos, ibias;
        int                             one, i1;
        int                             base_pos;
        int                     scr, pcolor;
        int                             kntr;
        int                             *index;
        int                             nl, fny;
        int                             pw, ph;

        float                   temp, tpix, sec;
        float                   *freqs = NULL;
    	float           *pl, ang;
    	float            rad;

        char                    *time;

        XColor                  color;
        Colormap                cmap;
    	Pixmap          *local;

	int	ix, iy;
	int	plx, ply;

/*****************************************************************************/
	plx = 3;
	ply = 5;

/* *   Create the pixmap for drawing */

    	rad = 180. / 3.1415926;
        fny = (int)fnyqst;

        nl = (int)(fnyqst/ (float)label_inc) + 2;
        index = (int *)scalloc(nl, (int)sizeof(int));
        freqs = (float *)scalloc(nl, (int)sizeof(float));

        /*index = (int *)scalloc(nl, sizeof(int));
        freqs = (float *)scalloc(nl, sizeof(float));*/

        k = 0;
        for (i = 0; i < fny; i+= label_inc) {
                freqs[k] = (float)i;
                index[k] = (int)(freqs[k]/freq_incr);
                k++;
        }

        scr = DefaultScreen(dpy);
        cmap = AppCmap;

        base_pos = 500 + can_bias_y;
        one = 1;
        time = (char *)scalloc(80, (int)sizeof(char));
        /*time = (char *)scalloc(80, sizeof(char));*/

        tpix = (float)pix_per_trace;
        local = pixmap3 + iselect;

        if(*local) XFreePixmap(dpy, *local);

        pw = pixwidth;
        ph = can_hi;

        *local = XCreatePixmap(dpy, id, pw, ph, depth);
        if (!(*local))
                printf("  Creation failed for pixmap %d\n", iselect);

        gcvals.foreground = WhitePixel(dpy, DefaultScreen(dpy));
        gcvals.background = BlackPixel(dpy, DefaultScreen(dpy));
        gclocal = XCreateGC(dpy, *local, GCForeground|GCBackground,
                        &gcvals);

/* *    Fill the rectangle to clear it for drawing */

        XFillRectangle(dpy, *local, gclocal, 0, 0, pixwidth, can_hi);

        gcvals.foreground = BlackPixel(dpy, DefaultScreen(dpy));
        gcvals.background = WhitePixel(dpy, DefaultScreen(dpy));
        XChangeGC(dpy, gclocal, GCForeground | GCBackground, &gcvals);

        ipos = can_bias_x - pix_per_trace;
        ma =  can_bias_y;
        XDrawLine(dpy, *local, gclocal, ipos - 11, ma, ipos, ma);

        sec = 180.;
        sprintf(time,"%5.1f", sec);

        jpos = (ipos - 13)- strlen(time) * num_font.width;
        if (jpos < 0) jpos = 0;

    	mb = can_bias_y + 500;
    	k = can_bias_x;
    	XDrawLine(dpy, *local, gclocal, k, ma, k, mb);

        k = mb + num_font.height/3;
        if (k < 0) k = 0;

        XDrawString(dpy, *local, gclocal, jpos, k,
                time, strlen(time));

    	sec = 180;

        for (i=375; i >= 0; i -= 125) {
                ma = i -1 + can_bias_y;
                mb = i + can_bias_y;
                XDrawLine(dpy, *local, gclocal, ipos, ma, ipos, mb);

                sec -= 90;
                XDrawLine(dpy, *local, gclocal, ipos - 11, mb, ipos, mb);

                sprintf(time,"%5.1f", sec);

                jpos = (ipos - 13)- strlen(time) * num_font.width;
                if (jpos < 0) jpos = 0;

                k = mb + num_font.height/3;
                if (k < 0) k = 0;

                XDrawString(dpy, *local, gclocal, jpos, k,
                        time, strlen(time));

		k = i + can_bias_y;
    		ma = can_bias_x;
    		mb = ma + ncmplx;
    		XDrawLine(dpy, *local, gclocal, ma, k, mb, k);

        }

    	k = 500 + can_bias_y;
    	ma = can_bias_x;
    	mb = ma + ncmplx;
    	XDrawLine(dpy, *local, gclocal, ma, k, mb, k);

        k = 0;
        i1 = -1;
        ibias = can_bias_x;
    	pl = datai;

    	gcvals.line_width = 3;
    	XChangeGC(dpy, gclocal, GCLineWidth, &gcvals);

        for (i=0; i < ncmplx; i++) {
                ipos = i * pix_per_trace;
                ipos += ibias;

                i1++;
                iaddr = i;

                temp = *pl;
        	temp = temp * rad;
        	temp = (temp + 180.)/360.;

                if (fabs(temp) > 1.) {
                        /*printf(" temp = %f\n", temp);*/
                        temp =  1.;
		}

                if (temp < 0.) {
                        /*printf(" temp = %f\n", temp);*/
                        temp = 0.;
                }

                offset = (int)(501. - temp*501. + .5);
                offset += can_bias_y;
		offset += ply;

                mb = i + can_bias_x - plx;


	        sprintf(time,"%s","*");
                XDrawString(dpy, *local, gclocal,
                        mb, offset, time, strlen(time));

        	pl ++;
        }

    	gcvals.line_width = 0;
    	XChangeGC(dpy, gclocal, GCLineWidth, &gcvals);

        kntr = 0;
        for (i = 0; i < ncmplx; i++) {
                ipos = i * pix_per_trace + ibias;

                if( i == index[kntr]) {
                        XDrawLine(dpy, *local, gclocal,
                    		ipos, base_pos, ipos, base_pos + 10);

                        sprintf(time,"%d", (int)freqs[kntr]);

                        jpos = base_pos + 12 + num_font.height;
                        XDrawString(dpy, *local, gclocal,
                                ipos, jpos, time, strlen(time));

                        kntr++;
                }
        }


/* ..... label with filename .... */

        sprintf(time,"%s",input_file);
	ix = can_bias_x + 5;
	iy = can_bias_y + 560;
        XDrawString(dpy, *local, gclocal,
                        ix, iy, time, strlen(time));

/* ..... label fram with rec/trc number ... */
        ix = can_bias_x + 5;
        iy = can_bias_y + 580;
        XDrawString(dpy, *local, gclocal, ix, iy,
                filesp[iselect], strlen(filesp[iselect]) );


/* .... free up everything .... */
        XFreeGC(dpy, gclocal);
        free(freqs);
        free(index);
        free(time);
}

void compute_phase(x, y, n)
	float *x, *y;
	int n;
{
        int i,k;
    	float  ratio;
    	double im, re, zero;
    	/*float im, re, ratio;*/

/**********************************************************/

	zero = (double)0.0;
	ratio = 3.1415927/2.;

    	k=0;
    	for (i = 0; i < n; i++) {
       		re = (double)(*(x + k));
       		k ++;
       		im = (double)(*(x + k));

/*.........don't we need to bump up to next real part here?.......*/

       		k ++;
       		if (re != zero)
          		*(y+i) = atan2(im, re);
       		else
       			*(y+i) = ratio;
     	}
}


XtCallbackProc adj_colorsCB(w, data, call)
	Widget w;
	caddr_t call;
	int data;
	/*caddr_t data, call;*/
{
	iptcc = data;
	(void)DisplayColorEditor();

	/*DisplayColorEditor(bb_Color);*/
	/*DisplayColorEditor();*/
}


/* ** Color Editor calls this if colormap endpoints are changed */

void limits_change()
{
   extern void  draw_it() ;

/******************************************************************/
   Info2d[iptcc].cmap = AppCmap;

   /*XSetWindowColormap(display,Info2d[iptcc].xid2,AppCmap);*/

   draw_it (display, Info2d[iptcc].xid2, iptcc);

   /*draw_it (display, xid, iptcc);*/
   /*draw_it (display, xid);*/

   /*XtUnmanageChild (Info2d[iptcc].aboard) ;*/

   /*XtUnmanageChild (bboard3) ;
   XtManageChild   (bboard3) ;*/

   /*XtManageChild   (Info2d[iptcc].aboard) ;*/
}

Widget create_zoom_box (id)
	int id;
{
   int n ;
   Arg args[10] ;
   Widget   form,
            cascade;

   XmString xmstring ;
   Cursor cursor ;

   static int flag ;

   char *astring;


/* ** Create a form widget and attach a scrolled window and drawing
** area.  */

   n = 0 ;

   /*if(astring)
       free(astring);*/

   astring = (char *)calloc(MAX_FILENAME_LEN + 1, sizeof(char));
   sprintf(astring,"Zoom Window %d",id+1);

   XtSetArg(args[n], XmNdialogTitle,
           (xmstring=XmStringCreate(astring,
            XmSTRING_DEFAULT_CHARSET))); n++;

   /*form = XmCreateBulletinBoardDialog(toplevel, "zoomForm", args, n) ;*/
   form = XmCreateBulletinBoardDialog(Info2d[id].topa, "zoomForm", args, n) ;
	XmStringFree(xmstring);
	free(astring);

/* *  Build scrolled window to hold the drawing area */
   n = 0 ;
   XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC) ; n++ ;
   XtSetArg (args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED) ; n++ ;
   XtSetArg (args[n], XmNvisualPolicy, XmVARIABLE) ; n++ ;
   zoomsw = XmCreateScrolledWindow (form, "swz", args, n) ;
   XtManageChild(zoomsw);


/* ** Setup scrollbars */

   n = 0 ;
   XtSetArg (args[n], XmNverticalScrollBar, &Info2d[id].zvsb) ; n++ ;
   XtGetValues (zoomsw, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNhorizontalScrollBar, &Info2d[id].zhsb) ; n++ ;
   XtGetValues (zoomsw, args, n) ;

/* get values from the scrollbars */
   n = 0;
   XtSetArg (args[n], XmNminimum, &zvmin); n++;
   XtSetArg (args[n], XmNmaximum, &zvmax); n++;
   XtGetValues(Info2d[id].zvsb, args, n);

   n = 0;
   XtSetArg (args[n], XmNminimum, &zhmin); n++;
   XtSetArg (args[n], XmNmaximum, &zhmax); n++;
   XtGetValues(Info2d[id].zhsb, args, n);
/* ... end of scrollbar stuff ... */


/* ** Create drawing areas managed by each scrolled window */

   n = 0 ;
   zoomdraw = XmCreateDrawingArea (zoomsw, "drawingZ", args, n) ;
   XtManageChild (zoomdraw) ;

   n = 0 ;
   XtSetArg (args[n], XmNworkWindow, zoomdraw) ; n++ ;
   XtSetArg (args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
   XtSetValues (zoomsw, args, n) ;

   XtAddCallback(zoomdraw, XmNexposeCallback, repaint_zoom, (XtPointer)id);
   /*XtAddCallback(zoomdraw, XmNexposeCallback, repaint_zoom, NULL);*/

/* ** Install cursor in the drawing area */

   return(form);
}

void repaint_zoom(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int id;
	id = (int)client_data;

        /*XCopyArea(display, copypix, zwin, gclocal,*/
        XCopyArea(display, Info2d[id].zoompix, Info2d[id].zwin, Info2d[id].gc2,
	           0, 0, Info2d[id].xwidth, Info2d[id].xheight, 0, 0);

}


/* ** Draw a string centered in the odometer drawing area, Note ---->
** a drawing area seems to be faster than a label widget for this purpose */

void update_odometer (string)
	char *string ;
{
   Arg args[2] ;
   Dimension width, height ;
   int x, y ;

   /* assumes 9x15 font is loaded in gc_odometer.font */
   XtSetArg (args[0], XmNwidth, &width) ;
   XtSetArg (args[1], XmNheight, &height) ;
   XtGetValues ( odometer, args, 2) ;

   x = (int) (width - (9 * strlen(string))) / 2 ;
   y = height - ((int)(height - 11) / 2) ;

   XClearWindow (display, XtWindow(odometer)) ;

   XDrawString (display, XtWindow(odometer), gc_odometer,
               x, y, string, strlen(string)) ;
}

XtEventHandler handle_odomCB (w, sp, event)
	Widget w ;
	int sp;
	/*caddr_t sp;*/
	XEvent *event ;
{
   char   string[80] ;
   int    ex, ey;
   int    get_x, get_y;
   Arg args[10];
   float tf, sf;
   float temp, temp1, *f1;
   int xfac, yfac;

   int wid, ht, ncplx, biasx, biasy;
   float freqincr;

   switch (spec_flag) {
	case 1:  wid = pixwidth1;
		 ht = can_hi1;
		 ncplx = ncmplx1;
		 biasx = can_bias_x1;
		 biasy = can_bias_y1;
		 freqincr = freqi1;
		 break;
	/*case 2:  wid = pixwidth2;
		 ht = can_hi2;
		 ncplx = ncmplx2;
		 freqincr = freqi2;
		 break;*/
 	case 3:  wid = pixwidth3;
		 ht = can_hi3;
		 ncplx = ncmplx3;
		 biasx = can_bias_x3;
		 biasy = can_bias_y3;
		 freqincr = freqi3;
		 break;
	case 4:  wid = pixwidth1;
		 ht = can_hi1;
		 ncplx = ncmplx1;
		 biasx = can_bias_x1;
		 biasy = can_bias_y1;
		 freqincr = freqi1;
		 break;
   }

   switch (event->type) {

   case MotionNotify :

      	ex = event->xmotion.x ;
      	ey = event->xmotion.y ;

/* **             Handle odometer */

/* ............1-d linear scaling.................*/
 	if(spec_flag == 1) {

   		if(ex < biasx || ex > (biasx + ncplx - 1) ||
			ey < biasy || ey > (biasy + numpt1)) {
			sprintf(string," ");
   		}
   		else {
			get_x = ex - biasx;
			tf = get_x * freqincr;
	   		get_y = ey - biasy;

	   		/*sf = (-6.*get_y) / 25.;*/
           		sf = (500. - (float)get_y)/500.;

			/*sprintf(string, "freq=%10.5f amp in dB=%10.5f",*/
        		sprintf(string, "freq=%10.5f norm.amp=%10.5f", tf, sf);
   		}
	}

/* ............1-d log scaling....................*/
	else if(spec_flag == 4) {
   		if(ex < biasx || ex > (biasx + ncplx - 1) ||
        		ey < biasy || ey > (biasy + numpt1)) {
        		sprintf(string," ");
   		}
   		else {
        		get_x = ex - biasx;
        		tf = get_x * freqincr;
           		get_y = ey - biasy;

           		/*sf = (500. - (float)get_y)/500.;*/
	   		sf = (-6.*get_y) / 25.;

        		/*sprintf(string, "freq=%10.5f norm.amp=%10.5f",*/
			sprintf(string, "freq=%10.5f amp in dB=%10.5f", tf, sf);
   		}
	}

/*..............phase spectrum.................*/
	else {
   		if(ex < biasx || ex > (biasx + ncplx - 1) ||
        		ey < biasy || ey > (biasy + 500)) {
        		sprintf(string," ");
   		}
   		else {
        		get_x = ex - biasx;
        		tf = get_x * freqincr;
           		get_y = ey - biasy;

           		sf = (float)get_y/500.;
           		sf = sf*360. - 180.;

        		sprintf(string, "freq=%10.5f phase=%10.5f", tf, sf);
   		}
	}

        update_odometer(string) ;

      	break ;

   case LeaveNotify :
/* **    Blank out odometer and clear hyperbola if we just left the window */

     	update_odometer (" ") ;
      	break ;

   default :
/* **    This should never happen !!!!! */

      	printf("\nunknown event received in handle_eventsCB") ;
      	break ;
   }
}


void create_zoom_parm(id)
	/*Widget create_zoom_parm(id)*/
	int	id;
{
   int n, k;
   Arg args[10] ;
   XmString xmstring ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep;
   Widget toggle_box, label0, rc4;
   extern XtCallbackProc manage_widgetCB(), zoom_allCB() ;

/***********************************************************************/

   n = 0;
   XtSetArg(args[n], XmNdialogTitle,
           (xmstring=XmStringCreate("Zoom Scale Parameters",
            XmSTRING_DEFAULT_CHARSET))); n++;
   XtSetArg(args[n], XmNheight, 150); n ++;
   XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;

   /*bboard = XmCreateBulletinBoardDialog (toplevel, "parmboard", args,*/
   /*bboard = XmCreateBulletinBoardDialog (Info2d[id].forma,*/

 /*Info2d[id].zoom_parm_panel = XmCreateBulletinBoardDialog (toplevel,*/
   Info2d[id].zoom_parm_panel = XmCreateBulletinBoardDialog (Info2d[id].topa,
	"parmboard", args, n);

   XmStringFree(xmstring);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (Info2d[id].zoom_parm_panel, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3a", args, n);
   XtManageChild (rc3) ;

   xmstring = XmStringCreateLtoR("Horizontal zoom factor",
                                 XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;

   XmStringFree (xmstring) ;
   xmstring = XmStringCreateLtoR("Vertical zoom factor",
                                 XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc3) ;

   ztexts[0] =  XmCreateText (rc3, "txt", NULL, 0) ;
   XtManageChild (ztexts[0]) ;

   ztexts[1] =  XmCreateText (rc3, "txt", NULL, 0) ;
   XtManageChild (ztexts[1]) ;

   n = 0 ;
   XtSetArg (args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;

   n = 0;
   XtSetArg(args[n], XmNshowAsDefault, 1); n++;
   pb_ok =XtCreateManagedWidget("ok",xmPushButtonWidgetClass,
        rc2, args,n);

   XtAddCallback(pb_ok, XmNactivateCallback,
      (XtCallbackProc)unmanage_widgetCB, Info2d[id].zoom_parm_panel);

   XtAddCallback(pb_ok, XmNactivateCallback,
      (XtCallbackProc)zoom_allCB, (XtPointer)id);
      /*zoom_allCB, XtWindow(draw_area));*/

   n = 0;
   XtSetArg(args[n], XmNdefaultButton, pb_ok); n++;
   XtSetValues(Info2d[id].zoom_parm_panel,args,n);

   pb_dismiss = XtCreateManagedWidget
       ("cancel", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback,
          (XtCallbackProc)unmanage_widgetCB, Info2d[id].zoom_parm_panel);

   return ;
   /*return (bboard);*/
}

XtCallbackProc unmanage_widgetCB (w, client, call)
	Widget      w, client ;
	caddr_t     call ;
{
   XtUnmanageChild (client) ;
}

XtCallbackProc manage_widgetCB (w, client, call)
	Widget      w, client ;
	caddr_t     call ;
{
   XtManageChild (client) ;
}

/*.............function to put old parameters on screen.........*/

static void get_old(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
        int nargs, i;
        XmString        lstring;
        Arg   arg[2];
        char temp[80];
        /*String temp;*/
	int	itype;
	void	tog_set();
 
/******************************************************************/
 
	if(old_parms) {
 
        	XtUnmanageChild(parm_panel_dialog);
        	/*XtUnmanageChild(bboard2);*/

        	if(strncmp((char *)input_file," ",1) == 0) {
  			XBell(display,50);
                	XtManageChild(nofile);
                	return;
        	}

 
/* start record */
        	sprintf(temp, "%d", old_s_rec);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[4], arg, 1);
 
/* start trace */
        	sprintf(temp, "%d", old_s_tr);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[5], arg, 1);
 
/* end record */
        	sprintf(temp, "%d", old_e_rec);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[6], arg, 1);
 
/* end trace */
        	sprintf(temp, "%d", old_e_tr);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[7], arg, 1);
 
/* trace increment */
        	sprintf(temp, "%d", old_tr_inc);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[8], arg, 1);

/* window start */
        	sprintf(temp, "%d", old_s_win);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[9], arg, 1);
 
/* window end */
        	sprintf(temp, "%d", old_e_win);
        	XtSetArg(arg[0], XmNvalue, temp);
        	XtSetValues(texts[10], arg, 1);

		itype = old_spec_type + 1;

		if(itype == 3) itype = 7;
		tog_set(itype);

		itype = old_phase_type + 4;
		tog_set(itype);

        	/* XtManageChild(parm_panel); */
        	XtManageChild(parm_panel_dialog);
        	/*XtManageChild(bboard2);*/
	}
}
 
void tog_set (itype)
	int	itype;
{
   switch (itype) {
 
   case 1:
        XmToggleButtonGadgetSetState(tog2d, False, False);
        XmToggleButtonGadgetSetState(tog3d, False, False);
        XmToggleButtonGadgetSetState(tog4d, False, False);
        XmToggleButtonGadgetSetState(tog1d, True, False);
        spec_type = 0;
        break;
 
   case 2:
        XmToggleButtonGadgetSetState(tog1d, False, False);
        XmToggleButtonGadgetSetState(tog3d, False, False);
        XmToggleButtonGadgetSetState(tog4d, False, False);
        XmToggleButtonGadgetSetState(tog2d, True, False);
        spec_type = 1;
        break;
 
   case 3:
        XmToggleButtonGadgetSetState(tog1d, False, False);
        XmToggleButtonGadgetSetState(tog2d, False, False);
        XmToggleButtonGadgetSetState(tog4d, False, False);
        XmToggleButtonGadgetSetState(tog3d, True, False);
        spec_type = 2;
        break;
 
   case 4:
        XmToggleButtonGadgetSetState(tog2p, False, False);
        XmToggleButtonGadgetSetState(tog3p, False, False);
        XmToggleButtonGadgetSetState(tog1p, True, False);
        phase_type = 0;
        break;
 
   case 5:
        XmToggleButtonGadgetSetState(tog1p, False, False);
        XmToggleButtonGadgetSetState(tog3p, False, False);
        XmToggleButtonGadgetSetState(tog2p, True, False);
        phase_type = 1;
        break;
 
   case 6:
        XmToggleButtonGadgetSetState(tog1p, False, False);
        XmToggleButtonGadgetSetState(tog2p, False, False);
        XmToggleButtonGadgetSetState(tog3p, True, False);
        phase_type = 2;
        break;
 
   case 7:
        XmToggleButtonGadgetSetState(tog1d, False, False);
        XmToggleButtonGadgetSetState(tog2d, False, False);
        XmToggleButtonGadgetSetState(tog3d, False, False);
        XmToggleButtonGadgetSetState(tog4d, True, False);
        spec_type = 3;
        break;
 
   }
}

XtEventHandler handle_odom2CB (w, id, event)
	Widget w ;
	int id;
	XEvent *event ;
{
   char   string[80] ;
   int    ex, ey;
   int    get_x, get_y;
   Arg args[10];
   float tf, sf;
   float temp, temp1, *f1;
   int xfac, yfac;

   void update_odometer2();
 
/*....................2-d spectrum.................*/
 
   switch (event->type) {
 
   case MotionNotify :
 
      	ex = event->xmotion.x ;
      	ey = event->xmotion.y ;
 
/* **             Handle odometer */
 
    	if(ex < Info2d[id].xpos || ey < Info2d[id].ypos ||
		ex > (Info2d[id].pixwidth2-11) || ey > (9 + Info2d[id].ph1) ) {
        	sprintf(string, " ");
    	}
    	else {
        	get_x = ex - xpos;
        	get_y = ey - ypos;
 
        	tf = (float)(Info2d[id].ncmplx2 - 1 - get_y/Info2d[id].fact2) *
			Info2d[id].freqi2;
        	sf = ((float)(get_x/Info2d[id].fact2) / (float)(Info2d[id].leng2)) - .5;
 
        	f1 = Info2d[id].amp;
        	xfac = get_x/Info2d[id].fact2;
        	yfac = get_y/Info2d[id].fact2;
        	f1 += ((Info2d[id].ncmplx2 - 1 -yfac)*(Info2d[id].leng2+1) + xfac);
        	temp = (*f1);
        	temp1 = temp*Info2d[id].fscal;
 
 
		/*sprintf(string,"tf=%5.1f sf=%5.3f amp=%10.5f norm.amp=%10.5f",*/
		sprintf(string,"tf=%5.1f sf=%5.3f amp=%g norm.amp=%10.5f", tf, sf, temp, temp1);
    	}

        update_odometer2(string,id) ;
      	break ;
 
   case LeaveNotify :
/* **    Blank out odometer and clear hyperbola if we just left the window */
      	update_odometer2 (" ",id) ;
      	break ;

   default :
/* **    This should never happen !!!!! */
      printf("\nunknown event received in handle_eventsCB") ;
      break ;
   }
}
	
/* ** Draw a string centered in the odometer drawing area, Note ---->
** a drawing area seems to be faster than a label widget for this purpose
**	.........this is for the 2d spectra only.........  */
 
void update_odometer2 (string, id)
	char *string ;
	int	id;
{
   Arg args[2] ;
   Dimension width, height ;
   int x, y ;

/**************************************************************************/
 
   /* assumes 9x15 font is loaded in gc_odometer.font */
   XtSetArg (args[0], XmNwidth, &width) ;
   XtSetArg (args[1], XmNheight, &height) ;
   XtGetValues ( Info2d[id].odom, args, 2) ;

   x = (int) (width - (9 * strlen(string))) / 2 ;
   y = height - ((int) (height - 11) / 2) ;

   XClearWindow (display, XtWindow(Info2d[id].odom)) ;

   XDrawString (display, XtWindow(Info2d[id].odom), gc_odometer,
   /*XDrawString (display, XtWindow(Info2d[id].odom), Info2d[id].gc2,*/
               x, y, string, strlen(string)) ;
}
