C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  SPIKE: generate a record of ntr traces with spike
c                            of given ampl. at specified times
C
C**********************************************************************C
C
C For a given near offset time, t0, a given velocity, and a given group
C interval, program computes either a refraction event or a reflection
C hyperbola  and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUOUT, LBYTES,obytes
      integer argis
#include <f77/pid.h>
      REAL        xtr ( 2*SZLNHD )
      REAL        weight ( 2*SZLNHD )
      real        tx,v,tt,dt1,dt2,v2,dip,theta,v1,amp
      integer     it1,it2
      CHARACTER   NAME * 5, otap * 100
      logical verbos,refl,refr,up,down,freq
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'SPIKE'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if ( argis( '-?' ) .gt. 0 .or. 
     :     argis( '-h' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(otap,t0,v,x0,dx,ntr,nsi,amp,ns,refl,refr,
     *dip,v2,up,down,verbos,freq,fst,fed,fnc,iramp)

      if(dx .eq. 0. .AND. .not.freq) then
         write(LERR,*)'No group interval given -- FATAL'
         stop
      endif
      if (nsi .le. 32) then
         dt = float(nsi) / 1000
         v = v/1000.
         v2 = v2/1000.
      else
         dt = float(nsi) / 1000000
         v = v/1000000.
         v2 = v2/1000000.
      endif
      if(v .eq. 0.) v=1.e10
C**********************************************************************C
C     open output data set; build line header
C**********************************************************************C
      call getln( luout, otap, 'w', 1)

      si = nsi
      nsamp=ns/nsi
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      if (freq) then
         fnyq = .5  / dt
         if (fed .eq. 0.) fed = fnyq
         nf = nint ( (fed - fst) / fnc ) + 1
         ntrc = nf
         itpr = iramp / nsi
         do  i = 1, nsamp
             weight (i) = 1.
         enddo
         if (itpr .gt. 1) then
            do  i = 1, itpr
                wti = float (i) / float (itpr)
                weight (i) = wti
                weight (nsamp - i + 1) = wti
            enddo
         endif
      else
         ntrc=ntr
      endif
      nrec=1
      iform=3

       call savew( itr, 'NumTrc', ntrc  , LINHED)
       call savew( itr, 'NumRec', nrec  , LINHED)
       call savew( itr, 'SmpInt',  nsi  , LINHED)
       call savew( itr, 'NumSmp', nsamp , LINHED)
       call savew( itr, 'Format', iform , LINHED)
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


c----------------------------------
c  print out parameters
c----------------------------------
c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        if (freq) then
        write(LERR,*) ' Starting frequency =  ',fst
        write(LERR,*) ' Ending frequency   =  ',fed
        write(LERR,*) ' Frequency incr     =  ',fnc
        write(LERR,*) ' Taper length (ms)  =  ',iramp
        else
        write(LERR,*) ' Near offset time   =  ',t0,' ms'
        write(LERR,*) ' Reflector velocity =  ',v
        write(LERR,*) ' Near offset        =  ',x0
        write(LERR,*) ' Group interval     =  ',dx
        write(LERR,*) ' Spike amplitude    =  ',amp
        write(LERR,*) ' Dip Angle          =  ',180.*dip/3.1415926535
        if(refr) then
         if((dip-0.).gt.1.0e-10) then 
          write(LERR,*) ' Lower Velocity     =  ',v2
          if(up) write(LERR,*)' refraction is updip'
          if(down) write(LERR,*)' refraction is downdip'
         endif
        endif
        endif
c     endif

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      if(t0 .lt. 0.) t0=nsi
      if(t0/nsi .gt. nsamp) then
         write(LERR,*)'Near offset time too large for given trace length
     &'
         stop
      endif
c-------------------------------------
c  update line header; historical LH
c-------------------------------------
      obytes = SZTRHD + SZSMPD*nsamp
      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
       call savew( itr, 'HlhEnt',  0   , LINHED)
       call savew( itr, 'HlhByt', nbyt , LINHED)
      call savhlh( itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )
C**********************************************************************C
C     put spike in appropriate place & write out to otap
C**********************************************************************C

      IF (freq) THEN

         DO  KK = 1, ntrc

             ff  = fst + float(kk-1) * fnc
             iff = ff
             call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     1    , TRACEHEADER)
             call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     kk   , TRACEHEADER)
             call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     iff  , TRACEHEADER)

             do  i = 1, nsamp

                 arg = 6.2831853 * ff * float(i-1) * dt
                 xtr (i) = amp * sin ( arg )
             enddo

          call vmul  (xtr, 1, weight, 1, lhed(ITHWP1), 1, nsamp)
          call wrtape(luout,itr,obytes)

         ENDDO

      ELSE


      DO 100 KK = 1, NTRC
  
          x = x0 + (kk-1)*dx
          ix = nint( x)

                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          1    , TRACEHEADER)
                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          kk   , TRACEHEADER)
                  call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          ix   , TRACEHEADER)
                  call savew2(lhed,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                          ix   , TRACEHEADER)

          xdip = x
          x = abs (x)
c---------------------
c   reflection times
c---------------------
          if(refl) then 

            if(dip.ne.0.)then 
               tx = sqrt((xdip/v)**2+t0**2+2*t0*xdip*sin(dip)/v) 
            else
               tx=sqrt((x/v)**2 + t0*t0)
            endif
          endif
c---------------------
c  refraction times
c---------------------
          if(refr)then
            if(dip.ne.0.) then
              v1 = v
c---------------------
c   check if refraction possible
c---------------------
           if(v2.le.v1)then
            write(LERR,*)' no head wave generated as v2 < v1'
            stop
           endif
 
              theta = asin(v1/v2)
 
           if(abs(dip-theta).lt.1.0e-10) then
             write(LERR,*)' You are asking for a calculation along'
             write(LERR,*)' the critical angle.  This routine does not'
             write(LERR,*)' handle such a beast.  If you really need'
             write(LERR,*)' to do this you need a wave equation routine'
             stop
           endif
c ----- debug -----
c              write(LOT,*)' theta = ',theta
c              write(LOT,*)' dip  = ', dip
c ----- ----- -----
              if(up) tx = (x/v1)*sin(theta-dip)+t0
              if(down) tx = (x/v1)*sin(theta+dip)+t0
            else
              tx=x/v + t0
            endif
          endif
 
          if(verbos) write(LERR,*)'Trace ',kk,' tx= ',tx

c-----------------------------------
c  interpolate spike across samples
c-----------------------------------
          tt = tx/float(nsi) + 1.000000001
          it1=tt
          it2=it1+1
          dt1=tt-it1
          dt2=it2-tt
          if(it1 .lt. 1) then
            it1=1
            dt2=dt1
          endif
          if(it2 .gt. nsamp) then
             it2=nsamp
             dt1=dt2
          endif
          call vclr(xtr,1,nsamp)
          xtr(it1)=amp*dt2
          xtr(it2)=amp*dt1

          call vmov  (xtr, 1, lhed(ITHWP1),1, nsamp)
          call wrtape(luout,itr,obytes)
c
  100 CONTINUE

      ENDIF

        call lbclos(luout)
      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for SPIKE: spike generation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-t0[t0]    -- normal incidence time (ms)     ( 0 )'
        write(LER,*)'-v[v]      -- reflection velocity (m/s; ft/s)(inf)'
        write(LER,*)'-x0[x0]    -- near offset  (ft or m)         ( 0 )'
        write(LER,*)'-gi[dx]    -- group interval'
        write(LER,*)'-ntr[ntr]  -- number of traces               ( 10)'
        write(LER,*)'-si[nsi]   -- sample interval                ( 4 )'
        write(LER,*)'-amp[amp]  -- spike amplitude                (1.0)'
        write(LER,*)'-L[ns]     -- trace length (ms)'
        write(LER,*)'-Rf        -- output is refraction event'
        write(LER,*)'-Rl        -- output is reflection hyperbola (def)'
        write(LER,*)'-Du        -- updip refraction event (default)'
        write(LER,*)'-Dd        -- downdip refraction event'
        write(LER,*)'-dip       -- dip angle of reflector/refractor'
        write(LER,*)'-v2        -- velocity below refractor'
        write(LER,*)'-F         -- generate monofreq traces:'
        write(LER,*)'-fs[fs]    -- start frequency (Hz)           (0)'
        write(LER,*)'-fe[fe]    -- end frequency (Hz)'
        write(LER,*)'-fi[fi]    -- frequency incr, 1 freq/trace   (5)'
        write(LER,*)'-rp[rp]    -- start/end trace taper (ms)    (48)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      spike -O[] -t0[] -v[] -x0[] -ntr[] -si[] '
        write(LER,*)'             -L[] -R[l,f] -D[u,d] -dip -v2'
        write(LER,*)'             [ -F -fs[] -fe[] -fi[] -rp[] -V]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(otap,t0,v,x0,dx,ntr,nsi,amp,ns,refl,refr,
     *dip,v2,up,down,verbos,freq,fst,fed,fnc,iramp)
#include <f77/iounit.h>
      character  otap*(*)
      integer    ntr, nsi, ns, argis
      real*4       t0, v, x0, dx, amp, dip, v2
      logical    verbos, refl, refr, up, down, freq

            call argstr('-O',otap,' ',' ')
            call argr4('-t0',t0,0.,0.) 
            call argr4('-v',v,0.,0.) 
            call argr4('-x0',x0,0.,0.) 
            call argr4('-gi',dx,0.,0.) 
            call argi4('-ntr',ntr,10,10)
            call argi4('-si',nsi,4,4)
            call argr4('-amp',amp,1.,1.)
            call argi4('-L',ns,4000,4000)
            refl = ( argis( '-Rl' ) .gt. 0 )
            refr = ( argis( '-Rf' ) .gt. 0 )
            if (.not.refl .AND. .not.refr) refl = .true.
            up = ( argis( '-Du' ) .gt.0 )
            down = ( argis( '-Dd' ) .gt.0 )
            call argr4('-v2',v2,0.,0.)
            call argr4('-dip',dip,0.,0.) 
            freq   = ( argis( '-F' ) .gt. 0 )

            call argr4('-fs', fst,0.,0.)
            call argr4('-fe', fed,0.,0.)
            call argr4('-fi', fnc,5.,5.)
            call argi4('-rp', iramp,48,48)

            verbos = ( argis( '-V' ) .gt. 0 )

c
c ----- check if v2 is defined if wanting refr with dip.ne.0
c
            if(refr) then
              if((dip-0.).gt.1.0e-8) then
                if((v2-0.).lt.1.0e-8) then
 
            write(LOT,*)' FATAL: you have asked for a refraction'
            write(LOT,*)'        calculation  using dip but have'
            write(LOT,*)'        not defined a lower velocity'
            write(LOT,*)' '
            write(LOT,*)'        Rerun with a -v2 entry on the ' 
            write(LOT,*)'        command line.'

                  stop
                endif
              endif
            endif

c
c ----- convert dip to radians -----
c

           dip = 3.1415926535 * dip/180.

c
c ----- make updip the default refraction calculation -----
c
            if(up) return
            if(down) return
            up = .true.

      return
      end
