C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------spike3d----------------------------------------
c
c spike3d generates a spikes at arrival time locations based on one of
c 4 simple model situations, a plane, cone, hyperboloid or point 
c diffractor.
c
c Author P.G.A. Garossino:Amoco Production Research:August,94
c
c Changes:
c
c April 11, 2003 - Garossino
c
c   Added -D, -offset[] -z0[] to allow for the point diffractor option
c   requested by Bill McLain.  This option positions a diffractor at
c   -x0[],-y0[],-z0[] and uses a source-receiver positioning dictated by
c   -offset[] and -azim[].  I also fixed several bugs that caused 
c   problems with model iterations.
c
c
C***********************************************************************

      implicit none

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     itr(2 * SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luout, lbytes, nbytes, obytes, luin, lbyout
      integer     argis, ist, iend, irs, ire, ns, ne, JJ, KK
      integer     lutty, ludsk, jerr

      real        tri(2 * SZLNHD)

      character   name*7, otap*255, ntap*255

      logical     verbos

c program variables defined with static memory allocation

      integer     StaCor, fmt_StaCor, l_StaCor, ln_StaCor
      integer     DstSgn, fmt_DstSgn, l_DstSgn, ln_DstSgn
      integer     DstUsg, fmt_DstUsg, l_DstUsg, ln_DstUsg
      integer     RecNum, fmt_RecNum, l_RecNum, ln_RecNum
      integer     TrcNum, fmt_TrcNum, l_TrcNum, ln_TrcNum
      integer     LinInd, fmt_LinInd, l_LinInd, ln_LinInd
      integer     DphInd, fmt_DphInd, l_DphInd, ln_DphInd
      integer     CDPBCX, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer     CDPBCY, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer     RcPtXC, fmt_RcPtXC, l_RcPtXC, ln_RcPtXC
      integer     RcPtYC, fmt_RcPtYC, l_RcPtYC, ln_RcPtYC
      integer     SrPtXC, fmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer     SrPtYC, fmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer     SrRcAz, fmt_SrRcAz, l_SrRcAz, ln_SrRcAz
      integer     dT, Tmax 
      integer     it1, it2

      real    dX, dY, Xmax, Xmin, Ymax, Ymin, X0, Y0, Z0, T0
      real    Azimuth, Dip, MaxModelRadius, velocity, Amplitude
      real    tr, tt, dt1, dt2, offset, Rs_r
      real    UnitSc_old, X, Y, R, UnitSc_user
      real    shotX, receiverX, shotY, receiverY
      real    half_offset, theta, degrad, sin_theta, cos_theta
      real    pi, half_offset_sin_theta, half_offset_cos_theta

      logical Plane, Cone, Hyperboloid, Point_Diffractor, pipe

c initialize variables 

      data name/'SPIKE3D'/
      data lbytes/0/
      data iform/3/
      data Plane/.false./
      data Cone/.false./
      data Hyperboloid/.false./

      pi = 4. * atan(1.0)
      degrad = pi / 180.

c get online help if necessary 

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
           call help ()
           stop
      endif

c open printout files 

#include <f77/open.h>

c get command line parameters 

      call cmdln ( ntap, dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, Point_Diffractor, Z0, 
     :     offset, UnitSc_user, verbos )

c open input 

      call getln ( luin, ntap, 'r', 0 )

c ludsk and lutty below are from lib ut.

      if ( ludsk ( luin ) .eq. 0 ) then

c check to see if input is a pipe

         if ( lutty ( luin ) .eq. 1 ) then

c check to see if pipe is connected to the terminal.  If it is not
c then this is the initial model run

            pipe = .false.
         else

c otherwise pipe is connected to stdin and am expecting data

            pipe = .true.
         endif
      else

c input is not a pipe therefore must be a disk file 

         pipe = .false.
      endif

c open output 

      call getln ( luout, otap, 'w', 1 )

c define USP volume descriptors in terms of input parameters

c records

      irs = 1 
      ire = nint( ( Ymax - Ymin ) / dY ) + 1
      nrec = ire - irs + 1

c traces

      ns = 1
      ne = nint( ( Xmax - Xmin ) / dX ) + 1
      ntrc = ne - ns + 1

c samples : [first sample is time zero]

      ist = 1
      iend = nint( float(Tmax) / float(dT) ) + 1
      nsi = dT
      nsamp = iend - ist + 1

      if ( nsamp .gt. ( 2 * SZLNHD ) ) nsamp = ( 2 * SZLNHD ) - ITRWRD

c Policemen:

      if ( .not. Plane .and. 
     :     .not. Cone .and. 
     :     .not. Hyperboloid .and. 
     :     .not. Point_Diffractor ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: must specify type of surface to '
         write(LERR,*)'          generate.  Use one of -P -H -C -D'
         write(LERR,*)'          on the command line and resubmit'
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' SPIKE3D: must specify type of surface to '
         write(LER,*)'          generate.  Use one of -P -H -C -D'
         write(LER,*)'          on the command line and resubmit'
         write(LER,*)' FATAL'       
         write(LER,*)' '
         stop
      endif

      if ( X0 .lt. Xmin .or. X0 .gt. Xmax ) then 

         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: X origin ',X0,' is outside volume'
         write(LERR,*)'          Check -x0 parameter and resubmit'
         write(LERR,*)' '

         if ( .not. Point_Diffractor ) then
            write(LERR,*)' FATAL'    
         else
            write(LERR,*)' WARNING'   
         endif 

         write(LERR,*)' '
   
         write(LER,*)' SPIKE3D: X origin ',X0,' is outside volume'
         write(LER,*)'          Check -x0 parameter and resubmit'
         write(LER,*)' '

         if ( .not. Point_Diffractor ) then
            write(LER,*)' FATAL'    
            write(LER,*)' '
            goto 999
         else
            write(LER,*)' WARNING'   
         endif 

         write(LER,*)' '

      endif

      if ( Y0 .lt. Ymin .or. Y0 .gt. Ymax ) then 
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Y origin ',Y0,' is outside volume'
         write(LERR,*)'          Check -y0 parameter and resubmit'
         write(LERR,*)' '

         if ( .not. Point_Diffractor ) then
            write(LERR,*)' FATAL'       
         else
            write(LERR,*)' WARNING'   
         endif 

         write(LERR,*)' '

         write(LER,*)' SPIKE3D: Y origin ',Y0,' is outside volume'
         write(LER,*)'          Check -y0 parameter and resubmit'
         write(LER,*)' '

         if ( .not. Point_Diffractor ) then
            write(LER,*)' FATAL'    
            write(LER,*)' '
            goto 999
         else
            write(LER,*)' WARNING'   
         endif 

         write(LER,*)' '

      endif

      if ( T0 .lt. 0.0 .or. T0 .gt. float(Tmax) ) then 
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: T origin ',T0,' is outside volume'
         write(LERR,*)'          Check -t0 parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D: T origin ',T0,' is outside volume'
         write(LER,*)'          Check -t0 parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
         goto 999
      endif

      if ( abs ( Dip ) .gt. 90.0 ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Dip greater than 90.0 degrees.'
         write(LERR,*)'          Check -dip parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D:  Dip greater than 90.0 degrees.'
         write(LERR,*)'          Check -dip parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
         goto 999
      endif

      if ( Dip .lt. 0.0 ) Dip = abs(Dip)

      if ( Azimuth .lt. 0.0 .or. Azimuth .gt. 360 ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Azimuth chosen is outside range'
         write(LERR,*)'          of zero to 360 degrees.  Check '
         write(LERR,*)'          -azim parameter and resubmit'
         write(LERR,*)' FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' SPIKE3D: Azimuth chosen is outside range'
         write(LER,*)'          of zero to 360 degrees.  Check '
         write(LER,*)'          -azim parameter and resubmit'
         write(LER,*)' FATAL'
         write(LER,*)' '
         goto 999
      endif

      call verbal (dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, nrec, ntrc, 
     :     nsamp, Point_Diffractor, Z0, offset, UnitSc_user, 
     :     pipe, ntap )


      if ( ntap .ne. ' ' .or. pipe ) then

c The user has either piped into this routine with a previous model or
c installed one on the command line with -N.  In either case read the input 
c line header.

         call rtape ( luin, itr, lbytes )
         if(lbytes .eq. 0) then
            write(LERR,*)'SPIKE3D: no line header read on ',ntap
            write(LERR,*)'FATAL'
            write(LERR,*)'Check existence of file & rerun'
            goto 999
         endif
      
c print previous historical line header to printout file

         call hlhprt ( itr , lbytes, name, 7, LERR )

c recover global parameters and compare against the current model
c description.  If the volumes are not congruent in every way then
c warn the user and stop the execution

         call saver(itr, 'NumSmp', nsamp , LINHED)
         call saver(itr, 'SmpInt', nsi   , LINHED)
         call saver(itr, 'NumTrc', ntrc  , LINHED)
         call saver(itr, 'NumRec', nrec  , LINHED)
         call saver(itr, 'Format', iform , LINHED)
         call saver(itr, 'UnitSc', UnitSc_old, LINHED)

         if ( UnitSc_old .ne. UnitSc_user ) then
            write(LERR,*)' '
            write(LERR,*)'SPIKE3D: The time units in your input model '
            write(LERR,*)'         do not match those requested on the'
            write(LERR,*)'         command line. The input line header'
            write(LERR,*)'         value of UnitSc is ',UnitSc_old
            write(LERR,*)'         You requested ',UnitSc_user,' for'
            write(LERR,*)'         this execution.  Fix one or the'
            write(LERR,*)'         other and try again'
            write(LERR,*)'FATAL'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'SPIKE3D: The time units in your input model '
            write(LER,*)'         do not match those requested on the'
            write(LER,*)'         command line. The input line header'
            write(LER,*)'         value of UnitSc is ',UnitSc_old
            write(LER,*)'         You requested ',UnitSc_user,' for'
            write(LER,*)'         this execution.  Fix one or the'
            write(LER,*)'         other and try again'
            write(LER,*)'FATAL'
            write(LER,*)' '
            goto 999
         endif

         if ( (nint(( Xmax - Xmin ) / dX )+1) .ne. ntrc  .or.
     :        (nint(( Ymax - Ymin ) / dY )+1) .ne. nrec .or.
     :        (nint( float(Tmax) / float(dT) ) + 1) .ne. nsamp ) then

            write(LERR,*)' '
            write(LERR,*)'SPIKE3D: ntrc, nrec or nsamp of input '
            write(LERR,*)'         dataset not compatible with  '
            write(LERR,*)'         command line entries'
            write(LERR,*)' FATAL'
            write(LER,*)' '
            write(LER,*)'SPIKE3D: ntrc, nrec or nsamp of input '
            write(LER,*)'         dataset not compatible with  '
            write(LER,*)'         command line entries'
            write(LER,*)' FATAL'
            goto 999
         endif
         
      endif

c handle velocity units according to the units of the model

      Velocity = Velocity * UnitSc_user

c convert Azimuth and Dip to radians if doing anything but 
c point diffractor.  If -D then we need to use the Azimuth
c in degrees to determine which quadrant the source and 
c receiver are located in

      if ( .not. Point_Diffractor ) Azimuth = Azimuth * degrad
      Dip = Dip * degrad

c define number of output bytes

      obytes = SZTRHD + SZSMPD * nsamp

c create an output line header if creating a new volume

       if ( ntap .eq. ' ' .and. .not. pipe ) then

          call vclr ( itr, 1, 2*SZLNHD)
          call savew( itr, 'NumTrc', ntrc  , LINHED)
          call savew( itr, 'NumRec', nrec  , LINHED)
          call savew( itr, 'SmpInt',  nsi  , LINHED)
          call savew( itr, 'NumSmp', nsamp , LINHED)
          call savew( itr, 'Format', iform , LINHED)
          call savew( itr, 'UnitSc', UnitSc_user, LINHED)
          lbytes = HSTOFF
          nbytes = 2 * SZHFWD

          call savew( itr, 'HlhEnt',  0   , LINHED)
          call savew( itr, 'HlhByt', nbytes , LINHED)
       endif

c save current command line stuff in hlh

       call savhlh( itr, lbytes, lbyout )

c write output line header

       call wrtape ( luout, itr, lbyout )

       if ( ntap .eq. ' ' .and. .not. pipe ) then

c if we are building a new model we don't want to carry line header
c entries into the trace header so clear the buffer again

          call vclr ( itr, 1, 2*SZLNHD)

       endif

c get pointers to required trace header mnemonics

      call savelu('TrcNum',fmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',fmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('LinInd',fmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',fmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',fmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',fmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',fmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('CDPBCX',fmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',fmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('RcPtXC',fmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',fmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrPtXC',fmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',fmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SrRcAz',fmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
       
c if this is not a point diffractor run then the source is located
c at X0,Y0 which only needs to be defined once and can be loaded
c to the trace header now.  If the run is a point diffractor pass then
c the source and receiver coordinates will be calculated inside the 
c appropriate loop below

      if ( .not. Point_Diffractor ) then
         SrPtXC = nint(X0)
         call savew2( itr, fmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC, 
     :        TRACEHEADER )
         SrPtYC = nint(Y0)
         call savew2( itr, fmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC, 
     :        TRACEHEADER )

      else

c precalculate project parameters

         half_offset = offset / 2.0
         theta = Azimuth * degrad
         SrRcAz = nint(Azimuth)

         if ( Azimuth .gt. 0. .and. Azimuth .lt. 90 ) then
            sin_theta = sin ( theta )
            cos_theta = cos ( theta )
         elseif ( Azimuth .gt. 90 .and. Azimuth .lt. 180 ) then
            sin_theta = sin ( pi - theta )
            cos_theta = cos ( pi - theta )
         elseif ( Azimuth .gt. 180 .and. Azimuth .lt. 270 ) then
            sin_theta = sin ( theta - pi )
            cos_theta = cos ( theta - pi )
         elseif ( Azimuth .gt. 270 .and. Azimuth .lt. 360 ) then
            sin_theta = sin ( 2. * pi - theta )
            cos_theta = cos ( 2. * pi - theta )
         endif

         half_offset_sin_theta = half_offset * sin_theta
         half_offset_cos_theta = half_offset * cos_theta
            
      endif

c calculate the model for these parameters

      DO JJ = irs, ire

c the trace is considered a CDP, the Y coordinate is associated with 
c the line [record] position 

         Y = Ymin + float(JJ - 1) * dY

         if ( Point_Diffractor ) then

c Determine the shot and receiver Y coordinate

            if ( Azimuth .eq. 0.0 .or. Azimuth .eq. 180.0 ) then

               shotY = Y
               receiverY = Y

            elseif( Azimuth .gt. 0.0 .and. 
     :              Azimuth .lt. 180.0 .and. 
     :              Azimuth .ne. 90.0 ) then

               shotY = Y - half_offset_sin_theta
               receiverY = Y + half_offset_sin_theta

            elseif ( Azimuth .eq. 90.0 ) then

               shotY = Y - half_offset
               receiverY = Y + half_offset

            elseif( Azimuth .gt. 180.0 .and. 
     :              Azimuth .lt. 360.0 .and. 
     :              Azimuth .ne. 270.0 ) then
               
               shotY = Y + half_offset_sin_theta
               receiverY = Y - half_offset_sin_theta

            elseif ( Azimuth .eq. 270.0 ) then

               shotY = Y + half_offset
               receiverY = Y - half_offset
               
            endif

c take into account the source -receiver azimuth

            SrPtYC = nint(shotY)
            RcPtYC = nint(receiverY)

            call savew2( itr, fmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC, 
     :           TRACEHEADER )
            call savew2( itr, fmt_RcPtYC, l_RcPtYC, ln_RcPtYC, RcPtYC, 
     :           TRACEHEADER )

         endif

         if ( ntap .eq. ' ' .and. .not. pipe ) then

c this is a new model so calculate CDP Y coordinate and flush out trace
c header entries as required

            CDPBCY = nint(Y)
            RecNum = JJ
            LinInd = JJ

            call savew2( itr, fmt_LinInd, l_LinInd, ln_LinInd, LinInd, 
     :           TRACEHEADER )
            call savew2( itr, fmt_RecNum, l_RecNum, ln_RecNum, RecNum, 
     :           TRACEHEADER )
            call savew2( itr, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY, 
     :           TRACEHEADER )

         endif

         DO KK = ns, ne

            X =  Xmin + float(KK - 1) * dX
            R = sqrt( (X - X0)**2 + (Y - Y0)**2 )

            if ( Point_Diffractor ) then

c distance covered is distance from shot to diffractor plus distance
c from diffractor to receiver.  In this case the shot and receiver
c are always offset along the line so that both the shot and receiver
c X coordinate is that of the line.  The shot and receiver Y coordinate 
c is a function of the source - receiver offset requested on the command line.
c Both the source and receiver are located on the surface so their Z coordinate
c is zero.  The diffractor is located at X0,Y0,Z0 as specified on the 
c command line

               
c Determine the shot and receiver X coordinate

               if ( Azimuth .eq. 0.0 ) then

                  shotX = X + half_offset
                  receiverX = X - half_offset
                  
               elseif ( Azimuth .eq. 90.0 .or. Azimuth .eq. 270.0 ) then

                  shotX = X
                  receiverX = X

               elseif ( Azimuth .eq. 180.0 ) then

                  shotX = X - half_offset
                  receiverX = X + half_offset

               elseif (( Azimuth .gt. 0.0 .and. Azimuth .lt. 90.0 ) .or.
     :             ( Azimuth .gt. 270.0 .and. Azimuth .lt. 360.0 )) then

                  shotX = X + half_offset_cos_theta
                  receiverX = X - half_offset_cos_theta

               elseif(( Azimuth .gt. 90.0 .and. Azimuth .lt. 180.0 ).or.
     :             ( Azimuth .gt. 180.0 .and. Azimuth .lt. 270.0 )) then

                  shotX = X - half_offset_cos_theta
                  receiverX = X + half_offset_cos_theta

               endif

               Rs_r = sqrt( (shotX-X0)**2 + (shotY-Y0)**2 + Z0**2 ) +
     :            sqrt( (receiverX-X0)**2 + (receiverY-Y0)**2 + Z0**2 )

               SrPtXC = nint(shotX)
               RcPtXC = nint(receiverX)

              call savew2( itr, fmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC, 
     :              TRACEHEADER )
              call savew2( itr, fmt_RcPtXC, l_RcPtXC, ln_RcPtXC, RcPtXC, 
     :              TRACEHEADER )
              call savew2( itr, fmt_SrRcAz, l_SrRcAz, ln_SrRcAz, SrRcAz, 
     :              TRACEHEADER )

            endif

            if ( ntap .ne. ' ' .or. pipe ) then

c this is NOT a new model, we are adding a surface to a pre-existing
c model so read the trace which will already have trace header entries
c in place

               nbytes = 0
               call rtape ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif
               call vmov ( itr(ITHWP1), 1, tri(1), 1, nsamp )

            endif

            if ( ntap .eq. ' ' .and. .not. pipe ) then

c this is a new model, clear the trace and flush out trace header entries

               call vclr(tri,1,nsamp)

               CDPBCX = nint(X)
               DstSgn = nint(R)
               DstUsg = iabs(DstSgn)
               DphInd = KK
               TrcNum = KK
               StaCor = 0

              call savew2( itr, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DstUsg, l_DstUsg, ln_DstUsg, DstUsg, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DphInd, l_DphInd, ln_DphInd, DphInd, 
     :              TRACEHEADER )
              call savew2( itr, fmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum, 
     :              TRACEHEADER )
              call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :              TRACEHEADER )
            endif

            IF ( R .le. MaxModelRadius ) then

               if ( Plane ) then
                  
                  tr = T0  + 
     :                 ( (X - X0) * cos(Azimuth) + 
     :                 (Y - Y0) * sin(Azimuth) ) * 
     :                 tan(Dip) / Velocity

               elseif ( Cone ) then

                  tr = T0 + R * tan(Dip) / Velocity

               elseif ( Hyperboloid ) then

                  tr = sqrt( T0**2 + R**2 /Velocity**2 )

               elseif ( Point_Diffractor ) then

c The total distance from the shot to the point diffractor back to the receiver
c is Rs_r [calculated above].  This can be from a point outside the bounds of the
c model but the data will be registered in at the CDP only if the distance from the
c point to the CDP as projected along the surface [R calculated above] is within the 
c range specified by the user on the command line.

                  tr = Rs_r / Velocity

               endif

c interpolate spike across samples: ripped off from spike.F

               if ( abs(tr) .ge. 0.0 .and. abs(tr) .lt. Tmax ) then

                  tt = tr / float(nsi) + 1.000000001
                  it1 = tt
                  it2 = it1 + 1
                  dt1 = tt - it1
                  dt2 = it2 - tt
               
                  if ( it1 .lt. 1 ) then
                     it1 = 1
                     dt2 = dt1
                  endif

                  if ( it2 .gt. nsamp ) then
                     it2 = nsamp
                     dt1 = dt2
                  endif

                  tri(it1) = Amplitude * dt2
                  tri(it2) = Amplitude * dt1

               elseif ( ntap .eq. ' ' .and. .not. pipe ) then
                  StaCor = 30000
                  call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor,  
     :                 StaCor, TRACEHEADER )
               endif

            ELSEIF ( ntap .eq. ' ' .and. .not. pipe ) then

               call vclr(tri,1,nsamp)
               StaCor = 30000
               call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor,  
     :              StaCor, TRACEHEADER )

           ENDIF

c write out trace 

            call vmov ( tri, 1, itr(ITHWP1),1, nsamp)
            call wrtape( luout, itr, obytes )

         ENDDO

      ENDDO

      if ( ntap .ne. ' ' .or. pipe ) call lbclos (luin )
      call lbclos(luout)

      write(LERR,*)'processed ',nrec,' record(s) with ',ntrc,' traces'
      write(LERR,*)'Normal Termination'
      write(LER,*)'spike3d: Normal Termination'
      stop

 999  continue

      write(LERR,*)'Abnormal Termination'
      write(LER,*)'spike3d: Abnormal Termination'

      stop
      end

