C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, nrec, ntrc, 
     :     nsamp, Point_Diffractor, Z0, offset, UnitSc_user, 
     :     pipe, ntap )

#include <f77/iounit.h>

      integer dT, Tmax, nrec, ntrc, nsamp, length

      real    dX, dY, Xmax, Xmin, Ymax, Ymin, X0, Y0, Z0, offset
      real    Azimuth, Dip, MaxModelRadius, Velocity, Amplitude
      real    UnitSc_user

      character otap*(*), ntap*(*)
      
      logical   Plane, Cone, Hyperboloid, Point_Diffractor, pipe

      write(LERR,*)' '
      write(LERR,*)' <<<<<<<< Spike 3D Parameters >>>>>>>>>'
      write(LERR,*)' '

      if ( ntap .ne. ' ' ) then
         length = lenth(ntap)
         write(LERR,*)' Input File Name:  ', ntap(1:length)
         write(LERR,*)' '
      endif

      if ( pipe ) then
         write(LERR,*)' Input File is on a pipe'
         write(LERR,*)' '
      endif
         
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*)' Output File Name:  ', otap(1:length)
      else
        write(LERR,*)' Output File:       stdout'
      endif

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Volume Parameters'
      write(LERR,*)' '
      write(LERR,*)' Maximum X co-ordinate  = ', Xmax
      write(LERR,*)' Maximum Y co-ordinate  = ', Ymax
      write(LERR,*)' Minimum X co-ordinate  = ', Xmin
      write(LERR,*)' Minimum Y co-ordinate  = ', Ymin
      write(LERR,*)' Maximum Time           = ', Tmax
      write(LERR,*)' X increment            = ', dX
      write(LERR,*)' Y increment            = ', dY
      write(LERR,*)' T increment            = ', dT
      write(LERR,*)' T scalar               = ', UnitSc_user
      write(LERR,*)' Number Inline Traces   = ', ntrc
      write(LERR,*)' Number X-Line Traces   = ', nrec
      write(LERR,*)' Number of Samples      = ', nsamp
      write(LERR,*)' '
      write(LERR,*)' Source Location Parameters  '
      write(LERR,*)' '
      write(LERR,*)' X origin               = ', X0
      write(LERR,*)' Y origin               = ', Y0
      write(LERR,*)' '
      write(LERR,*)' Model Surface Parameters  '
      write(LERR,*)' '
      if ( Plane ) then
         write(LERR,*)' Surface is Planar '
         write(LERR,*)' Surface Dip [deg]      = ', Dip
         write(LERR,*)' Surface Azimuth [deg]  = ', Azimuth
         write(LERR,*)' Time  origin           = ', T0
      elseif ( Cone ) then
         write(LERR,*)' Surface is Conical '
         write(LERR,*)' Surface Dip [deg]      = ', Dip
         write(LERR,*)' Time  origin           = ', T0
      elseif ( Hyperboloid ) then
         write(LERR,*)' Surface is Hyperboloid '
         write(LERR,*)' Time  origin           = ', T0
      elseif ( Point_Diffractor ) then
         write(LERR,*)' Point Diffractor located at:'
         write(LERR,*)' x0 = ',X0,' Y0 = ',Y0,' Z0 = ',Z0
         write(LERR,*)' '
         write(LERR,*)' Source - Reciever offset = ',offset
         write(LERR,*)' Source - Reciever azimuth = ',Azimuth
         write(LERR,*)' '
      endif

      write(LERR,*)' Model velocity    = ', Velocity
      write(LERR,*)' Spike Amplitude        = ', Amplitude
      write(LERR,*)' Maximum Surface Radius = ', MaxModelRadius
      write(LERR,*)' '
      write(LERR,*)'<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>'

      return
      end
