C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     SUBROUTINE - DOSTAK            ENTRY POINT - DOSTAK        
C                                                               
C     LANGUAGE - FORTRAN 77                                    
C     SYSTEM(S) - SUN, CRAY2                                         
C     AUTHOR - Richard Crider                                
C     DATE WRITTEN - January 28, 1991
C                                                          
C                AMOCO PRODUCTION CO. PROPRIETARY
C                 TO BE MAINTAINED IN CONFIDENCE
C                                                        
C     ABSTRACT - Do angle stacking as a function of velocity and
C                offset.
C                                                            
C     USAGE                                                 
C                                                          
C          CALL DOSTAK(NS,VCOEF, DATA, ANGLES, STAK, DX,
C                       ANGMN, ANGMX, NANG, ntr, dt, LIVEBF,
C                       TIMVEC, VRMS, mode emerg,vtmax,
C                       ierr, errparms,vsrms,vism,vit,langle,hangle)
C                                                       
C               NS    =  NUMBER OF SAMPLES PER TRACE.              
C            VCOEF    =  RMS VELOCITY COEFFICIENTS
C              DATA   =  TRACE DATA
C             ANGLES  =  Returned ANGLES MATRIX
C              STAK   =  Returned angle staks
C              DX     =  TRACE DISTANCES
C            ANGMN    =  MINIMUM ANGLE VECTOR
C            ANGMX    =  MAXIMUM ANGLE VECTOR
C             NANG    =  NUMBER OF ANGLE STACKS
C              NTR    =  NUMBER OF TRACES PER RECORD
C             dt      =  sample interval, in seconds.
C          LIVEBF     =  counter buffer for live samples in each stak.
C           TIMVEC    =  Vector containing time (in sec) for each
C                        sample.
C            VRMS     =  RMS Velocity vector, 1 value for each
C                        sample.
C            MODE     =  Solution type
C                        0 = Straight Ray
C                        1 = Curved Ray
C                        2 = Perturbed Curved Ray
C           EMERG     =  Angle type   
C                        0 = Incident     
C                        1 = Emergence 
C            VTMAX    =  Valid last time for velocity vector  
C             IERR    =  Error flag to be returned by crvray(creray)
C          ERRPARMS   =  V2,V1,T2,T1, error time for error r  
C                        returned by crvray(creray)     
C            vsrms    =  Smoothed rms function
C            vism     =  Smooth interval velocities
C             vit     =  Inteval velocities from vrms
C            langle   =  array of true minimun angles
C            hangle   =  array of true maximun angles
C                                                      
C     ERROR/RETURN CODES - ierr                 
C                          1 = error in crvray 
C                                              
C***************************************************************
      SUBROUTINE dostak(NS,VCOEF, DATA, ANGLES, STAK, DX, trhd,
     *  ANGMN, ANGMX, NANG, NTR, DT, livebf, iws, iwe,timvec,
     *  vrms, mode,emerg,vtmax,ierr,errparms,vsrms,vism,vit,
     *  langle, hangle)
C                                                            
C       DATA DECLARATIONS                                   
      REAL DATA(*), STAK(*), ANGLES(*), vcoef(*)
      real timvec(*), vrms(*),vsrms(*),vism(*),vit(*)
      real  dx(*),livebf(*),errparms(*)
      real  langle(*), hangle(*)
      integer trhd(*),emerg,ierr
C
      real ANGMN(*), ANGMX(*)
C
      do i=1,ntr
       if(dx(i).eq.0.0)dx(i)=0.0005
      end do
      const = 57.295
      lwin = iwe - iws + 1
      if(lwin.gt.ns)lwin = ns
      if (iwe.gt.ns)iwe = ns
      if(iws.lt.1)iws = 1
      if(emerg.eq.0)then
c +=================================================+
c |  crvray and creray build the "angles" matrix    |
c +=================================================+
       call crvray(ntr,angles,timvec,dx,vrms,vcoef,
     : dt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
       if(ierr.ne.0)return
      else
       call creray(ntr,angles,timvec,dx,vrms,vcoef,
     : dt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
       if(ierr.ne.0)return
      endif
c +==================================================+
c |  Following loops perform the "binning" operation |
c |  Loops take a value of ang and compare it to min |
c |  and max values for each of the nang possible    |
c |  values and sums a data value corresponding to   |
c |  the angle value into a summation buffer.        |
c +==================================================+
      do 199 j=iws,iwe
		n=j-iws+1
		hangle(j) = -1.0
		langle(j) = -1.0
  199 continue

      do 200 i=1,ntr
      indx1 = (i-1)*ns
       do 200 k = 1,nang
       indx2 = (k-1)*ns
       do 200 j=iws,iwe
         iaddr = indx1 + j
         iaddr2 = indx2 + j
	    n=j-iws+1
          if(i.eq.1)stak(iaddr2)=0.0           
           if(data(iaddr).ne.0.0)then

            if((angles(iaddr).ge.angmn(k)).and.
     &           (angles(iaddr).lt.angmx(k)))then
			if(k.eq.1.and.i.eq.1) then
				langle(n) = angles(iaddr)
			end if
			if(k.eq.nang.and.i.eq.ntr) then
				hangle(n) = angles(iaddr)
			endif
               stak(iaddr2) = (stak(iaddr2) * livebf(iaddr2) + 
     :                      data(iaddr))
               livebf(iaddr2) = livebf(iaddr2)+1.
              	stak(iaddr2) = stak(iaddr2) / livebf(iaddr2)
           endif
          endif
200      continue           
      return
      end
