C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#ifdef DISCO
       SUBROUTINE getvel(iri, JR, TT, C, NC, nsamp, dt, coefs,
     * sig,ch,vtrms,nsets,vtmax,fit,vsrms,vism, vi, vscale)
#else
       SUBROUTINE getvel(iri, JR, TT, C, NC, nsamp, dt, coefs,
     * sig,ch,vtrms,nsets,vtmax,fit,npol,vsrms,vism, vi, vscale)
#endif
C ******************************************************************** C
C *   Subroutine to find the velocity function closest to the        * C
C *   current cdp and compute the coefficients.  If the coefficients * C
C *   are "current", it simply returns the coefficients              * C
C *                                                                  * C
C *   INPUT:                                                         * C
C *                                                                  * C
C *     iri    - I*4   -  Current RI #                               * C
C *      JR    - I*4() -  Vector of RI #'s for velocity functions    * C
C *      TT    - R*4() -  Matrix of times for vf's, in secs          * C
C *       C    - R*4() -  Matrix of velocitis                        * C
C *      NC    - I*4() -  Vector of #pts in each vf                  * C
C *   nsamp    - I*4   -  Trace length for vf expansion/interpolation* C
C *     dt     - R*4   -  Sample interval in sec.                    * C
C *    sig     - R*4() -  Individual standard deviations             * C
C *     ch     - R*4   -  chisqr constant for polyfit routine        * C
C *   nsets    - I*4   -  number of velocity functions               * C
C *   vscale   - I*4   -  multiplier on rms velocitys                * C
C *                                                                  * C
C *   OUTPUT :                                                       * C
C *                                                                  * C
C *   vtrms    - R*4() -  Trace-length rms velocity  vector          * C
C *   coefs    - R*4() -  RMS Velocity coefficients                  * C
C *                                                                  * C
C ******************************************************************** C
#ifndef CRAY
       parameter (ISZBYT=4)
#else
       parameter (ISZBYT=8)
#endif
#ifdef DISCO
      parameter (npol = 6)
      real tt(*), c(*),coefs(*),sig(*)
      integer compoff
#else
      real tt(63,70), c(63,70),coefs(*),sig(*)
#endif
      real vtrms(*)
      real work1(3500), work2(3500),work3(3000),time(3500)
      real wt(1000), wv(1000),w1(1), w2(1),w3(1)
      real holdt(6001), vsrms(*),vism(*),vi(*)
      real work4(1), work5(1)
      real vscale
      POINTER (pw1,w1),(pw2,w2),(pw3,w3)
      POINTER (pw4,work4),(pw5,work5)
      INTEGER  JR(*), NC(*)
      integer nsets
      REAL CH
      logical fit, ok
      external fpoly,hsort
C
#ifdef DISCO
      iget = nsamp*ISZBYT
      pw4 = malloc(iget)
      pw5 = malloc(iget)
      iget = npol*nsamp*ISZBYT
      pw1= malloc(iget)
      pw2= malloc(iget)
      pw3= malloc(iget)
#else
      jerr = 0
      jabort = 0
      iget = nsamp*ISZBYT
      call galloc(pw4,iget,jerr,jabort)
      call galloc(pw5,iget,jerr,jabort)
      iget= npol*nsamp*ISZBYT
      call galloc(pw1,iget,jerr,jabort)
      call galloc(pw2,iget,jerr,jabort)
      call galloc(pw3,iget,jerr,jabort)
#endif
      tmax = (nsamp-1)*dt
      lclr = npol*nsamp
      do i = 1,nsamp
         time(i) = float(i-1)*dt
      end do
      if(nsets.eq.0)then
        do I=1,70
           if(nc(i).ne.0)  nsets = nsets + 1
        end do
      endif
      if(nsets.eq.0)then
       do i=1,npol
        coefs(i)=0.
       end do
       do i=1,nsamp
        vtrms(i)=0.
        vism(i)=0.
        vi(i)=0.
       end do
#ifdef DISCO
       call free(pw1)
       call free(pw2)
       call free(pw3)
       call free(pw4)
       call free(pw5)
#else
       call gfree(pw1)
       call gfree(pw2)
       call gfree(pw3)
       call gfree(pw4)
       call gfree(pw5)
#endif
       return
      endif
      do ii=1,1000
        wt(ii)=0.
        wv(ii)=0.
      end do
      if(nsets.eq.1)then
       j=nc(1)
#ifdef DISCO
       m=0
       if(k.gt.1)m=compoff(k,nc)
       do ii=1,j
        wt(ii)=tt(m+ii)
        wv(ii)=c(m+ii) * vscale
       end do
#else
       do ii=1,j
        wt(ii)=tt(ii,1)
        wv(ii)=c(ii,1) * vscale
       end do
#endif
*      if(wt(1).lt.dt)call add_first(wt,wv,nc(1),j,dt)
       if(wt(1).gt.dt)call add_first(wt,wv,nc(1),j,dt)
       if(wt(j).lt.tmax)then
        call add_last(wt,wv,j,k,tmax)
        j=k
       end if
       do i=1,lclr
        w1(i)=0.
        w2(i)=0.
        w3(i)=0.
       end do
       do i=1,npol
        coefs(i)=0.
       end do
       ch =0.
       call brms(wt,wv,j,nsamp,dt,vtrms)
       if(fit)then
        jl = j
        call infill(wt,wv,work4,work5,jl,jj)
*       call svdfit(wt,wv,sig,j,coefs,npol,w1,w2,w3,j,npol,
        call svdfit(work4,work5,sig,j,coefs,npol,w1,w2,w3,j,npol,
     :  ch,fpoly)
        call polev(time,nsamp,coefs,npol,vsrms)
        call rmsint(vsrms,time,nsamp,tmax,vism)
        call rmsint(vtrms,time,nsamp,tmax,vi)
       endif
#ifdef DISCO
       call free(pw1)
       call free(pw2)
       call free(pw3)
       call free(pw4)
       call free(pw5)
#else
       call gfree(pw1)
       call gfree(pw2)
       call gfree(pw3)
       call gfree(pw4)
       call gfree(pw5)
#endif
       return
      endif
C +====================================+
C | Handle the case where iri lies     |
C | before or on ri for first function |
C | or on/after ri for last function   |
C +====================================+
      if(iri.le.jr(1).or.iri.ge.jr(nsets))then
       k = 1
       if(iri.ge.jr(nsets))k = nsets
       j = nc(k)
       do ii=1,1000
        wt(ii)=0.
        wv(ii)=0.
       end do
#ifdef DISCO
       m=0
       if(k.gt.1)m=compoff(k,nc)
       do ii=1,j
        wt(ii)=tt(m+ii)
        wv(ii)=c(m+ii) * vscale
       end do
#else
       do ii=1,j
        wt(ii)=tt(ii,k)
        wv(ii)=c(ii,k) * vscale
       end do
#endif
       if(wt(1).gt.dt)call add_first(wt,wv,nc(1),j,dt)
       if(wt(j).lt.tmax.and.j.ge.2)then
        call add_last(wt,wv,j,k,tmax)
        j=k
       end if
       vtmax = tmax
       do ii=1,lclr
        w1(ii)=0.
        w2(ii)=0.
        w3(ii)=0.
       end do
       do ii=1,npol
        coefs(ii)=0.
       end do
       call brms(wt,wv,j,nsamp,dt,vtrms)
       if(fit)then
        jl = j
        call infill(wt,wv,work4,work5,jl,j)
*       call svdfit(wt,wv,sig,j,coefs,
*    :      npol, w1, w2,w3,j,npol,CH,fpoly)
        call svdfit(work4,work5,sig,j,coefs,
     :      npol, w1, w2,w3,j,npol,CH,fpoly)
        call polev(time,nsamp,coefs,npol,vsrms)
        call rmsint(vsrms,time,nsamp,vtmax,vism)
        call rmsint(vtrms,time,nsamp,vtmax,vi)
       endif
#ifdef DISCO
       call free(pw1)
       call free(pw2)
       call free(pw3)
       call free(pw4)
       call free(pw5)
#else
       call gfree(pw1)
       call gfree(pw2)
       call gfree(pw3)
       call gfree(pw4)
       call gfree(pw5)
#endif
       return
      endif
      DO 210 I = 2,nsets
       if(jr(i).ge.iri.or.i.eq.nsets)then
        k = i-1
        j1 = nc(i)
        j0 = nc(k)
C +==============================+
C | Take care of first occurring |
C | function first, then last    |
C +==============================+
        j = j0
        do ii=1,1000
         wt(ii)=0.
         wv(ii)=0.
        end do
#ifdef DISCO
        m=0
        if(k.gt.1)m=compoff(k,nc)
        do ii=1,j
         wt(ii)=tt(m+ii)
         wv(ii)=c(m+ii) * vscale
        end do
#else
        do ii=1,j
         wt(ii)=tt(ii,k)
         wv(ii)=c(ii,k) * vscale
        end do
#endif
        if(wt(1).gt.dt)call add_first(wt,wv,nc(k),j,dt)
        if(wt(j).lt.tmax)then
         call add_last(wt,wv,j,m,tmax)
         j = m
        end if
        do ii=1,j
         holdt(ii)=wt(ii)
        end do
        call brms(wt,wv,j,nsamp,dt,work1)
C +====================================+
C | Now have the first rms function in |
C | work1. Now get the second          |
C +====================================+
        do ii=1,j
         wt(ii)=0.
         wv(ii)=0.
        end do
C +====================================+
C | j2 holds the total count for the   |
C | number of velocity sample points   |
C +====================================+
        j2=j
C +====================================+
C | Now set the processing count to    |
C | number of points for next function |
C +====================================+
        j = j1
        m=0
#ifdef DISCO
        if(i.gt.1)m=compoff(i,nc)
        do ii=1,j
         wt(ii)=tt(m+ii)
         wv(ii)= c(m+ii)
        end do
#else
        do ii=1,j 
         wt(ii)=tt(ii,i)
         wv(ii)= c(ii,i)
        end do
#endif
        if(wt(1).gt.dt)call add_first(wt,wv,nc(i),j,dt)
        if(wt(j).lt.tmax)then
         call add_last(wt,wv,j,m,tmax)
         j = m
        end if
        do ii=1,j
         holdt(j2+ii)=wt(ii)
        end do
        j2 = j2 + j
        call brms(wt,wv,j,nsamp,dt,work2)
C +====================================+
C | Handle the case where iri = jr(i)  |
C +====================================+
        if(jr(i).eq.iri)then
         do ii=1,lclr
          w1(ii)=0.
          w2(ii)=0.
          w3(ii)=0.
         end do
         ch = 0.
         do ii=1,6
          coefs(ii)=0.
         end do
         do ii=1,nsamp
          vtrms(ii)=work2(ii)
         end do
         if(fit)then
          jl = j
          call infill(wt,wv,work4,work5,jl,j)
*         call svdfit(wt,wv,sig,j,coefs,
*    :     npol, w1, w2,w3,j,npol,CH,fpoly)
          call svdfit(work4,work5,sig,j,coefs,
     :     npol, w1, w2,w3,j,npol,CH,fpoly)
          call polev(time,nsamp,coefs,npol,vsrms)
          call rmsint(vsrms,time,nsamp,vtmax,vism)
          call rmsint(vtrms,time,nsamp,vtmax,vi)
         endif
#ifdef DISCO
         call free(pw1)
         call free(pw2)
         call free(pw3)
         call free(pw4)
         call free(pw5)
#else
         call gfree(pw1)
         call gfree(pw2)
         call gfree(pw3)
         call gfree(pw4)
         call gfree(pw5)
#endif
         return
        endif
C +====================================+
C | Now handle case where iri lies     |
C | between two input functions.       |
C +====================================+
C +==========================+
C | Convert holdt to samples |
C +==========================+
        do k=1,j2
         holdt(k)=holdt(k)/dt + 1.
         if(holdt(k).gt.nsamp)holdt(k)=nsamp
        end do
C +=============================+
C | Interpolate to the given ri |
C +=============================+
        call lineari(work1,work2,nsamp,jr(i-1),jr(i),iri,work3)
        ch = 0.
        do ii=1,npol
         coefs(ii)=0.
        end do
        do ii=1,nsamp
         vtrms(ii)=work3(ii)
        end do
        if(fit)then
         do k=1,lclr
          w1(k)=0.
          w2(k)=0.
          w3(k)=0.
         end do
         call hsort(j2,holdt)
C +==============================+
C | Eliminate duplicate samples  |
C | in holdt                     |
C +==============================+
         j=0
         do k=1,j2-1
          ok=.true.
          do m=k+1,j2
           if(holdt(m).eq.holdt(k))ok=.false.
          end do
          if(ok)then
           j=j+1
           work4(j)=holdt(k)
          end if
         end do
         j=j+1
         work4(j)=holdt(j2)
C +===========================+
C | Sample the interpolated   |
C | velocity function at hold |
C | positions                 |
C +===========================+
         do k=1,j
          wt(k)=(work4(k)-1.)*dt
          mk = work4(k)
          wv(k)=work3(mk)
         end do
         do k=1,lclr
          w1(k)=0.
          w2(k)=0.
          w3(k)=0.
         end do
         jl = j
         call infill(wt,wv,work4,work5,jl,j)
         call svdfit(work4,work5,sig,j,coefs,
     :     npol, w1, w2,w3,j,npol,CH,fpoly)
         call polev(time,nsamp,coefs,npol,vsrms)
         call rmsint(vsrms,time,nsamp,vtmax,vism)
         call rmsint(vtrms,time,nsamp,vtmax,vi)
        endif
#ifdef DISCO
        call free(pw1)
        call free(pw2)
        call free(pw3)
        call free(pw4)
        call free(pw5)
#else
        call gfree(pw1)
        call gfree(pw2)
        call gfree(pw3)
        call gfree(pw4)
        call gfree(pw5)
#endif
        return
      endif
  210 continue
C  Just in case should fall through
#ifdef DISCO
        call free(pw1)
        call free(pw2)
        call free(pw3)
        call free(pw4)
        call free(pw5)
#else
        call gfree(pw1)
        call gfree(pw2)
        call gfree(pw3)
        call gfree(pw4)
        call gfree(pw5)
#endif
      return
      END
      subroutine polev(x,nx, co,nco,y)
      real x(*), co(*), y(*)
 
      do 200 i=1,nx
        y(i)=0.
        do 100 j=1,nco
          k = j-1
          y(i)=y(i)+(x(i)+.000001)**k*co(j) 
  100   continue
  200 continue
      return
      end
      subroutine infill(a,b,x,y,la,lx)
      real a(*),b(*),x(*),y(*)
      integer la,lx

      lx = 1
      x(1)=a(1)
      y(1)=b(1)
      do i=2,la
        dx=a(i)-a(i-1)
        if(dx.gt.1.0)then
          dv=abs(b(i)-b(i-1))
          slope=dv/dx
          lx=lx+1
          x(lx)=a(i-1)+1.
          y(lx)=b(i-1)+slope
          lx=lx+1
          y(lx)=b(i)
          x(lx)=a(i)
        else
          lx=lx+1
          x(lx)=a(i)
          y(lx)=b(i)
        endif
      end do
      return
      end
      subroutine add_first(t,v,n,j,dt)
      real t(*),v(*),dt
      integer n,j

      do i=n,1,-1
       t(i+1)=t(i)
       v(i+1)=v(i)
      end do
      t(1)=dt
      v(1)=v(2)-25.
      j=n+1
      return
      end
      subroutine add_last(t,v,n,j,dt)
      real t(*),v(*),dt
      integer n,j

*     acceler = (v(j)-v(j-1))/(t(j)-t(j-1))
*     acceler = abs(acceler)*1.1
      j = n + 1
      t(j)= dt
      v(j)=v(j-1)+25.
*     v(j) = v(j-1)+acceler*(t(j)-t(j-1))
       
      return
      end
      subroutine lineari(x,y,lx,ix,iy,ixi,z)
      real x(*),y(*),z(*)
      integer lx,ix,iy,ixi

      do i=1,lx
       dx=float(iy-ix)
       dy=y(i)-x(i)
       dxx=ixi-ix
       z(i)=x(i)+dy/dx*dxx
      end do
      return
      end
