C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine squarewave(x,nx,y,rms,area, stretch,vtr,off,si,ier)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      real x(*),y(*),vtr(*),off,si
      integer nx 
      logical rms,area,stretch

      real absv(1),xh(1)
      pointer (pabsv,absv)
      pointer (pxh,xh)

      iget = ISZBYT * nx
      ier = 0
      ner = 0
      call galloc(pabsv,iget,ier,0)
      ner = ner + ier
      call galloc(pxh  ,iget,ier,0)
      ner = ner + ier
      if(ner.ne.0)then
       ier = 1
       return
      endif

c +================================+
c | Get the absolute value of data |
c | and zero the return array      |
c +================================+
      do i=1,nx
       absv(i)=abs(x(i))
       y(i)=0.
       xh(i)=x(i)
      end do
      j=1
      m  = 0
c +===================+
c | Main process loop |
c +===================+
      do while(j.lt.nx)
c +===============================+
c | Find the first non-zero value |
c +===============================+
       do while(x(j).eq.0.and.j.le.nx)
        y(j)=x(j)
        j=j+1
       end do
       if(j.ge.nx)then
        y(nx)=0.
        call gfree(pabsv)
        call gfree(pxh )
        return
       endif
       m = j+1
       nzro = 0
c +===============================================+
c | Look for zero crossings, defined as the point |
c | at which the sign of the data trace changes.  |
c | The variable j points to the start of the     |
c | "lobe" and m points to the end.  Computations |
c | are made between j and m.                     |
c +===============================================+
       do while(m.le.nx.and.sign(1.0,x(m-1)).eq.sign(1.0,x(m)))
        m=m+1
        if(absv(m).ne.0)nzro = nzro+1
       end do
       m=m-1
       if(nzro.gt.0)then
        mid = j+(m-j)/2
        if(stretch)then
         do n=j,m
          tz = float(j-1)*si
          v0 = vtr(n)
          v0 = v0*v0
          tz = tz*tz
          denom=v0*tz
          xx = off*off
          if(denom.ne.0)then
           denom=xx/denom
           factor = 1./sqrt(1.+denom)
          else
           factor = 1.
          endif
          absv(n)=absv(n)*factor
          xh(n)=xh(n)*factor
         end do
        endif
        if(rms)then
         sum=0.
         do n=j,m
          sum=sum+xh(n)*xh(n)
         end do
         xx=m-j+1
         arms = sqrt(sum)/xx
         arms = arms*sign(1.0,xh(mid))
        elseif(area)then
         sum=0.
         do n=j,m
          sum=sum+xh(n)
         end do
         arms=sum
         arms = arms
        else
         big = 0.
         do n=j,m
          if(absv(n).gt.big)then
           big=absv(n)
           arms=xh(n)
          endif
         end do
        endif
       endif
       do n=j,m
        y(n)=arms
       end do
c +==============================+
c | Reset the pointer to the top |
c | of the lobe.                 |
c +==============================+
       j=m+1
      end do
      call gfree(pabsv)
      call gfree(pxh    )
      return
      end
