C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getwgt( taper, theta, xoff, ntr, lerr, hamming, 
     :     blackman, tnorm, snorm, verbos )

      implicit none

c declare variables passed from calling routine

      integer ntr, lerr

      real taper(ntr,ntr)  
      real theta(ntr)
      real xoff(ntr)

      logical hamming, blackman, tnorm, snorm, verbos

c declare local variables

      integer noffset, i, k

      real pi, twopi, dx, xoffmin, xoffmax
      real xavg, xdiff, sum

c initialize variables

      parameter  (pi=3.14159265,twopi=2.*pi)
c
c
c
      dx=1.

      DO noffset = 1,ntr

         if(hamming .or. blackman .or. tnorm .or. snorm) then
c_____________________________________________________________________
c         calculate normalized weights for constant trace separation.
c
c         cf Gijs Vermeer
c            Seismic Wavefield Sampling
c            SEG 1990.
c_____________________________________________________________________
            xoffmin=1.*dx
            xoffmax=noffset*dx

            do i=1,ntr
               xoff(i)=i*dx  
            enddo

            xavg=.5*(xoffmax+xoffmin)
            xdiff=xoffmax-xoffmin

            if(noffset .gt. 1) then
               do k=1,noffset
                  theta(k)=twopi*(xoff(k)-xavg)/xdiff
               enddo
            else
               theta(1)=0.
            endif

            if(hamming) then
               do k=1,noffset
                  taper(k,noffset)=(.54+.46*cos(theta(k)))
               enddo
            elseif(blackman) then
               do k=1,noffset
                  taper(k,noffset)=(.42+.5*cos(theta(k))
     1                 +.08*cos(2.*theta(k)))
               enddo
            else
               do k=1,noffset
                  taper(k,noffset)=1.
               enddo
            endif
c_____________________________________________________________________
c         normalize weights.
c_____________________________________________________________________

            sum=0.

            do k=1,noffset
               sum=sum+taper(k,noffset)
            enddo

            do k=1,noffset
               taper(k,noffset)=taper(k,noffset)/sum
            enddo
         else
c_____________________________________________________________________
c         unnormalized, unitary weights.
c_____________________________________________________________________
            do k=1,noffset
               taper(k,noffset)=1.
            enddo
         endif

         if(verbos) then
            write(lerr,*) 'number of nonzero samples = ',noffset
            write(lerr,'(3a12)') 'k','taper(k,noffset)'
            write(lerr,'(i12,f12.6)')
     1           (k,taper(k,noffset),k=1,noffset)
         endif

      ENDDO
c
      return
      end
