C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c	Wade - Feb 2002 -
c	  Remove lntrhd, ITRWRD and SZLNHD from the parameter list and 
c	  added the include file where they are defined.
c
      subroutine stacksub(uin,bufin,uout,bufout,threed,BC,nsamp,
     1     nbytes,holdi,holdo,renum, attribute,ugather,usum,udenom,
     2     weight,xoff,taper,icount,power,ic,icc,irs,
     3     ire,irec,ngath,ntpr,ifmt_CDPBCY,hbegin,luin,luout,lerr,
     4     verbos,ns,ne,ifmt_CDPBCX,semb,semwt,snorm,dwgt,l_CDPBCX,
     5     ln_CDPBCX,ln_CDPBCY,d1neg,d2neg,d1pos,d2pos,l_SrRcMX,
     6     l_SrRcMY,l_CDPBCY,l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,
     7     l_TrcNum,l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,l_StaCor,
     8     l_DstSgn,l_LinInd,l_SoPtNm,ln_SrRcMX,ln_FlReFN,ln_ToStUn,
     9     ln_ToTmAU,ln_RecNum,ln_TrcNum,ln_RecInd,ln_DphInd,ln_SrcLoc,
     a     ln_SrcPnt,ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     b     ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     c     ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,ifmt_SrcPnt,
     d     ifmt_StaCor,ifmt_DstSgn,ifmt_LinInd,ifmt_SoPtNm,ifmt_SrRcMX,
     e     ifmt_SrRcMY,ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,
     f     l_SrPtYC,ln_SrPtYC,ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,
     g     ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,ifmt_FoldNm,l_FoldNm,
     h     ln_FoldNm, LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, 
     i      STP, STN, STA, AVA, AAA, APV, APN )
c
      implicit none

#include <f77/lhdrsz.h>

c declare variables passed from calling routine 

c     integer lntrhd, nsamp, nbytes, ITRWRD, SZLNHD
      integer nsamp, nbytes
      integer ic, icc, irs, ire, irec, ngath, ntpr
      integer luin, luout, lerr, ns, ne
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer ifmt_SrRcMX, l_SrRcMX, ln_SrRcMX
      integer ifmt_SrRcMY, l_SrRcMY, ln_SrRcMY
      integer ifmt_FlReFn, l_FlReFn, ln_FlReFn
      integer ifmt_ToStUn, l_ToStUn, ln_ToStUn
      integer ifmt_ToTmAu, l_ToTmAu, ln_ToTmAu
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_SrcPnt, l_SrcPnt, ln_SrcPnt
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC
      integer ifmt_FoldNm, l_FoldNm, ln_FoldNm

      integer    hbegin
      integer    bufin(SZLNHD)
      integer    bufout(SZLNHD)
      integer    holdi(SZLNHD)
      integer    holdo(SZLNHD)
      integer    icount(nsamp)

      real       uin(hbegin:nsamp)
      real       uout(hbegin:nsamp)
      real       ugather(nsamp,ngath)
      real       usum(nsamp)
      real       udenom(nsamp)
      real       taper(ngath,ngath)     
      real       weight(nsamp,ngath) 
      real       xoff(ngath)

      real power
      real d1pos, d2pos, d1neg, d2neg

      logical    semb,semwt,verbos,snorm,dwgt,threed,BC
      logical    renum
      logical   LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, STP
      logical   STN, STA, AVA, AAA, APV, APN, attribute

c declare local variables

      integer isamp, noffset, k, istatic, ii, idist, counter
      integer i_FlReFn, i_ToStUn, i_ToTmAu, i_RecNum, i_TrcNum
      integer i_RecInd, i_SrcLoc, i_SrcPnt, i_SoPtNm, i_LinInd
      integer i_DphInd, i_SrRcMX, i_SrRcMY, i_SrPtXC, i_SrPtYC
      integer i_RcPtXC, i_RcPtYC, i_CDPBCX, i_CDPBCY

      real powerinv, pi, twopi, eps, peak, median, avg
      real cdpxsum, cdpysum, am, dist, cdpx, cdpy, sum, ampl
      real work(SZLNHD)

      parameter  (pi=3.14159265,twopi=2.*pi)
      parameter  (eps=1.e-20)

      external function median

c initialize variables

      powerinv=1./power
      noffset = 0
      cdpxsum = 0.
      cdpysum = 0.

      call vclr(uout(1),1,nsamp)           
      call vclr(usum,1,nsamp)

      do isamp = 1,nsamp
         udenom(isamp)=eps
         icount(isamp)=0
      enddo

c verbose heading if requested

      if(verbos) then
         write(lerr,'(7a10)')
     1        'ioffset','RecNum','TrcNum','SrcLoc',
     2        'DphInd','SrcPnt','LinInd'
      endif

      DO k = 1,ngath

         nbytes=0
         call rtape(luin,holdi,nbytes)
         call move (1, uin(hbegin), holdi(1), nbytes)
         if(nbytes .eq. 0) then
            write(lerr,*)'End of file on input:'
            write(lerr,*)'  rec= ',irec,'  trace= ',k
            return      
         endif

         IF (k .ge. ns .and. k .le. ne) then
c_____________________________________________________________________
c         trace falls within trace window.         
c_____________________________________________________________________

c bufin and uin are equivalent arrays as they are both bufin in the
c call to the stacksub subroutine.  Same goes for bufout and uout

            call saver2(bufin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           istatic  , 1)

            am = 0.
            do  ii = 1, nsamp
               am = am + abs(uin(ii))
            enddo

            if(istatic .ne. 30000 .AND. am .ne. 0.0) then
c_____________________________________________________________________
c            live trace.                           
c_____________________________________________________________________
               call saver2(bufin,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              idist    , 1)
               dist = float( idist )
               if(dist .ge. d2neg .and. dist .le. d1neg .OR.
     1              dist .ge. d1pos .and. dist .le. d2pos) then
c_____________________________________________________________________
c               trace falls within distance window.
c_____________________________________________________________________
                  noffset=noffset+1
                  if (noffset .eq. 1)
     1                 call move (1, holdo(1), holdi(1), nbytes)
                  xoff(noffset)=dist
                  call vmov(uin(1),1,ugather(1,noffset),1,nsamp)
                  call vfill(dist,weight(1,noffset),1,nsamp)
c_____________________________________________________________________
c               capture important trace header information
c_____________________________________________________________________
                  call saver2(bufin,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                 i_FlReFN , 1)
                  call saver2(bufin,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                 i_ToStUn , 1)
                  call saver2(bufin,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                 i_ToTmAU , 1)
                  call saver2(bufin,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                 i_RecNum , 1)
                  call saver2(bufin,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                 i_TrcNum , 1)
                  call saver2(bufin,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                 i_RecInd , 1)
                  call saver2(bufin,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                 i_SrcLoc , 1)
                  call saver2(bufin,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1                 i_SrcPnt , 1)
                  call saver2(bufin,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                 i_SoPtNm , 1)
                  call saver2(bufin,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 i_LinInd , 1)
                  call saver2(bufin,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 i_DphInd , 1)
                  call saver2(bufin,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                 i_SrRcMX , 1)
                  call saver2(bufin,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                 i_SrRcMY , 1)
                  if ( BC ) then
                     call saver2(bufin,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                    i_SrPtXC , 1)
                     call saver2(bufin,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                    i_SrPtYC , 1)
                     call saver2(bufin,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                    i_RcPtXC , 1)
                     call saver2(bufin,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                    i_RcPtYC , 1)
                     cdpx = 0.5 * float (i_SrPtXC + i_RcPtXC) + 0.5
                     cdpy = 0.5 * float (i_SrPtYC + i_RcPtYC) + 0.5
                     cdpxsum = cdpxsum + cdpx
                     cdpysum = cdpysum + cdpy
                  else
                     call saver2(bufin,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                    i_CDPBCX , 1)
                     call saver2(bufin,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                    i_CDPBCY , 1)
                  endif

c
                  if(verbos) then
                     write(lerr,'(7i10)')
     1                    noffset,i_recnum,i_trcnum,i_srcloc,
     2                    i_dphind,i_srcpnt,i_linind
                  endif
               endif
            endif

         ENDIF

      ENDDO

      if (noffset .eq. 0) then
         do ii = 1,ITRWRD+nsamp
            bufout (ii) = 0
         enddo
         call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        30000 , 1)
         go to 76000
      endif

c record now loaded in ugather[], if not doing attribute of data in stack
c then calculate weighting to be used on stacked amplitudes.  If an 
c attribute of data to be stacked has been requested then the weighting
c is not required and we can skip all these calculations
c
      IF ( snorm .and. .not. attribute ) then
c_____________________________________________________________________
c        count how many non zero samples there are in each gather.
c        shift nonzero samples to the left.
c_____________________________________________________________________
         do 25000 k=1,noffset
            do 22000 isamp=1,nsamp
               if(ugather(isamp,k) .ne. 0.) then
                  icount(isamp)=icount(isamp)+1
                  ugather(isamp,icount(isamp))=ugather(isamp,k)
                  weight(isamp,icount(isamp))=weight(isamp,k)       
               endif
22000       continue
25000    continue

         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            do 30000 isamp=1,nsamp
               sum=0.
               do 26000 k=1,icount(isamp)
                  xoff(k)=weight(isamp,k)*taper(k,icount(isamp))
                  sum=sum+xoff(k)               
26000          continue

               if(sum .ne. 0.) then
                  do 28000 k=1,icount(isamp)
                     weight(isamp,k)=xoff(k)/sum
28000             continue
               else
                  do 29000 k=1,icount(isamp)
                     weight(isamp,k)=0.
29000             continue
               endif
30000       continue
         else
c_____________________________________________________________________
c           weights invariant with distance. copy taper into weight.       
c_____________________________________________________________________
            do 30050 isamp=1,nsamp
               do 26050 k=1,icount(isamp)
                  weight(isamp,k)=taper(k,icount(isamp))
26050          continue
30050       continue
         endif
      ELSEIF ( .not. snorm .and. .not. attribute ) then
c_____________________________________________________________________
c        simple normalization by the number of live traces in the 
c        window.
c_____________________________________________________________________
         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            sum=0.
            do 26100 k=1,noffset             
               xoff(k)=weight(1,k)*taper(k,noffset)             
               sum=sum+xoff(k)               
26100       continue
            if(sum .ne. 0.) then
               do 28100 k=1,noffset        
                  do 28050 isamp=1,nsamp
                     weight(isamp,k)=xoff(k)/sum
28050             continue
28100          continue
            else
               call vclr(weight,1,nsamp*noffset)
               write(lerr,*) 'possible error in routine stacksub'
               write(lerr,*) 'distance weights are all zero!'
               write(lerr,*) 'noffset = ',noffset
               write(lerr,*) 'xoff ',(xoff(k),k=1,noffset)
            endif
         else
c_____________________________________________________________________
c           weights invariant with distance. taper into weight.           
c_____________________________________________________________________
            do 30150 k=1,noffset  
               do 26150 isamp=1,nsamp         
                  weight(isamp,k)=taper(k,noffset)             
26150          continue
30150       continue
         endif
      ENDIF
c
      if(power.ne. 1.) then
c_____________________________________________________________________
c        do power-th root stack of the input data.
c_____________________________________________________________________
         do 35000 k=1,noffset
            do 31000 isamp=1,nsamp
               ampl=sign(abs(ugather(isamp,k))**powerinv,
     1              ugather(isamp,k))
               usum(isamp)=ampl+usum(isamp)
31000       continue
c_____________________________________________________________________
c         raise stacked trace to the power 'power'
c_____________________________________________________________________
            do 32000 isamp=1,nsamp
               usum(isamp)=sign(abs(usum(isamp))**power,usum(isamp))
32000       continue
35000    continue
      elseif(semb .or. semwt) then
         do 50000 k=1,noffset
c_____________________________________________________________________
c         do power-th root stack of the input data.
c_____________________________________________________________________
            do 40000 isamp=1,nsamp
               usum(isamp)=usum(isamp)+ugather(isamp,k)
               udenom(isamp)=udenom(isamp)+ugather(isamp,k)**2
40000       continue
50000    continue
      elseif(snorm .and. .not. attribute ) then
c_____________________________________________________________________
c        weighted stack honoring mute zones (zero valued samples).
c_____________________________________________________________________
         do 55000 isamp=1,nsamp
            do 52000 k=1,icount(isamp)
               usum(isamp)=usum(isamp)
     1              +ugather(isamp,k)*weight(isamp,k)           
52000       continue
55000    continue
      elseif ( .not. attribute ) then
c_____________________________________________________________________
c        simple weighting (with or without normalization).        
c_____________________________________________________________________
         do 70000 k=1,noffset
            do 60000 isamp=1,nsamp
               usum(isamp)=usum(isamp)+ugather(isamp,k)*weight(isamp,k)
60000       continue
70000    continue
      endif
      if(noffset .eq. 0) noffset = 1
      if(semb) then
c_____________________________________________________________________
c        output the semblance.             
c_____________________________________________________________________
         do 72000  isamp=1,nsamp
            uout(isamp)=(usum(isamp)**2)/udenom(isamp)
72000    continue
      elseif(semwt) then
c_____________________________________________________________________
c        output the semblance weighted stack
c_____________________________________________________________________
         do  74000  isamp=1,nsamp
            uout(isamp)=(usum(isamp)**3)/(udenom(isamp)*noffset)
74000    continue
      elseif ( .not. attribute ) then
c_____________________________________________________________________
c        output non semblance weighted stack
c_____________________________________________________________________
         do 75000 isamp=1,nsamp
            uout(isamp)=usum(isamp)
75000    continue
      endif

      if ( LPV ) then

c output largest positive value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               peak = max(peak,ugather(isamp,k))
            enddo
            uout(isamp) = peak
         enddo

      elseif ( LNV ) then

c output largest negative value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               peak = min(peak,ugather(isamp,k))
            enddo
            uout(isamp) = peak
         enddo

      elseif ( MAA ) then

c output maximum absolute value at each sample level

         do isamp = 1,nsamp
            peak = -1.0
            do k = 1, noffset
               if ( abs ( ugather(isamp,k)) .gt. peak ) 
     :              peak = abs( ugather(isamp,k))
            enddo
            uout(isamp) = peak
         enddo

      elseif ( MNZ ) then

c output minimum non-zero absolute value at each sample level

         do isamp = 1,nsamp
            peak = 1.0e32
            do k = 1, noffset
               if ( abs ( ugather(isamp,k)) .lt. peak .and. 
     :              abs(ugather(isamp,k)) .gt. 1.0e-32 ) 
     :              peak = abs( ugather(isamp,k))
            enddo
            if ( peak .lt. 1.0e32 ) uout(isamp) = peak
         enddo

      elseif ( MDA ) then

c output median of absolute values at each sample level

         do isamp = 1,nsamp

            peak = 0.0
            do k = 1, noffset
               work(k) = abs(ugather(isamp,k))
            enddo
            peak = median ( work, 1, noffset, 1, noffset )
            uout(isamp) = peak
         enddo

      elseif ( MED ) then

c output median value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               work(k) = ugather(isamp,k)
            enddo
            peak = median ( work, 1, noffset, 1, noffset )
            uout(isamp) = peak
         enddo

      elseif ( SAV ) then

c output sum of absolute values at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               peak = peak + abs(ugather(isamp,k))
            enddo
            uout(isamp) = peak
         enddo

      elseif ( STD ) then

c output standard deviation of values at each sample level

         do isamp = 1,nsamp
            avg = 0.0
            do k = 1, noffset
               avg = avg + ugather(isamp,k)
            enddo
            avg = avg / float(noffset)
            sum = 0.0
            do k = 1, noffset
               sum = sum + (( ugather(isamp,k) - avg )**2)
            enddo
            uout(isamp) = sqrt ( sum / float(noffset) )
         enddo

      elseif ( STP ) then

c output standard deviation of positive values at each sample level

         do isamp = 1,nsamp
            avg = 0.0
            counter = 0
            do k = 1, noffset
               if ( ugather(isamp,k) .gt. 0.0 ) then
                  avg = avg + ugather(isamp,k)
                  counter = counter + 1
               endif
            enddo
            if ( counter .gt. 0 ) then
               avg = avg / float(counter)
               sum = 0.0
               do k = 1, noffset
                  if ( ugather(isamp,k) .gt. 0.0 ) then
                     sum = sum + (( ugather(isamp,k) - avg )**2)
                  endif
               enddo
               uout(isamp) = sqrt ( sum / float(counter) )
            endif
         enddo

      elseif ( STN ) then

c output standard deviation of negative values at each sample level

         do isamp = 1,nsamp
            avg = 0.0
            counter = 0
            do k = 1, noffset
               if ( ugather(isamp,k) .lt. 0.0 ) then
                  avg = avg + ugather(isamp,k)
                  counter = counter + 1
               endif
            enddo
            if ( counter .gt. 0 ) then
               avg = avg / float(counter)
               sum = 0.0
               do k = 1, noffset
                  if ( ugather(isamp,k) .lt. 0.0 ) then
                     sum = sum + (( ugather(isamp,k) - avg )**2)
                  endif
               enddo
               uout(isamp) = sqrt ( sum / float(counter) )
            endif
         enddo

      elseif ( STA ) then

c output standard deviation of absolute values at each sample level

         do isamp = 1,nsamp
            avg = 0.0
            do k = 1, noffset
               avg = avg + abs( ugather(isamp,k) )
            enddo
            avg = avg / float(noffset)
            sum = 0.0
            do k = 1, noffset
               sum = sum + (( abs(ugather(isamp,k)) - avg )**2)
            enddo
            uout(isamp) = sqrt ( sum / float(noffset) )
         enddo

      elseif ( AVA ) then

c output unweighted average value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               peak = peak + ugather(isamp,k)
            enddo
            uout(isamp) = peak / float(noffset)
         enddo

      elseif ( AAA ) then

c output average absolute value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            do k = 1, noffset
               peak = peak + abs(ugather(isamp,k))
            enddo
            uout(isamp) = peak / float(noffset)
         enddo

      elseif ( APV ) then

c output average  positive value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            counter = 0.0
            do k = 1, noffset
               if ( ugather(isamp,k) .gt. 0.0 ) then
                  peak = peak + ugather(isamp,k)
                  counter = counter + 1
               endif
            enddo
            if ( counter .gt. 0 ) then
               uout(isamp) = peak / float(counter)
            endif
         enddo

      elseif ( APN ) then

c output average negative value at each sample level

         do isamp = 1,nsamp
            peak = 0.0
            counter = 0.0
            do k = 1, noffset
               if ( ugather(isamp,k) .lt. 0.0 ) then
                  peak = peak + ugather(isamp,k)
                  counter = counter + 1
               endif
            enddo
            if ( counter .gt. 0 ) then
               uout(isamp) = peak / float(counter)
            endif
         enddo

      endif

76000 continue
      icc = icc + 1

      call vmov (holdo(1), 1, bufout(1), 1, ITRWRD)
c----
c   deal with completely dead gather
c----
      if (noffset .eq. 0) then
         do  ii = 1, ITRWRD+nsamp
            bufout (ii) = 0
         enddo
         call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        30000 , 1)
         i_ToStUn = 0
         i_ToTmAU = 0
         i_SrcLoc = 0
         i_SrcPnt = 0
         i_SoPtNm = 0
         i_CDPBCX = 0
         i_CDPBCY = 0
      else
         if ( BC ) then
            cdpxsum = cdpxsum / noffset
            cdpysum = cdpysum / noffset
            i_CDPBCX = cdpxsum
            i_CDPBCY = cdpysum
         endif
      endif
c----
c   put proper indexing into stacked trace
c----
 
      call savew2(bufout,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1     i_ToStUn , 1)
      call savew2(bufout,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1     i_ToTmAU , 1)
c 
c  Changed to switch output RecNum and TrcNum if renum flag is set - jev
c
      if (renum) then
         call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        icc       , 1)
         call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1        irec      , 1)
      else
         call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        irec     , 1)
         call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1        icc      , 1)
      endif

      call savew2(bufout,ifmt_RecInd,l_RecInd, ln_RecInd,
     1     i_RecInd , 1)
      call savew2(bufout,ifmt_DphInd,l_DphInd, ln_DphInd,
     1     i_DphInd , 1)
      call savew2(bufout,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1     i_SrcLoc , 1)
      call savew2(bufout,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1     i_SrcPnt , 1)
      call savew2(bufout,ifmt_LinInd,l_LinInd, ln_LinInd,
     1     i_LinInd , 1)
      call savew2(bufout,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1     i_SoPtNm , 1)
      call savew2(bufout,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1     i_SrRcMX , 1)
      call savew2(bufout,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1     i_SrRcMY , 1)
      call savew2(bufout,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1     i_CDPBCX , 1)
      call savew2(bufout,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1     i_CDPBCY , 1)
      call savew2(bufout,ifmt_FoldNm,l_FoldNm, ln_FoldNm,
     1     noffset , 1)

      if(mod(icc,ntpr) .eq. 0) then
         irec=irec+1                 
         icc = 0
      endif
      ic=ic+1
      call wrtape(luout,bufout,nbytes)
c
      return
      end
