C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount( lupick, NumPicks, PickType, nseg)

c routine to count number of segments and total number of picks 
c in pick file.  Expects xsd or oper pick format

#include <f77/iounit.h>

      integer lupick, NumPicks, nrec, ntrc, nseg, nsmp, maxpicks

      real rec_units, trc_units, smp_units, segs, value
      real recoff, trcoff, smpoff

      character junk*1, key*10, PickType*(*)

c initialize variables 

      NumPicks = 0

c determine type of pickfile being read if the new headeroutput file is 
c being used do appropriate read 

      IF ( PickType .ne. 'header' ) then

c read file header


	read(lupick,100)junk,rec_units,trc_units,smp_units,nrec,ntrc,nsmp,
     *             recoff,trcoff,smpoff,nseg,maxpicks
 100    format(a1,5x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     *  7x,f12.6,1x,f12.6,1x,f12.6,8x,i5,1x,i5)

         if(junk.ne."U")then
            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' first line does not start with Units'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop
         endif

c check first segment for format

         read(lupick,'(a1)',end=900)junk

         if(junk.ne."S")then

            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' second line does not start with Segment'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop

         endif

c determine number of picks

 10      read(lupick,'(a1)',end=910)junk
      
         if(junk.ne."S")then

            NumPicks = NumPicks + 1

         endif

         goto 10

      ELSE

c use new pickfile key,value format 

         do while (1.EQ.1)

            read(lupick,'(a10,1x,f17.6)',end=200)key,value
            if (key.EQ.'No_Seg') then
               segs = value
               nseg = nint(segs)
            endif

            if (key.EQ.'Max_Pick') then
               NumPicks = nint(segs * value)
            endif
            
            if(segs.gt.0.and.NumPicks.gt.0)goto 200

         enddo

 200     continue

         if(NumPicks.lt.1) then

            write(LERR,*)'FATAL: something fishy in control pickfile'
            write(LERR,*)'       The total number of picks could not'
            write(LERR,*)'       be calculated.  Check that format of'
            write(LERR,*)'       pickfile is consitent with -M option'
            write(LERR,*)'       used on command line or that correct'
            write(LERR,*)'       spelling was used or if the file'
            write(LERR,*)'       exists at all'
            write(LERR,*)'       '
            stop

         else

            goto 910

         endif

      ENDIF

 900     continue

         write(LERR,*)'FATAL .........'
         write(LERR,*)'No entries found in pick file'
         stop
         
 910     continue

         write(LERR,*)' '
         write(LERR,*)'EOF on pick file after ',NumPicks,' picks'
         write(LERR,*)' '
         rewind(lupick)

      return
      end
