C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :     mtype, mul, spinit, spincr, vtap, MultOrder, Simple, 
     :     Flat, mnemonic, TraceSpacing, verbos )

c     verbose output of processing parameters

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, mul
      integer     spinit, spincr, MultOrder, lentap, leotap, levtap

      real        TraceSpacing

      character   ntap*(*), otap*(*), vtap*(*), mtype*(*), mnemonic*(*)

      logical     Simple, verbos, Flat
 
      if ( verbos )then
      write(LERR,*)'Verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)' Input Primaries Pickfile '
      lentap = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name  =  ', ntap(1:lentap)
      else
        write(LERR,*) ' input data set       =  stdin'
      endif
      write(LERR,*)' PickType                =  ', mtype
      write(LERR,*)' time multiplier (ms)    =  ', mul
      write(LERR,*)' initial sp override     =  ', spinit
      write(LERR,*)' sp increment override   = ', spincr
      write(LERR,*)' trace spacing           = ', TraceSpacing
      write(LERR,*)' indexing based on trace header mnemonic = ',
     :     mnemonic
      write(LERR,*)' '
      write(LERR,*)' Input Velocity Dataset'
      levtap = lenth(vtap)
      if (levtap .gt. 0) then
        write(LERR,*) ' input velocity data set name = ',
     :		vtap(1:levtap)
      else
        write(LERR,*) ' input velocity data set      = pipe'
      endif
      write(LERR,*) ' samples per trace    =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec
      write(LERR,*) ' format of data       =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Input XSD Pickfile Parameters'
      write(LERR,*)' '
      write(LERR,*)' Output XSD Pickfile Parameters'
      leotap = lenth(otap)
      if (leotap .gt. 0) then
        write(LERR,*)' output XSD pick file name =  ',
     :		otap(1:leotap)
      else
        write(LERR,*)' output XSD pick file      =  pipe'
      endif
      write(LERR,*)' order of multiple to generate = ', MultOrder
      if ( Simple ) then
         write(LERR,*)' Generating multiples of above order only'
      else 
         write(LERR,*)' Generating multiples up to and including order r
     :equested'
      endif
      if ( Flat ) then
         write(LERR,*)' multiple time = multorder * primary time'
      else 
         write(LERR,*)' multiple time using dipping plane formula'
      endif
      write(LERR,*)' '
      else
      write(LERR,*)'No verbose printout requested'
      write(LERR,*)' '
	endif
 
      return
      end
