C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(u, uout, uhdr, tsum, ssum, recip, live,
     1                   liverec, livesum, i_mult_num, i_mult_asg,
     2                   livesum_num, livesum_asg, ii, jj, kk, im, 
     3                   jm, km, isamp, istart, iskip, iend, NumSmp,
     4                   NumTrc, NumRec, lenhed, lbyout, Nx_Pad, luin, 
     5                   luout, ler, lerr, cputim, waltim, ifmt_StaCor,
     6                   l_StaCor, ln_StaCor, fdead)

      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford  	04/14/97
c
c Bertram Kaufhold 	05/01/98	Modification
c
c This routine contains the rolling sum process necessary for the mean
c calculation of routine stat3d
c
c-----------------------------------------------------------------------

#include <save_defs.h>

      integer ii, jj, kk, im, jm, km, isamp, istart, iskip, iend 
      integer NumSmp, NumTrc, NumRec, Nx_Pad, lenhed, lbyout
      integer luin, luout, ler, lerr
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      logical fdead

      integer livesum_num(NumTrc), livesum_asg(NumTrc)
      real u(-lenhed+1:NumSmp), uout(isamp, NumTrc) 
      real uhdr(lenhed, NumTrc, kk+1), recip(im, kk*jj)
      double precision tsum(isamp, NumTrc, kk+1), ssum(isamp, NumTrc)
      integer live(NumTrc, kk+1), liverec(NumTrc), livesum(NumTrc) 
      integer i_mult_num(im), i_mult_asg(isamp)

      real cputim(*), waltim(*)

      integer irec, itrc, header, drop, add, current, StaCor, lbytes
      integer i, i_dim
      real v1, vtot1, w1, wtot1
      real v2, vtot2, w2, wtot2
      real v3, vtot3, w3, wtot3
      real v8, vtot8, w8, wtot8
      real time_per_line, time_left
      integer nhour, nmin, nsec, kstart, kend

      call timstr(v2,w2)

c-----------------------------------------------------------------------
c The i-direction summation multipliers (see subroutine reciprocals) 
c only contain a small set of numbers whose number depends on the
c i-direction windowsize. To reduce processing time we will find this
c set of numbers, write them in array i_mult_num and store the
c i-direction assignment list in array i_mult_assg

      i_mult_num(1) = im
      do i = 2, im
         i_mult_num(i) = i_mult_num(i-1)+1
      enddo
      i_mult_asg(1) = 1
      do i = 2, im
         i_mult_asg(i) = i_mult_asg(i-1)+1
      enddo
      do i = im+1, isamp-im+1
         i_mult_asg(i) = i_mult_asg(i-1)
      enddo
      do i = isamp-im+2, isamp
         i_mult_asg(i) = i_mult_asg(i-1)-1
      enddo  

c-----------------------------------------------------------------------
c These variables determine which record should be dropped or added from 
c the current sums.  Once we accumulate the entire window of sums into
c current, then header tells us which record we are actually writing out.

      drop = 1
      add = kk + 1
      current = 1
      header = 1

c Start the timer that we will use to gauge how long until we finish

      call timstr(v8,w8)
      kstart = 1
      kend = NumRec
      
c-----------------------------------------------------------------------
c						=> START OUTER LOOP =>
      do irec = kstart, kend			

c Diagnostic message.  What line are we on and how much time until done?
 
         if (irec .ge. kk) then
            call timstr(vtot8,wtot8)                 
            time_per_line = (wtot8-w8)/(irec-kstart)
            time_left = (kend-irec+1)*time_per_line  
            nhour=time_left/3600.
            nmin=(time_left-3600.*nhour)/60.
            nsec=time_left-3600.*nhour-60.*nmin
            write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1         '(stat3d) Processing line ',irec,' of ',NumRec,
     2         ' time left: ',nhour, ' hr',
     3         nmin, ' min', nsec, ' sec'
         else
            write(ler,'(a,i5,a,i5)')
     1         '(stat3d) Processing line ',irec,' of ',NumRec
         endif

c-----------------------------------------------------------------------
c					=> START INNER LOOP =>
         do itrc = 1, NumTrc		

c Read a trace.

            call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
            call timstr(v1,w1)
            call rtape(luin, u(-lenhed+1), lbytes)
            call timend(cputim(1),v1,vtot1,waltim(1),w1,wtot1)
            call timstr(v2,w2)

c Save the header for later use and rearrange the data entries 
c according to the specifications made in the command line 

            call vmov(u(-lenhed+1), 1, uhdr(1,itrc,current), 1, lenhed)
            i_dim = 1
            do i = istart, iend, iskip
               u(i_dim)=u(i)
               i_dim = i_dim + 1
            enddo

c-----------------------------------------------------------------------
c By convention a "Station Correction" of 30000 is used as a dead trace 
c flag. If it is a dead trace fill it with zeros and report in array live
c that no actual summation has taken place

            call saver2(u(-lenhed+1), ifmt_StaCor, l_StaCor, ln_StaCor,
     1                  StaCor, TRACEHEADER)
            if (StaCor .ne. 30000) then

c Create sums across the samples

               call sample_sums(ssum(1,itrc), u(1), isamp, im)
               live(itrc, current) = 1
            else

c If dead trace, just fill with zeros

               call vclr(ssum(1,itrc), 1, isamp)
               live(itrc, current) = 0
            endif
         enddo				
c					=> END INNER LOOP =>
c-----------------------------------------------------------------------

c-----------------------------------------------------------------------
c Using the sample sums, create sums across the traces.  Note that we 
c need not consider whether the trace is live or dead here because we 
c filled the dead traces with zeroes.

         call trace_sums(tsum(1,1,current), ssum, isamp, NumTrc, jm)

         if (irec .eq. 1) then

c For first record, just copy trace sums into master sum holder, uout.

            call copy_record(uout, tsum(1,1,current), isamp, NumTrc)
            call copy_liverec(liverec, live(1,current), NumTrc)
         else if (irec .gt. 1 .and. irec .le. kk) then

c Until we have summed across the entire window, continue to add the 
c trace sums for each record to our master sum holder, uout.

            call add_record(uout, tsum(1,1,current), isamp, NumTrc)
            call add_liverec(liverec, live(1,current), NumTrc)
         else if (irec .gt. kk) then

c We are using a sliding window of sums.  As we move the window in the
c y-direction (lines or records) we will add newest set of sums
c (tsum(1,1,add)) and subtract off the oldest set of sums 
c (tsum(1,1,drop)). We do this until we read through the entire dataset.

            call add_drop_record(uout, tsum(1,1,add), tsum(1,1,drop),
     1                           isamp, NumTrc)
            call add_drop_liverec(liverec, live(1,add), live(1,drop),
     1                            NumTrc)
            drop = drop + 1
            if (drop .gt. kk+1) drop = 1
            add = add + 1
            if (add .gt. kk+1) add = 1
         endif

c We can't write anything out until we have read in km records.

         if (irec .ge. km) then

c Create the live/dead trace sums for use in the reciprocal calculations.  

            call isample_sums(livesum, liverec, NumTrc, jm)

c Reciprocals (stored in recip) are the correct 1/N values from the 
c formula shown in the comments at the top of routine stat3d. Note 
c that N is different for the outside edges of the dataset because we 
c do not have a complete window. The reciprocal routine generates a record 
c of these reciprocals for use in averaging.  Note that because dead 
c traces change the reciprocal multipliers, and since there are usually
c some dead traces hanging around the edges of the dataset, we just 
c recompute the reciprocals each time.  

            call reciprocals(recip, livesum, isamp, NumTrc, im, kk, jj,
     1                       i_mult_num, i_mult_asg, 
     2                       livesum_num, livesum_asg)

c Multiply each set of sums by the reciprocals and write them out.  
c Note that uout is unchanged after this call!

            call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
            call timstr(v3,w3)
            call write_avg_record(u, uhdr(1,1,header),live(1,header),
     1                            uout, recip, i_mult_asg, livesum_asg,
     2                            isamp, NumTrc, Nx_Pad, luout, lerr, 
     3                            lbyout, lenhed, im, kk, jj, fdead)
            call timend(cputim(3),v3,vtot3,waltim(3),w3,wtot3)
            call timstr(v2,w2)
            header = header + 1
            if (header .gt. kk+1) header = 1
         endif

         current = current + 1
         if (current .gt. kk+1) current = 1
      enddo					
c						=> END OUTER LOOP =>
c-----------------------------------------------------------------------

c-----------------------------------------------------------------------
c Even though we have read through the entire dataset, we still have some
c records to write out.  The last km-1 records must be summed and averaged. 
c Note that we are once again working with less than a full window, so we 
c must generate the reciprocals again before each write.

      do irec = 1, km-1
         call drop_record(uout, tsum(1,1,drop), isamp, NumTrc)
         call drop_liverec(liverec, live(1,drop), NumTrc)
         drop = drop + 1
         if (drop .gt. kk+1) drop = 1

         call isample_sums(livesum, liverec, NumTrc, jm)
         call reciprocals(recip, livesum, isamp, NumTrc, im, kk, jj,
     1                    i_mult_num, i_mult_asg, 
     2                    livesum_num, livesum_asg)

         call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)
         call timstr(v3,w3)
         call write_avg_record(u, uhdr(1,1,header),live(1,header), 
     1                         uout, recip, i_mult_asg, livesum_asg,
     2                         isamp, NumTrc, Nx_Pad, luout, lerr,
     3                         lbyout, lenhed, im, kk, jj, fdead)
         call timend(cputim(3),v3,vtot3,waltim(3),w3,wtot3)
         call timstr(v2,w2)
         header = header + 1
         if (header .gt. kk+1) header = 1
      enddo
      call timend(cputim(2),v2,vtot2,waltim(2),w2,wtot2)

      end
