C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ----------------------------------------------------------------
C Routine stelfilt.
      SUBROUTINE STELFILT(G,RECORD,TRSTEL,NTRC,NSAMP,BETA,RES,DIDST)
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C-----
C      SZDTHD	- size of trace header on disk in bytes
C      SZTRHD	- size of trace header in pipes in bytes
C      LNTRHD   - size of trace header in samples
C      SZDVHD	- size of vanl analysis header on disk in bytes
C      SZVAHD	- size of vanl analysis header in pipes in bytes
C      SZSAMP	- size of floating point sample in bytes
C      SZSMPM	- maximum number of trace samples
C      SZLNHD	- line file size = (SZTRHD + SZSAMP*MAXSMP)/2
C      SZSPRD   - size of the spread in channels
C      SZSMPD   - size of sample in pipe (in bytes)
C      HSTOFF   - byte count at which hlh starts
C      SZHFWD   - size in bytes of 1/2 word
C-----
C
      DIMENSION G(*),RECORD(NSAMP,NTRC),TRSTEL(NSAMP,NTRC)
C NOTE ORDER OF ARGUMENTS IN DIMENSION OF 2D ARRAYS
C
      DIMENSION TRACE(SZSMPM), TARGET(SZSMPM)
      DIMENSION GC(20000),GREAL(SZSMPM),GIMAG(SZSMPM)
      DIMENSION TC(20000),TREAL(SZSMPM),TIMAG(SZSMPM)
C Assumption is that 20000 is greater than twice SZSMPM. Increase
C  if it is not.
      DIMENSION GAMP(SZSMPM), TAMP(SZSMPM)
      REAL V1,V2,VDIF
      LOGICAL RES, DIDST
C
C beta is the fraction (greater than 0 and less than or equal to 1.00)
C  that the difference between amplitude spectra is reduced. Spectra
C  of traces in record( , ) become more like spectra of trace g.
C
C Logical variable res is true if the user wants the traces restored
C  to their original average amplitude.
C
      write(LERR,*) 'stelfilt: NSAMP ', NSAMP, ' NTRC ', NTRC
cmam  write(30,*) 'stelfilt: NSAMP ', NSAMP, ' NTRC ', NTRC
C Copy the samples of g() into target with zero pad for late samples.
      DIDST=.TRUE.
      ABSMAX=0.0
      DO 100 LSAMP=1,SZSMPM,1
      TARGET(LSAMP)=0.0
      if(LSAMP.le.NSAMP) then
       VABS=ABS(G(LSAMP))
       IF(VABS.GT.ABSMAX) ABSMAX=VABS
       TARGET(LSAMP)=G(LSAMP)
      endif
  100 CONTINUE
C
C If target trace is dead return with trstel array unchanged.
      IF(ABSMAX.EQ.0) THEN
      WRITE(LERR,*) 'Target trace all zeroes. Record not filtered.'
cmam  WRITE(30,*) 'Target trace all zeroes. Record not filtered.'
      DIDST=.FALSE.
      RETURN
      ENDIF
C
C Get proper exact integer power of 2 required for FFT.
C Value of mpow will be greater than or equal to nsamp.
      CALL NEXTPOW2(NSAMP,MPOW)
c     write(30,*) 'Exact power after nextpow2 is: ', MPOW
C
C Get FFT of target trace and calculate its amplitude spectrum.
C ***** WARNING ***** mpow must be an integer power of 2 for fft routine
      IF(MPOW.GT.SZSMPM) MPOW=MPOW/2
      write(LERR,*) 'Exact power used is: ', MPOW
cmam  write(30,*) 'Exact power used is: ', MPOW
      if(MPOW.gt.NSAMP) then
       do 120 ipad=NSAMP+1,MPOW,1
       TARGET(ipad)=0.0
  120  continue
      endif
C Do forward fft input trace.
      CALL RFFTB(TARGET,GC,MPOW,1)
C Scale and unpack.
      CALL RFFTSC(GC,MPOW,3,1)
      KMAX=1+MPOW/2
      FKMAX=FLOAT(KMAX)
C Extract real and imag parts input trace (array ca).
      CALL VREAL(GC,2,GREAL,1,KMAX)
      CALL VIMAG(GC,2,GIMAG,1,KMAX)
C
C Calculate spectra of target (reference) trace g().
      GSUM=0.0
      GMAX=0.0
      DO 200 JSP=1,KMAX,1
      GAMP(JSP)=SQRT(GREAL(JSP)*GREAL(JSP)+GIMAG(JSP)*GIMAG(JSP))
      GSUM=GSUM+GAMP(JSP)
      IF(GAMP(JSP).GT.GMAX) GMAX=GAMP(JSP)
  200 CONTINUE
      GAVE=GSUM/FKMAX
      CUT=GMAX/1000000.0
c     write(30,*) 'ref ave ', gave, ' ref max ', gmax, ' cut ', cut
C
C..........................................................
C Loop thru traces of record.
      DO 900 KK=1,NTRC,1
C
      ABSMAX=0.0
C Copy the samples into trace.
      DO 350 LSAMP=1,SZSMPM,1
      VABS=0.0
      if(LSAMP.le.NSAMP) VABS=ABS(RECORD(LSAMP,KK))
      IF(VABS.GT.ABSMAX) ABSMAX=VABS
      TRACE(LSAMP)=0.0
      IF(LSAMP.LE.NSAMP) TRACE(LSAMP)=RECORD(LSAMP,KK)
  350 CONTINUE
C
      IF(ABSMAX.EQ.0.0) THEN
      WRITE(LERR,*) 'Trace ', KK, ' all zeroes. Trace not filtered.'
cmam  WRITE(30,*) 'Trace ', KK, ' all zeroes. Trace not filtered.'
      ENDIF
C
C Do not apply a filter if current trace from record is dead.
C
      IF(ABSMAX.GT.0.0) THEN
C
CL2   call L2norm(g,trace,1,nsamp,v1)
C Get FFT of trace and calculate its amplitude spectrum.
C ***** WARNING ***** mpow must be an integer power of 2 for fft routine
C Do forward fft input trace.
      CALL RFFTB(TRACE,TC,MPOW,1)
C Scale and unpack.
      CALL RFFTSC(TC,MPOW,3,1)
C Extract real and imag parts of trace (array ca).
      CALL VREAL(TC,2,TREAL,1,KMAX)
      CALL VIMAG(TC,2,TIMAG,1,KMAX)
C
C Calculate spectra of trace from record.
      TSUM=0.0
      TMAX=0.0
      DO 375 JSP=1,KMAX,1
      TAMP(JSP)=SQRT(TREAL(JSP)*TREAL(JSP)+TIMAG(JSP)*TIMAG(JSP))
      TSUM=TSUM+TAMP(JSP)
      IF(TAMP(JSP).GT.TMAX) TMAX=TAMP(JSP)
  375 CONTINUE
      TAVE=TSUM/FKMAX
Cw    write(30,*) 'trace ave ', tave, ' trace max ', tmax
C
C Filter the trace.
      SUMSCALE=0.0
      DO 700 J=1,KMAX,1
C Mult complex array tc() for trace by proper scale factor.
C There are kmax different frequencies.
      SCALE=1.0
      IF(TAMP(J).GT.0.0) THEN
      SCALE=(BETA*GAMP(J)+(1.0-BETA)*TAMP(J))/TAMP(J)
      ENDIF
      SUMSCALE=SUMSCALE+SCALE
C Multipy both real and complex part of trace FFT by scale factor.
      INDEX=2*J
      TC(INDEX)=TC(INDEX)*SCALE
      INDEX=INDEX-1
      TC(INDEX)=TC(INDEX)*SCALE
C Phase is preserved as both parts of complex frequecy mult by scale.
  700 CONTINUE
C
      AVESCALE=SUMSCALE/FKMAX
Cw    write(30,*) 'Average scale multiplier is: ', avescale
C
C Restore average trace amplitude if requested.
      IF(RES.AND.(AVESCALE.NE.0.0)) THEN
      DO 800 INV=1,2*KMAX,1
      TC(INV)=TC(INV)/AVESCALE
  800 CONTINUE
      ENDIF
C
C Invert the trace with inverse FFT.
      CALL RFFTB(TC,TRACE,MPOW,-1)
C
CL2   call L2norm(g,trace,1,nsamp,v2)
      VDIF=V2-V1
Cw    write(30,*) 'L2 norms v2 ', v2, ' v1 ', v1, ' v2-v1 ', vdif
C
C Copy trace to output record.
      DO 850 JS=1,NSAMP,1
      TRSTEL(JS,KK)=TRACE(JS)
  850 CONTINUE
C
      ENDIF
  900 CONTINUE
C
      RETURN
      END
C
C ----------------------------------------------------------------
C Routine nextpow2
      SUBROUTINE NEXTPOW2(NSAMP,MPOW)
      IPOW2=IFIX(LOG(FLOAT(NSAMP))/LOG(2.0))
      IF(IPOW2.EQ.0) THEN
      MPOW=0
      RETURN
      ENDIF
      MPOW=2**IPOW2
C mpow will be .le. nsamp
      IF(MPOW.LT.NSAMP) MPOW=2*MPOW
C mpow will be .ge. nsamp
      RETURN
      END
C
C ----------------------------------------------------------------
C Subroutine L2norm
C *******************************************************************
C ***** Routine calculates raw L2 norm for two traces.          *****
C ***** d. bjerstedt may 16 1991.                               *****
C *******************************************************************
      SUBROUTINE L2NORM(TR1,TR2,ISTART,IEND,VALUE)
      DIMENSION TR1(*),TR2(*)
      REAL SUM
      SUM=0.0
      DO 100 I=ISTART,IEND,1
      SUM=SUM+(TR1(I)-TR2(I))*(TR1(I)-TR2(I))
  100 CONTINUE
      VALUE=SUM
      RETURN
      END
C
C Array readin routine targin80.
C *******************************************************************
C ***** Routine reads in a data array from formated disk file.  *****
C ***** d. bjerstedt january 23, 1991.                          *****
C *******************************************************************
      SUBROUTINE TARGIN80(Q,NSIZE,MPERLI,IUNIT)
C Routine reads array in logical unit iunit with mperli values per line.
      REAL Q(*)
      INTEGER DAT(8)
      IF((MPERLI.GT.8).OR.(MPERLI.LT.1)) MPERLI=8
      IF(NSIZE.LT.1) RETURN
      NLINES=NSIZE/MPERLI
      NLEFT=MOD(NSIZE,MPERLI)
C
      DO 200 L=1,NLINES,1
      READ(IUNIT,90) (DAT(KJ),KJ=1,MPERLI,1)
   90 FORMAT(8I10)
      DO 100 KK=1,MPERLI,1
      IND=(L-1)*MPERLI+KK
      Q(IND)=FLOAT(DAT(KK))
  100 CONTINUE
  200 CONTINUE
C
      IF(NLEFT.NE.0) THEN
C
      READ(IUNIT,90) (DAT(KL),KL=1,NLEFT,1)
      DO 300 L=1,NLEFT,1
      IND=NLINES*MPERLI+L
      Q(IND)=FLOAT(DAT(L))
  300 CONTINUE
C
      ENDIF
      RETURN
      END
C ------------------------------------------------------------------
C Taper subroutine targtapr
      SUBROUTINE TARGTAPR(TARGET,NSAMP,NSF,NSL,LENWM1,FLENWM1)
C Note that a 10 point taper will have a length of 9 sample increments
C  (by our convention) and that the tenth sample from the edge of the
C  window will have value 0.0 while the first sample in the window is
C  not amplitude modified.
      DIMENSION TARGET(*)
      INTEGER NSAMP,NSF,NSL,LENWM1
      REAL FLENWM1
c     write(30,*) 'NSF ', NSF, ' NSL ', NSL
c     write(30,*) 'LENWM1 ', LENWM1, ' FLENWM1 ', FLENWM1
      IF(LENWM1.LE.0) RETURN
C
      DO 100 JKWIN=1,NSAMP,1
      IF(JKWIN.LE.(NSF-LENWM1)) TARGET(JKWIN)=0.0
C
      IF((JKWIN.GT.(NSF-LENWM1)).AND.(JKWIN.LT.NSF)) THEN
       TARGET(JKWIN)=TARGET(JKWIN)*(1.0-FLOAT(NSF-JKWIN)/FLENWM1)
      ENDIF
C
      IF(JKWIN.GE.(NSL+LENWM1)) TARGET(JKWIN)=0.0
C
      IF((JKWIN.GT.NSL).AND.(JKWIN.LT.(NSL+LENWM1))) THEN
       TARGET(JKWIN)=TARGET(JKWIN)*(1.0-FLOAT(JKWIN-NSL)/FLENWM1)
      ENDIF
C
  100 CONTINUE
C
      RETURN
      END
