C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine inverse_stft( tri, Workspace, nsamp, ist, iend, nf,  
     :     nwin, stft_Record, ntrco, nsampo, w, ctr, verbos )

      implicit none

c variables passed from calling routine

      integer nsamp, ist, iend, nf, nwin, ntrco, nsampo

      real tri(nsampo), Workspace(nsampo), stft_Record( nsamp, nf+1) 
      real w(nwin)

      complex ctr (nf+1)

      logical verbos

c declare local variables

      integer nwinh, nft, nf_unpack, i, j

c initialize variables

      call vclr ( tri, 1, nsampo)
      nf_unpack = nf + 1
      nwinh = nwin / 2
      nft = 2 * nf 

c process data

      do i = ist, iend

         call vclr ( Workspace , 1, nsampo )

         do j = 1, nf_unpack
            ctr(j) = cmplx(0.0,0.0)
         enddo
         
c assign complex array from input phase and amplitude data
c amplitude is coming from the top half of stft_Record
c phase is coming from the bottom half of stft_Record
c we are going to extract for an output time sample at a time
c then extract from the inverse the center sample to output
c at the desired time

         do j = 1, nf_unpack
            ctr(j) = stft_Record(i,j) * 
     :           cexp ( cmplx(0., stft_Record(i+nsampo,j) ) )
         enddo
 
c inverse FFT 

c         call rfftsc ( ctr, nft, -2 ,0)
         call rfftsc ( ctr, nft, -3 ,0)
         call rffti ( ctr, Workspace, nft)

c get the central sample only of the window

         tri(i) = Workspace( nwinh + 1 ) / w( nwinh + 1 )
         
      enddo

      return
      end
