C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine table (tabl1, n1, tabl2, n2, dt1, dt2,
     1                  pwr,sfac,dtmin,ifunc,nsamp, revers)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer  n1, n2, ifunc

      real     tabl1(SZLNHD), tabl2(SZLNHD)
      real     dt1, dt2, dtmin, pwr, sfac
      real     pi2

      logical  revers
      
      pi2 = .5 * 3.14159265


      IF (ifunc .eq. 0) THEN

         if (.not.revers) then

            do  1    j = 1, n1
               tabl1(j) = float( j - 1 ) * dt1
1           continue

            do  2    j = 1, n2
               tabl2(j) = dtmin * exp (float(j-1) * dt2)
2           continue

         else

            do  3    j = 1, n1
               tabl1(j) = dtmin * exp (float(j-1) * dt1)
3           continue

            do  4    j = 1, n2
               tabl2(j) = float( j - 1 ) * dt2
4           continue

         endif

      ELSEIF (ifunc .eq. 1) THEN

         if (.not.revers) then

            do  101   j = 1, n1
               tabl1(j) = float( j - 1 ) * dt1
101         continue

            do  102   j = 1, n2
               tabl2(j) = float ( j - 1) ** pwr * dt2
102         continue

         else

            do  103  j = 1, n1
               tabl1(j) = float ( j - 1) ** pwr * dt1
103         continue

            do  104  j = 1, n2
               tabl2(j) = float( j - 1 ) * dt2
104         continue

         endif

      ELSEIF (ifunc .eq. 2) THEN

         if (.not.revers) then

            do  200  j = 1, n1
               tabl1(j) = float( j - 1 ) * dt1
200         continue

            do  201  j = 1, n2
               tabl2(j) =  float(j-1) * dt2
201         continue

         else

            do  202  j = 1, n1
               tabl1(j) =  float(j-1) * dt1
202         continue

            do  203  j = 1, n2
               tabl2(j) = float(j-1) * dt2
203         continue

         endif

      ELSEIF (ifunc .eq. 3) THEN

         if (.not.revers) then

            do  300  j = 1, n1
               tabl1(j) = float( j - 1 ) * dt1
300         continue

            do  301  j = 1, n2
               sn       = sin (pi2*sfac*float(j-1)/float(nsamp) )
               tabl2(j) = nsamp * sn * dt2
301         continue

         else

            do  302  j = 1, n1
               sn       = sin (pi2*sfac*float(j-1)/float(nsamp) )
               tabl1(j) = nsamp * sn * dt1
302         continue

            do  303  j = 1, n2
               tabl2(j) = float(j-1) * dt2
303         continue

         endif

      ELSEIF (ifunc .eq. 4) THEN

         if (.not.revers) then

            do  400  j = 1, n1
               tabl1(j) = float( j - 1 ) * dt1
400         continue

            do  401  j = 1, n2
               cs       = cos (pi2*sfac*float(j-1)/float(nsamp) )
               tabl2(j) = nsamp * (1. - cs) * dt2
401         continue

         else

            do  402  j = 1, n1
               cs       = cos (pi2*sfac*float(j-1)/float(nsamp) )
               tabl1(j) = nsamp * (1. - cs) * dt1
402         continue

            do  403  j = 1, n2
               tabl2(j) = float(j-1) * dt2
403         continue

         endif

      ENDIF

      return
      end


