C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c SURFACE  reads a disco file and extracts near-surface geometry.
c	This info is put in a pick file format e.g. xsd.
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      real*4 elev(6000),d1(6000),d2(6000),d3(6000),d4(6000),d5(6000)
#include <f77/pid.h>
      character   sfile * 256, rfile * 256, name*7,tfile *256
      logical     verbos, query, revers, gli, big, old, cdp,flat
      integer     argis, vw, v1, v2
      integer     s(6000,22), r(6000,19),index(6000)
 
      data lur / 30 /, name/'SURFACE'/
      data lus / 40 /, luflat/50/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/open.h>


 
 
      call gcmdln(rfile,sfile,nz,datum,cdp,revers,
     :     maxind,gli,imin,imax,big,old,nlayers, iseed,tfile)
c-----
c     open disco or gli3d file
c-----
         if (rfile(1:1) .ne. ' ') then
	        open(unit=lur, file=rfile,form = 'formatted')
         else
                lur = LIN
         endif

c-----
c     open xsd file
c-----
         if (sfile(1:1) .ne. ' ') then
	        open(unit=lus, file=sfile,form = 'formatted')
         else
                lus = LOT
         endif
c------
c	open topo flat file
c------
	if (tfile(1:1) .ne. ' ') then
		open(unit=luflat,file=tfile,form='formatted')
		flat = .true.
	else
		luflat = LOT
	endif
c--------------------------------------------------

c--------------------------------------------------
c     READ DISCO file
	if (gli) then
		if (big) then
		   if (old) then
			call readgli1(lur,ns,nr, s, r ,iseed)
		   else
			call neadgli1(lur,ns,nr, s, r ,iseed)
		   endif
			do 101 i = 1,nr
				ii       = r(i,1)
				index(i) = ii
				elev(ii) = r(i,8)
				d1(ii)   = r(i,2)
				d2(ii)   = r(i,4)
				d3(ii)   = r(i,14)
				d4(ii)   = r(i,16)
				d5(ii)   = r(i,18)
987	format(f10.0,i10,4f10.0)
101		continue
		else	
		   if (old) then
			call readgli (lur,ns,nr, s, r ,iseed)
		   else
			call neadgli (lur,ns,nr, s, r ,iseed)
		   endif
			do 100 i = 1,nr
				ii       = r(i,1)
				index(i) = ii
				elev(ii) = r(i,8)
				d1(ii)   = r(i,2)
				d2(ii)   = r(i,4)
				d3(ii)   = 0.
				d4(ii)   = 0.
				d5(ii)   = 0.
100		continue
		endif
		if (imin .le. 0 )imin = 1
		if (imax .eq. 0 )imax = nr
	else
		call readisco (lur,lus,elev,d1,d2,imin,imax,maxind)
	endif
c	write XSD file
 	if ( revers ) then
	  call writexsd(lus,elev,d1,d2,d3,d4,d5,
     :		 imax,imin,datum,nz,revers,nlayers,cdp)
	if (flat) then
		do i = nr,1,-1 
			ii = r(i,1)
			if ( ii .ge. imin .and. ii .le. imax)
     :				write(luflat,*)elev(ii)
		enddo
	endif
	else
	  call writexsd(lus,elev,d1,d2,d3,d4,d5,
     :		  imin,imax,datum,nz,revers,nlayers,cdp)
	if (flat) then
		do i = 1,nr
			ii = r(i,1)
			if ( ii .ge. imin .and. ii .le. imax)
     :				write(luflat,*)elev(ii)
		enddo
	endif
	endif

      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE SURFACE  --  Generate near-surface geometry '
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program SURFACE  writes an xsd pick file for near-surface layers'
      WRITE(LER,*)
     :'This includes the topo, weathering, & subweathering surfaces'
      WRITE(LER,*)
     :'The user provides the datum, vw, vsw, v2 as arguments;'
      WRITE(LER,*)
     :'program reads disco (or gli3d) file for elevation and depths'
      WRITE(LER,*)
      WRITE(LER,*)
     :'To run type "surface" followed by command-line args'
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap] (no default): input disco (*.mlf) or gli file (*.ele)'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output file for xsd'
        WRITE(LER,*)
     :' -T [tfile]      (no default): topo file name'
        WRITE(LER,*)
     :' -d [datum]     (no default) : datum elevation'
        WRITE(LER,*)
     :' -nz[nz   ]     (no default) : depth increment'
        WRITE(LER,*)
     :' -max[maxind]   (default=5000) : max group station + 1000'
        WRITE(LER,*)
     :'         above  used only for disco input and not gli3d'
        WRITE(LER,*)
     :' -imin[imin]   (default=1) : min sequential group(cdp) to pick'
        WRITE(LER,*)
     :' -imax[imax] (default=last): max sequential group(cdp) to pick'
        WRITE(LER,*)
     :' -nlay[nlayers](default=0) : # layers in gli file (.ele)'
        WRITE(LER,*)
     :' -C             (default=groups): output picks at cdps'
        WRITE(LER,*)
     :' -R             (default=normal): reverse order of picks'
        WRITE(LER,*)
     :' -G             (default=no): enter -G for gli3d input'
        WRITE(LER,*)
     :'                if -G not typed, program assumes DISCO input'
        WRITE(LER,*)
     :' -B             (no): enter -B for gli3d input with > 2 layers'
        WRITE(LER,*)
     :'                if -B not typed, program assumes 2 layers'
        WRITE(LER,*)
     :' -Q          (no): enter -Q for gli3d input from batch program'
        WRITE(LER,*)
     :' -iseed[iseed] (-7777): add to all table values in .ele',
     :'		file to avoid naturally occuring zeros'
	return
	end

  	subroutine readisco (lur,lus,elev,d1,d2,imin,imax,maxind)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	real elev(*),d1(*),d2(*)
	integer icount(10000)
	character card1*108

1      read (lur,'(a108)',end=9999) card1
	if (card1(1:6) .eq. 'NORMAL') go to 9999
	if (card1(9:12) .ne. 'SHOT') then
		go to 1
	else
		read(lur,'(a108)') card1
			do 30 i = 1,10000
				read(lur,'(a108)') card1
				if(card1(1:7) .eq. '1 amoco') go to 1
				read(card1,'(28x,i10)')index
				if (index .gt. maxind) go to 30
 				index= index-1000
				icount(index) = 1
				read(card1,'(41x,i10)')ielev
				elev(index) = float(ielev)/100.0
				read(card1,'(54x,i10)')id1
				d1(index)= float(id1)
				read(card1,'(67x,i10)')id1
				d2(index)= float(id1)
30			continue
	endif
c
c	count the number of live index values, find 1st and last, too
c	
9999	continue
	imin = 999999
	imax = 0
	do 100 i = 1,10000
		if(icount(i) .eq. 1) then
			if(i .lt. imin) imin = i
			if(i .gt. imax) imax = i
		endif
100	continue
	return
	end
	subroutine writexsd(lus,elev,d1,d2,d3,d4,d5,imin,
     :		imax,datum,nz,revers,nlayers,cdp)
	real * 4 elev(*),d1(*),d2(*),d3(*),d4(*),d5(*),datum
	integer imin,imax
	logical revers,cdp
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	rec = 1.0
	one = 1.0
	ione = 1
	zero = 0.0
c
c	write a file of xsd picks for near-surface topographhy
c
	if (revers) then
		idir = -1
	else
		idir = 1
	endif
	write(lus,55)one,one,one,ione,ntr,nz,zero,zero,zero
55	format('Units',3f13.6,i9,i7,i7,' Offset',3f9.6)
	write(lus,50)
50	format('Segment = 1    color = 0')
	a = 0.0
	do 100 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum - elev(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
		write(lus,56) rec, a, samp
		if (cdp) then
			kk = i + idir*1
			if( i .eq. imax )go to 199
			bs = (datum - elev(kk))/float(nz)
			samp = (ss + bs  )/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			a = a + 1.0
			write(lus,56) rec, a, samp
		end if
100	continue
56	format(3f12.6)
199	write(lus,51)
51	format('Segment = 2    color = 0')
	a = 0.0
	do 200 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum-elev(i)+d1(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
 		write(lus,56) rec, a, samp               
		if (cdp ) then
			kk = i + idir*1
			if( i .eq. imax )go to 299
			bs = (datum - elev(kk)
     :				+ d1(kk))/float(nz)
			samp = (ss + bs  )/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			a = a + 1.0
			write(lus,56) rec, a, samp
		end if
200	continue
299	if (nlayers .lt. 2) return
	write(lus,52)
52	format('Segment = 3    color = 0')
	a = 0.0
	do 300 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum-elev(i)+d1(i)+d2(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
 		write(lus,56) rec, a, samp               
		if (cdp) then
			kk = i + idir*1
			if( i .eq. imax )go to 399
			bs = (datum - elev(kk)
     :				+ d1(kk)
     :				+ d2(kk))/float(nz)
			samp = (ss + bs  )/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			a = a + 1.0
			write(lus,56) rec, a, samp
		end if
300	continue
399	if (nlayers .lt. 3) return
	write(lus,53)
53	format('Segment = 4    color = 0')
	a = 0.0
	do 400 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum-elev(i)+d1(i)+d2(i)+d3(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
 		write(lus,56) rec, a, samp               
		if (cdp) then
			kk = i + idir*1
			if( i .eq. imax )go to 499
			bs = (datum - elev(kk)
     :				+ d1(kk)
     :				+ d2(kk)
     :				+ d3(kk))/float(nz)
			samp = (ss + bs  )/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			a = a + 1.0
			write(lus,56) rec, a, samp
		end if
400	continue
499	if (nlayers .lt. 4) return
	write(lus,54)
54	format('Segment = 5    color = 0')
	a = 0.0
	do 500 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum-elev(i)+d1(i)+d2(i)+d3(i)
     :			+d4(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
 		write(lus,56) rec, a, samp               
		if (cdp) then
			kk = i + idir*1
			if( i .eq. imax )go to 599
			bs = (datum - elev(kk)
     :				+ d1(kk)
     :				+ d2(kk)
     :				+ d3(kk)
     :				+ d4(kk))/float(nz)
			samp = (ss+bs)/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			write(lus,56) rec, a, samp
		end if
500	continue
599	if (nlayers .lt. 5) return
	write(lus,58)
58	format('Segment = 6    color = 0')
	a = 0.0
	do 600 i = imin,imax,idir
		a = a + 1.0
 		ss   = (datum-elev(i)+d1(i)+d2(i)
     :			+d3(i)+d4(i)+d5(i))/float(nz)
		isamp = 1 + nint(ss)
		samp  = isamp
 		write(lus,56) rec, a, samp               
		if (cdp) then
			kk = i + idir*1
			if( i .eq. imax )return
			bs = (datum - elev(kk)
     :				+ d1(kk)
     :				+ d2(kk)
     :				+ d3(kk)
     :				+ d4(kk)
     :				+ d5(kk))/float(nz)
			samp = (ss + bs  )/2.0
			isamp = 1 + nint(samp)
			samp = isamp
			a = a + 1.0
			write(lus,56) rec, a, samp
		end if
600	continue
	return
	end
      subroutine gcmdln(rfile,sfile,nz,datum, cdp,
     :   revers,maxind,gli,imin,imax,big,old,nlayers,iseed,tfile)
      integer argis
      logical revers,gli,big,old,cdp
      real datum
      character rfile*(*),sfile*(*),tfile*(*)
      call argstr('-N',rfile,' ',' ')
      call argstr('-O',sfile,' ',' ')
      call argstr('-T',tfile,' ',' ')
      call argr4('-d',datum,0.0,0.0)
      call argi4('-nz',nz,0,0)
      call argi4('-imin',imin,0,0)
      call argi4('-imax',imax,0,0)
      call argi4('-max',maxind,5000,5000)
      call argi4('-nlay',nlayers,0, 0)
      call argi4('-iseed',iseed ,-7777, -7777)
      revers = ( argis('-R') .gt. 0 )
      gli    = ( argis('-G') .gt. 0 )
      big    = ( argis('-B') .gt. 0 )
      old    = ( argis('-Q') .gt. 0 )
      cdp    = ( argis('-C') .gt. 0 )
      if (nlayers .eq. 0 ) then
      	if (big) then
		nlayers = 3
      	else
		nlayers = 2
      	endif
      endif
      return
      end
c
c
