C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine apprho(u,rbuf,cbuf,rho,
     1           afact,nt,nfft,ifl,ifh,istart,iend)
      real    u(istart:iend)
      real    rbuf(0:nfft-1)
      real    rho(ifl:ifh)
      complex cbuf(0:nfft/2-1)
c___________________________________________________________________
c     apply the rho filter. 
c___________________________________________________________________
      do 20000 jt=0,istart-1         
       rbuf(jt)=0.
20000 continue
      do 21000 jt=istart,iend
       rbuf(jt)=u(jt)
21000 continue
      do 22000 jt=iend+1,nfft-1
       rbuf(jt)=0.
22000 continue
      call rfftb(rbuf,cbuf,nfft,+1)
      call rfftsc(cbuf,nfft,+2,+1)
      do 22500 jf=0,ifl-1
       cbuf(jf)=(0.,0.)
22500 continue
      do 23000 jf=ifl,ifh
       cbuf(jf)=rho(jf)*cbuf(jf)
23000 continue
      do 23500 jf=ifh+1,nfft/2-1
       cbuf(jf)=(0.,0.)
23500 continue
      call rfftsc(cbuf,nfft,-2,0)
      call rfftb(cbuf,rbuf,nfft,-1)
      do 24000 jt=istart,iend
       u(jt)=rbuf(jt)
24000 continue
c
      return
      end


