C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine getrr(rx1d,rx1dinv,rx2dinv,
     1                  ry1d,ry1dinv,ry2dinv,
     2                  rx1dc,ry1dc,r2,z,iperm, 
     3                  rx1dfine,rx2dfine,ry1dfine,ry2dfine,
     4                  r2rinv,rt,rr,toeplitz,rv,
     5                  x,y,p,q,nxw,nyw,np,nq,dx,dy,dp,dq,
     6                  wgtpq,jpqlive,npqlive,omega,jcenter,
     7                  ifl,ifh,rho,fwgt,
     8                  prew,lerr,ler,
     9                  kximin,kximax,xmin,dxi,mx,nxinterp,nxwfine,
     a                  kyimin,kyimax,ymin,dyi,my,nyinterp,nywfine,
     b                  map)
c_________________________________________________________________
c     calculate the 2D radon transform matrix.
c
c
c       
c     x,y................relative x and y position from center of stencil.
c     p,q................ray parameters in x and y directions.      
c     omega..............temporal frequency in radians/sec.
c     wgtpq..............mute matrix in p,q transform space.       
c     rx1d,ry1d..........1D radon transform matrices.        
c     rx2d,ry2d..........2D radon transform matrices.        
c     rx1dinv,ry1dinv....1D pseudo inverse radon transform matrices.        
c     rx2dinv,ry2dinv....2D pseudo inverse radon transform matrices.        
c     rt.................2D transpose of R
c     r2rinv.............2D inverse of (RtR)
c     rr.................the radon transform filter rt*wgtpq*r2rinv.
c     map................map of output interpolated trace locations.
c
c
c     the 2D reverse radon transform matrix rt is define by:
c
c     rt(omega,p,q,x,y)=exp{-i*omega*(p*x+q*y)}
c
c     the 2D forward radon transform matrix r2rinv will be defined at the
c     2D pseudo inverse of matrix rt.
c_________________________________________________________________
      complex  rx1d(nxw,np)           
      complex  rx1dc(np,nxw)           
      complex  rx1dinv(np,np)           
      complex  rx2dinv(nq*np,nxw*nyw)
c
      complex  rx1dfine(nxwfine,np)           
      complex  rx2dfine(nxwfine*nywfine,nq*np)
c
      complex  ry1d(nyw,nq)           
      complex  ry1dc(nq,nyw)           
      complex  ry1dinv(nq,nq)           
      complex  ry2dinv(nq*np,nq*np)
c
      complex  ry1dfine(nywfine,nq)           
      complex  ry2dfine(nywfine*np,nq*np)
c
      complex  r2rinv(npqlive,npqlive)
      complex  rt(npqlive,kximin:kximax,kyimin:kyimax)
      complex  rr(ifl:ifh,npqlive,kximin:kximax,kyimin:kyimax)
c
      complex  rv(*)
      complex  r2(*),z(*)
      integer  iperm(*)
c
      real     x(nxw),y(nyw)
      real     p(np),q(nq)
      real     wgtpq(npqlive)
      real     omega(ifl:ifh)
      complex  csum
      real     rho(ifl:ifh),fwgt(ifl:ifh)
      integer  jpqlive(npqlive)
      integer  map(nxwfine,nywfine)
      integer  ler
      logical  toeplitz
      parameter (pi=3.1415926,twopi=2.*pi)
c_________________________________________________________________
c     map the 2d index of output interpolated points to the 1d index
c     used in the matrix calculations.
c_________________________________________________________________
      kount=0
      do 2000 jy=-my*nyinterp,+my*nyinterp
       do 1000 jx=-mx*nxinterp,+mx*nxinterp
        kount=kount+1
        map(jx,jy)=kount
1000   continue
2000  continue
c_________________________________________________________________
c     loop over temporal frequency omega.
c_________________________________________________________________
      do 90000 jomega=ifl,ifh
c_________________________________________________________________
c      go calculate the radon transform and pseudo inverse matrices
c      in x.
c
c      [rx1d]=exp{-i*p*omega*x}                                 
c
c      columns vary as {p1,p2,...,pn}
c      rows vary as {x1,x2,...,xn}
c_________________________________________________________________
       do 21000 jp=1,np    
        do 11000 jx=1,nxw           
         arg=-omega(jomega)*p(jp)*x(jx)
         rx1d(jx,jp)=cmplx(cos(arg),sin(arg))
         rx1dc(jp,jx)=conjg(rx1d(jx,jp))         
11000  continue
21000 continue
c_________________________________________________________________
c     calculate least square inverse rx1dinv of rx1d
c_________________________________________________________________
      call invert(rx1d,rx1dc,r2,rx1dinv,z,iperm,rcondx,
     1            rv,nxw,np,prew,toeplitz,ler,lerr)
c_________________________________________________________________
c      go calculate the radon transform and pseudo inverse matrices
c      in y.
c
c      [ry1d]=exp{-i*p*omega*y}
c
c      rows vary as {y1,y2,...,yn}
c      columns vary as {q1,q2,...,qn}
c_________________________________________________________________

       do 22000 jq=1,nq
        do 12000 jy=1,nyw
         arg=-omega(jomega)*q(jq)*y(jy)
         ry1d(jy,jq)=cmplx(cos(arg),sin(arg))
         ry1dc(jq,jy)=conjg(ry1d(jy,jq))
12000  continue
22000 continue
c_________________________________________________________________
c     calcuate least square inverse ry1dinv of ry1d
c_________________________________________________________________
      call invert(ry1d,ry1dc,r2,ry1dinv,z,iperm,rcondy,
     1            rv,nyw,nq,prew,toeplitz,ler,lerr)
      if(mod(jomega,10) .eq. 0) then
         write(ler,'(a,3i5,2e12.3)') 'ifl,jomega,ifh,rcondx,rcondy ',
     1                                ifl,jomega,ifh,rcondx,rcondy
      endif
c_________________________________________________________________
c     form [RX2DINV] from [RX1DINV], reordering the rows for the
c     next step.
c
c     rows vary as {(p1,y1),(p1,y2),...,(p1,yn),(p2,y1),(p2,y2)...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2)...}
c_________________________________________________________________
      do 67000 jcol=1,np*nq  
       do 66000 jrow=1,nq*np
        rx2dinv(jrow,jcol)=(0.,0.)
66000  continue
67000 continue
c
      do 65000 kq=1,nq
       do 64000 jp=1,np
        jrow=(jp-1)*nq+kq
        do 63000 kp=1,np
         jcol=(kq-1)*nxw+kp
         rx2dinv(jrow,jcol)=rx1dinv(jp,kp)
63000   continue
64000  continue
65000 continue
c_________________________________________________________________
c     form [RY2DINV] from [RY1DINV]
c
c     rows vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c     columns vary as {(p1,y1),(p1,y2),...,(p1,yn),(p2,y1),(p2,y2)...}
c_________________________________________________________________
      do 77000 jcol=1,np*nq
       do 76000 jrow=1,np*nq 
        ry2dinv(jrow,jcol)=(0.,0.)
76000  continue
77000 continue
c
      do 75000 jp=1,np 
       do 74000 jq=1,nq
        jrow=(jp-1)*nq+jq
        do 73000 kq=1,nq 
         jcol=(jp-1)*nq+kq
         ry2dinv(jrow,jcol)=ry1dinv(jq,kq)
73000   continue
74000  continue
75000 continue
c_________________________________________________________________
c     form the forward 2d transform: [r2rinv]=[RY2DINV]*[RX2DINV]
c
c     rows vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2)...}
c_________________________________________________________________
      do 54300 jrow=1,npqlive
       krow=jpqlive(jrow)
       do 54200 jcol=1,npqlive
        kcol=jpqlive(jcol)
        r2rinv(jrow,jcol)=(0.,0.)
        do 54100 k=1,np*nq
         r2rinv(jrow,jcol)=r2rinv(jrow,jcol)
     1                +ry2dinv(krow,k)*rx2dinv(k,kcol)
54100   continue
54200  continue
54300 continue
c_________________________________________________________________
c      go calculate the reverse radon transform  matrices
c      in x and y on the interpolated grid.
c
c      [rx1dfine]=exp{-i*p*omega*x}
c
c      columns vary as {p1,p2,...,pn}
c      rows vary as {x1,x2,...,xn}
c
c      [ry1dfine]=exp{-i*p*omega*y}
c
c      rows vary as {y1,y2,...,yn}
c      columns vary as {q1,q2,...,qn}
c_________________________________________________________________
       do 55500 jp=1,np
        do 55400 jx=1,nxwfine
         xinterp=xmin+(jx-1)*dxi
         arg=-omega(jomega)*p(jp)*xinterp
         rx1dfine(jx,jp)=cmplx(cos(arg),sin(arg))
55400   continue
55500  continue
c
       do 55700 jq=1,nq
        do 55600 jy=1,nywfine
         yinterp=ymin+(jy-1)*dyi
C
         arg=-omega(jomega)*q(jq)*yinterp
         ry1dfine(jy,jq)=cmplx(cos(arg),sin(arg))
55600   continue
55700  continue
c_________________________________________________________________
c     form [RY2D] from [RY1D], reordering the rows for the
c     next step.
c
c     rows vary as {(p1,y1),(p2,y1),...,(pn,y1),(p1,y2),(p2,y2),...}
c     columns vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c_________________________________________________________________
      call vclr(ry2dfine,1,2*(nywfine*np)*(nq*np))
      do 55300 jp=1,np
       do 55200 jy=1,nywfine
         jrow=(jy-1)*np+jp
         do 55100 jq=1,nq
          jcol=(jp-1)*nq+jq
          ry2dfine(jrow,jcol)=ry1dfine(jy,jq)
55100    continue
55200   continue
55300  continue
c_________________________________________________________________
c     form [RX2D] from [RX1D], reordering the rows for the
c     next step.
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(p1,y1),(p2,y1),...,(pn,y1),(p1,y2),(p2,y2),...}
c_________________________________________________________________
      call vclr(rx2dfine,1,2*(nywfine*nxwfine)*(nywfine*np))
      do 56300 jx=1,nxwfine 
       do 56200 jy=1,nywfine
         jrow=(jy-1)*nxwfine+jx
         do 56100 jp=1,np
          jcol=(jy-1)*np+jp
          rx2dfine(jrow,jcol)=rx1dfine(jx,jp)
56100    continue
56200   continue
56300  continue
c_________________________________________________________________
c     form the reverse 2d transform: [rt]=[RX2D]*[RY2D]
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c
c     calculate the filtered reverse transform matrix.
c
c               [rt] = [rt] [wgtpq] 
c_________________________________________________________________
      do 57400 jyi=kyimin,kyimax
       do 57300 jxi=kximin,kximax
        jrow=map(jxi,jyi)
        do 57200 kpq=1,npqlive
         kcol=jpqlive(kpq)
         rt(kpq,jxi,jyi)=(0.,0.)
         do 57100 k=1,np*nywfine
          rt(kpq,jxi,jyi)=rt(kpq,jxi,jyi)
     1                      +rx2dfine(jrow,k)*ry2dfine(k,kcol)
57100    continue
         rt(kpq,jxi,jyi)=fwgt(jomega)*rt(kpq,jxi,jyi)
57200   continue
57300  continue
57400 continue
c_________________________________________________________________
c     calculate the radon transform filter response matrix:
c
c               [RR] = [RT] [r2rinv]
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c
c     wgtpq is a diagonal matrix whose rows and columns vary as
c                     {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c_________________________________________________________________
      do 58400 jyi=kyimin,kyimax
       do 58300 jxi=kximin,kximax
        do 58200 kpq=1,npqlive
         rr(jomega,kpq,jxi,jyi)=(0.,0.)
         do 58100 jpq=1,npqlive
          rr(jomega,kpq,jxi,jyi)=rr(jomega,kpq,jxi,jyi)
     1          +rt(jpq,jxi,jyi)*r2rinv(jpq,kpq)
58100     continue
58200    continue
58300   continue
58400  continue
90000 continue
c____________________________________________________________________
c     calculate some reasonable approximation to the rho filter.
c____________________________________________________________________
      write(lerr,'(4a12)') 'jomega','rho'
      do 93000 jomega=ifl,ifh
       csum=(0.,0.)
       do 92000 jpq=1,npqlive
        csum=csum+rr(jomega,jpq,0,0)
92000  continue
       rho(jomega)=csum/npqlive
       write(lerr,'(i12,2e12.5)') jomega,rho(jomega)
93000 continue


      return
      end
