C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine invert(r,rc,r2,rinv,z,iperm,rcond,
     1                  rv,nx,np,prew,toeplitz,stderr,lerr)
c_________________________________________________________________
c     calculate least square inverse of matrix [R] 
c_________________________________________________________________
      complex  r(nx,np)           
      complex  rc(np,nx)
      complex  r2(np,np)
      complex  rinv(np,nx)
      complex  rv(np)
      integer  iperm(np)
      complex  z(np)
      integer  stderr
      logical  toeplitz
c_________________________________________________________________
c     calculate
c       
c                    *            -1   
c         [RINV]=([R] [R]+eps*[I])  [I] 
c
c_________________________________________________________________
c_________________________________________________________________
c                            *
c        calculate [R2] = [R] [R]
c_________________________________________________________________
         do 23000 jp=1,np
          do 22000 kp=1,np
           r2(jp,kp)=(0.,0.)
           do 21000 jx=1,nx
            r2(jp,kp)=r2(jp,kp)+rc(jp,jx)*r(jx,kp)
21000      continue
22000     continue
23000    continue
c_________________________________________________________________
c        calculate eps to be used in prewhitening.
c_________________________________________________________________
         rmax=0.
         do 30000 jp=1,np
          rmax=max(rmax,abs(r2(jp,jp)))
30000    continue
         eps=prew*rmax
c_________________________________________________________________
c        add prewhitening:
c
c                         *
c               [R2] = [R] [R]+eps*[I]
c_________________________________________________________________
         do 60000 jp=1,np
          r2(jp,jp)=r2(jp,jp)+eps
60000    continue
c_________________________________________________________________
c        calculate 
c
c                            *            -1   *
c               [RINV] = ([R] [R]+eps*[I])  [I]
c
c_________________________________________________________________
        if(toeplitz) then
           do 72000 kp=1,np
            do 71000 jp=1,np
             rv(jp)=r2(jp,1)
             rc(jp,1)=(0.,0.)
71000       continue
            rc(kp,1)=(1.,0.)
            call clev(np,rv,rc,rinv(1,kp),z)
72000      continue
        else
           call cgeco(r2,np,np,iperm,rcond,z)
           job=0
           do 80000 kp=1,np
            do 75000 jp=1,np
             rinv(jp,kp)=(0.,0.)
75000       continue
            rinv(kp,kp)=(1.,0.)
            call cgesl(r2,np,np,iperm,rinv(1,kp),job)
80000      continue
        endif
c
      return
      end
