C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine revtaup(utaupq,utaupqfine,wsemb,uout,w,jx,nx,
     1                   istart,iend,kstart,kend,nt,ntfine,
     2                   jpadvance,npqlive,kximin,kximax,kyimin,kyimax,
     3                   afact,interpolate,cputim,waltim,lerr,
     4                   rho,cbuf,rbuf,nfft,ifl,ifh)
c___________________________________________________________________
c     calculate uout(t,x,y) from  utaupqfine(tau,p,q)         
c___________________________________________________________________
c     utaupq   = input (tau,p,q) data.
c     wsemb   = input (tau,p,q) semblance weights.
c     uout    = output (t,x,y) data.                         
c___________________________________________________________________
      real      uout(istart:iend,0:nx,kximin:kximax,kyimin:kyimax)
      real      wsemb(0:nt,npqlive)
      real      utaupq(-2:nt+3,npqlive)
      real      utaupqfine(0:nt,0:ntfine-1,npqlive)
      real      w(-2:+3,0:ntfine)
c
      integer   jpadvance(npqlive,kximin:kximax,kyimin:kyimax,2)
c
      real    rbuf(0:nfft-1)
      real    rho(ifl:ifh)
      complex cbuf(0:nfft/2-1)
c
      real      cputim(*),waltim(*)
      logical   interpolate
c
c___________________________________________________________________
c     initialize.
c___________________________________________________________________
      do 16000 kyi=kyimin,kyimax
       do 15000 kxi=kximin,kximax
        do 14000 jt=istart,iend
         uout(jt,jx,kxi,kyi)=0.
14000   continue
15000  continue
16000 continue
      if(.not. interpolate) then
c___________________________________________________________________
c        phase advances at (x=0,y=0) are all zero. 
c        degenerate reverse (tau,p,q) transform is a simple sum.
c___________________________________________________________________
         call timstr(v1,w1)
         do 20000 jang=1,npqlive
          do 10000 jt=istart,iend
            uout(jt,jx,0,0)=uout(jt,jx,0,0)
     1                      +utaupq(jt,jang)*wsemb(jt,jang)
10000     continue
20000    continue
c___________________________________________________________________
c        apply the rho filter. 
c___________________________________________________________________
         call apprho(uout(istart,jx,0,0),rbuf,cbuf,rho,
     1               afact,nt,nfft,ifl,ifh,istart,iend)
         call timend(cputim(14),v1,v2,waltim(14),w1,w2)
      else
c___________________________________________________________________
c        interpolation will require a formal reverse (tau,p,q) transform.
c        interpolate to utaupq to a finer time/depth sample.
c___________________________________________________________________
         call timstr(v1,w1)
         call mint6(utaupq,utaupqfine,w,nt,ntfine,
     1              npqlive,kstart,kend)
         call timend(cputim(13),v1,v2,waltim(13),w1,w2)
         call timstr(v1,w1)
c___________________________________________________________________
c        loop over interpolated output points
c___________________________________________________________________
         do 90000 kyi=kyimin,kyimax
          do 80000 kxi=kximin,kximax
c___________________________________________________________________
c          loop over all angles.
c___________________________________________________________________
           do 70000 jang=1,npqlive
c___________________________________________________________________
c           collect traces comprising the computational star.
c___________________________________________________________________
            jadvance_samp=jpadvance(jang,kxi,kyi,1)
            jadvance_fine=jpadvance(jang,kxi,kyi,2)
            js=max(istart,0+jadvance_samp,0)
            je=min(iend,nt+(jadvance_samp+1),nt)
            do 60000 jsamp=js,je
             uout(jsamp,jx,kxi,kyi)=uout(jsamp,jx,kxi,kyi)  
     1           +utaupqfine(jsamp+jadvance_samp,jadvance_fine,jang)  
60000       continue
70000      continue
c___________________________________________________________________
c          apply the rho filter. 
c___________________________________________________________________
           call apprho(uout(istart,jx,kxi,kyi),rbuf,cbuf,rho,
     1                 afact,nt,nfft,ifl,ifh,istart,iend)
80000     continue
90000    continue
         call timend(cputim(14),v1,v2,waltim(14),w1,w2)
      endif
c
      return
      end
